"""
	File generated by UShareSoft
"""

import objects
import StringIO
import urllib
import sys
import hmac
import requests
import os
import ConfigParser

from hashlib import sha1
from pyxb.utils import domutils
from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

reload(sys)
sys.setdefaultencoding('utf-8')

#Check if Uforge is compatible with this SDK
def checkUForgeCompatible(api):
	serviceStatus = api.Status.Get()

	config = ConfigParser.ConfigParser()
	config.readfp(open(os.path.join(os.path.abspath(os.path.dirname(__file__)), 'config', 'config.cfg')))

	compatible = False
	if serviceStatus.version == config.get('constants', 'UFORGE_VERSION'):
		compatible = True
	return compatible,serviceStatus.version

class _Objects(object):
	@classmethod
	def parseString(cls, string, silence=False):
		exception = Exception('No parser found')
		for xsd in filter(lambda d: not d.startswith('__'), dir(objects)):
			try:
				return  getattr(objects, xsd).CreateFromDocument(string)
			except Exception as e:
				exception = e
		raise exception

class UForgeApiKeyAuth(requests.auth.AuthBase):
	def __init__(self, baseUrl, secretkey):
		self.baseUrl = baseUrl
		self.secretkey = secretkey
	def __call__(self, r):
		relativeUrl = (r.url).replace(self.baseUrl, "")
		signature = self._calc_signature(url=relativeUrl, secretkey=self.secretkey)
		signature = urllib.urlencode({"signature" : signature})
		r.url = r.url+"&"+signature
		return r
	def _calc_signature(self, url, secretkey):
		if url.startswith("/"):
			url=url[1:]
		hashed = hmac.new(secretkey, url, sha1)
		return hashed.digest().encode("base64").rstrip('\n')

class _CommonAPIClass(object):
	def _get(self, arg):
		if hasattr(self, arg):
			ret = getattr(self, arg)
			delattr(self, arg)
			return ret
		elif hasattr(self, '_parent') and self._parent:
			return self._parent._get(arg)
		else:
			raise Exception('Argument "%s" is not set' % (arg))
	def _REST(self, url, method, body, element_name, streamingResponseFile, **kwargs):
		obj = self
		while obj <> None and not hasattr(obj, '_url'):
			if hasattr(obj, '_parent'):
				obj = obj._parent
			else:
				obj = None
		if obj == None:
			raise Exception('API instance not found')

		# Build headers
		if obj._headers is not None:
			requestHttpHeader = obj._headers
		else:
			requestHttpHeader = {}
		requestHttpHeader.update({'Content-Type': 'application/xml'})
		requestHttpHeader.update({'Accept': 'application/xml'})

		# Build request
		if obj._apikeys:
			kwargs["apiKey"] = obj._apikeys["publickey"]

		# Build Authentication
		if obj._apikeys:
			auth=UForgeApiKeyAuth(baseUrl = obj._url, secretkey = obj._apikeys["secretkey"])
		else:
			auth=requests.auth.HTTPBasicAuth(obj._username, obj._password)

		fullUrl = obj._url + url

		if body:
			try:
				if type(body) is not file:
					if element_name is not None:
						bds = domutils.BindingDOMSupport(require_xsi_type=True)
						body = body.toxml(encoding="utf-8", bds=bds, element_name=element_name)
					else:
						body = body.toxml(encoding="utf-8")
			except:
				print "Problem converting python object to XML"
				raise

		isStream = True if streamingResponseFile is not None else False
		resp = getattr(requests, method.lower())(fullUrl, params=kwargs, auth=auth, headers=requestHttpHeader, data=body, verify=not obj._disable_ssl_certificate_validation, timeout = obj._timeout, stream = isStream)
		if resp.status_code < 200 or resp.status_code >= 300:
			raise Exception(_Objects.parseString(resp.content, True))
		if resp.status_code != 204 and 'content-type' in resp.headers and resp.headers['content-type']=="application/xml":
			return _Objects.parseString(resp.content, True)
		else:
			if isStream and type(streamingResponseFile) is file:
				# we do streaming download in this case
				for chunk in resp.iter_content(8192):
					if chunk: # filter out keep-alive new chunks
						streamingResponseFile.write(chunk)
				return
			else:
				return resp.content
class Api(_CommonAPIClass):
	def __init__(self, url, username, password, headers = {}, apikeys = {}, disable_ssl_certificate_validation = False, timeout = 10):
		self._apikeys = apikeys
		self._headers = headers
		self._url = url
		self._username = username
		self._password = password
		self._disable_ssl_certificate_validation = disable_ssl_certificate_validation
		self._timeout = timeout
		self.Status = Api._Status(self)
		self.Statistics = Api._Statistics(self)
		self.Users = Api._Users(self)
		self.Entitlements = Api._Entitlements(self)
		self.Usergroups = Api._Usergroups(self)
		self.Usage = Api._Usage(self)
		self.Orgs = Api._Orgs(self)
		self.Distributions = Api._Distributions(self)
		self.CloudProviders = Api._CloudProviders(self)
		pass
	
	def getUrl(self):
		return self._url
	
	def getDisableSslCertificateValidation(self):
		return self._disable_ssl_certificate_validation
	
	class _Status(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: status
		def Get(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
	
	class _Statistics(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: statistics
		def Get(self, Type=None, Filter=None, Fromdate=None, Todate=None, Graphtype=None, Nb=None, Order=None, Groupby=None, Periodicity=None, Org=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'type': Type, 'filter': Filter, 'fromDate': Fromdate, 'toDate': Todate, 'graphType': Graphtype, 'nb': Nb, 'order': Order, 'groupby': Groupby, 'periodicity': Periodicity, 'org': Org}
			return self._REST('/statistics', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
	
	class _Users(_CommonAPIClass):
		def __call__(self, Uid=None):
			self.Uid = Uid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Photo = Api._Users._Photo(self)
			self.Accounts = Api._Users._Accounts(self)
			self.Appliances = Api._Users._Appliances(self)
			self.Images = Api._Users._Images(self)
			self.Apikeys = Api._Users._Apikeys(self)
			self.Pxe = Api._Users._Pxe(self)
			self.Distros = Api._Users._Distros(self)
			self.Targetplatforms = Api._Users._Targetplatforms(self)
			self.Stats = Api._Users._Stats(self)
			self.Mysoftware = Api._Users._Mysoftware(self)
			self.Quotas = Api._Users._Quotas(self)
			self.Deployments = Api._Users._Deployments(self)
			self.Imports = Api._Users._Imports(self)
			self.Usage = Api._Users._Usage(self)
			self.Bundleimports = Api._Users._Bundleimports(self)
			self.Scans = Api._Users._Scans(self)
			self.Activities = Api._Users._Activities(self)
			self.Exports = Api._Users._Exports(self)
			self.Workspaces = Api._Users._Workspaces(self)
			self.Forgotpassword = Api._Users._Forgotpassword(self)
			self.Artifactaccounts = Api._Users._Artifactaccounts(self)
			self.Targetformats = Api._Users._Targetformats(self)
			self.Sshkeys = Api._Users._Sshkeys(self)
			self.Roles = Api._Users._Roles(self)
			self.Pimages = Api._Users._Pimages(self)
			self.Scannedinstances = Api._Users._Scannedinstances(self)
			self.Formats = Api._Users._Formats(self)
			self.Orgs = Api._Users._Orgs(self)
			pass
		
		#URL: users/{uid}
		def Get(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/users/' + str(self._get('Uid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: users
		def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, Orgname=None, Active=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset, 'orgName': Orgname, 'active': Active}
			return self._REST('/users', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: users
		def Create(self, Notify=None, Notifyadmin=None, Org=None, Publisher=None, Admin=None, Autopasswd=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'notify': Notify, 'notifyAdmin': Notifyadmin, 'org': Org, 'publisher': Publisher, 'admin': Admin, 'autopasswd': Autopasswd}
			return self._REST('/users', 'POST', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: users/{uid}
		def Update(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/users/' + str(self._get('Uid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
		class _Photo(_CommonAPIClass):
			def __call__(self, Photoid=None, Filename=None):
				self.Photoid = Photoid
				self.Filename = Filename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/photo/{photoId}/{fileName}
			def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}
			def Download(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}/{fileName}
			def Upload(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Accounts(_CommonAPIClass):
			def __call__(self, Caid=None):
				self.Caid = Caid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Certs = Api._Users._Accounts._Certs(self)
				self.Resources = Api._Users._Accounts._Resources(self)
				pass
			
			#URL: users/{uid}/accounts/{caid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/accounts/{caid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/accounts
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/accounts
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/accounts/{caid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Certs(_CommonAPIClass):
				def __call__(self, Certid=None, Filename=None):
					self.Certid = Certid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/accounts/{caid}/certs/{certid}
				def Download(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'downloadId': Downloadid}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs/' + str(self._get('Certid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/accounts/{caid}/certs/{certid}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs/' + str(self._get('Certid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/accounts/{caid}/certs
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/accounts/{caid}/certs/{certid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs/' + str(self._get('Certid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Resources(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/accounts/{caid}/resources
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/resources', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Appliances(_CommonAPIClass):
			def __call__(self, Aid=None):
				self.Aid = Aid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Exports = Api._Users._Appliances._Exports(self)
				self.Osprofile = Api._Users._Appliances._Osprofile(self)
				self.Pimages = Api._Users._Appliances._Pimages(self)
				self.Mysoftware = Api._Users._Appliances._Mysoftware(self)
				self.Clones = Api._Users._Appliances._Clones(self)
				self.Bootscripts = Api._Users._Appliances._Bootscripts(self)
				self.Oas = Api._Users._Appliances._Oas(self)
				self.Images = Api._Users._Appliances._Images(self)
				self.Logo = Api._Users._Appliances._Logo(self)
				self.Installprofile = Api._Users._Appliances._Installprofile(self)
				self.Projects = Api._Users._Appliances._Projects(self)
				pass
			
			#URL: users/{uid}/appliances/{aid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/appliances/{aid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/appliances
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/appliances
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/appliances/{aid}
			def Delete(self, Force=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'force': Force}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			class _Exports(_CommonAPIClass):
				def __call__(self, Eid=None):
					self.Eid = Eid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Appliances._Exports._Status(self)
					self.Downloads = Api._Users._Appliances._Exports._Downloads(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/exports
				def Export(self, Outputformat=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'outputFormat': Outputformat}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/exports/{eid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/exports/{eid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/exports/{eid}/status
					def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/exports/{eid}/status
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Downloads(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/exports/{eid}/downloads
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '/downloads', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Osprofile(_CommonAPIClass):
				def __call__(self, Osid=None):
					self.Osid = Osid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Services = Api._Users._Appliances._Osprofile._Services(self)
					self.Applications = Api._Users._Appliances._Osprofile._Applications(self)
					self.Updates = Api._Users._Appliances._Osprofile._Updates(self)
					self.Pkgs = Api._Users._Appliances._Osprofile._Pkgs(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/osprofile
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/osprofile/{osid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/osprofile/{osid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				class _Services(_CommonAPIClass):
					def __call__(self, Sid=None):
						self.Sid = Sid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/services/{sid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/{osid}/services/' + str(self._get('Sid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/services
					def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/{osid}/services', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Applications(_CommonAPIClass):
					def __call__(self, Appid=None):
						self.Appid = Appid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/applications/{appid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/applications/' + str(self._get('Appid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/applications
					def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/applications', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Updates(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/updates
					def Save(self, At=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'at': At}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/updates', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/updates
					def Get(self, From=None, To=None, Simulate=None, At=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'from': From, 'to': To, 'simulate': Simulate, 'at': At}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/updates', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Pkgs(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/pkgs
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/pkgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/pkgs
					def Updateall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/pkgs', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Pimages(_CommonAPIClass):
				def __call__(self, Pitid=None):
					self.Pitid = Pitid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Downloads = Api._Users._Appliances._Pimages._Downloads(self)
					self.Statuses = Api._Users._Appliances._Pimages._Statuses(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/pimages
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/pimages
				def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/pimages
				def Publish(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages', 'POST', body, element_name, streamingResponseFile, **kwargs)
				class _Downloads(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/pimages/{pitid}/downloads
					def Download(self, Id=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'id': Id}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages/' + str(self._get('Pitid')) + '/downloads', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Statuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/pimages/statuses
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages/statuses', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Mysoftware(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/mysoftware
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/mysoftware', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Clones(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/clones
				def Clone(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/clones', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Bootscripts(_CommonAPIClass):
				def __call__(self, Bsid=None):
					self.Bsid = Bsid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Users._Appliances._Bootscripts._Bin(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/bootscripts
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts
				def Deleteall(self, Id=None, Type=None, Name=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'id': Id, 'type': Type, 'name': Name}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}/bin/{fileName}
					def Downloadfile(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}/bin/{fileName}
					def Upload(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}/bin
					def Download(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '/bin', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Oas(_CommonAPIClass):
				def __call__(self, Oaspkgid=None):
					self.Oaspkgid = Oaspkgid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Licenses = Api._Users._Appliances._Oas._Licenses(self)
					self.Bin = Api._Users._Appliances._Oas._Bin(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/oas
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas', 'POST', body, element_name, streamingResponseFile, **kwargs)
				class _Licenses(_CommonAPIClass):
					def __call__(self, Oaslid=None, Filename=None):
						self.Oaslid = Oaslid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}
					def Upload(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}/{fileName}
					def Uploadfile(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/bin/{fileName}
					def Upload(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/bin/{fileName}', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/bin
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/bin', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Images(_CommonAPIClass):
				def __call__(self, Itid=None):
					self.Itid = Itid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Appliances._Images._Status(self)
					self.Files = Api._Users._Appliances._Images._Files(self)
					self.Pimages = Api._Users._Appliances._Images._Pimages(self)
					self.Downloads = Api._Users._Appliances._Images._Downloads(self)
					self.Pkgs = Api._Users._Appliances._Images._Pkgs(self)
					self.Statuses = Api._Users._Appliances._Images._Statuses(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/images
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images/{itid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images
				def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images/{itid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images/{itid}
				def Regenerate(self, Force=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'force': Force}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images
				def Generate(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images', 'POST', body, element_name, streamingResponseFile, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/status
					def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/status
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Files(_CommonAPIClass):
					def __call__(self, Filepath=None):
						self.Filepath = Filepath
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/files/{filepath}
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/files/' + str(self._get('Filepath')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Pimages(_CommonAPIClass):
					def __call__(self, Pitid=None):
						self.Pitid = Pitid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Appliances._Images._Pimages._Status(self)
						self.Cancel = Api._Users._Appliances._Images._Pimages._Cancel(self)
						self.Accounts = Api._Users._Appliances._Images._Pimages._Accounts(self)
						self.Deploys = Api._Users._Appliances._Images._Pimages._Deploys(self)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages
					def Publish(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/status
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Cancel(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/cancel
						def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/cancel', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Accounts(_CommonAPIClass):
						def __call__(self, Caid=None):
							self.Caid = Caid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Resources = Api._Users._Appliances._Images._Pimages._Accounts._Resources(self)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/accounts/{caid}
						def Getaccount(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/accounts/' + str(self._get('Caid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
						class _Resources(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/accounts/{caid}/resources
							def Getaccountresources(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/accounts/' + str(self._get('Caid')) + '/resources', 'GET', body, element_name, streamingResponseFile, **kwargs)
							
						
					
					class _Deploys(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/deploys
						def Deploy(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/deploys', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Downloads(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/downloads
					def Download(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/downloads', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/downloads/{fileName}
					def Downloadfile(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/downloads/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Pkgs(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pkgs
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pkgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Statuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/statuses
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/statuses', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}/{fileName}
				def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Installprofile(_CommonAPIClass):
				def __call__(self, Ipid=None):
					self.Ipid = Ipid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Groups = Api._Users._Appliances._Installprofile._Groups(self)
					self.Nics = Api._Users._Appliances._Installprofile._Nics(self)
					self.Users = Api._Users._Appliances._Installprofile._Users(self)
					self.Pt = Api._Users._Appliances._Installprofile._Pt(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/installProfile
				def Getdeprecated(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/installProfile
				def Updatedeprecated(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				class _Groups(_CommonAPIClass):
					def __call__(self, Osgid=None):
						self.Osgid = Osgid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups/{osgid}
					def Update(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups/' + str(self._get('Osgid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups/{osgid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups/' + str(self._get('Osgid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups
					def Create(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups/{osgid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups/' + str(self._get('Osgid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups
					def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Nics(_CommonAPIClass):
					def __call__(self, Nid=None):
						self.Nid = Nid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/nics/{nid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/nics/' + str(self._get('Nid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/nics
					def Updatelist(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/nics', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/nics/{nid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/nics/' + str(self._get('Nid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/nics
					def Create(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/nics', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/nics/{nid}
					def Update(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/nics/' + str(self._get('Nid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/nics
					def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/nics', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Users(_CommonAPIClass):
					def __call__(self, Osuid=None):
						self.Osuid = Osuid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users/{osuid}
					def Update(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users/' + str(self._get('Osuid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users
					def Create(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users/{osuid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users/' + str(self._get('Osuid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users/{osuid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users/' + str(self._get('Osuid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users
					def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Pt(_CommonAPIClass):
					def __call__(self, Ptid=None):
						self.Ptid = Ptid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Disks = Api._Users._Appliances._Installprofile._Pt._Disks(self)
						self.Volumes = Api._Users._Appliances._Installprofile._Pt._Volumes(self)
						self.Groups = Api._Users._Appliances._Installprofile._Pt._Groups(self)
						pass
					
					class _Disks(_CommonAPIClass):
						def __call__(self, Did=None):
							self.Did = Did
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Partitions = Api._Users._Appliances._Installprofile._Pt._Disks._Partitions(self)
							pass
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks
						def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks
						def Create(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}
						def Update(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}
						def Delete(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks
						def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						class _Partitions(_CommonAPIClass):
							def __call__(self, Pid=None):
								self.Pid = Pid
								return self
						
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								self.Lpartitions = Api._Users._Appliances._Installprofile._Pt._Disks._Partitions._Lpartitions(self)
								pass
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}
							def Delete(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions
							def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}
							def Get(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions
							def Create(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions', 'POST', body, element_name, streamingResponseFile, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions
							def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions', 'GET', body, element_name, streamingResponseFile, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}
							def Update(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
							class _Lpartitions(_CommonAPIClass):
								def __call__(self, Lpid=None):
									self.Lpid = Lpid
									return self
							
								def __init__(self, parent, **kwargs):
									self._parent = parent
									self.__dict__.update(kwargs)
									pass
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions
								def Create(self, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions', 'POST', body, element_name, streamingResponseFile, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions/{lpid}
								def Delete(self, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions/' + str(self._get('Lpid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions/{lpid}
								def Get(self, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions/' + str(self._get('Lpid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions
								def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions/{lpid}
								def Update(self, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions/' + str(self._get('Lpid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions
								def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions', 'GET', body, element_name, streamingResponseFile, **kwargs)
								
							
						
					
					class _Volumes(_CommonAPIClass):
						def __call__(self, Vid=None):
							self.Vid = Vid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes/{vid}
						def Delete(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes/' + str(self._get('Vid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes/{vid}
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes/' + str(self._get('Vid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes
						def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes/{vid}
						def Update(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes/' + str(self._get('Vid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes
						def Create(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes
						def Getall(self, Name=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'name': Name}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Groups(_CommonAPIClass):
						def __call__(self, Gid=None):
							self.Gid = Gid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups
						def Create(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups
						def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups/{gid}
						def Update(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups/' + str(self._get('Gid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups
						def Getall(self, Name=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'name': Name}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups/{gid}
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups/' + str(self._get('Gid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups/{gid}
						def Delete(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups/' + str(self._get('Gid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
					
				
			
			class _Projects(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/projects
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/projects', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Images(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Images._Status(self)
				pass
			
			#URL: users/{uid}/images
			def Getall(self, Img=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'img': Img}
				return self._REST('/users/' + str(self._get('Uid')) + '/images', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/images/status
				def Get(self, Img=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'img': Img}
					return self._REST('/users/' + str(self._get('Uid')) + '/images/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Apikeys(_CommonAPIClass):
			def __call__(self, Akid=None):
				self.Akid = Akid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/apikeys
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/apikeys
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/apikeys/{akid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys/' + str(self._get('Akid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/apikeys/{akid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys/' + str(self._get('Akid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Pxe(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/pxe
			def Download(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/pxe', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Distros(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/distros
			def Update(self, Org=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'org': Org}
				return self._REST('/users/' + str(self._get('Uid')) + '/distros', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/distros
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/distros', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Targetplatforms(_CommonAPIClass):
			def __call__(self, Tpid=None):
				self.Tpid = Tpid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Targetformats = Api._Users._Targetplatforms._Targetformats(self)
				pass
			
			#URL: users/{uid}/targetplatforms
			def Update(self, Org=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'org': Org}
				return self._REST('/users/' + str(self._get('Uid')) + '/targetplatforms', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/targetplatforms
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/targetplatforms', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Targetformats(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/targetplatforms/{tpid}/targetformats
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/users/' + str(self._get('Uid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/targetformats', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Stats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/stats
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/stats', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Mysoftware(_CommonAPIClass):
			def __call__(self, Msid=None):
				self.Msid = Msid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Restriction = Api._Users._Mysoftware._Restriction(self)
				self.Exports = Api._Users._Mysoftware._Exports(self)
				self.Artifacts = Api._Users._Mysoftware._Artifacts(self)
				self.Clone = Api._Users._Mysoftware._Clone(self)
				self.Images = Api._Users._Mysoftware._Images(self)
				self.Appliances = Api._Users._Mysoftware._Appliances(self)
				self.Licenses = Api._Users._Mysoftware._Licenses(self)
				self.Logo = Api._Users._Mysoftware._Logo(self)
				pass
			
			#URL: users/{uid}/mysoftware
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, Distribid=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset, 'distribId': Distribid}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/mysoftware
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/mysoftware/{msid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/mysoftware/{msid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/mysoftware/{msid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Restriction(_CommonAPIClass):
				def __call__(self, Brid=None):
					self.Brid = Brid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Distributions = Api._Users._Mysoftware._Restriction._Distributions(self)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/restriction/{brid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/restriction/' + str(self._get('Brid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				class _Distributions(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/restriction/{brid}/distributions
					def Evaluate(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/restriction/' + str(self._get('Brid')) + '/distributions', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Exports(_CommonAPIClass):
				def __call__(self, Eid=None):
					self.Eid = Eid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Mysoftware._Exports._Status(self)
					self.Downloads = Api._Users._Mysoftware._Exports._Downloads(self)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/exports/{eid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/exports/' + str(self._get('Eid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/exports
				def Export(self, Outputformat=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'outputFormat': Outputformat}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/exports', 'POST', body, element_name, streamingResponseFile, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/exports/{eid}/status
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/exports/' + str(self._get('Eid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Downloads(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/exports/{eid}/downloads
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/exports/' + str(self._get('Eid')) + '/downloads', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Artifacts(_CommonAPIClass):
				def __call__(self, Said=None):
					self.Said = Said
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Users._Mysoftware._Artifacts._Bin(self)
					self.Subsoftwareartifacts = Api._Users._Mysoftware._Artifacts._Subsoftwareartifacts(self)
					self.Fetch = Api._Users._Mysoftware._Artifacts._Fetch(self)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts
				def Add(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts
				def Updateall(self, Recursive=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'recursive': Recursive}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts
				def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts
				def Getall(self, Filename=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'filename': Filename}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}
				def Update(self, Recursive=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'recursive': Recursive}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}/bin/{fileName}
					def Upload(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}/bin
					def Download(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '/bin', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}/bin/{fileName}
					def Downloadfile(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Subsoftwareartifacts(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}/subsoftwareartifacts
					def Addchild(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '/subsoftwareartifacts', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Fetch(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/artifacts/fetch
					def Createfromremoteserver(self, Parentsaid=None, Caid=None, Remotefilepath=None, Usecache=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'parentsaid': Parentsaid, 'caid': Caid, 'remoteFilePath': Remotefilepath, 'useCache': Usecache}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/fetch', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/mysoftware/{msid}/artifacts/{said}/fetch
					def Addorremovefilefromcache(self, Usecache=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'useCache': Usecache}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/artifacts/' + str(self._get('Said')) + '/fetch', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Clone(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/clone
				def Clone(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/clone', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Images(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/images
				def Availableforimage(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/images', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Appliances(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/appliances
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/appliances', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Licenses(_CommonAPIClass):
				def __call__(self, Lid=None, Filename=None):
					self.Lid = Lid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{lid}/{fileName}
				def Uploadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/' + str(self._get('Lid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{lid}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/' + str(self._get('Lid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{lid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/' + str(self._get('Lid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{lid}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/' + str(self._get('Lid')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/logo/{logoId}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/logo/{logoId}/{fileName}
				def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/logo/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/logo/{logoId}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Quotas(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/quotas
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/quotas', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/quotas
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/quotas', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Deployments(_CommonAPIClass):
			def __call__(self, Did=None):
				self.Did = Did
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Deployments._Status(self)
				pass
			
			#URL: users/{uid}/deployments/{did}
			def Terminate(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/deployments/' + str(self._get('Did')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/deployments/{did}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/deployments/' + str(self._get('Did')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/deployments
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/deployments', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/deployments/{did}/status
				def Getdeploystatus(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/deployments/' + str(self._get('Did')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Imports(_CommonAPIClass):
			def __call__(self, Iid=None):
				self.Iid = Iid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Imports._Status(self)
				self.Uploads = Api._Users._Imports._Uploads(self)
				self.Statuses = Api._Users._Imports._Statuses(self)
				pass
			
			#URL: users/{uid}/imports
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/imports', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/imports/{iid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/imports/{iid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/imports
			def Import(self, Imported=None, Force=None, Reusebundles=None, Usemajor=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'imported': Imported, 'force': Force, 'reuseBundles': Reusebundles, 'useMajor': Usemajor}
				return self._REST('/users/' + str(self._get('Uid')) + '/imports', 'POST', body, element_name, streamingResponseFile, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/imports/{iid}/status
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Uploads(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/imports/{iid}/uploads
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '/uploads', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Statuses(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/imports/statuses
				def Getallstatus(self, Ai=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'ai': Ai}
					return self._REST('/users/' + str(self._get('Uid')) + '/imports/statuses', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Usage(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/usage
			def Get(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/usage', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Bundleimports(_CommonAPIClass):
			def __call__(self, Sbid=None):
				self.Sbid = Sbid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Bundleimports._Status(self)
				self.Uploads = Api._Users._Bundleimports._Uploads(self)
				pass
			
			#URL: users/{uid}/bundleimports/{sbid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/bundleimports/' + str(self._get('Sbid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/bundleimports
			def Import(self, Imported=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'imported': Imported}
				return self._REST('/users/' + str(self._get('Uid')) + '/bundleimports', 'POST', body, element_name, streamingResponseFile, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/bundleimports/{sbid}/status
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/bundleimports/' + str(self._get('Sbid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Uploads(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/bundleimports/{sbid}/uploads
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/bundleimports/' + str(self._get('Sbid')) + '/uploads', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Scans(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/scans
			def Deleteall(self, Id=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'id': Id}
				return self._REST('/users/' + str(self._get('Uid')) + '/scans', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/scans
			def Getall(self, Id=None, Index=None, Max=None, Orderby=None, Asc=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'id': Id, 'index': Index, 'max': Max, 'orderby': Orderby, 'asc': Asc}
				return self._REST('/users/' + str(self._get('Uid')) + '/scans', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Activities(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/activities
			def Get(self, Type=None, Nblatestresults=None, Order=None, Fromdate=None, Todate=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'type': Type, 'nbLatestResults': Nblatestresults, 'order': Order, 'fromDate': Fromdate, 'toDate': Todate}
				return self._REST('/users/' + str(self._get('Uid')) + '/activities', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Exports(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Statuses = Api._Users._Exports._Statuses(self)
				pass
			
			#URL: users/{uid}/exports
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/exports', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Statuses(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/exports/statuses
				def Getallstatus(self, Ae=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'ae': Ae}
					return self._REST('/users/' + str(self._get('Uid')) + '/exports/statuses', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Workspaces(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/workspaces
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/workspaces', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/workspaces
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/workspaces', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Forgotpassword(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/forgotpassword
			def Reset(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/forgotpassword', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Artifactaccounts(_CommonAPIClass):
			def __call__(self, Caid=None):
				self.Caid = Caid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/artifactaccounts
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, Includefromorg=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset, 'includeFromOrg': Includefromorg}
				return self._REST('/users/' + str(self._get('Uid')) + '/artifactaccounts', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/artifactaccounts
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/artifactaccounts', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/artifactaccounts/{caid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/artifactaccounts/' + str(self._get('Caid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/artifactaccounts/{caid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/artifactaccounts/' + str(self._get('Caid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/artifactaccounts/{caid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/artifactaccounts/' + str(self._get('Caid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Targetformats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/targetformats
			def Update(self, Org=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'org': Org}
				return self._REST('/users/' + str(self._get('Uid')) + '/targetformats', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/targetformats
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/targetformats', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Sshkeys(_CommonAPIClass):
			def __call__(self, Sshid=None):
				self.Sshid = Sshid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/sshkeys/{sshid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys/' + str(self._get('Sshid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/sshkeys
			def Getall(self, Name=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'name': Name}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/sshkeys/{sshid}
			def Delete(self, Force=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'force': Force}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys/' + str(self._get('Sshid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/sshkeys
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Roles(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/roles
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/roles', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/roles
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/roles', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Pimages(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Pimages._Status(self)
				pass
			
			#URL: users/{uid}/pimages
			def Getall(self, Img=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'img': Img}
				return self._REST('/users/' + str(self._get('Uid')) + '/pimages', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/pimages/status
				def Getall(self, Img=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'img': Img}
					return self._REST('/users/' + str(self._get('Uid')) + '/pimages/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Scannedinstances(_CommonAPIClass):
			def __call__(self, Siid=None):
				self.Siid = Siid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Scans = Api._Users._Scannedinstances._Scans(self)
				pass
			
			#URL: users/{uid}/scannedinstances/{siid}
			def Get(self, Includescans=None, Delta=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'includeScans': Includescans, 'delta': Delta}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/scannedinstances/{siid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/scannedinstances
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/scannedinstances
			def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/scannedinstances
			def Getall(self, Name=None, Id=None, Index=None, Max=None, Orderby=None, Asc=None, Includescans=None, Delta=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'name': Name, 'id': Id, 'index': Index, 'max': Max, 'orderby': Orderby, 'asc': Asc, 'includeScans': Includescans, 'delta': Delta}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Scans(_CommonAPIClass):
				def __call__(self, Sid=None):
					self.Sid = Sid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Scannedinstances._Scans._Status(self)
					self.Goldens = Api._Users._Scannedinstances._Scans._Goldens(self)
					self.Rawparts = Api._Users._Scannedinstances._Scans._Rawparts(self)
					self.Overlay = Api._Users._Scannedinstances._Scans._Overlay(self)
					self.Imports = Api._Users._Scannedinstances._Scans._Imports(self)
					self.Sync = Api._Users._Scannedinstances._Scans._Sync(self)
					self.Images = Api._Users._Scannedinstances._Scans._Images(self)
					self.Installprofile = Api._Users._Scannedinstances._Scans._Installprofile(self)
					self.Packages = Api._Users._Scannedinstances._Scans._Packages(self)
					self.Files = Api._Users._Scannedinstances._Scans._Files(self)
					pass
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Get(self, Validated=None, Pkgs=None, Added=None, Pkgfiles=None, Dir=None, Rellevel=None, Delta=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'validated': Validated, 'pkgs': Pkgs, 'added': Added, 'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Update(self, Acceptall=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'acceptAll': Acceptall}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, Ongoing=None, Includestats=None, Delta=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset, 'ongoing': Ongoing, 'includeStats': Includestats, 'delta': Delta}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Create(self, Crc=None, Reportfilename=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'crc': Crc, 'reportFileName': Reportfilename}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Multipartcreate(self, Crc=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'crc': Crc}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Compare(self, Rellevel=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'rellevel': Rellevel}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/status
					def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Goldens(_CommonAPIClass):
					def __call__(self, Sitgid=None, Iid=None):
						self.Sitgid = Sitgid
						self.Iid = Iid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Scannedinstances._Scans._Goldens._Status(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/goldens/{sitgid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/goldens/' + str(self._get('Sitgid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/goldens
					def Import(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/goldens', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/goldens
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/goldens', 'GET', body, element_name, streamingResponseFile, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/goldens/{iid}/status
						def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/goldens/' + str(self._get('Iid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/goldens/status
						def Get(self, I=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'i': I}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/goldens//status', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Rawparts(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/rawparts/{fileName}
					def Upload(self, Crc=None, Partitionname=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'crc': Crc, 'partitionName': Partitionname}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/rawparts/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Overlay(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/overlay
					def Upload(self, Crc=None, Overlayname=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'crc': Crc, 'overlayName': Overlayname}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/overlay
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/overlay
					def Uploadchunk(self, Crc=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'crc': Crc}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Imports(_CommonAPIClass):
					def __call__(self, Iid=None):
						self.Iid = Iid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Scannedinstances._Scans._Imports._Status(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports/{iid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports/' + str(self._get('Iid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports
					def Import(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports', 'GET', body, element_name, streamingResponseFile, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports/status
						def Get(self, I=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'i': I}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports/status/', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports/{iid}/status
						def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports/' + str(self._get('Iid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Sync(_CommonAPIClass):
					def __call__(self, Ssid=None):
						self.Ssid = Ssid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Files = Api._Users._Scannedinstances._Scans._Sync._Files(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/sync/{ssid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/sync/' + str(self._get('Ssid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/sync
					def Create(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/sync', 'POST', body, element_name, streamingResponseFile, **kwargs)
					class _Files(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/sync/{ssid}/files
						def Getfiles(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/sync/' + str(self._get('Ssid')) + '/files', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Images(_CommonAPIClass):
					def __call__(self, Itid=None, Sitid=None):
						self.Itid = Itid
						self.Sitid = Sitid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Scannedinstances._Scans._Images._Status(self)
						self.Pimages = Api._Users._Scannedinstances._Scans._Images._Pimages(self)
						self.Downloads = Api._Users._Scannedinstances._Scans._Images._Downloads(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images
					def Getall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images
					def Generate(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images', 'POST', body, element_name, streamingResponseFile, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}/status
						def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}/status
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Pimages(_CommonAPIClass):
						def __call__(self, Pitid=None):
							self.Pitid = Pitid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Status = Api._Users._Scannedinstances._Scans._Images._Pimages._Status(self)
							self.Cancel = Api._Users._Scannedinstances._Scans._Images._Pimages._Cancel(self)
							self.Accounts = Api._Users._Scannedinstances._Scans._Images._Pimages._Accounts(self)
							self.Deploys = Api._Users._Scannedinstances._Scans._Images._Pimages._Deploys(self)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}
						def Delete(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages
						def Publish(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages', 'POST', body, element_name, streamingResponseFile, **kwargs)
						class _Status(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/status
							def Get(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
							
						
						class _Cancel(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/cancel
							def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/cancel', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
							
						
						class _Accounts(_CommonAPIClass):
							def __call__(self, Caid=None):
								self.Caid = Caid
								return self
						
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								self.Resources = Api._Users._Scannedinstances._Scans._Images._Pimages._Accounts._Resources(self)
								pass
							
							#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/accounts/{caid}
							def Getaccount(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/accounts/' + str(self._get('Caid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
							class _Resources(_CommonAPIClass):
								def __init__(self, parent, **kwargs):
									self._parent = parent
									self.__dict__.update(kwargs)
									pass
								
								#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/accounts/{caid}/resources
								def Getaccountresources(self, body=None, element_name=None, streamingResponseFile=None):
									kwargs = {}
									return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/accounts/' + str(self._get('Caid')) + '/resources', 'GET', body, element_name, streamingResponseFile, **kwargs)
								
							
						
						class _Deploys(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/deploys
							def Deploy(self, body=None, element_name=None, streamingResponseFile=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/deploys', 'POST', body, element_name, streamingResponseFile, **kwargs)
							
						
					
					class _Downloads(_CommonAPIClass):
						def __call__(self, Filename=None):
							self.Filename = Filename
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/downloads/{fileName}
						def Downloadfile(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'downloadId': Downloadid}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/downloads/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/downloads
						def Download(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'downloadId': Downloadid}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/downloads', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Installprofile(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/installprofile
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/installprofile', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Packages(_CommonAPIClass):
					def __call__(self, Pid=None):
						self.Pid = Pid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Bin = Api._Users._Scannedinstances._Scans._Packages._Bin(self)
						self.Files = Api._Users._Scannedinstances._Scans._Packages._Files(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/packages
					def Getall(self, Excludefiles=None, All=None, Fromrepo=None, Uploaded=None, Notselected=None, Comparewith=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'excludeFiles': Excludefiles, 'all': All, 'fromRepo': Fromrepo, 'uploaded': Uploaded, 'notSelected': Notselected, 'compareWith': Comparewith}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages', 'GET', body, element_name, streamingResponseFile, **kwargs)
					class _Bin(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/packages/{pid}/bin
						def Getall(self, Downloadtoken=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'downloadToken': Downloadtoken}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages/' + str(self._get('Pid')) + '/bin', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Files(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/packages/{pid}/files
						def Get(self, Dir=None, Rellevel=None, Delta=None, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {'dir': Dir, 'rellevel': Rellevel, 'delta': Delta}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages/' + str(self._get('Pid')) + '/files', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Files(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/files
					def Download(self, Limit=None, Comparewith=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'limit': Limit, 'compareWith': Comparewith}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/files', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/files
					def Getall(self, Comparewith=None, Limit=None, Added=None, Pkgfiles=None, Dir=None, Rellevel=None, Delta=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'compareWith': Comparewith, 'limit': Limit, 'added': Added, 'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/files', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
		
		class _Formats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/formats
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/users/' + str(self._get('Uid')) + '/formats', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/formats
			def Update(self, Org=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'org': Org}
				return self._REST('/users/' + str(self._get('Uid')) + '/formats', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Orgs(_CommonAPIClass):
			def __call__(self, Oid=None):
				self.Oid = Oid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/orgs
			def Getall(self, Name=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'name': Name}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/orgs/{oid}
			def Change(self, Admin=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'admin': Admin}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs/' + str(self._get('Oid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: users/{uid}/orgs/{oid}
			def Remove(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs/' + str(self._get('Oid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
		
	
	class _Entitlements(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: entitlements
		def Getall(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/entitlements', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
	
	class _Usergroups(_CommonAPIClass):
		def __call__(self, Ugid=None):
			self.Ugid = Ugid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Members = Api._Usergroups._Members(self)
			pass
		
		#URL: usergroups
		def Getall(self, Name=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'name': Name}
			return self._REST('/usergroups', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: usergroups/{ugid}
		def Delete(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/usergroups/' + str(self._get('Ugid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: usergroups
		def Create(self, Org=None, Publisher=None, Admin=None, Force=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'org': Org, 'publisher': Publisher, 'admin': Admin, 'force': Force}
			return self._REST('/usergroups', 'POST', body, element_name, streamingResponseFile, **kwargs)
		class _Members(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: usergroups/{ugid}/members
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/usergroups/' + str(self._get('Ugid')) + '/members', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: usergroups/{ugid}/members
			def Add(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/usergroups/' + str(self._get('Ugid')) + '/members', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: usergroups/{ugid}/members
			def Delete(self, User=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'user': User}
				return self._REST('/usergroups/' + str(self._get('Ugid')) + '/members', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
		
	
	class _Usage(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: usage
		def Get(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
			return self._REST('/usage', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
	
	class _Orgs(_CommonAPIClass):
		def __call__(self, Oid=None):
			self.Oid = Oid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Targetplatforms = Api._Orgs._Targetplatforms(self)
			self.Workspaces = Api._Orgs._Workspaces(self)
			self.Roles = Api._Orgs._Roles(self)
			self.Subscriptions = Api._Orgs._Subscriptions(self)
			self.Companies = Api._Orgs._Companies(self)
			self.Repositories = Api._Orgs._Repositories(self)
			self.Artifactaccounts = Api._Orgs._Artifactaccounts(self)
			self.Licenses = Api._Orgs._Licenses(self)
			self.Projects = Api._Orgs._Projects(self)
			self.Members = Api._Orgs._Members(self)
			self.Formats = Api._Orgs._Formats(self)
			self.Targetformats = Api._Orgs._Targetformats(self)
			self.Stats = Api._Orgs._Stats(self)
			self.Distributions = Api._Orgs._Distributions(self)
			self.Categories = Api._Orgs._Categories(self)
			pass
		
		#URL: orgs/{oid}
		def Get(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/orgs/' + str(self._get('Oid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: orgs
		def Create(self, Autoactivate=None, Hasgallery=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'autoActivate': Autoactivate, 'hasGallery': Hasgallery}
			return self._REST('/orgs', 'POST', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: orgs
		def Getall(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/orgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
		class _Targetplatforms(_CommonAPIClass):
			def __call__(self, Tpid=None):
				self.Tpid = Tpid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Targetformats = Api._Orgs._Targetplatforms._Targetformats(self)
				self.Logo = Api._Orgs._Targetplatforms._Logo(self)
				pass
			
			#URL: orgs/{oid}/targetplatforms
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetplatforms/{tpid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetplatforms
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetplatforms/{tpid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetplatforms
			def Updateaccess(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetplatforms/{tpid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Targetformats(_CommonAPIClass):
				def __call__(self, Tfid=None):
					self.Tfid = Tfid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/targetformats
				def Getallformats(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/targetformats', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/targetformats/{tfid}
				def Removeformat(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/targetformats/' + str(self._get('Tfid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/targetformats
				def Addformat(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/targetformats', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/logo/{logoId}/{fileName}
				def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/logo/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/logo/{logoId}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetplatforms/{tpid}/logo/{logoId}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetplatforms/' + str(self._get('Tpid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Workspaces(_CommonAPIClass):
			def __call__(self, Wid=None):
				self.Wid = Wid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Templates = Api._Orgs._Workspaces._Templates(self)
				self.Memberships = Api._Orgs._Workspaces._Memberships(self)
				self.Comments = Api._Orgs._Workspaces._Comments(self)
				pass
			
			#URL: orgs/{oid}/workspaces
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/workspaces/{wid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/workspaces
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/workspaces/{wid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Templates(_CommonAPIClass):
				def __call__(self, Tid=None):
					self.Tid = Tid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Orgs._Workspaces._Templates._Status(self)
					self.Osprofile = Api._Orgs._Workspaces._Templates._Osprofile(self)
					self.Comments = Api._Orgs._Workspaces._Templates._Comments(self)
					self.Oas = Api._Orgs._Workspaces._Templates._Oas(self)
					self.Logo = Api._Orgs._Workspaces._Templates._Logo(self)
					self.Vote = Api._Orgs._Workspaces._Templates._Vote(self)
					self.Stats = Api._Orgs._Workspaces._Templates._Stats(self)
					self.Installprofile = Api._Orgs._Workspaces._Templates._Installprofile(self)
					self.Projects = Api._Orgs._Workspaces._Templates._Projects(self)
					pass
				
				#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}
				def Delete(self, Force=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'force': Force}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates
				def Share(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/status
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/status
					def Cancel(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/status', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Osprofile(_CommonAPIClass):
					def __call__(self, Ospid=None):
						self.Ospid = Ospid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Services = Api._Orgs._Workspaces._Templates._Osprofile._Services(self)
						self.Applications = Api._Orgs._Workspaces._Templates._Osprofile._Applications(self)
						self.Partitiontable = Api._Orgs._Workspaces._Templates._Osprofile._Partitiontable(self)
						self.Pkgs = Api._Orgs._Workspaces._Templates._Osprofile._Pkgs(self)
						pass
					
					class _Services(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/osprofile/{ospid}/services
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/osprofile/' + str(self._get('Ospid')) + '/services', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Applications(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/osprofile/{ospid}/applications
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/osprofile/' + str(self._get('Ospid')) + '/applications', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Partitiontable(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/osprofile/{ospid}/partitionTable
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/osprofile/' + str(self._get('Ospid')) + '/partitionTable', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Pkgs(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/osprofile/{ospid}/pkgs
						def Get(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/osprofile/' + str(self._get('Ospid')) + '/pkgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Comments(_CommonAPIClass):
					def __call__(self, Cid=None):
						self.Cid = Cid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Abuses = Api._Orgs._Workspaces._Templates._Comments._Abuses(self)
						self.Likes = Api._Orgs._Workspaces._Templates._Comments._Likes(self)
						self.Replies = Api._Orgs._Workspaces._Templates._Comments._Replies(self)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments
					def Create(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments
					def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments
					def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}
					def Update(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					class _Abuses(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}/abuses
						def Reportabuse(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Likes(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}/likes
						def Dislike(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}/likes
						def Like(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
					
					class _Replies(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}/replies
						def Reply(self, body=None, element_name=None, streamingResponseFile=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, element_name, streamingResponseFile, **kwargs)
						
					
				
				class _Oas(_CommonAPIClass):
					def __call__(self, Oaspkgid=None):
						self.Oaspkgid = Oaspkgid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/oas/{oaspkgid}
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Logo(_CommonAPIClass):
					def __call__(self, Lid=None, Filename=None):
						self.Lid = Lid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/logo/{lid}
					def Download(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/logo/{lid}/{fileName}
					def Upload(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/logo/{lid}
					def Delete(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Vote(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/vote
					def Vote(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/vote', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Stats(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/stats
					def Get(self, Fromdate=None, Todate=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'fromDate': Fromdate, 'toDate': Todate}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/stats', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Installprofile(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/installProfile
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/installProfile', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Projects(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/projects
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/projects', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Memberships(_CommonAPIClass):
				def __call__(self, Mid=None):
					self.Mid = Mid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Invite(self, Pi=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'pi': Pi}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships/{mid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships/' + str(self._get('Mid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Getall(self, User=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'user': User}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Deletelist(self, Email=None, Login=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'email': Email, 'login': Login}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Updatelist(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships/{mid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships/' + str(self._get('Mid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Comments(_CommonAPIClass):
				def __call__(self, Cid=None):
					self.Cid = Cid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Replies = Api._Orgs._Workspaces._Comments._Replies(self)
					self.Likes = Api._Orgs._Workspaces._Comments._Likes(self)
					self.Abuses = Api._Orgs._Workspaces._Comments._Abuses(self)
					pass
				
				#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments
				def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments', 'POST', body, element_name, streamingResponseFile, **kwargs)
				class _Replies(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}/replies
					def Reply(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Likes(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}/likes
					def Dislike(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}/likes
					def Like(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '/likes', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Abuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}/abuses
					def Reportabuse(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
			
		
		class _Roles(_CommonAPIClass):
			def __call__(self, Rolename=None):
				self.Rolename = Rolename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/roles/{rolename}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles/' + str(self._get('Rolename')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/roles', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Subscriptions(_CommonAPIClass):
			def __call__(self, Spid=None):
				self.Spid = Spid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Targetplatforms = Api._Orgs._Subscriptions._Targetplatforms(self)
				self.Roles = Api._Orgs._Subscriptions._Roles(self)
				self.Quotas = Api._Orgs._Subscriptions._Quotas(self)
				self.Admins = Api._Orgs._Subscriptions._Admins(self)
				self.Formats = Api._Orgs._Subscriptions._Formats(self)
				self.Targetformats = Api._Orgs._Subscriptions._Targetformats(self)
				self.Distros = Api._Orgs._Subscriptions._Distros(self)
				pass
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/subscriptions
			def Getall(self, Search=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'search': Search}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Remove(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/subscriptions
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions', 'POST', body, element_name, streamingResponseFile, **kwargs)
			class _Targetplatforms(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/targetplatforms
				def Update(self, Allusers=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'allusers': Allusers}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/targetplatforms', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Roles(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/roles
				def Update(self, Allusers=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'allusers': Allusers}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/roles', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Quotas(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/quotas
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/quotas', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Admins(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/admins
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/admins', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Formats(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/formats
				def Update(self, Allusers=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'allusers': Allusers}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/formats', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Targetformats(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/targetformats
				def Update(self, Allusers=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'allusers': Allusers}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/targetformats', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Distros(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/distros
				def Update(self, Allusers=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'allusers': Allusers}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/distros', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Companies(_CommonAPIClass):
			def __call__(self, Cid=None):
				self.Cid = Cid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Logos = Api._Orgs._Companies._Logos(self)
				pass
			
			#URL: orgs/{oid}/companies
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/companies', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Logos(_CommonAPIClass):
				def __call__(self, Sclogoid=None, Filename=None):
					self.Sclogoid = Sclogoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}/{fileName}
				def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Repositories(_CommonAPIClass):
			def __call__(self, Rid=None):
				self.Rid = Rid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Distributions = Api._Orgs._Repositories._Distributions(self)
				self.Updates = Api._Orgs._Repositories._Updates(self)
				pass
			
			#URL: orgs/{oid}/repositories/{rid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/repositories/{rid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/repositories
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/repositories
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Distributions(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/repositories/{rid}/distributions
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '/distributions', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Updates(_CommonAPIClass):
				def __call__(self, Uid=None):
					self.Uid = Uid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Orgs._Repositories._Updates._Status(self)
					pass
				
				#URL: orgs/{oid}/repositories/{rid}/updates
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '/updates', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/repositories/{rid}/updates
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '/updates', 'GET', body, element_name, streamingResponseFile, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/repositories/{rid}/updates/{uid}/status
					def Get(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '/updates/' + str(self._get('Uid')) + '/status', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
		
		class _Artifactaccounts(_CommonAPIClass):
			def __call__(self, Caid=None):
				self.Caid = Caid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/artifactaccounts/{caid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/artifactaccounts/' + str(self._get('Caid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/artifactaccounts/{caid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/artifactaccounts/' + str(self._get('Caid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/artifactaccounts
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/artifactaccounts', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/artifactaccounts
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/artifactaccounts', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/artifactaccounts/{caid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/artifactaccounts/' + str(self._get('Caid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Licenses(_CommonAPIClass):
			def __call__(self, Slid=None):
				self.Slid = Slid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/licenses/{slid}
			def Download(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/licenses/' + str(self._get('Slid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/licenses
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/licenses', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Projects(_CommonAPIClass):
			def __call__(self, Pid=None):
				self.Pid = Pid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Images = Api._Orgs._Projects._Images(self)
				self.Artifacts = Api._Orgs._Projects._Artifacts(self)
				self.Licenses = Api._Orgs._Projects._Licenses(self)
				self.Logo = Api._Orgs._Projects._Logo(self)
				self.Restriction = Api._Orgs._Projects._Restriction(self)
				pass
			
			#URL: orgs/{oid}/projects
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/projects/{pid}
			def Delete(self, Erase=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'erase': Erase}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/projects/{pid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/projects
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, Distribid=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset, 'distribId': Distribid}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/projects/{pid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Images(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/projects/{pid}/images
				def Availableforimage(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/images', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Artifacts(_CommonAPIClass):
				def __call__(self, Said=None):
					self.Said = Said
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Orgs._Projects._Artifacts._Bin(self)
					self.Subsoftwareartifacts = Api._Orgs._Projects._Artifacts._Subsoftwareartifacts(self)
					self.Fetch = Api._Orgs._Projects._Artifacts._Fetch(self)
					pass
				
				#URL: orgs/{oid}/projects/{pid}/artifacts
				def Updateall(self, Recursive=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'recursive': Recursive}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/artifacts
				def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/artifacts/{said}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/artifacts/{said}
				def Update(self, Recursive=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'recursive': Recursive}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/artifacts/{said}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/artifacts
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/artifacts
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts', 'GET', body, element_name, streamingResponseFile, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/projects/{pid}/artifacts/{said}/bin/{fileName}
					def Upload(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/projects/{pid}/artifacts/{said}/bin/{fileName}
					def Downloadfile(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/projects/{pid}/artifacts/{said}/bin
					def Download(self, Downloadid=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '/bin', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Subsoftwareartifacts(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/projects/{pid}/artifacts/{said}/subsoftwareartifacts
					def Addchild(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '/subsoftwareartifacts', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
				class _Fetch(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/projects/{pid}/artifacts/{said}/fetch
					def Addorremovefilefromcache(self, Usecache=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'useCache': Usecache}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/' + str(self._get('Said')) + '/fetch', 'PUT', body, element_name, streamingResponseFile, **kwargs)
					
					#URL: orgs/{oid}/projects/{pid}/artifacts/fetch
					def Createfromremoteserver(self, Parentsaid=None, Caid=None, Remotefilepath=None, Usecache=None, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {'parentsaid': Parentsaid, 'caid': Caid, 'remoteFilePath': Remotefilepath, 'useCache': Usecache}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/artifacts/fetch', 'GET', body, element_name, streamingResponseFile, **kwargs)
					
				
			
			class _Licenses(_CommonAPIClass):
				def __call__(self, Lid=None, Filename=None):
					self.Lid = Lid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/projects/{pid}/licenses/{lid}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Lid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/licenses/{lid}
				def Uploadchunk(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Lid')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/licenses/{lid}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Lid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/licenses/{lid}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Lid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/projects/{pid}/logo/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/logo/{logoId}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/logo/{logoId}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/projects/{pid}/logo/{logoId}/{fileName}
				def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Restriction(_CommonAPIClass):
				def __call__(self, Brid=None):
					self.Brid = Brid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Distributions = Api._Orgs._Projects._Restriction._Distributions(self)
					pass
				
				#URL: orgs/{oid}/projects/{pid}/restriction/{brid}
				def Update(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/restriction/' + str(self._get('Brid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
				class _Distributions(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/projects/{pid}/restriction/{brid}/distributions
					def Evaluate(self, body=None, element_name=None, streamingResponseFile=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/projects/' + str(self._get('Pid')) + '/restriction/' + str(self._get('Brid')) + '/distributions', 'POST', body, element_name, streamingResponseFile, **kwargs)
					
				
			
		
		class _Members(_CommonAPIClass):
			def __call__(self, Uid=None):
				self.Uid = Uid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/members/{uid}
			def Update(self, Admin=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'admin': Admin}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members/' + str(self._get('Uid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/members
			def Getall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/members/{uid}
			def Remove(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members/' + str(self._get('Uid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Formats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/formats
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/formats', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/formats
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/formats', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Targetformats(_CommonAPIClass):
			def __call__(self, Tfid=None):
				self.Tfid = Tfid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Logo = Api._Orgs._Targetformats._Logo(self)
				self.Targetplatforms = Api._Orgs._Targetformats._Targetplatforms(self)
				pass
			
			#URL: orgs/{oid}/targetformats/{tfid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetformats/{tfid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetformats
			def Updateaccess(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetformats
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetformats/{tfid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/targetformats
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/targetformats/{tfid}/logo/{logoId}
				def Delete(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetformats/{tfid}/logo/{logoId}/{fileName}
				def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetformats/{tfid}/logo/{logoId}/{fileName}
				def Upload(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetformats/{tfid}/logo/{logoId}
				def Download(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Targetplatforms(_CommonAPIClass):
				def __call__(self, Tpid=None):
					self.Tpid = Tpid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/targetformats/{tfid}/targetplatforms/{tpid}
				def Removetargetplatform(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/targetplatforms/' + str(self._get('Tpid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetformats/{tfid}/targetplatforms
				def Getalltargetplatforms(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/targetplatforms', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/targetformats/{tfid}/targetplatforms
				def Addtargetplatform(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/targetformats/' + str(self._get('Tfid')) + '/targetplatforms', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Stats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/stats
			def Get(self, Type=None, Filter=None, Fromdate=None, Todate=None, Graphtype=None, Periodicity=None, Nb=None, Order=None, Groupby=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'type': Type, 'filter': Filter, 'fromDate': Fromdate, 'toDate': Todate, 'graphType': Graphtype, 'periodicity': Periodicity, 'nb': Nb, 'order': Order, 'groupby': Groupby}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/stats', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Distributions(_CommonAPIClass):
			def __call__(self, Did=None):
				self.Did = Did
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Goldens = Api._Orgs._Distributions._Goldens(self)
				pass
			
			#URL: orgs/{oid}/distributions
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/distributions
			def Getall(self, Name=None, Version=None, Arch=None, Info=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'name': Name, 'version': Version, 'arch': Arch, 'info': Info}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/distributions
			def Add(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions', 'POST', body, element_name, streamingResponseFile, **kwargs)
			class _Goldens(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/distributions/{did}/goldens
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions/' + str(self._get('Did')) + '/goldens', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/distributions/{did}/goldens
				def Delete(self, Prname=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'prname': Prname}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions/' + str(self._get('Did')) + '/goldens', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: orgs/{oid}/distributions/{did}/goldens
				def Add(self, Language=None, Edition=None, Type=None, Goldendate=None, Force=None, Profilename=None, Goldenpath=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'language': Language, 'edition': Edition, 'type': Type, 'goldenDate': Goldendate, 'force': Force, 'profileName': Profilename, 'goldenPath': Goldenpath}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions/' + str(self._get('Did')) + '/goldens', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Categories(_CommonAPIClass):
			def __call__(self, Cid=None):
				self.Cid = Cid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Subcategories = Api._Orgs._Categories._Subcategories(self)
				pass
			
			#URL: orgs/{oid}/categories
			def Create(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/categories
			def Deleteall(self, Id=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'id': Id}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: orgs/{oid}/categories
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Subcategories(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/categories/{cid}/subcategories
				def Create(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '/subcategories', 'POST', body, element_name, streamingResponseFile, **kwargs)
				
			
		
	
	class _Distributions(_CommonAPIClass):
		def __call__(self, Id=None, Oid=None, Name=None, Version=None):
			self.Id = Id
			self.Oid = Oid
			self.Name = Name
			self.Version = Version
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Milestones = Api._Distributions._Milestones(self)
			self.License = Api._Distributions._License(self)
			self.Profiles = Api._Distributions._Profiles(self)
			self.Pkgs = Api._Distributions._Pkgs(self)
			self.Changeactivestatus = Api._Distributions._Changeactivestatus(self)
			self.Logo = Api._Distributions._Logo(self)
			pass
		
		#URL: distributions
		def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
			return self._REST('/distributions', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: distributions/{id}
		def Update(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/distributions/' + str(self._get('Id')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: distributions/{oid}/{name}/{version}
		def Create(self, Flavor=None, Arch=None, Isactive=None, Isdefault=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'flavor': Flavor, 'arch': Arch, 'isActive': Isactive, 'isDefault': Isdefault}
			return self._REST('/distributions/' + str(self._get('Oid')) + '/' + str(self._get('Name')) + '/' + str(self._get('Version')) + '', 'POST', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: distributions/{id}
		def Get(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/distributions/' + str(self._get('Id')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
		class _Milestones(_CommonAPIClass):
			def __call__(self, Mid=None):
				self.Mid = Mid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/milestones
			def Getall(self, Search=None, Orguri=None, From=None, To=None, Singlesearch=None, Cs=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'search': Search, 'orgUri': Orguri, 'from': From, 'to': To, 'singleSearch': Singlesearch, 'cs': Cs}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/milestones
			def Create(self, Orgid=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/milestones/{mid}
			def Update(self, Orgid=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones/' + str(self._get('Mid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/milestones/{mid}
			def Delete(self, Orgid=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones/' + str(self._get('Mid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/milestones/{mid}
			def Get(self, Orgid=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones/' + str(self._get('Mid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _License(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/license
			def Download(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/license', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Profiles(_CommonAPIClass):
			def __call__(self, Prid=None):
				self.Prid = Prid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Services = Api._Distributions._Profiles._Services(self)
				self.Applications = Api._Distributions._Profiles._Applications(self)
				self.Pkgs = Api._Distributions._Profiles._Pkgs(self)
				pass
			
			#URL: distributions/{id}/profiles/{prid}
			def Update(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/profiles
			def Create(self, Basedon=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'basedOn': Basedon}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/profiles
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/profiles/{prid}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/profiles/{prid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Services(_CommonAPIClass):
				def __call__(self, Sid=None):
					self.Sid = Sid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/profiles/{prid}/services
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '/services', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: distributions/{id}/profiles/{prid}/services/{sid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '/services/' + str(self._get('Sid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Applications(_CommonAPIClass):
				def __call__(self, Appid=None):
					self.Appid = Appid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/profiles/{prid}/applications
				def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
					return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '/applications', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
				#URL: distributions/{id}/profiles/{prid}/applications/{appid}
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '/applications/' + str(self._get('Appid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
			class _Pkgs(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/profiles/{prid}/pkgs
				def Get(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '/pkgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Pkgs(_CommonAPIClass):
			def __call__(self, Pid=None):
				self.Pid = Pid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Updateinfo = Api._Distributions._Pkgs._Updateinfo(self)
				pass
			
			#URL: distributions/{id}/pkgs
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, Latestonly=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset, 'latestOnly': Latestonly}
				return self._REST('/distributions/' + str(self._get('Id')) + '/pkgs', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/pkgs/{pid}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/pkgs/' + str(self._get('Pid')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			class _Updateinfo(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/pkgs/{pid}/updateinfo
				def Getall(self, body=None, element_name=None, streamingResponseFile=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/pkgs/' + str(self._get('Pid')) + '/updateinfo', 'GET', body, element_name, streamingResponseFile, **kwargs)
				
			
		
		class _Changeactivestatus(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/changeActiveStatus
			def Update(self, Active=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'active': Active}
				return self._REST('/distributions/' + str(self._get('Id')) + '/changeActiveStatus', 'PUT', body, element_name, streamingResponseFile, **kwargs)
			
		
		class _Logo(_CommonAPIClass):
			def __call__(self, Filename=None):
				self.Filename = Filename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/logo/{fileName}
			def Downloadfile(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/logo/' + str(self._get('Filename')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: distributions/{id}/logo
			def Download(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/logo', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
	
	class _CloudProviders(_CommonAPIClass):
		def __call__(self, Provider=None):
			self.Provider = Provider
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Birs = Api._CloudProviders._Birs(self)
			pass
		
		#URL: cloud-providers/{provider}
		def Get(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/cloud-providers/' + str(self._get('Provider')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: cloud-providers
		def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
			return self._REST('/cloud-providers', 'GET', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: cloud-providers
		def Create(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/cloud-providers', 'POST', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: cloud-providers
		def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/cloud-providers', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
		
		#URL: cloud-providers/{provider}
		def Delete(self, body=None, element_name=None, streamingResponseFile=None):
			kwargs = {}
			return self._REST('/cloud-providers/' + str(self._get('Provider')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
		class _Birs(_CommonAPIClass):
			def __call__(self, Bir=None):
				self.Bir = Bir
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: cloud-providers/{provider}/birs/{bir}
			def Get(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/cloud-providers/' + str(self._get('Provider')) + '/birs/' + str(self._get('Bir')) + '', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: cloud-providers/{provider}/birs
			def Deleteall(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/cloud-providers/' + str(self._get('Provider')) + '/birs', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: cloud-providers/{provider}/birs/{bir}
			def Delete(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/cloud-providers/' + str(self._get('Provider')) + '/birs/' + str(self._get('Bir')) + '', 'DELETE', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: cloud-providers/{provider}/birs
			def Set(self, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {}
				return self._REST('/cloud-providers/' + str(self._get('Provider')) + '/birs', 'POST', body, element_name, streamingResponseFile, **kwargs)
			
			#URL: cloud-providers/{provider}/birs
			def Getall(self, Query=None, Descending=None, Orderby=None, Count=None, Offset=None, body=None, element_name=None, streamingResponseFile=None):
				kwargs = {'query': Query, 'descending': Descending, 'orderBy': Orderby, 'count': Count, 'offset': Offset}
				return self._REST('/cloud-providers/' + str(self._get('Provider')) + '/birs', 'GET', body, element_name, streamingResponseFile, **kwargs)
			
		
	
