# mypy-boto3-cognito-idp<a id="mypy-boto3-cognito-idp"></a>

[![PyPI - mypy-boto3-cognito-idp](https://img.shields.io/pypi/v/mypy-boto3-cognito-idp.svg?color=blue)](https://pypi.org/project/mypy-boto3-cognito-idp)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cognito-idp.svg?color=blue)](https://pypi.org/project/mypy-boto3-cognito-idp)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-cognito-idp?color=blue)](https://pypistats.org/packages/mypy-boto3-cognito-idp)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CognitoIdentityProvider 1.17.89](https://boto3.amazonaws.com/v1/documentation/api/1.17.89/reference/services/cognito-idp.html#CognitoIdentityProvider)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.15.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-cognito-idp docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cognito_idp/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-cognito-idp](#mypy-boto3-cognito-idp)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `CognitoIdentityProvider` service.

```bash
python -m pip install boto3-stubs[cognito-idp]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cognito-idp]` in your environment:
  `python -m pip install 'boto3-stubs[cognito-idp]'`

Both type checking and auto-complete should work for `CognitoIdentityProvider`
service. No explicit type annotations required, write your `boto3` code as
usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[cognito-idp]` in your environment:
  `python -m pip install 'boto3-stubs[cognito-idp]'`

Both type checking and auto-complete should work for `CognitoIdentityProvider`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cognito-idp]` in your environment:
  `python -m pip install 'boto3-stubs[cognito-idp]'`
- Run `mypy` as usual

Type checking should work for `CognitoIdentityProvider` service. No explicit
type annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cognito-idp]` in your environment:
  `python -m pip install 'boto3-stubs[cognito-idp]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CognitoIdentityProvider` service. No explicit
type annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`CognitoIdentityProviderClient` provides annotations for
`boto3.client("cognito-idp")`.

```python
import boto3

from mypy_boto3_cognito_idp import CognitoIdentityProviderClient

client: CognitoIdentityProviderClient = boto3.client("cognito-idp")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CognitoIdentityProviderClient = session.client("cognito-idp")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_cognito_idp.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_cognito_idp import CognitoIdentityProviderClient
from mypy_boto3_cognito_idp.paginator import (
    AdminListGroupsForUserPaginator,
    AdminListUserAuthEventsPaginator,
    ListGroupsPaginator,
    ListIdentityProvidersPaginator,
    ListResourceServersPaginator,
    ListUserPoolClientsPaginator,
    ListUserPoolsPaginator,
    ListUsersPaginator,
    ListUsersInGroupPaginator,
)

client: CognitoIdentityProviderClient = boto3.client("cognito-idp")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
admin_list_groups_for_user_paginator: AdminListGroupsForUserPaginator = client.get_paginator("admin_list_groups_for_user")
admin_list_user_auth_events_paginator: AdminListUserAuthEventsPaginator = client.get_paginator("admin_list_user_auth_events")
list_groups_paginator: ListGroupsPaginator = client.get_paginator("list_groups")
list_identity_providers_paginator: ListIdentityProvidersPaginator = client.get_paginator("list_identity_providers")
list_resource_servers_paginator: ListResourceServersPaginator = client.get_paginator("list_resource_servers")
list_user_pool_clients_paginator: ListUserPoolClientsPaginator = client.get_paginator("list_user_pool_clients")
list_user_pools_paginator: ListUserPoolsPaginator = client.get_paginator("list_user_pools")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
list_users_in_group_paginator: ListUsersInGroupPaginator = client.get_paginator("list_users_in_group")
```

### Literals<a id="literals"></a>

`mypy_boto3_cognito_idp.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_cognito_idp.literals import (
    AccountTakeoverEventActionTypeType,
    AdminListGroupsForUserPaginatorName,
    AdminListUserAuthEventsPaginatorName,
    AdvancedSecurityModeTypeType,
    AliasAttributeTypeType,
    AttributeDataTypeType,
    AuthFlowTypeType,
    ChallengeNameType,
    ChallengeNameTypeType,
    ChallengeResponseType,
    CompromisedCredentialsEventActionTypeType,
    CustomEmailSenderLambdaVersionTypeType,
    CustomSMSSenderLambdaVersionTypeType,
    DefaultEmailOptionTypeType,
    DeliveryMediumTypeType,
    DeviceRememberedStatusTypeType,
    DomainStatusTypeType,
    EmailSendingAccountTypeType,
    EventFilterTypeType,
    EventResponseTypeType,
    EventTypeType,
    ExplicitAuthFlowsTypeType,
    FeedbackValueTypeType,
    IdentityProviderTypeTypeType,
    ListGroupsPaginatorName,
    ListIdentityProvidersPaginatorName,
    ListResourceServersPaginatorName,
    ListUserPoolClientsPaginatorName,
    ListUserPoolsPaginatorName,
    ListUsersInGroupPaginatorName,
    ListUsersPaginatorName,
    MessageActionTypeType,
    OAuthFlowTypeType,
    PreventUserExistenceErrorTypesType,
    RecoveryOptionNameTypeType,
    RiskDecisionTypeType,
    RiskLevelTypeType,
    StatusTypeType,
    TimeUnitsTypeType,
    UserImportJobStatusTypeType,
    UserPoolMfaTypeType,
    UserStatusTypeType,
    UsernameAttributeTypeType,
    VerifiedAttributeTypeType,
    VerifySoftwareTokenResponseTypeType,
)

def check_value(value: AccountTakeoverEventActionTypeType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_cognito_idp.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_cognito_idp.type_defs import (
    AccountRecoverySettingTypeTypeDef,
    AccountTakeoverActionTypeTypeDef,
    AccountTakeoverActionsTypeTypeDef,
    AccountTakeoverRiskConfigurationTypeTypeDef,
    AdminCreateUserConfigTypeTypeDef,
    AdminCreateUserResponseTypeDef,
    AdminGetDeviceResponseTypeDef,
    AdminGetUserResponseTypeDef,
    AdminInitiateAuthResponseTypeDef,
    AdminListDevicesResponseTypeDef,
    AdminListGroupsForUserResponseTypeDef,
    AdminListUserAuthEventsResponseTypeDef,
    AdminRespondToAuthChallengeResponseTypeDef,
    AnalyticsConfigurationTypeTypeDef,
    AnalyticsMetadataTypeTypeDef,
    AssociateSoftwareTokenResponseTypeDef,
    AttributeTypeTypeDef,
    AuthEventTypeTypeDef,
    AuthenticationResultTypeTypeDef,
    ChallengeResponseTypeTypeDef,
    CodeDeliveryDetailsTypeTypeDef,
    CompromisedCredentialsActionsTypeTypeDef,
    CompromisedCredentialsRiskConfigurationTypeTypeDef,
    ConfirmDeviceResponseTypeDef,
    ContextDataTypeTypeDef,
    CreateGroupResponseTypeDef,
    CreateIdentityProviderResponseTypeDef,
    CreateResourceServerResponseTypeDef,
    CreateUserImportJobResponseTypeDef,
    CreateUserPoolClientResponseTypeDef,
    CreateUserPoolDomainResponseTypeDef,
    CreateUserPoolResponseTypeDef,
    CustomDomainConfigTypeTypeDef,
    CustomEmailLambdaVersionConfigTypeTypeDef,
    CustomSMSLambdaVersionConfigTypeTypeDef,
    DescribeIdentityProviderResponseTypeDef,
    DescribeResourceServerResponseTypeDef,
    DescribeRiskConfigurationResponseTypeDef,
    DescribeUserImportJobResponseTypeDef,
    DescribeUserPoolClientResponseTypeDef,
    DescribeUserPoolDomainResponseTypeDef,
    DescribeUserPoolResponseTypeDef,
    DeviceConfigurationTypeTypeDef,
    DeviceSecretVerifierConfigTypeTypeDef,
    DeviceTypeTypeDef,
    DomainDescriptionTypeTypeDef,
    EmailConfigurationTypeTypeDef,
    EventContextDataTypeTypeDef,
    EventFeedbackTypeTypeDef,
    EventRiskTypeTypeDef,
    ForgotPasswordResponseTypeDef,
    GetCSVHeaderResponseTypeDef,
    GetDeviceResponseTypeDef,
    GetGroupResponseTypeDef,
    GetIdentityProviderByIdentifierResponseTypeDef,
    GetSigningCertificateResponseTypeDef,
    GetUICustomizationResponseTypeDef,
    GetUserAttributeVerificationCodeResponseTypeDef,
    GetUserPoolMfaConfigResponseTypeDef,
    GetUserResponseTypeDef,
    GroupTypeTypeDef,
    HttpHeaderTypeDef,
    IdentityProviderTypeTypeDef,
    InitiateAuthResponseTypeDef,
    LambdaConfigTypeTypeDef,
    ListDevicesResponseTypeDef,
    ListGroupsResponseTypeDef,
    ListIdentityProvidersResponseTypeDef,
    ListResourceServersResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUserImportJobsResponseTypeDef,
    ListUserPoolClientsResponseTypeDef,
    ListUserPoolsResponseTypeDef,
    ListUsersInGroupResponseTypeDef,
    ListUsersResponseTypeDef,
    MFAOptionTypeTypeDef,
    MessageTemplateTypeTypeDef,
    NewDeviceMetadataTypeTypeDef,
    NotifyConfigurationTypeTypeDef,
    NotifyEmailTypeTypeDef,
    NumberAttributeConstraintsTypeTypeDef,
    PaginatorConfigTypeDef,
    PasswordPolicyTypeTypeDef,
    ProviderDescriptionTypeDef,
    ProviderUserIdentifierTypeTypeDef,
    RecoveryOptionTypeTypeDef,
    ResendConfirmationCodeResponseTypeDef,
    ResourceServerScopeTypeTypeDef,
    ResourceServerTypeTypeDef,
    RespondToAuthChallengeResponseTypeDef,
    RiskConfigurationTypeTypeDef,
    RiskExceptionConfigurationTypeTypeDef,
    SMSMfaSettingsTypeTypeDef,
    SchemaAttributeTypeTypeDef,
    SetRiskConfigurationResponseTypeDef,
    SetUICustomizationResponseTypeDef,
    SetUserPoolMfaConfigResponseTypeDef,
    SignUpResponseTypeDef,
    SmsConfigurationTypeTypeDef,
    SmsMfaConfigTypeTypeDef,
    SoftwareTokenMfaConfigTypeTypeDef,
    SoftwareTokenMfaSettingsTypeTypeDef,
    StartUserImportJobResponseTypeDef,
    StopUserImportJobResponseTypeDef,
    StringAttributeConstraintsTypeTypeDef,
    TokenValidityUnitsTypeTypeDef,
    UICustomizationTypeTypeDef,
    UpdateGroupResponseTypeDef,
    UpdateIdentityProviderResponseTypeDef,
    UpdateResourceServerResponseTypeDef,
    UpdateUserAttributesResponseTypeDef,
    UpdateUserPoolClientResponseTypeDef,
    UpdateUserPoolDomainResponseTypeDef,
    UserContextDataTypeTypeDef,
    UserImportJobTypeTypeDef,
    UserPoolAddOnsTypeTypeDef,
    UserPoolClientDescriptionTypeDef,
    UserPoolClientTypeTypeDef,
    UserPoolDescriptionTypeTypeDef,
    UserPoolPolicyTypeTypeDef,
    UserPoolTypeTypeDef,
    UserTypeTypeDef,
    UsernameConfigurationTypeTypeDef,
    VerificationMessageTemplateTypeTypeDef,
    VerifySoftwareTokenResponseTypeDef,
)

def get_structure() -> AccountRecoverySettingTypeTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-cognito-idp` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-cognito-idp docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cognito_idp/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
