"""
Defines the avaliable parameters in the Free@Home System.

See: https://github.com/Busch-Jaeger/node-free-at-home/blob/master/src/parameterIds.ts
Converted With: https://github.com/nitzano/enum-converter?tab=readme-ov-file
"""

import enum  # pragma: no cover


class ParameterId(enum.Enum):  # pragma: no cover
    """An Enum class for all Free@Home parameters."""

    PID_LED_DAY_BRIGHTNESS = 1
    PID_LED_NIGHT_BRIGHTNESS = 2
    PID_DIMMING_ACTUATOR_TYPE1_LOAD_TYPE = 3
    PID_DIMMING_ACTUATOR_MIN_BRIGHTNESS = 4
    PID_DIMMING_ACTUATOR_MAX_BRIGHTNESS_DAY = 5
    PID_SENSOR_FORCE_ON_OFF = 6
    PID_LED_OPERATION_MODE = 7
    PID_TOTAL_BLINDS_MOVEMENT_TIME = 8
    PID_TOTAL_BLINDS_MOVEMENT_TIME_CALIBRATED = 9
    PID_TOTAL_SLATS_MOVEMENT_TIME = 10
    PID_TOTAL_SLATS_MOVEMENT_TIME_CALIBRATED = 11
    PID_CHANNEL_SELECTOR_2_GANG = 12
    PID_SENSOR_FORCE_UP_DOWN = 13
    PID_CHANNEL_SELECTOR_BINARY_INPUT_2_GANG = 14
    PID_CHANNEL_SELECTOR_BINARY_INPUT_4_GANG = 15
    PID_BI_CONTACT_TYPE = 16
    PID_BI_FORCE_ON_OFF = 17
    PID_DIMMING_ACTUATOR_MAX_BRIGHTNESS_NIGHT = 18
    PID_DIMMING_ACTUATOR_TYPE0_LOAD_TYPE = 19
    PID_BEHAVIOUR_ON_MALFUNCTION = 20
    PID_AUTONOMOUS_SWITCH_OFF_TIME_DURATION = 21
    PID_DEFAULT_SETPOINT_TEMPERATURE = 24
    PID_ECO_DELTA_TEMPERATURE = 25
    PID_PRESENCE_DETECTOR_TIMED_ON_DURATION = 26
    PID_TEMPERATURE_CORRECTION = 27
    PID_TEMPERATURE_SEND_INTERVAL = 28
    PID_MAX_TEMP_ADJ = 29
    PID_MIN_TEMP_ADJ = 30
    PID_RTC_HAS_FANCOIL = 32
    PID_DISPLAY_SWITCH_OFF_TIME = 33
    PID_FAIR_MODE = 34
    PID_SCENE_MODE = 36
    PID_SWITCH_ON_MODE_RGB = 37
    PID_CHANNEL_SELECTOR_8_GANG = 38
    PID_SWITCH_ACTUATOR_BEHAVIOR_ON_MALFUNCTION = 39
    PID_DELAY_TIME = 40
    PID_DIMMER_SWITCH_ON_MODE = 41
    PID_TEMPERATURE_SOURCE = 42
    PID_BRIGHTNESS_ALERT_ACTIVATION_LEVEL = 43
    PID_HYSTERESIS = 44
    PID_FROST_ALARM_ACTIVATION_LEVEL = 45
    PID_WIND_FORCE = 46
    PID_CONTACT_TYPE = 47
    PID_BEHAVIOUR_ON_MALFUNCTION_HEATING = 48
    PID_PWM_PERIOD = 49
    PID_TRIGGER_DURATION = 50
    PID_MOVEMENT_DETECTOR_SWITCH_ON_CONDITIONS = 52
    PID_TOTAL_BLINDS_MOVEMENT_TIME_DOWN = 53
    PID_TOTAL_BLINDS_MOVEMENT_TIME_CALIBRATED_DOWN = 54
    PID_ENGINE_SWITCH_ON_DELAY_TIME = 55
    PID_DEVICE_CHANNEL_SELECTOR = 56
    PID_TRANSMISSION_INTERVAL = 57
    PID_FAN_COIL_FAN_SPEED = 58
    PID_FAN_COIL_NIGHT_MODE = 59
    PID_FAN_COIL_FAN_MODE = 60
    PID_FAN_COIL_FAN_STARTUP_TIME = 61
    PID_FAN_COIL_FAN_CHANGEOVER_DELAY = 62
    PID_CONTACT_TYPE_A = 63
    PID_CONTACT_TYPE_B = 64
    PID_FAN_COIL_VALVE_OPENING_TIME = 65
    PID_FAN_COIL_PWM_PROFILE = 66
    PID_SENSOR_TYPE = 67
    PID_FAN_COIL_VALVE_3POINT = 68
    PID_FAN_COIL_VALVE_NCNO = 69
    PID_PRIMARY_FUNCTION = 70
    PID_ALERT_ACTIVATION_DELAY = 71
    PID_DEALERT_ACTIVATION_DELAY = 72
    PID_RAIN_SENSOR_SENSITIVITY = 73
    PID_HOURS_PER_DAY = 74
    PID_USER_LANGUAGE = 75
    PID_EFFECTIVE_USER_LANGUAGE = 76
    PID_TEMP_SENSOR_USAGE = 77
    PID_EXT_TEMP_OFFSET = 78
    PID_TEMP_LIMIT = 79
    PID_ACOUSTIC_FEEDBACK = 80
    PID_REFERENCE_DRIVE_BEFORE_POSITIONING = 84
    PID_PROVIDE_TEMPERATURE = 85
    PID_HC_ACTIVE_THRESHOLD = 86
    PID_POWER_SAVING_MODE = 87
    PID_HANDLE_WIND_ALARM = 88
    PID_HANDLE_RAIN_ALARM = 89
    PID_HANDLE_FROST_ALARM = 90
    PID_HANDLE_WINDOW_ALARM = 91
    PID_BEHAVIOUR_DISABLE_FORCE = 92
    PID_SONOS_GROUP_BIT_POSITION = 93
    PID_SONOS_SENSOR_BEHAVIOUR = 94
    PID_SONOS_PLAYER_VOLUME_LIMIT = 95
    PID_CEILING_FAN_SWITCH_ON_MODE = 96
    PID_CFAT0_MINIMUM_FAN_SPEED = 97
    PID_CFAT0_MAXIMUM_FAN_SPEED = 98
    PID_TEMPERATURE_UNIT = 99
    PID_EFFECTIVE_TEMPERATURE_UNIT = 100
    PID_AWAKE_INDICATOR = 101
    PID_HEATING_FIRST_STAGE = 102
    PID_HEATING_SECOND_STAGE = 103
    PID_COOLING_FIRST_STAGE = 104
    PID_COOLING_SECOND_STAGE = 105
    PID_REVERSING_VALVE_OPMODE = 106
    PID_AUX_TYPE = 107
    PID_COMPRESSOR_DELAY = 108
    PID_TEMPERATURE_EXTRACT_HEAT = 109
    PID_TEMPERATURE_EXTRACT_COOL = 110
    PID_VALUES_IN_ACTIVE_MODE = 111
    PID_SHOW_TEMPERATURE_WHILE_OFF = 112
    PID_SHORTCUT_FOR_FAN = 113
    PID_SHORTCUT_FOR_HEAT = 114
    PID_SHORTCUT_FOR_COOL = 115
    PID_SHORTCUT_FOR_AUX = 116
    PID_SHORTCUT_FOR_ECO = 117
    PID_SHORTCUT_FOR_OFF = 118
    PID_FAN_MANUAL_RUNTIME = 119
    PID_DELAY_FOR_EXIT_MODE = 120
    PID_PROTECTION_HIGH_LIMIT = 121
    PID_PROTECTION_LOW_LIMIT = 122
    PID_MINIMUM_ON_TIME = 123
    PID_FAN_ON_TIME_LAG = 124
    PID_FAN_OFF_TIME_LAG = 125
    PID_COMPRESSOR_LOCKOUT = 126
    PID_HEAT_PUMP_AUX_HEAT_LOCKOUT = 127
    PID_FIRST_STAGE_COMP_CYCLE_RATE = 128
    PID_SECOND_STAGE_COMP_CYCLE_RATE = 129
    PID_FIRST_STAGE_HEAT_CYCLE_RATE = 130
    PID_SECOND_STAGE_HEAT_CYCLE_RATE = 131
    PID_EMERGENCY_HEAT_CYCLE_RATE = 132
    PID_FAN_CONTROL = 133
    PID_HEAT_PUMP_TIME = 134
    PID_HIGH_COOL_LATCH = 135
    PID_HIGH_HEAT_LATCH = 136
    PID_COOLING_HYSTERESIS = 137
    PID_HEATING_HYSTERESIS = 138
    PID_HC_SWITCH_DELAY = 139
    PID_MAXIMUM_SETPOINT_TEMPERATURE = 141
    PID_MINIMUM_SETPOINT_TEMPERATURE = 142
    PID_STAGING_TIMER_OVERRIDE = 143
    PID_ARMING_OPTION = 144
    PID_DAY_OF_WEEK = 145
    PID_START_TIME = 146
    PID_END_TIME = 147
    PID_ARM_DELAY = 148
    PID_SILENT_MODE = 151
    PID_PAIRING_PARTNER_PRODUCTION_NUMBER = 152
    PID_PAIRING_PARTNER_MANUFACTURER = 153
    PID_SWITCH_OFF_DELAY_MIN = 154
    PID_TWO_LEVEL_CONTROLLER_HYSTERESIS = 155
    PID_LED_BRIGHTNESS = 156
    PID_LED_OFF_AT_NIGHT = 157
    PID_USER_MODE = 158
    PID_INTERNAL_SIREN = 163
    PID_WIZARD_COMPLETED = 212
    PID_TWILIGHT_BRIGHTNESS = 213
    PID_WIRING = 214
    PID_WIND_SPEED_UNIT = 216
    PID_EFFECTIVE_WIND_SPEED_UNIT = 217
    PID_FAN_LEVEL_STEP_WIDTH = 220
    PID_DIMMING_ACTUATOR_TYPE2_LOAD_TYPE = 221
    PID_RESET_MANUAL_FAN_STAGE = 225
    PID_USE_MASTER_MEASURED_TEMPERATURE = 226
    PID_LIMIT_TEMPERATURE = 227
    PID_SEND_IR_TELEGRAM = 228
    PID_LOCK_ON_SITE_OPERATION = 229
    PID_USE_TEMPLATE = 230
    PID_OPENER_CONTACT = 231
    PID_OUTPUT_EXECUTES_CENTRAL_INPUT = 232
    PID_POWER_ON_LEVEL = 233
    PID_SYSTEM_FAILURE_LEVEL = 234
    PID_CHANNEL_SELECTOR_AUX_INPUT_SHUTTER = 235
    PID_CHANNEL_SELECTOR_AUX_INPUT_SWITCH = 236
    PID_CHANNEL_SELECTOR_1_GANG = 237
    PID_CHANNEL_SELECTOR_3_GANG = 238
    PID_VOLUME_SETUP = 239
    PID_AUTO_RELOCK_TIME = 240
    PID_ALBUM_COVER_URL = 241
    PID_ZSTICK_CONTROL = 242
    PID_TEMPERATURE_COLOR_PHYSICAL_COOLEST = 245
    PID_TEMPERATURE_COLOR_PHYSICAL_WARMEST = 246
    PID_DOMUS_SCENE_DISARMING = 247
    PID_DOMUS_DISABLE_INTERNAL_BUZZER = 248
    PID_DOMUS_ALARM_ON_BURGLARY = 249
    PID_OPERATION_MODE = 250
    PID_DETECTION_AREA = 251
    PID_MOVEMENT_DETECTOR_TEST_MODE = 252
    PID_BLIND_SENSOR_OPERATION_MODE = 253
    PID_SWITCH_OFF_PREWARNING = 254
    PID_HEATING_ACTUATOR_PAUSE_TIME = 255
    PID_ACOUSTIC_FEEDBACK_VOLUME = 256
    PID_COLOR_THEME = 257
    PID_BRIGHTNESS_FOR_SWITCHING_TO_DARK_MODE = 258
    PID_AUTOMATIC_RETURN_TO_START_PAGE = 259
    PID_BRIGHTNESS_ADJUSTED_TO_AMBIENT_LIGHT = 260
    PID_SWITCH_DISPLAY_OFF_WHEN_ROOM_IS_DARK = 261
    PID_BRIGHTNESS_LEVEL_FOR_SWITCHING_TO_DARK = 262
    PID_SWITCH_OFF_TIME_AFTER_DARK = 263
    PID_USE_PROXIMITY_SENSOR = 264
    PID_PROXIMITY_SENSOR_SENSITIVITY = 265
    PID_HAPTIC_FEEDBACK = 266
    PID_SCEEN_SAVER = 267
    PID_SCEEN_SAVER_MODE = 268
    PID_AUTOMATIC_RETURN = 269
    PID_CHANNEL_SELECTOR_MOVEMENT_DETECTOR = 270
    PID_CHANNEL_SELECTOR_AUX_INPUT_SWITCH_1_GANG = 271
    PID_CHANNEL_SELECTOR_CONNECTED_VALVES = 272
    PID_CHANNEL_SELECTOR_CHANNEL_1 = 273
    PID_CHANNEL_SELECTOR_CHANNEL_2 = 274
    PID_CHANNEL_SELECTOR_CHANNEL_3 = 275
    PID_CHANNEL_SELECTOR_CHANNEL_4 = 276
    PID_CHANNEL_SELECTOR_CHANNEL_5 = 277
    PID_CHANNEL_SELECTOR_CHANNEL_6 = 278
    PID_DOMUS_USER_INSTALLER = 279
    PID_DOMUS_USER_0 = 280
    PID_DOMUS_USER_1 = 281
    PID_DOMUS_USER_2 = 289
    PID_DOMUS_USER_3 = 290
    PID_DOMUS_USER_4 = 291
    PID_DOMUS_USER_5 = 292
    PID_DOMUS_USER_6 = 293
    PID_DOMUS_USER_7 = 294
    PID_DOMUS_USER_8 = 295
    PID_DOMUS_KEY_0 = 296
    PID_DOMUS_KEY_1 = 297
    PID_DOMUS_KEY_2 = 304
    PID_DOMUS_KEY_3 = 305
    PID_DOMUS_KEY_4 = 306
    PID_DOMUS_SIREN_INTRUSION_RINGTONE = 307
    PID_DOMUS_SIREN_INTRUSION_LED = 308
    PID_DOMUS_SIREN_SAFETY_RINGTONE = 309
    PID_DOMUS_SIREN_SAFETY_LED = 310
    PID_CHANNEL_SELECTOR_MWIRE_ROCKER_1GANG = 311
    PID_CHANNEL_SELECTOR_MWIRE_ROCKER_2GANG = 312
    PID_DOMUS_SELECTED_REPEATER = 313
    PID_CHANNEL_SELECTOR_MWIRE_MOVEMENT_DETECTOR = 314
    PID_CHANNEL_SELECTOR_FUNCTION_INPUT_A = 315
    PID_CHANNEL_SELECTOR_FUNCTION_INPUT_B = 316
    PID_BI_CONTACT_TYPE_INPUT_A = 317
    PID_BI_CONTACT_TYPE_INPUT_B = 318
    PID_DIMMING_ACTUATOR_MAX_BRIGHTNESS = 319
    PID_HEIGHT_ABOVE_SEA = 320
    PID_CALDION_UI_DURING_NON_USE = 321
    PID_IGNORE_LOCAL_TEMPERATURE = 322
    PID_PRESENCE_DETECTOR_SWITCH_ON_CONDITION = 323
    PID_PRESENCE_DETECTOR_SWITCH_ON_MODE = 324
    PID_PRESENCE_DETECTOR_TARGET_BRIGHTNESS = 325
    PID_BASIC_SETPOINT_HEATING_COMFORT = 326
    PID_BASIC_SETPOINT_HEATING_ECO_MODE = 327
    PID_BASIC_SETPOINT_COOLING_COMFORT = 328
    PID_BASIC_SETPOINT_COOLING_ECO_MODE = 329
    PID_TEMPERATURE_LOWER_LIMIT_FLOOR = 346
    PID_TEMPERATURE_UPPER_LIMIT_FLOOR = 347
    PID_ADAPTIVE_TIMER_CONTROL = 348
    PID_EXTERNAL_INPUT_FUNCTION = 349
    PID_CONTROLLER_TYPE = 350
    PID_BUILDING_PROTECTION = 351
    PID_VALVE_PROTECTION = 352
    PID_EXTERNAL_TEMPERATURE_SENSOR_TYPE = 353
    PID_SWITCH_OVER_TO_HEATING = 354
    PID_SWITCH_OVER_TO_COOLING = 355
    PID_BOOSTER_TIMER = 356
    PID_SWITCHING_CAPACITY = 357
    PID_PIR_1_SENSITIVITY = 358
    PID_PIR_2_SENSITIVITY = 359
    PID_PIR_3_SENSITIVITY = 360
    PID_PIR_4_SENSITIVITY = 361
    PID_PIR_1_ACTIVE = 362
    PID_PIR_2_ACTIVE = 363
    PID_PIR_3_ACTIVE = 364
    PID_PIR_4_ACTIVE = 365
    PID_SWITCH_ON_DELAY = 366
    PID_CHANNEL_SELECTOR_RTC_ASSIGNED_ROCKER = 367
    PID_CO2_ALERT_ACTIVATION_LEVEL = 368
    PID_VOC_ALERT_ACTIVATION_LEVEL = 369
    PID_DISPLAY_IDLE_TIME = 370
    PID_STD_RTC_UI_DURING_NON_USE = 371
    PID_HUMIDITY_ALERT_LOWER_LIMIT = 372
    PID_HUMIDITY_ALERT_UPPER_LIMIT = 373
    PID_ENABLE_CO2_ALERT = 374
    PID_ENABLE_VOC_ALERT = 375
    PID_ENABLE_HUMIDITY_ALERT = 376
    PID_FEATURE_SELECTOR = 377
    PID_REDUCED_LAYOUT = 378
    PID_MOUNTED_IN_SOLID_WALL = 379
    PID_ENGINE_SWITCH_ON_DELAY_TIME_NEW = 380
    PID_SCENE_BACKGROUND_IMG = 381
    PID_LED_COLOR = 382
    PID_SWITCH_ROCKER_BUTTONS = 383
    PID_ROCKER_ORIENTATION = 384
    PID_FEATURE_ORIENTATION = 385
    PID_FEATURE_RGB_SUPPORT = 386
    PID_FEATURE_SWITCH_ROCKER_BUTTONS = 387
    PID_USER_DEFINED_COLOR = 388
    PID_CHANNEL_SELECTOR_GENERIC_GANG = 389
    PID_SWITCH_ACTUATOR_OPERATION_MODE = 390
    PID_FORCE_MODE_DURATION_TYPE = 391
    PID_FORCE_MODE_AUTONOMOUS_SWITCH_OFF_TIME_DURATION = 392
    PID_LOW_ENERGY_DEVICE_CHANNEL_SELECTOR = 393
    PID_LOW_ENERGY_DEVICE_ADDRESS = 394
