# Generated by Django 3.2.13 on 2022-04-30 07:13

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import papermerge.core.models.tags
import papermerge.core.validators
import polymorphic_tree.models
import taggit.managers
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='BaseTreeNode',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=200, validators=[papermerge.core.validators.safe_character_validator], verbose_name='Title')),
                ('lang', models.CharField(default='deu', max_length=8, verbose_name='Language')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', polymorphic_tree.models.PolymorphicTreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='core.basetreenode', verbose_name='parent')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_core.basetreenode_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Documents',
                'verbose_name_plural': 'Documents',
                'ordering': ('tree_id', 'lft'),
                'abstract': False,
                'base_manager_name': 'objects',
            },
        ),
        migrations.CreateModel(
            name='DocumentVersion',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('lang', models.CharField(default='deu', max_length=8, verbose_name='Language')),
                ('number', models.IntegerField(default=1, verbose_name='Version number')),
                ('file_name', models.CharField(blank=True, max_length=1024, null=True)),
                ('size', models.BigIntegerField(default=0, help_text='Size of file_orig attached. Size is in Bytes')),
                ('page_count', models.IntegerField(default=0)),
                ('short_description', models.CharField(blank=True, default='', max_length=128)),
                ('text', models.TextField(blank=True)),
            ],
            options={
                'verbose_name': 'Document version',
                'verbose_name_plural': 'Document versions',
                'ordering': ('number',),
            },
        ),
        migrations.CreateModel(
            name='KVStore',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(blank=True, max_length=200, null=True)),
                ('namespace', models.CharField(blank=True, max_length=1024, null=True)),
                ('namespaced_key', models.CharField(blank=True, max_length=200, null=True)),
                ('value', models.TextField(blank=True, null=True)),
                ('kv_type', models.CharField(choices=[('text', 'Text'), ('money', 'Currency'), ('numeric', 'Numeric'), ('date', 'Date')], default='text', max_length=16)),
                ('kv_format', models.CharField(blank=True, max_length=64, null=True)),
                ('kv_inherited', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('basetreenode_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.basetreenode')),
                ('ocr', models.BooleanField(default=True)),
                ('ocr_status', models.CharField(choices=[('unknown', 'Unknown'), ('received', 'Received'), ('started', 'Started'), ('succeeded', 'Succeeded'), ('failed', 'Failed')], default='unknown', max_length=32)),
            ],
            options={
                'verbose_name': 'Document',
                'verbose_name_plural': 'Documents',
            },
            bases=('core.basetreenode',),
        ),
        migrations.CreateModel(
            name='Folder',
            fields=[
                ('basetreenode_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.basetreenode')),
            ],
            options={
                'verbose_name': 'Folder',
                'verbose_name_plural': 'Folders',
            },
            bases=('core.basetreenode',),
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('slug', models.SlugField(max_length=100, unique=True, verbose_name='slug')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('bg_color', models.CharField(default='#c41fff', max_length=7, verbose_name='Background Color')),
                ('fg_color', models.CharField(default='#FFFFFF', max_length=7, verbose_name='Foreground Color')),
                ('description', models.TextField(blank=True, max_length=1024, null=True, verbose_name='Description (optional)')),
                ('pinned', models.BooleanField(default=False, help_text='Pinned tag will be displayed under Documents menu. It serves as shortcut to quickly filter folders/documents associated with this tag')),
                ('name', models.CharField(max_length=100, validators=[papermerge.core.validators.safe_character_validator], verbose_name='name')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Tag',
                'verbose_name_plural': 'Tags',
                'ordering': ['name'],
                'unique_together': {('name', 'user')},
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=64)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('permissions', models.ManyToManyField(blank=True, to='auth.Permission', verbose_name='permissions')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('number', models.IntegerField(default=1)),
                ('page_count', models.IntegerField(default=1)),
                ('text', models.TextField(default='')),
                ('norm_doc_title', models.CharField(default='', max_length=200)),
                ('norm_folder_title', models.CharField(default='', max_length=200)),
                ('norm_breadcrump', models.CharField(default='', max_length=1024)),
                ('norm_text', models.TextField(default='')),
                ('lang', models.CharField(default='deu', max_length=8)),
                ('image', models.CharField(default='', max_length=1024)),
                ('document_version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pages', to='core.documentversion')),
            ],
            options={
                'ordering': ['number'],
            },
        ),
        migrations.CreateModel(
            name='KVStoreCompNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('node', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='kvstorecomp', to='core.basetreenode')),
            ],
        ),
        migrations.CreateModel(
            name='ColoredTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.UUIDField(db_index=True, verbose_name='object ID')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='core_coloredtag_tagged_items', to='contenttypes.contenttype', verbose_name='content type')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='core_coloredtag_items', to='core.tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='basetreenode',
            name='tags',
            field=taggit.managers.TaggableManager(help_text='A comma-separated list of tags.', through='core.ColoredTag', to='core.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='basetreenode',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='Access',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('access_type', models.CharField(choices=[('allow', 'Allow'), ('deny', 'Deny')], default='allow', max_length=16)),
                ('access_inherited', models.BooleanField(default=False)),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.group', verbose_name='group')),
                ('node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.basetreenode')),
                ('permissions', models.ManyToManyField(to='auth.Permission')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'permissions': [('read', 'Read Access'), ('write', 'Write Access'), ('delete', 'Delete Access'), ('change_perm', 'Change Permissions Access'), ('take_ownership', 'Take Ownership Access')],
            },
        ),
        migrations.AddField(
            model_name='user',
            name='role',
            field=models.ForeignKey(blank=True, help_text='Determines what operations this user is authorized to perform.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.role', verbose_name='role'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.CreateModel(
            name='KVStorePage',
            fields=[
                ('kvstore_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.kvstore')),
                ('page', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='kvstore', to='core.page')),
            ],
            bases=('core.kvstore',),
        ),
        migrations.CreateModel(
            name='KVStoreNode',
            fields=[
                ('kvstore_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.kvstore')),
                ('node', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='kvstore', to='core.basetreenode')),
            ],
            bases=('core.kvstore',),
        ),
        migrations.CreateModel(
            name='KVStoreCompItem',
            fields=[
                ('kvstore_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.kvstore')),
                ('comp_item', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='kvstore', to='core.kvstorecompnode')),
            ],
            bases=('core.kvstore',),
        ),
        migrations.AddField(
            model_name='documentversion',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', to='core.document', verbose_name='Document'),
        ),
        migrations.CreateModel(
            name='Automate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Name')),
                ('match', models.CharField(blank=True, max_length=256, verbose_name='Match')),
                ('matching_algorithm', models.PositiveIntegerField(choices=[(1, 'Any'), (2, 'All'), (3, 'Literal'), (4, 'Regular Expression')], default=1, verbose_name='Matching Algorithm')),
                ('is_case_sensitive', models.BooleanField(default=True, verbose_name='Is case sensitive')),
                ('extract_page', models.BooleanField(default=False, verbose_name='Extract Page')),
                ('tags', papermerge.core.models.tags.UserTaggableManager(blank=True, help_text='A comma-separated list of tags.', through='core.ColoredTag', to='core.Tag', verbose_name='Tags')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('dst_folder', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='core.folder', verbose_name='Destination Folder')),
            ],
        ),
        migrations.AddField(
            model_name='user',
            name='home_folder',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='home_folder_of', to='core.folder'),
        ),
        migrations.AddField(
            model_name='user',
            name='inbox_folder',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='inbox_folder_of', to='core.folder'),
        ),
    ]
