"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const kms = require("../lib");
const app = new cdk.App();
/// !show
/**
 * Stack that defines the key
 */
class KeyStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.key = new kms.Key(this, 'MyKey', { removalPolicy: core_1.RemovalPolicy.DESTROY });
    }
}
/**
 * Stack that uses the key
 */
class UseStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Use the IKey object here.
        new kms.Alias(this, 'Alias', {
            aliasName: 'alias/foo',
            targetKey: props.key
        });
    }
}
const keyStack = new KeyStack(app, 'KeyStack');
new UseStack(app, 'UseStack', { key: keyStack.key });
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2V5LXNoYXJpbmcubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcua2V5LXNoYXJpbmcubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsZ0JBQWdCO0FBQ2hCLHFDQUFzQztBQUN0Qyx3Q0FBOEM7QUFDOUMsOEJBQStCO0FBRS9CLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLFNBQVM7QUFFVDs7R0FFRztBQUNILE1BQU0sUUFBUyxTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBRzlCLFlBQVksS0FBYyxFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN4QixJQUFJLENBQUMsR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLEVBQUUsYUFBYSxFQUFFLG9CQUFhLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztJQUNsRixDQUFDO0NBQ0Y7QUFNRDs7R0FFRztBQUNILE1BQU0sUUFBUyxTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBQzlCLFlBQVksS0FBYyxFQUFFLEVBQVUsRUFBRSxLQUFvQjtRQUMxRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4Qiw0QkFBNEI7UUFDNUIsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxPQUFPLEVBQUU7WUFDM0IsU0FBUyxFQUFFLFdBQVc7WUFDdEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxHQUFHO1NBQ3JCLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQUVELE1BQU0sUUFBUSxHQUFHLElBQUksUUFBUSxDQUFDLEdBQUcsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUMvQyxJQUFJLFFBQVEsQ0FBQyxHQUFHLEVBQUUsVUFBVSxFQUFFLEVBQUUsR0FBRyxFQUFFLFFBQVEsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBQ3JELFNBQVM7QUFFVCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLy8gIWNkay1pbnRlZyAqXG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IHsgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IGttcyA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG4vLy8gIXNob3dcblxuLyoqXG4gKiBTdGFjayB0aGF0IGRlZmluZXMgdGhlIGtleVxuICovXG5jbGFzcyBLZXlTdGFjayBleHRlbmRzIGNkay5TdGFjayB7XG4gIHB1YmxpYyByZWFkb25seSBrZXk6IGttcy5LZXk7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcsIHByb3BzPzogY2RrLlN0YWNrUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLmtleSA9IG5ldyBrbXMuS2V5KHRoaXMsICdNeUtleScsIHsgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5ERVNUUk9ZIH0pO1xuICB9XG59XG5cbmludGVyZmFjZSBVc2VTdGFja1Byb3BzIGV4dGVuZHMgY2RrLlN0YWNrUHJvcHMge1xuICBrZXk6IGttcy5JS2V5OyAvLyBVc2UgSUtleSBoZXJlXG59XG5cbi8qKlxuICogU3RhY2sgdGhhdCB1c2VzIHRoZSBrZXlcbiAqL1xuY2xhc3MgVXNlU3RhY2sgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkFwcCwgaWQ6IHN0cmluZywgcHJvcHM6IFVzZVN0YWNrUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIC8vIFVzZSB0aGUgSUtleSBvYmplY3QgaGVyZS5cbiAgICBuZXcga21zLkFsaWFzKHRoaXMsICdBbGlhcycsIHtcbiAgICAgIGFsaWFzTmFtZTogJ2FsaWFzL2ZvbycsXG4gICAgICB0YXJnZXRLZXk6IHByb3BzLmtleVxuICAgIH0pO1xuICB9XG59XG5cbmNvbnN0IGtleVN0YWNrID0gbmV3IEtleVN0YWNrKGFwcCwgJ0tleVN0YWNrJyk7XG5uZXcgVXNlU3RhY2soYXBwLCAnVXNlU3RhY2snLCB7IGtleToga2V5U3RhY2sua2V5IH0pO1xuLy8vICFoaWRlXG5cbmFwcC5zeW50aCgpO1xuIl19