"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmutableRole = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Resource {
    constructor(scope, id, role, addGrantsToResources) {
        super(scope, id, {
            account: role.env.account,
            region: role.env.region,
        });
        this.role = role;
        this.addGrantsToResources = addGrantsToResources;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.principalAccount = this.role.principalAccount;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // If we return `false`, the grants will try to add the statement to the resource
        // (if possible).
        const pretendSuccess = !this.addGrantsToResources;
        return { statementAdded: pretendSuccess, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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