from pylab import plt, np

# 实验电阻辨识测量结果
R = 1.1
current = [
    -4.19999456 ,
    -3.77999449 ,
    -3.36001229 ,
    -2.94001722 ,
    -2.51998568 ,
    -2.10003948 ,
    -1.68003583 ,
    -1.26001501 ,
    -0.840051532    ,
    -0.419948429    ,
    5.88753983e-06  ,
    0.420032352 ,
    0.839997649 ,
    1.26002526  ,
    1.67997801  ,
    2.10008645  ,
    2.51995587  ,
    2.87325644  ,
    3.36001039  ,
    3.78002191  ,
    4.20000076  ,]
voltage = [
   -9.82718372     ,
   -9.36589527     ,
   -8.88535309     ,
   -8.39355659     ,
   -7.88835335     ,
   -7.35727119     ,
   -6.78267193     ,
   -6.14968348     ,
   -5.34927511     ,
   -3.93019223     ,
   0.317450166     ,
   4.21791697      ,
   5.48136473      ,
   6.26376247      ,
   6.89256334      ,
   7.46477699      ,
   8.00099564      ,
   8.5,
   8.95530128      ,
   9.43973064      ,
   9.9204483       ,
   ]


plt.figure(1)
plt.plot(current, voltage, 'k-o', label='measured')
plt.figure(2)
voltage_to_compensate = np.array(voltage) - np.array(current)*R
plt.plot(current, voltage_to_compensate, 'k-o', label='measured')

print(len(current))
print('{' + ', '.join(f'{el:g}' for el in current) + '}')
print('{' + ', '.join(f'{el:g}' for el in voltage_to_compensate) + '}')


# 仿真电阻辨识测量结果
R=1.22
current = [#4.199997,
    3.780003,
    3.360003,
    2.940003,
    2.520003,
    2.100003,
    1.680003,
    1.260002,
    0.840002,
    0.420002,
    -0.000000, 
    -0.419998, 
    -0.839998, 
    -1.259998, 
    -1.679997, 
    -2.099996, 
    -2.519997, 
    -2.939997, 
    -3.359996, 
    -3.779997, ][::-1]
voltage = [ #11.518425,
     11.006423,
     10.491941,
     10.019051,
     9.433810,
     8.809387,
     8.161138,
     7.268965,
     6.274497,
     4.016205,
    -0.000000,
    -4.131907,
    -6.377804,
    -7.332830,
    -8.175985,
    -8.819834,
    -9.434714,
    -9.981126,
    -10.518619,
    -11.029680,][::-1]

R=1.20
current=[  4.199997,
  4.116003,
  4.032003,
  3.948003,
  3.864003,
  3.780003,
  3.696003,
  3.612003,
  3.528003,
  3.444003,
  3.360003,
  3.276003,
  3.192003,
  3.108003,
  3.024003,
  2.940003,
  2.856003,
  2.772003,
  2.688003,
  2.604003,
  2.520003,
  2.436003,
  2.352003,
  2.268003,
  2.184003,
  2.100003,
  2.016003,
  1.932003,
  1.848003,
  1.764003,
  1.680003,
  1.596002,
  1.512002,
  1.428002,
  1.344002,
  1.260002,
  1.176002,
  1.092002,
  1.008002,
  0.924002,
  0.840002,
  0.756002,
  0.672002,
  0.588002,
  0.504002,
  0.420002,
  0.336001,
  0.252001,
  0.168000,
  0.084000,
  -0.000000,
  -0.084000,
  -0.168000,
  -0.251999,
  -0.335999,
  -0.419998,
  -0.503998,
  -0.587998,
  -0.671998,
  -0.755998,
  -0.839998,
  -0.923998,
  -1.007998,
  -1.091998,
  -1.175998,
  -1.259998,
  -1.343998,
  -1.427998,
  -1.511998,
  -1.595997,
  -1.679997,
  -1.763997,
  -1.847997,
  -1.931997,
  -2.015997,
  -2.099997,
  -2.183997,
  -2.267997,
  -2.351997,
  -2.435997,
  -2.519997,
  -2.603997,
  -2.687997,
  -2.771997,
  -2.855997,
  -2.939997,
  -3.023997,
  -3.107997,
  -3.191997,
  -3.275997,
  -3.359997,
  -3.443997,
  -3.527997,
  -3.611997,
  -3.695997,
  -3.779997,
  -3.863997,
  -3.947997,
  -4.031997,
  -4.115997,][::-1]
voltage = [ 11.518425,
 11.416044,
 11.313639,
 11.211234,
 11.108828,
 11.006423,
 10.903527,
 10.800631,
 10.697735,
 10.594839,
 10.491941,
 10.397363,
 10.302785,
 10.208207,
 10.113629,
 10.019051,
 9.918985,
 9.797692,
 9.676399,
 9.555107,
 9.433809,
 9.308923,
 9.184040,
 9.059157,
 8.934274,
 8.809387,
 8.679747,
 8.550107,
 8.420467,
 8.290827,
 8.161138,
 7.982703,
 7.804271,
 7.625838,
 7.447405,
 7.268965,
 7.070072,
 6.871178,
 6.672284,
 6.473391,
 6.274497,
 5.823056,
 5.371375,
 4.919693,
 4.468012,
 4.016204,
 3.212958,
 2.409721,
 1.606480,
 0.803241,
 -0.000001,
 -0.826432,
 -1.652859,
 -2.479284,
 -3.305713,
 -4.131908,
 -4.581087,
 -5.030266,
 -5.479446,
 -5.928625,
 -6.377804,
 -6.568962,
 -6.759929,
 -6.950896,
 -7.141863,
 -7.332830,
 -7.501466,
 -7.670097,
 -7.838727,
 -8.007354,
 -8.175985,
 -8.304758,
 -8.433527,
 -8.562296,
 -8.691065,
 -8.819834,
 -8.942812,
 -9.065788,
 -9.188763,
 -9.311739,
 -9.434714,
 -9.544003,
 -9.653284,
 -9.762564,
 -9.871846,
 -9.981126,
 -10.088626,
 -10.196124,
 -10.303623,
 -10.411122,
 -10.518619,
 -10.620831,
 -10.723044,
 -10.825256,
 -10.927468,
 -11.029680,
 -11.129323,
 -11.228966,
 -11.328609,
 -11.428251,][::-1]

plt.figure(1)
plt.plot(current, voltage, 'r-s', label='measured in simulation')
plt.grid(); plt.legend(); plt.xlabel('d-axis current [A]'); plt.ylabel('d-axis voltage [V]')

plt.figure(2)
voltage_to_compensate = np.array(voltage) - np.array(current)*R
plt.plot(current, voltage_to_compensate, 'r-s', label='measured in simulation')
# plt.plot(current_comp, np.array(voltage_comp) - np.array(current_comp)*R, 'b-.', label='compensated measurement in simulation')
plt.grid(); plt.legend(); plt.xlabel('d-axis current [A]'); plt.ylabel('distorted voltage [V]')

print('#define LENGTH_OF_LUT ', len(current))
print('double lut_current_ctrl[LENGTH_OF_LUT] = {' + ', '.join(f'{el:g}' for el in current) + '};')
print('double lut_voltage_ctrl[LENGTH_OF_LUT] = {' + ', '.join(f'{el:g}' for el in voltage_to_compensate) + '};')


print('你看到蓝色的线不是水平的，那是因为测量的电阻不准！所以补偿电压也不exact')

plt.show()




