#include "ACMSim.h"
#define CURRENT_OFFSET_A ( 0.1*0)
#define CURRENT_OFFSET_B (-0.02*0)


#define QEP_DEFAULTS {0,0,0,0,{0,0,0,0},0,0}
struct eQEP{
    double theta_d;
    double theta_d_prev;
    double omg_mech;
    double omg_elec;
    double moving_average[4];
    Uint32 ActualPosInCnt;
    Uint32 ActualPosInCnt_Previous;
} qep=QEP_DEFAULTS;
void measurement(){
    // 本函数每隔采样时间 CL_TS 执行一次

    // 下面出现的US_C，IS_C等，都是全局的宏变量，方便在不同的.c文件内共享。

    // 电压测量
    US_C(0) = CTRL.O->uab_cmd[0]; // 后缀_C表示当前步的电压，C = Current
    US_C(1) = CTRL.O->uab_cmd[1];
    US_P(0) = US_C(0); // 后缀_P表示上一步的电压，P = Previous
    US_P(1) = US_C(1);

    // 电流测量存在噪声，只会影响反馈控制，实际的扰动可能是逆变器引入的，见逆变器建模
        // power-invariant to amplitude-invariant via Clarke transformation???
    // REAL sqrt_2slash3 = sqrt(2.0/3.0);
    // REAL ia = sqrt_2slash3 * ACM.ial                              + 0*2*5e-2*RANDOM;
    // REAL ib = sqrt_2slash3 * (-0.5*ACM.ial + 0.5*sqrt(3)*ACM.ibe) + 0*2*5e-2*RANDOM;
    // REAL ic = sqrt_2slash3 * (-0.5*ACM.ial - 0.5*sqrt(3)*ACM.ibe) + 0*2*5e-2*RANDOM;
    // IS_C(0) = 2.0/3.0 * (ia - 0.5*ib - 0.5*ic);
    // IS_C(1) = 2.0/3.0 * 0.5*sqrt(3.0) * (ib - ic);
    IS_C(0)        = ACM.ial + CURRENT_OFFSET_A;
    IS_C(1)        = ACM.ibe + 1*CURRENT_OFFSET_B; // TODO: what makes beta current so special that adding offset here unstablizes the control system
    CTRL.I->iab[0] = ACM.ial + CURRENT_OFFSET_A;
    CTRL.I->iab[1] = ACM.ibe + 1*CURRENT_OFFSET_B;

    // 转速和位置测量
    #define USE_EQEP FALSE
    #define USE_HALL FALSE
    #if USE_EQEP == TRUE
        #define TOTAL_PULSE_PER_REV          1e4 // 2500 line per rev + eQEP
        #define TOTAL_PULSE_PER_REV_INVERSE 1e-4 // 2500 line per rev + eQEP
        #define QEP_SPEED_ERROR_RPM (60.0 / (TOTAL_PULSE_PER_REV * VL_TS))

        // 这里的建模没有考虑初始d轴的偏置角！

        反转的时候qep的转速好像是错的！

        static int vc_count = 0;
        if(vc_count++ == SPEED_LOOP_CEILING){
            vc_count = 0;

            qep.ActualPosInCnt_Previous = qep.ActualPosInCnt;

            REAL rotor_position_mech_rad = ACM.x[4]*ACM.npp_inv;
            qep.ActualPosInCnt = (Uint32)( rotor_position_mech_rad / (2*M_PI) * TOTAL_PULSE_PER_REV);
            qep.theta_d  = (EXP.npp*qep.ActualPosInCnt*TOTAL_PULSE_PER_REV_INVERSE)*2*M_PI;

            qep.moving_average[3] = qep.moving_average[2];
            qep.moving_average[2] = qep.moving_average[1];
            qep.moving_average[1] = qep.moving_average[0];
            qep.moving_average[0] = 60*(qep.ActualPosInCnt - qep.ActualPosInCnt_Previous) / (TOTAL_PULSE_PER_REV * VL_TS); // [rpm]
            // qep.omg_mech = 0.25*(qep.moving_average[3]+qep.moving_average[2]+qep.moving_average[1]+qep.moving_average[0]);
            
            qep.omg_elec = qep.moving_average[0] * RPM_2_ELEC_RAD_PER_SEC;
            qep.omg_mech = qep.omg_elec * EXP.npp_inv;
        }
    #endif
    #if USE_HALL == TRUE

        EXP.theta_d  = ACM.theta_d; // + 30.0/180*M_PI;
        EXP.omg_elec = ACM.omg_elec;
        EXP.omg_mech = EXP.omg_elec * EXP.npp_inv;

        // 霍尔传感器检测
        EXP.hallABC = hall_sensor(ACM.theta_d/M_PI*180.0);
        hall_resolver(EXP.hallABC, &EXP.theta_d_hall, &EXP.omg_elec_hall);

        // 测量转子d轴位置限幅
        if(EXP.theta_d_hall > M_PI){
            EXP.theta_d_hall -= 2*M_PI;
        }else if(EXP.theta_d_hall < -M_PI){
            EXP.theta_d_hall += 2*M_PI;
        }

        // // if(CTRL.timebase>19){
        //     EXP.theta_d  = EXP.theta_d_hall;
        //     EXP.omg_elec = EXP.omg_elec_hall;
        // // }
    #endif

    #if MACHINE_TYPE == PM_SYNCHRONOUS_MACHINE
        {
            //（霍尔反馈）
            // CTRL.I->omg_elec     = EXP.omg_elec_hall;
            // CTRL.S->theta_D_elec__fb = EXP.theta_d_hall;

            //（编码器反馈）
            // CTRL.I->omg_elec     = qep.omg_elec;
            // CTRL.S->theta_D_elec__fb = qep.theta_d;

            //（实际反馈，实验中不可能）
            CTRL.I->omg_elec     = ACM.omg_elec;
            CTRL.I->theta_d_elec = ACM.theta_d; // + 30.0/180*M_PI;
        }

    #elif MACHINE_TYPE == INDUCTION_MACHINE_CLASSIC_MODEL || MACHINE_TYPE == INDUCTION_MACHINE_FLUX_ONLY_MODEL
        {
            CTRL.I->omg_elec = ACM.omg_elec;
        }
    #endif
}



struct HallSensor HALL;
void HALL_init(){

    HALL.acceleration_avg = 0.0;
    HALL.last_omg_elec_hall = 0.0;

    HALL.omg_elec_hall = 0.0;
    HALL.omg_mech_hall = 0.0;
    HALL.theta_d_hall = 0.0;

    HALL.hallA = 0;
    HALL.hallB = 1;
    HALL.hallC = 1;
    HALL.hallABC = 0x3;
    HALL.last_hallABC = 0x1;
    HALL.speed_direction = +1;
    HALL.bool_position_correction_pending = FALSE;

    HALL.timebase = 0.0;
    HALL.timeStamp = 0.0;
    HALL.timeDifference = 0.0;
    HALL.timeDifferenceStamp = 100000.0;

}

