from pylab import plt, np
current_data = dict()
voltage_data = dict()

SIN_DASH_2PI_SLASH_3 = -0.86602540378443871

def plot_ui_curve(ax1, ax2, R, *arg, **kwarg): 

    u_data = voltage_data[kwarg['label']]
    i_data = current_data[kwarg['label']]

    ax1.plot(i_data, u_data, *arg, **kwarg)
    ax1.set_xlabel('Current [A]')
    ax1.set_ylabel('Voltage [V]')

    voltage_to_compensate = np.array(u_data) - np.array(i_data)*R
    ax2.plot(i_data, voltage_to_compensate, *arg, **kwarg)
    ax2.set_xlabel('Current [A]')
    ax2.set_ylabel('Voltage [V]')

    print('#define LENGTH_OF_LUT ', len(i_data))
    print('REAL lut_current_ctrl[LENGTH_OF_LUT] = {' + ', '.join(f'{el:g}' for el in i_data[::-1]) + '};')
    print('REAL lut_voltage_ctrl[LENGTH_OF_LUT] = {' + ', '.join(f'{el:g}' for el in voltage_to_compensate[::-1]) + '};')
    print()

from scipy.optimize import curve_fit
def func(x, a1, a2, a3):
    return a1 * x + a2 / (1+np.exp(-a3 * x)) - a2/2
    # a1,a2,a3 = [1.28430164 8.99347107 5.37783655]

def my_curve_fitting(xdata, ydata, alpha=1.0, color='b'):
    xdata = np.asarray(xdata)
    popt, pcov = curve_fit(func, xdata, ydata) # bounds=(0, [3., 1., 0.5])) # https://docs.scipy.org/doc/scipy/reference/generated/scipy.optimize.curve_fit.html
    print('a1,a2,a3 =', popt)
    plt.plot(xdata, ydata, 'x', label='original data', alpha=alpha)
    x = np.arange(min(xdata)*3, max(xdata)*3, 0.1)
    plt.plot(x, func(x, *popt), 'r--', alpha=alpha,
         label='fit: a1=%5.3f, a2=%5.3f, a3=%5.3f' % tuple(popt))
    plt.plot(x, func(x, 0.0, popt[1], popt[2]), '--', color=color, alpha=alpha,
         label='fit: a1=%5.3f, a2=%5.3f, a3=%5.3f' % tuple(popt))

    print('End value for distorted voltage is:', func(100, 0, popt[1], popt[2]))

if __name__ == '__main__':

    # 实验电阻辨识测量结果
    R = 1.1

    # Old measurement in 03-11
    current_data['0311'] = [
        -4.19999456 ,
        -3.77999449 ,
        -3.36001229 ,
        -2.94001722 ,
        -2.51998568 ,
        -2.10003948 ,
        -1.68003583 ,
        -1.26001501 ,
        -0.840051532    ,
        -0.419948429    ,
        5.88753983e-06  ,
        0.420032352 ,
        0.839997649 ,
        1.26002526  ,
        1.67997801  ,
        2.10008645  ,
        2.51995587  ,
        2.87325644  ,
        3.36001039  ,
        3.78002191  ,
        4.20000076  ,]
    voltage_data['0311'] = [
       -9.82718372     ,
       -9.36589527     ,
       -8.88535309     ,
       -8.39355659     ,
       -7.88835335     ,
       -7.35727119     ,
       -6.78267193     ,
       -6.14968348     ,
       -5.34927511     ,
       -3.93019223     ,
       0.317450166     ,
       4.21791697      ,
       5.48136473      ,
       6.26376247      ,
       6.89256334      ,
       7.46477699      ,
       8.00099564      ,
       8.5,
       8.95530128      ,
       9.43973064      ,
       9.9204483       ,
       ]

    # New measurment in 03-18 (20 points), Udc measured as 70V, but bus voltage is 80 V.
    current_data['0318-20pts'] = [4.20001268,
     3.78005672,
     3.3600347,
     2.94001389,
     2.51998568,
     2.09995532,
     1.67998624,
     1.25998044,
     0.840030313,
     0.419985026,
     1.55855214e-05,
      -0.419936597,
      -0.840004861,
      -1.25998318,
      -1.67999244,
      -2.09995317,
      -2.51998353,
      -2.94002366,
      -3.35996866,
      -3.78001189,
      -4.20076084,]
    voltage_data['0318-20pts'] =  [9.78327084,
     9.31332207,
     8.83496952,
     8.34282017,
     7.83414507,
     7.30621624,
     6.74165344,
     6.11646175,
     5.33162212,
     4.01765585,
      -0.0300196428,
      -3.99883485,
      -5.3204999,
      -6.09219646,
      -6.7063489,
      -7.26806307,
      -7.7860136,
      -8.27959251,
      -8.76324463,
      -9.23482037,
      -9.75802803,]

    # New measurment in 03-18 (40 points), Udc measured as 70V, but bus voltage is 80 V.
    current_data['0318-40pts'] =   [4.20000935 ,
        3.9899888  ,
        3.77999139 ,
        3.56996727 ,
        3.35995245 ,
        3.14996886 ,
        2.93999743 ,
        2.72997975 ,
        2.52001643 ,
        2.31001973 ,
        2.09999561 ,
        1.88995349 ,
        1.67995358 ,
        1.47000933 ,
        1.26001644 ,
        1.0500195  ,
        0.84000206 ,
        0.62998426 ,
        0.419958502,
        0.210007608,
        -1.80977622e-05,
        -0.20996809,
        -0.419972152   ,
        -0.629980445   ,
        -0.839975595   ,
        -1.04997706,
        -1.26001477,
        -1.46997201,
        -1.68000364,
        -1.89001775,
        -2.09998894,
        -2.31003022,
        -2.51995826,
        -2.72996807,
        -2.93999147,
        -3.15000701,
        -3.35998011,
        -3.56999874,
        -3.77996111,
        -3.98996186,
        -4.19998455,]
    voltage_data['0318-40pts'] = [9.07984447  ,
        8.86020184  ,
        8.63860989  ,
        8.41960526  ,
        8.19495583  ,
        7.96438932  ,
        7.73331642  ,
        7.5008831   ,
        7.26101732  ,
        7.01996994  ,
        6.77117157  ,
        6.51138401  ,
        6.24012613  ,
        5.9573555   ,
        5.65299559  ,
        5.31212807  ,
        4.90990019  ,
        4.39070082  ,
        3.60157394  ,
        1.89256501  ,
        -0.4084059  ,
        -2.45479918 ,
        -3.86190104 ,
        -4.55173111 ,
        -5.02463865 ,
        -5.40080118 ,
        -5.72698784 ,
        -6.02244473 ,
        -6.29927349 ,
        -6.56387091 ,
        -6.82098341 ,
        -7.06784773 ,
        -7.30728149 ,
        -7.54015875 ,
        -7.76944923 ,
        -7.9975152  ,
        -8.22190666 ,
        -8.44289494 ,
        -8.66035748 ,
        -8.87536526 ,
        -9.08257008 ,]




    ''' 切记，错误的母线电压会影响你的逆变器非线性！
        切记，错误的母线电压会影响你的逆变器非线性！
        切记，错误的母线电压会影响你的逆变器非线性！
    '''
    R = 1.1
    current_data['0318-40pts-80V'] = [
        4.20000267  ,
        3.98997855  ,
        3.77999067  ,
        3.57000637  ,
        3.35994649  ,
        3.14996052  ,
        2.93999577  ,
        2.7300396   ,
        2.51998639  ,
        2.30999732  ,
        2.10002136  ,
        1.8900094   ,
        1.68001246  ,
        1.47002327  ,
        1.25998855  ,
        1.05002248  ,
        0.840007901 ,
        0.629998028 ,
        0.420001417 ,
        0.209888369 ,
        1.39409058e-05  ,
        -0.210047856    ,
        -0.420046479    ,
        -0.629949868    ,
        -0.839961648    ,
        -1.05000556 ,
        -1.25999308 ,
        -1.46997643 ,
        -1.67999005 ,
        -1.88995802 ,
        -2.09999728 ,
        -2.31003356 ,
        -2.5199821  ,
        -2.72993016 ,
        -2.9399581  ,
        -3.14998794 ,
        -3.36001682 ,
        -3.56999636 ,
        -3.78002191 ,
        -3.98998308 ,
        -4.20000505 ,]
    voltage_data['0318-40pts-80V'] = [
        10.4563198  ,
        10.2063484  ,
        9.94874096  ,
        9.69336319  ,
        9.43211174  ,
        9.16693211  ,
        8.89634228  ,
        8.62689209  ,
        8.34705353  ,
        8.06960106  ,
        7.7775569   ,
        7.47768688  ,
        7.16523027  ,
        6.83958483  ,
        6.48954821  ,
        6.0987854   ,
        5.63828325  ,
        5.04932404  ,
        4.16310263  ,
        2.25361443  ,
        -0.382085204    ,
        -2.70950294 ,
        -4.37169981 ,
        -5.17663383 ,
        -5.72417259 ,
        -6.15696192 ,
        -6.53150702 ,
        -6.86716223 ,
        -7.18263054 ,
        -7.48806143 ,
        -7.78246212 ,
        -8.06390381 ,
        -8.33588696 ,
        -8.6027422  ,
        -8.8666935  ,
        -9.12722874 ,
        -9.3820734  ,
        -9.63435841 ,
        -9.88605213 ,
        -10.1361914 ,
        -10.3743439 ,]


    ''' Udc,measured=82 V; Udc,actual=80 V.
    '''
    R = 1.219 # 本次测量测量L3的时候机械开关误重启，L3结果不可靠。
    current_data['0320-40pts-82V-BetaAxis'] = [4.19998693  ,
        3.98996568  ,
        3.77999496  ,
        3.56998849  ,
        3.36001563  ,
        3.15001035  ,
        2.93997812  ,
        2.73000479  ,
        2.5200119   ,
        2.31000733  ,
        2.09999871  ,
        1.89000189  ,
        1.68001652  ,
        1.47000051  ,
        1.25998199  ,
        1.04998863  ,
        0.839993358 ,
        0.629997969 ,
        0.419988126 ,
        0.21001932  ,
        3.71439746e-05  ,
        -0.209994644    ,
        -0.419990093    ,
        -0.629975855    ,
        -0.839983404    ,
        -1.05000317 ,
        -1.26001251 ,
        -1.46999705 ,
        -1.67998099 ,
        -1.89000058 ,
        -2.09999633 ,
        -2.30999899 ,
        -2.52001619 ,
        -2.72999835 ,
        -2.93997574 ,
        -3.14998889 ,
        -3.35999513 ,
        -3.57001257 ,
        -3.77999496 ,
        -3.98999643 ,
        -4.1999836  ,]
    voltage_data['0320-40pts-82V-BetaAxis'] = [9.99356651  ,
        9.74704647  ,
        9.48719406  ,
        9.23802757  ,
        8.97471809  ,
        8.71501923  ,
        8.46279716  ,
        8.1980648   ,
        7.93237734  ,
        7.6658473   ,
        7.38917685  ,
        7.11465502  ,
        6.81831169  ,
        6.51398945  ,
        6.19553804  ,
        5.85180426  ,
        5.45777607  ,
        4.96267509  ,
        4.24003696  ,
        2.58985949  ,
        -0.214281321    ,
        -2.86806011 ,
        -4.3348155  ,
        -5.01699352 ,
        -5.49734259 ,
        -5.88770294 ,
        -6.23143244 ,
        -6.54877806 ,
        -6.85221148 ,
        -7.14033175 ,
        -7.42272568 ,
        -7.68940496 ,
        -7.95479298 ,
        -8.22238827 ,
        -8.48710918 ,
        -8.7488842  ,
        -9.01177597 ,
        -9.26081181 ,
        -9.52398014 ,
        -9.77569485 ,
        -10.0342741 ,]

    R = 1.176
    current_data['0320-40pts-81V-BetaAxis-Repeat1'] = [4.19997215  ,
        3.98998165  ,
        3.7799983   ,
        3.56999683  ,
        3.36000156  ,
        3.14999557  ,
        2.93999648  ,
        2.73000169  ,
        2.51999474  ,
        2.31000566  ,
        2.09998679  ,
        1.89000738  ,
        1.67999864  ,
        1.46999276  ,
        1.2600168   ,
        1.05000317  ,
        0.839998722 ,
        0.629994154 ,
        0.420030028 ,
        0.209985182 ,
        4.86424469e-05  ,
        -0.210011661    ,
        -0.420020431    ,
        -0.630007923    ,
        -0.839996755    ,
        -1.04998863 ,
        -1.25998831 ,
        -1.46999824 ,
        -1.67999923 ,
        -1.88999176 ,
        -2.10001254 ,
        -2.30999351 ,
        -2.51999807 ,
        -2.73000097 ,
        -2.93999696 ,
        -3.14999604 ,
        -3.35999084 ,
        -3.56998682 ,
        -3.77999616 ,
        -3.99001765 ,
        -4.20000839 ,]
    voltage_data['0320-40pts-81V-BetaAxis-Repeat1'] = [9.7787466   ,
        9.53656101  ,
        9.29240131  ,
        9.04705906  ,
        8.7916851   ,
        8.54594231  ,
        8.28904152  ,
        8.03017807  ,
        7.7703681   ,
        7.50921965  ,
        7.24917173  ,
        6.972188    ,
        6.68984413  ,
        6.38521338  ,
        6.08052349  ,
        5.7456584   ,
        5.36149454  ,
        4.88275433  ,
        4.18950891  ,
        2.66761088  ,
        -0.0304903314   ,
        -2.69902015 ,
        -4.20196342 ,
        -4.88324738 ,
        -5.36177826 ,
        -5.74285555 ,
        -6.08348417 ,
        -6.3873744  ,
        -6.68247557 ,
        -6.97276688 ,
        -7.2447114  ,
        -7.5103817  ,
        -7.76920748 ,
        -8.02947998 ,
        -8.28915691 ,
        -8.5473299  ,
        -8.79302979 ,
        -9.04815102 ,
        -9.29378128 ,
        -9.54880905 ,
        -9.79282379 ,]

    R = 1.179
    # R = 1.2843
    x = current_data['0320-40pts-81.5V-BetaAxis-Repeat2'] = np.array( [4.19995975  ,
       3.98999357  ,
       3.77997351  ,
       3.5700109   ,
       3.35997939  ,
       3.14998031  ,
       2.93999791  ,
       2.72997522  ,
       2.51999402  ,
       2.31000113  ,
       2.10000396  ,
       1.88996792  ,
       1.68000925  ,
       1.47000039  ,
       1.26001358  ,
       1.05000758  ,
       0.840004265 ,
       0.629989207 ,
       0.419989944 ,
       0.210036725 ,
       2.28461176e-05  ,
       -0.209993556    ,
       -0.419971794    ,
       -0.629993081    ,
       -0.840007603    ,
       -1.04999542 ,
       -1.26000357 ,
       -1.4699806  ,
       -1.68000591 ,
       -1.88999796 ,
       -2.10001326 ,
       -2.30999351 ,
       -2.51998496 ,
       -2.72999525 ,
       -2.93999219 ,
       -3.14999771 ,
       -3.3599987  ,
       -3.57000303 ,
       -3.77998376 ,
       -3.98994708 ,
       -4.19995403 ,])
    y = voltage_data['0320-40pts-81.5V-BetaAxis-Repeat2'] = np.array( [9.77734566 ,
        9.53515053  ,
        9.29074192  ,
        9.03914452  ,
        8.79198742  ,
        8.54033756  ,
        8.28903103  ,
        8.02985764  ,
        7.76938057  ,
        7.50647736  ,
        7.23640394  ,
        6.96652126  ,
        6.67586994  ,
        6.37697649  ,
        6.06512833  ,
        5.72815228  ,
        5.34036303  ,
        4.85059786  ,
        4.13037062  ,
        2.44448161  ,
        -0.28064239 ,
        -2.85574722 ,
        -4.26733828 ,
        -4.92929888 ,
        -5.40011597 ,
        -5.78099108 ,
        -6.11834288 ,
        -6.42944956 ,
        -6.72472382 ,
        -7.00851822 ,
        -7.28410673 ,
        -7.54711819 ,
        -7.80723238 ,
        -8.06792355 ,
        -8.32787991 ,
        -8.5868597  ,
        -8.84365368 ,
        -9.09043026 ,
        -9.34671593 ,
        -9.59438419 ,
        -9.84079838 ,])
    
    

    ''' Simulatied inverter nonlinearity using experimental LUT
    '''
    R = 1.1
    current_data['0320-40pts-81.5V-BetaAxis-Repeat2-Simulated']=[   4.2,
        3.99,
        3.78,
        3.57,
        3.36,
        3.15,
        2.94,
        2.73,
        2.52,
        2.31,
        2.1,
        1.89,
        1.68,
        1.47,
        1.26,
        1.05,
        0.840002,
        0.630002,
        0.420002,
        0.210001,
        6.24839e-007,
        -0.209999,
        -0.419998,
        -0.629998,
        -0.835039,
        -1.03607,
        -1.2591,
        -1.46996,
        -1.68001,
        -1.89,
        -2.1,
        -2.31,
        -2.52,
        -2.73,
        -2.94,
        -3.15,
        -3.36,
        -3.57,
        -3.78,
        -3.99,]
    voltage_data['0320-40pts-81.5V-BetaAxis-Repeat2-Simulated']=[        9.8128,
        9.5814,
        9.35039,
        9.11938,
        8.88839,
        8.65738,
        8.42637,
        8.19536,
        7.9643,
        7.73316,
        7.5018,
        7.26982,
        7.03623,
        6.79835,
        6.5491,
        6.26988,
        5.91279,
        5.36104,
        4.36781,
        2.58544,
        8.03631e-006,
        -2.58542,
        -4.36779,
        -5.36103,
        -6.09343,
        -6.47775,
        -6.56286,
        -6.80197,
        -7.03622,
        -7.26985,
        -7.5018,
        -7.73316,
        -7.9643,
        -8.19535,
        -8.42637,
        -8.65737,
        -8.88838,
        -9.11938,
        -9.35038,
        -9.58138,]

    R = 1.179
    xS = current_data['0320-40pts-81.5V-BetaAxis-Repeat2-Simulated-IdentifiedModel-BetaAxisQuantity']=[4.2,
        3.99,
        3.78,
        3.57,
        3.36,
        3.15,
        2.94,
        2.73,
        2.52,
        2.31,
        2.1,
        1.89,
        1.68,
        1.47,
        1.26,
        1.05,
        0.840001,
        0.630001,
        0.420001,
        0.210001,
        -5.93168e-008,
        -0.209999,
        -0.419999,
        -0.629999,
        -0.839999,
        -1.05,
        -1.26,
        -1.47,
        -1.68,
        -1.89,
        -2.1,
        -2.31,
        -2.52,
        -2.73,
        -2.94,
        -3.15,
        -3.36,
        -3.57,
        -3.78,
        -3.99,]
    yS = voltage_data['0320-40pts-81.5V-BetaAxis-Repeat2-Simulated-IdentifiedModel-BetaAxisQuantity']=[10.1442,
        9.89659,
        9.649,
        9.40141,
        9.15382,
        8.90623,
        8.65863,
        8.41102,
        8.16338,
        7.91565,
        7.6677,
        7.41913,
        7.16895,
        6.91448,
        6.64864,
        6.35283,
        5.97915,
        5.41081,
        4.40099,
        2.60203,
        -7.87283e-007,
        -2.60201,
        -4.40097,
        -5.4108,
        -5.97915,
        -6.35282,
        -6.64864,
        -6.91448,
        -7.16895,
        -7.41913,
        -7.66769,
        -7.91565,
        -8.16338,
        -8.41102,
        -8.65863,
        -8.90623,
        -9.15382,
        -9.40141,
        -9.649,
        -9.89659,]

    R = 1.179
    xS = voltage_data['0320-40pts-81.5V-BetaAxis-Repeat2-Simulated-IdentifiedModel-PhaseBQuantity']=[        -8.78512,
        -8.5707,
        -8.35628,
        -8.14186,
        -7.92744,
        -7.71302,
        -7.4986,
        -7.28416,
        -7.0697,
        -6.85516,
        -6.64042,
        -6.42516,
        -6.2085,
        -5.98812,
        -5.75789,
        -5.50171,
        -5.1781,
        -4.6859,
        -3.81137,
        -2.25342,
        8.78513,
        8.5707,
        8.35628,
        8.14186,
        7.92744,
        7.71302,
        7.4986,
        7.28416,
        7.0697,
        6.85516,
        6.64042,
        6.42516,
        6.2085,
        5.98812,
        5.75789,
        5.50171,
        5.1781,
        4.6859,
        3.81137,
        2.25342,]
    yS = current_data['0320-40pts-81.5V-BetaAxis-Repeat2-Simulated-IdentifiedModel-PhaseBQuantity']=[        -3.63731,
        -3.45544,
        -3.27358,
        -3.09171,
        -2.90985,
        -2.72798,
        -2.54612,
        -2.36425,
        -2.18239,
        -2.00052,
        -1.81865,
        -1.63679,
        -1.45492,
        -1.27306,
        -1.09119,
        -0.909328,
        -0.727462,
        -0.545597,
        -0.363732,
        -0.181866,
        3.6373,
        3.45544,
        3.27358,
        3.09171,
        2.90985,
        2.72798,
        2.54612,
        2.36425,
        2.18239,
        2.00052,
        1.81865,
        1.63679,
        1.45492,
        1.27306,
        1.09119,
        0.909328,
        0.727462,
        0.545597,
        0.363732,
        0.181866,]


    ''' Phase B Model + Phase B Measurment
        S stands for Simulation
    '''
    x = current_data['Experiment-0320-phaseB'] = x * -SIN_DASH_2PI_SLASH_3
    y = voltage_data['Experiment-0320-phaseB'] = y * -SIN_DASH_2PI_SLASH_3   
    xS = current_data['Simulated-phaseB']=[        3.63731,
        3.45544,
        3.27358,
        3.09171,
        2.90985,
        2.72798,
        2.54612,
        2.36425,
        2.18238,
        2.00052,
        1.81865,
        1.63679,
        1.45492,
        1.27306,
        1.09119,
        0.909328,
        0.727462,
        0.545597,
        0.363732,
        0.181866,
        -3.6373,
        -3.45544,
        -3.27358,
        -3.09171,
        -2.90985,
        -2.72798,
        -2.54612,
        -2.36425,
        -2.18238,
        -2.00052,
        -1.81865,
        -1.63679,
        -1.45492,
        -1.27306,
        -1.09119,
        -0.909328,
        -0.727462,
        -0.545597,
        -0.363732,
        -0.181866,]
    yS = voltage_data['Simulated-phaseB'] = [8.18267,
        7.96825,
        7.75384,
        7.53942,
        7.325,
        7.11058,
        6.89616,
        6.68174,
        6.46731,
        6.25287,
        6.03838,
        5.82376,
        5.60871,
        5.39235,
        5.17193,
        4.93899,
        4.66785,
        4.28308,
        3.58631,
        2.2061,
        -8.18267,
        -7.96825,
        -7.75384,
        -7.53942,
        -7.325,
        -7.11058,
        -6.89616,
        -6.68174,
        -6.46731,
        -6.25287,
        -6.03838,
        -5.82376,
        -5.60871,
        -5.39235,
        -5.17193,
        -4.93899,
        -4.66785,
        -4.28308,
        -3.58631,
        -2.2061]


    for i in range(1, 3):
        exec(f'fig{i} = plt.figure({i})')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'k-o', label='0311')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'k-o', label='0318-20pts')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'r--s', label='0318-40pts')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'b--*', label='0318-40pts-80V')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'k-o', label='0320-40pts-82V-BetaAxis')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'r--s', label='0320-40pts-81V-BetaAxis-Repeat1')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'ko', label='0320-40pts-81.5V-BetaAxis-Repeat2-Simulated-IdentifiedModel-PhaseBQuantity')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'r-s', label='0320-40pts-81.5V-BetaAxis-Repeat2-Simulated-IdentifiedModel-BetaAxisQuantity')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'b-*', label='0320-40pts-81.5V-BetaAxis-Repeat2')

    R = 1.2843
    plot_ui_curve(fig1.gca(), fig2.gca(),  R,'k-o',  label='Experiment-0320-phaseB')
    R = 1.179
    plot_ui_curve(fig1.gca(), fig2.gca(), R, 'rs',  label='Simulated-phaseB')
    # plot_ui_curve(fig1.gca(), fig2.gca(), 'b-*', label='')

    for fig in [fig1, fig2]:
        fig.gca().legend()
        fig.gca().grid()
        # fig.gca().set_xlim([0,4.5])
        # fig.gca().set_ylim([0,11])
    plt.show()



    plt.figure()
    plt.grid(True)
    plt.xlabel('Current [A]')
    plt.ylabel('Voltage [V]')    
    my_curve_fitting(x, y, alpha=0.2)
    my_curve_fitting(xS, yS, color='k', alpha=0.7)
    plt.show()

