# coding: utf-8

"""
    Loci Notes Server

     The [Loci Notes](https://loci-notes.gitlab.io/) server API.  The Loci Notes server is a FastAPI server that provides a RESTful API for interacting with the Loci Notes system. The server is designed to be used by the Loci Notes web UI, VS Code extension, Loci Notes CLI, and any other clients that may be developed in the future.

    The version of the OpenAPI document: 0.20240917.041813
    Contact: thetwitchy@thetwitchy.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserOut(BaseModel):
    """
    UserOut
    """ # noqa: E501
    email: StrictStr
    is_active: Optional[StrictBool] = True
    is_superuser: Optional[StrictBool] = False
    full_name: Optional[StrictStr] = None
    id: StrictInt
    __properties: ClassVar[List[str]] = ["email", "is_active", "is_superuser", "full_name", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserOut from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if full_name (nullable) is None
        # and model_fields_set contains the field
        if self.full_name is None and "full_name" in self.model_fields_set:
            _dict['full_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserOut from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "is_active": obj.get("is_active") if obj.get("is_active") is not None else True,
            "is_superuser": obj.get("is_superuser") if obj.get("is_superuser") is not None else False,
            "full_name": obj.get("full_name"),
            "id": obj.get("id")
        })
        return _obj


