# coding: utf-8

"""
    Loci Notes Server

     The [Loci Notes](https://loci-notes.gitlab.io/) server API.  The Loci Notes server is a FastAPI server that provides a RESTful API for interacting with the Loci Notes system. The server is designed to be used by the Loci Notes web UI, VS Code extension, Loci Notes CLI, and any other clients that may be developed in the future.

    The version of the OpenAPI document: 0.20240917.041813
    Contact: thetwitchy@thetwitchy.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from loci_client.models.api_key_out import ApiKeyOut
from loci_client.models.project_out import ProjectOut
from typing import Optional, Set
from typing_extensions import Self

class UserFullOut(BaseModel):
    """
    UserFullOut
    """ # noqa: E501
    email: StrictStr
    is_active: StrictBool
    is_superuser: StrictBool
    full_name: Optional[StrictStr] = None
    id: StrictInt
    api_keys: List[ApiKeyOut]
    projects: List[ProjectOut]
    managed_projects: List[ProjectOut]
    __properties: ClassVar[List[str]] = ["email", "is_active", "is_superuser", "full_name", "id", "api_keys", "projects", "managed_projects"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserFullOut from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in api_keys (list)
        _items = []
        if self.api_keys:
            for _item_api_keys in self.api_keys:
                if _item_api_keys:
                    _items.append(_item_api_keys.to_dict())
            _dict['api_keys'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item_projects in self.projects:
                if _item_projects:
                    _items.append(_item_projects.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in managed_projects (list)
        _items = []
        if self.managed_projects:
            for _item_managed_projects in self.managed_projects:
                if _item_managed_projects:
                    _items.append(_item_managed_projects.to_dict())
            _dict['managed_projects'] = _items
        # set to None if full_name (nullable) is None
        # and model_fields_set contains the field
        if self.full_name is None and "full_name" in self.model_fields_set:
            _dict['full_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserFullOut from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "is_active": obj.get("is_active"),
            "is_superuser": obj.get("is_superuser"),
            "full_name": obj.get("full_name"),
            "id": obj.get("id"),
            "api_keys": [ApiKeyOut.from_dict(_item) for _item in obj["api_keys"]] if obj.get("api_keys") is not None else None,
            "projects": [ProjectOut.from_dict(_item) for _item in obj["projects"]] if obj.get("projects") is not None else None,
            "managed_projects": [ProjectOut.from_dict(_item) for _item in obj["managed_projects"]] if obj.get("managed_projects") is not None else None
        })
        return _obj


