# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from pkgs.strenum_compat import StrEnum
from dataclasses import dataclass
from pkgs.serialization import serial_class
from ... import identifier as identifier_t
from ... import recipe_inputs as recipe_inputs_t
from ... import recipe_workflow_steps as recipe_workflow_steps_t

__all__: list[str] = [
    "Arguments",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "RecipeInputEdit",
    "RecipeInputEditAddInput",
    "RecipeInputEditBase",
    "RecipeInputEditClearInputs",
    "RecipeInputEditInputBase",
    "RecipeInputEditType",
    "RecipeInputEditUpsertInput",
]

ENDPOINT_METHOD = "POST"
ENDPOINT_PATH = "api/external/recipes/edit_recipe_inputs"


# DO NOT MODIFY -- This file is generated by type_spec
class RecipeInputEditType(StrEnum):
    CLEAR_INPUTS = "clear_inputs"
    UPSERT_INPUT = "upsert_input"
    ADD_INPUT = "add_input"


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class RecipeInputEditBase:
    type: RecipeInputEditType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclass(kw_only=True)
class RecipeInputEditClearInputs(RecipeInputEditBase):
    type: typing.Literal[RecipeInputEditType.CLEAR_INPUTS] = RecipeInputEditType.CLEAR_INPUTS


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    to_string_values={"value_numeric"},
)
@dataclass(kw_only=True)
class RecipeInputEditInputBase(RecipeInputEditBase):
    ingredient_key: identifier_t.IdentifierKey
    quantity_basis: recipe_inputs_t.QuantityBasis = recipe_inputs_t.QuantityBasis.MASS
    input_value_type: recipe_inputs_t.InputValueType = recipe_inputs_t.InputValueType.VALUE
    value_numeric: typing.Optional[Decimal] = None
    value_str: typing.Optional[str] = None
    calculation_key: typing.Optional[identifier_t.IdentifierKey] = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclass(kw_only=True)
class RecipeInputEditUpsertInput(RecipeInputEditInputBase):
    type: typing.Literal[RecipeInputEditType.UPSERT_INPUT] = RecipeInputEditType.UPSERT_INPUT
    clear_first: bool


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclass(kw_only=True)
class RecipeInputEditAddInput(RecipeInputEditInputBase):
    type: typing.Literal[RecipeInputEditType.ADD_INPUT] = RecipeInputEditType.ADD_INPUT


# DO NOT MODIFY -- This file is generated by type_spec
RecipeInputEdit = typing.Union[RecipeInputEditClearInputs, RecipeInputEditUpsertInput, RecipeInputEditAddInput]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Arguments:
    recipe_key: identifier_t.IdentifierKey
    recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifier
    edits: list[RecipeInputEdit]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclass(kw_only=True)
class Data:
    pass
# DO NOT MODIFY -- This file is generated by type_spec
