# Generated by Django 3.0.4 on 2020-05-01 16:00

import _socket
from django.conf import settings
import django.contrib.sites.managers
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_lab.managers
import edc_model.models.fields.blood_pressure
import edc_model.models.fields.date_estimated
import edc_model.models.fields.height
import edc_model.models.fields.other_charfield
import edc_model.models.fields.weight
import edc_model.validators.date
import edc_model_fields.fields.initials_field
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import mapitio_subject.models.subject_visit
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("mapitio_lists", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("edc_lab", "0020_auto_20191024_1000"),
        ("edc_appointment", "0021_auto_20191024_1000"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        default="alive",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit"),
                            ("unscheduled", "Unscheduled visit"),
                            ("missed", "Missed visit"),
                        ],
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            (
                                "patient_unwell_outpatient",
                                "Patient unwell (outpatient)",
                            ),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("recurrence_symptoms", "Recurrence of symptoms"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            ("patient", "Patient"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("OTHER", "Other"),
                        ],
                        default="hospital_notes",
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "appointment",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_appointment.Appointment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "ordering": (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ),
                "abstract": False,
            },
            managers=[
                ("on_site", mapitio_subject.models.subject_visit.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(
                        editable=False, max_length=50, null=True, unique=True
                    ),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(
                        editable=False, max_length=18, null=True, unique=True
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model_fields.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Specimen type",
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "panel",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_lab.Panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={"abstract": False,},
            managers=[
                ("on_site", edc_visit_tracking.managers.CurrentSiteManager()),
                ("objects", edc_lab.managers.RequisitionManager()),
            ],
        ),
        migrations.CreateModel(
            name="NcdHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "diabetes_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>diabetes</u> diagnosis date known?",
                    ),
                ),
                (
                    "diabetes_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Diabetes</u> diagnosis date",
                    ),
                ),
                (
                    "diabetes_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>diabetes</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_diabetes_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hypertension_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>hypertension</u> diagnosis date known?",
                    ),
                ),
                (
                    "hypertension_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Hypertension</u> diagnosis date",
                    ),
                ),
                (
                    "hypertension_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>hypertension</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_hypertension_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "diabetic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient first enrolled at the clinic, did they have <u>diabetes</u>?",
                    ),
                ),
                (
                    "hypertensive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient enrolled at the clinic, did they have <u>hypertension</u>?",
                    ),
                ),
                (
                    "smoking_status",
                    models.CharField(
                        choices=[
                            ("smoker", "Currently smokes"),
                            ("former_smoker", "Used to smoke but stopped"),
                            ("nonsmoker", "Never smoked"),
                            ("not_recorded", "Not recorded"),
                        ],
                        max_length=15,
                        verbose_name="Smoker? Which best describes the patient:",
                    ),
                ),
                (
                    "takes_cholesterol_rx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient currently taking any statins or other medications for control of blood cholesterol?",
                    ),
                ),
                (
                    "other_cholesterol_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "cholesterol_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.CholesterolMedications",
                        verbose_name="If YES, blood cholesterol medications",
                    ),
                ),
                (
                    "diabetes_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.DiabetesMedications",
                        verbose_name="Diabetes treatment",
                    ),
                ),
                (
                    "hypertension_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.HypertensionMedications",
                        verbose_name="Hypertension treatment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "NCD History",
                "verbose_name_plural": "NCD History",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="NcdFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "diabetes_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>diabetes</u> diagnosis date known?",
                    ),
                ),
                (
                    "diabetes_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Diabetes</u> diagnosis date",
                    ),
                ),
                (
                    "diabetes_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>diabetes</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_diabetes_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hypertension_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>hypertension</u> diagnosis date known?",
                    ),
                ),
                (
                    "hypertension_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Hypertension</u> diagnosis date",
                    ),
                ),
                (
                    "hypertension_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>hypertension</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_hypertension_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "diabetic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since the patient enrolled at this clinic, have they been diagnosed with <u>diabetes</u>?",
                    ),
                ),
                (
                    "hypertensive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since the patient enrolled at this clinic, have they been diagnosed with <u>hypertension</u>?",
                    ),
                ),
                (
                    "diabetes_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.DiabetesMedications",
                        verbose_name="Diabetes treatment",
                    ),
                ),
                (
                    "hypertension_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.HypertensionMedications",
                        verbose_name="Hypertension treatment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "NCD Followup",
                "verbose_name_plural": "NCD Followup",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Investigations",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "chest_xray_findings_other",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If 'Other', chest x-ray findings",
                    ),
                ),
                (
                    "ecg_findings_other",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If 'Other', ECG findings",
                    ),
                ),
                (
                    "echo_findings_other",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If 'Other', ECHO findings",
                    ),
                ),
                (
                    "chest_xray_findings",
                    models.ManyToManyField(
                        blank=True,
                        to="mapitio_lists.ChestXrayFindings",
                        verbose_name="Chest x-ray findings",
                    ),
                ),
                (
                    "ecg_findings",
                    models.ManyToManyField(
                        blank=True,
                        to="mapitio_lists.EcgFindings",
                        verbose_name="ECG findings",
                    ),
                ),
                (
                    "echo_findings",
                    models.ManyToManyField(
                        blank=True,
                        to="mapitio_lists.EchoFindings",
                        verbose_name="ECHO findings",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Investigations",
                "verbose_name_plural": "Investigations",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Indicators",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "height",
                    edc_model.models.fields.height.HeightField(blank=True, null=True),
                ),
                (
                    "weight",
                    edc_model.models.fields.weight.WeightField(blank=True, null=True),
                ),
                (
                    "waist_circumference",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in centimeters",
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50.0),
                            django.core.validators.MaxValueValidator(175.0),
                        ],
                        verbose_name="Waist circumference",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    edc_model.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure",
                    edc_model.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Blood Glucose Units",
                    ),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("fasting", "Fasting"),
                            ("non_fasting", "Non-fasting"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="Was this a fasting or random blood glucose?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Indicators",
                "verbose_name_plural": "Indicators",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HivHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "diabetic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient first enrolled at the clinic, did they have <u>diabetes</u>?",
                    ),
                ),
                (
                    "diabetes_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>diabetes</u> diagnosis date known?",
                    ),
                ),
                (
                    "diabetes_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Diabetes</u> diagnosis date",
                    ),
                ),
                (
                    "diabetes_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>diabetes</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_diabetes_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hypertensive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient enrolled at the clinic, did they have <u>hypertension</u>?",
                    ),
                ),
                (
                    "hypertension_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>hypertension</u> diagnosis date known?",
                    ),
                ),
                (
                    "hypertension_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Hypertension</u> diagnosis date",
                    ),
                ),
                (
                    "hypertension_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>hypertension</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_hypertension_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hiv_pos_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When did the patient first test positive for HIV",
                    ),
                ),
                (
                    "arv_initiation_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date antiretroviral therapy commenced",
                    ),
                ),
                (
                    "arv_regimen_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "arv_regimen",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_lists.ArvRegimens",
                        verbose_name="ARV Regimen at enrollment",
                    ),
                ),
                (
                    "diabetes_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.DiabetesMedications",
                        verbose_name="Diabetes treatment",
                    ),
                ),
                (
                    "hypertension_rx",
                    models.ManyToManyField(
                        to="mapitio_lists.HypertensionMedications",
                        verbose_name="Hypertension treatment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "HIV History",
                "verbose_name_plural": "HIV History",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        default="alive",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit"),
                            ("unscheduled", "Unscheduled visit"),
                            ("missed", "Missed visit"),
                        ],
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            (
                                "patient_unwell_outpatient",
                                "Patient unwell (outpatient)",
                            ),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("recurrence_symptoms", "Recurrence of symptoms"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            ("patient", "Patient"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("OTHER", "Other"),
                        ],
                        default="hospital_notes",
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "appointment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_appointment.Appointment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject visit",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(
                        db_index=True, editable=False, max_length=50, null=True
                    ),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(
                        db_index=True, editable=False, max_length=18, null=True
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model_fields.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Specimen type",
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "panel",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_lab.Panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject requisition",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalNcdHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "diabetes_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>diabetes</u> diagnosis date known?",
                    ),
                ),
                (
                    "diabetes_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Diabetes</u> diagnosis date",
                    ),
                ),
                (
                    "diabetes_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>diabetes</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_diabetes_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hypertension_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>hypertension</u> diagnosis date known?",
                    ),
                ),
                (
                    "hypertension_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Hypertension</u> diagnosis date",
                    ),
                ),
                (
                    "hypertension_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>hypertension</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_hypertension_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "diabetic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient first enrolled at the clinic, did they have <u>diabetes</u>?",
                    ),
                ),
                (
                    "hypertensive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient enrolled at the clinic, did they have <u>hypertension</u>?",
                    ),
                ),
                (
                    "smoking_status",
                    models.CharField(
                        choices=[
                            ("smoker", "Currently smokes"),
                            ("former_smoker", "Used to smoke but stopped"),
                            ("nonsmoker", "Never smoked"),
                            ("not_recorded", "Not recorded"),
                        ],
                        max_length=15,
                        verbose_name="Smoker? Which best describes the patient:",
                    ),
                ),
                (
                    "takes_cholesterol_rx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient currently taking any statins or other medications for control of blood cholesterol?",
                    ),
                ),
                (
                    "other_cholesterol_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical NCD History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalNcdFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "diabetes_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>diabetes</u> diagnosis date known?",
                    ),
                ),
                (
                    "diabetes_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Diabetes</u> diagnosis date",
                    ),
                ),
                (
                    "diabetes_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>diabetes</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_diabetes_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hypertension_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>hypertension</u> diagnosis date known?",
                    ),
                ),
                (
                    "hypertension_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Hypertension</u> diagnosis date",
                    ),
                ),
                (
                    "hypertension_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>hypertension</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_hypertension_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "diabetic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since the patient enrolled at this clinic, have they been diagnosed with <u>diabetes</u>?",
                    ),
                ),
                (
                    "hypertensive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since the patient enrolled at this clinic, have they been diagnosed with <u>hypertension</u>?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical NCD Followup",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalInvestigations",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "chest_xray_findings_other",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If 'Other', chest x-ray findings",
                    ),
                ),
                (
                    "ecg_findings_other",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If 'Other', ECG findings",
                    ),
                ),
                (
                    "echo_findings_other",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If 'Other', ECHO findings",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Investigations",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalIndicators",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "height",
                    edc_model.models.fields.height.HeightField(blank=True, null=True),
                ),
                (
                    "weight",
                    edc_model.models.fields.weight.WeightField(blank=True, null=True),
                ),
                (
                    "waist_circumference",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in centimeters",
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(50.0),
                            django.core.validators.MaxValueValidator(175.0),
                        ],
                        verbose_name="Waist circumference",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    edc_model.models.fields.blood_pressure.SystolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "dia_blood_pressure",
                    edc_model.models.fields.blood_pressure.DiastolicPressureField(
                        blank=True, null=True
                    ),
                ),
                (
                    "glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="Blood Glucose Units",
                    ),
                ),
                (
                    "glucose_fasting",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("fasting", "Fasting"),
                            ("non_fasting", "Non-fasting"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="Was this a fasting or random blood glucose?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Indicators",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHivHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "diabetic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient first enrolled at the clinic, did they have <u>diabetes</u>?",
                    ),
                ),
                (
                    "diabetes_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>diabetes</u> diagnosis date known?",
                    ),
                ),
                (
                    "diabetes_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Diabetes</u> diagnosis date",
                    ),
                ),
                (
                    "diabetes_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>diabetes</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_diabetes_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hypertensive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="When the patient enrolled at the clinic, did they have <u>hypertension</u>?",
                    ),
                ),
                (
                    "hypertension_dx_date_known",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Is the <u>hypertension</u> diagnosis date known?",
                    ),
                ),
                (
                    "hypertension_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="<u>Hypertension</u> diagnosis date",
                    ),
                ),
                (
                    "hypertension_dx_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        null=True,
                        verbose_name="Is the <u>hypertension</u> diagnosis date estimated?",
                    ),
                ),
                (
                    "other_hypertension_rx",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "hiv_pos_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When did the patient first test positive for HIV",
                    ),
                ),
                (
                    "arv_initiation_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date antiretroviral therapy commenced",
                    ),
                ),
                (
                    "arv_regimen_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_lists.ArvRegimens",
                        verbose_name="ARV Regimen at enrollment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical HIV History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalFollowUp",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "alive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Is the patient known to be alive?",
                    ),
                ),
                (
                    "in_care",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Is the patient still receiving HIV care in this clinic?",
                    ),
                ),
                (
                    "reason_not_in_care",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("transferred", "Transferred"),
                            ("LTFU", "Lost to followup"),
                            ("OTHER", "Other, please specify..."),
                        ],
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "reason_not_in_care_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'Other', specify other reason not in care",
                    ),
                ),
                (
                    "has_next_appointment",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Has the patient been scheduled for their next apointment?",
                    ),
                ),
                (
                    "next_appointment_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_is_future],
                        verbose_name="Date of patient's next clinic appointment?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Follow Up",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDeathReport",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "death_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_is_past],
                        verbose_name="Date of death",
                    ),
                ),
                (
                    "death_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("-", "No"),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the date of death estimated?",
                    ),
                ),
                (
                    "death_cause",
                    models.TextField(
                        verbose_name="The cause of death as recorded in the patient notes"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Death Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalComplications",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "stroke",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Stroke",
                    ),
                ),
                (
                    "stroke_dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If patient has a history of more than one stroke, report the date of the first stroke.",
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of stroke diagnosis",
                    ),
                ),
                (
                    "diabetic_foot",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Diabetic foot",
                    ),
                ),
                (
                    "diabetic_foot_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of diabetic foot diagnosis",
                    ),
                ),
                (
                    "diabetic_retinopathy",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Diabetic retinopathy",
                    ),
                ),
                (
                    "diabetic_retinopathy_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of diabetic retinopathy diagnosis",
                    ),
                ),
                (
                    "chronic_renal_failure",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Chronic renal failure",
                    ),
                ),
                (
                    "chronic_renal_failure_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of chronic renal failure",
                    ),
                ),
                (
                    "cardiomyopathy",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Ischaemic cardiomyopathy",
                    ),
                ),
                (
                    "cardiomyopathy_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of ischaemic cardiomyopathy",
                    ),
                ),
                (
                    "peripheral_vascular",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Peripheral vascular disease",
                    ),
                ),
                (
                    "peripheral_vascular_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of peripheral vascular disease diagnosis",
                    ),
                ),
                (
                    "peripheral_neuropathy",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Peripheral neuropathy",
                    ),
                ),
                (
                    "peripheral_neuropathy_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of peripheral neuropathy diagnosis",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Were there any other complications to report?",
                    ),
                ),
                (
                    "complications_other",
                    models.TextField(
                        blank=True, help_text="Please include dates", null=True
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Complications",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBiomedicalHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "total_cholesterol",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Total cholesterol</u>",
                    ),
                ),
                (
                    "total_cholesterol_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Total cholesterol date</i>",
                    ),
                ),
                (
                    "ldl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>LDL</u>",
                    ),
                ),
                (
                    "ldl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>LDL date</i>",
                    ),
                ),
                (
                    "hdl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>HDL</u>",
                    ),
                ),
                (
                    "hdl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HDL date</i>",
                    ),
                ),
                (
                    "triglycerides",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Triglycerides</u>",
                    ),
                ),
                (
                    "triglycerides_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Triglycerides date</i>",
                    ),
                ),
                (
                    "serum_urea",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum urea</u>",
                    ),
                ),
                (
                    "serum_urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum urea units</i>",
                    ),
                ),
                (
                    "serum_urea_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum urea date</i>",
                    ),
                ),
                (
                    "serum_creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum creatinine</u>",
                    ),
                ),
                (
                    "serum_creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum creatinine units</i>",
                    ),
                ),
                (
                    "serum_creatinine_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum creatinine date</i>",
                    ),
                ),
                (
                    "serum_uric_acid",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum uric acid</u>",
                    ),
                ),
                (
                    "serum_uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        default="mg/dL",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum uric acid units</i>",
                    ),
                ),
                (
                    "serum_uric_acid_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum uric acid date</i>",
                    ),
                ),
                (
                    "ast",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>AST</u>",
                    ),
                ),
                (
                    "ast_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>AST date</i>",
                    ),
                ),
                (
                    "alt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALT</u>",
                    ),
                ),
                (
                    "alt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALT date</i>",
                    ),
                ),
                (
                    "alp",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALP</u>",
                    ),
                ),
                (
                    "alp_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALP date</i>",
                    ),
                ),
                (
                    "amylase",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Amylase</u>",
                    ),
                ),
                (
                    "amylase_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Amylase date</i>",
                    ),
                ),
                (
                    "ggt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>GGT</u>",
                    ),
                ),
                (
                    "ggt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>GGT date</i>",
                    ),
                ),
                (
                    "albumin",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=6,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Albumin</u>",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        default="g/L",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum Albumin units</i>",
                    ),
                ),
                (
                    "albumin_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Albumin date</i>",
                    ),
                ),
                (
                    "egfr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mL/min/1.73 m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="<u>eGFR</u>",
                    ),
                ),
                (
                    "hbsag",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HbSAg</u>",
                    ),
                ),
                (
                    "hbsag_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HbSAg date</i>",
                    ),
                ),
                (
                    "hcv",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HCV</u>",
                    ),
                ),
                (
                    "hcv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HCV date</i>",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="<u>CD4 count</u>",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>CD4 date</i>",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="<u>Viral load</u>",
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Viral load date</i>",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Biomedical History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBiomedicalFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "total_cholesterol",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Total cholesterol</u>",
                    ),
                ),
                (
                    "total_cholesterol_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Total cholesterol date</i>",
                    ),
                ),
                (
                    "ldl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>LDL</u>",
                    ),
                ),
                (
                    "ldl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>LDL date</i>",
                    ),
                ),
                (
                    "hdl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>HDL</u>",
                    ),
                ),
                (
                    "hdl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HDL date</i>",
                    ),
                ),
                (
                    "triglycerides",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Triglycerides</u>",
                    ),
                ),
                (
                    "triglycerides_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Triglycerides date</i>",
                    ),
                ),
                (
                    "serum_urea",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum urea</u>",
                    ),
                ),
                (
                    "serum_urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum urea units</i>",
                    ),
                ),
                (
                    "serum_urea_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum urea date</i>",
                    ),
                ),
                (
                    "serum_creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum creatinine</u>",
                    ),
                ),
                (
                    "serum_creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum creatinine units</i>",
                    ),
                ),
                (
                    "serum_creatinine_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum creatinine date</i>",
                    ),
                ),
                (
                    "serum_uric_acid",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum uric acid</u>",
                    ),
                ),
                (
                    "serum_uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        default="mg/dL",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum uric acid units</i>",
                    ),
                ),
                (
                    "serum_uric_acid_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum uric acid date</i>",
                    ),
                ),
                (
                    "ast",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>AST</u>",
                    ),
                ),
                (
                    "ast_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>AST date</i>",
                    ),
                ),
                (
                    "alt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALT</u>",
                    ),
                ),
                (
                    "alt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALT date</i>",
                    ),
                ),
                (
                    "alp",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALP</u>",
                    ),
                ),
                (
                    "alp_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALP date</i>",
                    ),
                ),
                (
                    "amylase",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Amylase</u>",
                    ),
                ),
                (
                    "amylase_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Amylase date</i>",
                    ),
                ),
                (
                    "ggt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>GGT</u>",
                    ),
                ),
                (
                    "ggt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>GGT date</i>",
                    ),
                ),
                (
                    "albumin",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=6,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Albumin</u>",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        default="g/L",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum Albumin units</i>",
                    ),
                ),
                (
                    "albumin_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Albumin date</i>",
                    ),
                ),
                (
                    "egfr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mL/min/1.73 m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="<u>eGFR</u>",
                    ),
                ),
                (
                    "hbsag",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HbSAg</u>",
                    ),
                ),
                (
                    "hbsag_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HbSAg date</i>",
                    ),
                ),
                (
                    "hcv",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HCV</u>",
                    ),
                ),
                (
                    "hcv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HCV date</i>",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="<u>CD4 count</u>",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>CD4 date</i>",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="<u>Viral load</u>",
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Viral load date</i>",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Biomedical Followup",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="FollowUp",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "alive",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Is the patient known to be alive?",
                    ),
                ),
                (
                    "in_care",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Is the patient still receiving HIV care in this clinic?",
                    ),
                ),
                (
                    "reason_not_in_care",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("transferred", "Transferred"),
                            ("LTFU", "Lost to followup"),
                            ("OTHER", "Other, please specify..."),
                        ],
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "reason_not_in_care_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'Other', specify other reason not in care",
                    ),
                ),
                (
                    "has_next_appointment",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Has the patient been scheduled for their next apointment?",
                    ),
                ),
                (
                    "next_appointment_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_is_future],
                        verbose_name="Date of patient's next clinic appointment?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Follow Up",
                "verbose_name_plural": "Follow Ups",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="DeathReport",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "death_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_is_past],
                        verbose_name="Date of death",
                    ),
                ),
                (
                    "death_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedField(
                        choices=[
                            ("-", "No"),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the date of death estimated?",
                    ),
                ),
                (
                    "death_cause",
                    models.TextField(
                        verbose_name="The cause of death as recorded in the patient notes"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Death Report",
                "verbose_name_plural": "Death Reports",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Complications",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "stroke",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Stroke",
                    ),
                ),
                (
                    "stroke_dx_date",
                    models.DateField(
                        blank=True,
                        help_text="If patient has a history of more than one stroke, report the date of the first stroke.",
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of stroke diagnosis",
                    ),
                ),
                (
                    "diabetic_foot",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Diabetic foot",
                    ),
                ),
                (
                    "diabetic_foot_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of diabetic foot diagnosis",
                    ),
                ),
                (
                    "diabetic_retinopathy",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Diabetic retinopathy",
                    ),
                ),
                (
                    "diabetic_retinopathy_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of diabetic retinopathy diagnosis",
                    ),
                ),
                (
                    "chronic_renal_failure",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Chronic renal failure",
                    ),
                ),
                (
                    "chronic_renal_failure_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of chronic renal failure",
                    ),
                ),
                (
                    "cardiomyopathy",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Ischaemic cardiomyopathy",
                    ),
                ),
                (
                    "cardiomyopathy_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of ischaemic cardiomyopathy",
                    ),
                ),
                (
                    "peripheral_vascular",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Peripheral vascular disease",
                    ),
                ),
                (
                    "peripheral_vascular_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of peripheral vascular disease diagnosis",
                    ),
                ),
                (
                    "peripheral_neuropathy",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="Peripheral neuropathy",
                    ),
                ),
                (
                    "peripheral_neuropathy_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="If YES, date of peripheral neuropathy diagnosis",
                    ),
                ),
                (
                    "complications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="Were there any other complications to report?",
                    ),
                ),
                (
                    "complications_other",
                    models.TextField(
                        blank=True, help_text="Please include dates", null=True
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Complications",
                "verbose_name_plural": "Complications",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BiomedicalHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "total_cholesterol",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Total cholesterol</u>",
                    ),
                ),
                (
                    "total_cholesterol_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Total cholesterol date</i>",
                    ),
                ),
                (
                    "ldl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>LDL</u>",
                    ),
                ),
                (
                    "ldl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>LDL date</i>",
                    ),
                ),
                (
                    "hdl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>HDL</u>",
                    ),
                ),
                (
                    "hdl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HDL date</i>",
                    ),
                ),
                (
                    "triglycerides",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Triglycerides</u>",
                    ),
                ),
                (
                    "triglycerides_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Triglycerides date</i>",
                    ),
                ),
                (
                    "serum_urea",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum urea</u>",
                    ),
                ),
                (
                    "serum_urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum urea units</i>",
                    ),
                ),
                (
                    "serum_urea_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum urea date</i>",
                    ),
                ),
                (
                    "serum_creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum creatinine</u>",
                    ),
                ),
                (
                    "serum_creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum creatinine units</i>",
                    ),
                ),
                (
                    "serum_creatinine_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum creatinine date</i>",
                    ),
                ),
                (
                    "serum_uric_acid",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum uric acid</u>",
                    ),
                ),
                (
                    "serum_uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        default="mg/dL",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum uric acid units</i>",
                    ),
                ),
                (
                    "serum_uric_acid_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum uric acid date</i>",
                    ),
                ),
                (
                    "ast",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>AST</u>",
                    ),
                ),
                (
                    "ast_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>AST date</i>",
                    ),
                ),
                (
                    "alt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALT</u>",
                    ),
                ),
                (
                    "alt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALT date</i>",
                    ),
                ),
                (
                    "alp",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALP</u>",
                    ),
                ),
                (
                    "alp_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALP date</i>",
                    ),
                ),
                (
                    "amylase",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Amylase</u>",
                    ),
                ),
                (
                    "amylase_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Amylase date</i>",
                    ),
                ),
                (
                    "ggt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>GGT</u>",
                    ),
                ),
                (
                    "ggt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>GGT date</i>",
                    ),
                ),
                (
                    "albumin",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=6,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Albumin</u>",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        default="g/L",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum Albumin units</i>",
                    ),
                ),
                (
                    "albumin_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Albumin date</i>",
                    ),
                ),
                (
                    "egfr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mL/min/1.73 m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="<u>eGFR</u>",
                    ),
                ),
                (
                    "hbsag",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HbSAg</u>",
                    ),
                ),
                (
                    "hbsag_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HbSAg date</i>",
                    ),
                ),
                (
                    "hcv",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HCV</u>",
                    ),
                ),
                (
                    "hcv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HCV date</i>",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="<u>CD4 count</u>",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>CD4 date</i>",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="<u>Viral load</u>",
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Viral load date</i>",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Biomedical History",
                "verbose_name_plural": "Biomedical History",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BiomedicalFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="INCOMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True)),
                (
                    "total_cholesterol",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Total cholesterol</u>",
                    ),
                ),
                (
                    "total_cholesterol_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Total cholesterol date</i>",
                    ),
                ),
                (
                    "ldl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>LDL</u>",
                    ),
                ),
                (
                    "ldl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>LDL date</i>",
                    ),
                ),
                (
                    "hdl",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>HDL</u>",
                    ),
                ),
                (
                    "hdl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HDL date</i>",
                    ),
                ),
                (
                    "triglycerides",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="mmol/L",
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Triglycerides</u>",
                    ),
                ),
                (
                    "triglycerides_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Triglycerides date</i>",
                    ),
                ),
                (
                    "serum_urea",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum urea</u>",
                    ),
                ),
                (
                    "serum_urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum urea units</i>",
                    ),
                ),
                (
                    "serum_urea_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum urea date</i>",
                    ),
                ),
                (
                    "serum_creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum creatinine</u>",
                    ),
                ),
                (
                    "serum_creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum creatinine units</i>",
                    ),
                ),
                (
                    "serum_creatinine_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum creatinine date</i>",
                    ),
                ),
                (
                    "serum_uric_acid",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=4,
                        null=True,
                        verbose_name="<u>Serum uric acid</u>",
                    ),
                ),
                (
                    "serum_uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        default="mg/dL",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum uric acid units</i>",
                    ),
                ),
                (
                    "serum_uric_acid_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum uric acid date</i>",
                    ),
                ),
                (
                    "ast",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>AST</u>",
                    ),
                ),
                (
                    "ast_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>AST date</i>",
                    ),
                ),
                (
                    "alt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALT</u>",
                    ),
                ),
                (
                    "alt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALT date</i>",
                    ),
                ),
                (
                    "alp",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>ALP</u>",
                    ),
                ),
                (
                    "alp_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>ALP date</i>",
                    ),
                ),
                (
                    "amylase",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Amylase</u>",
                    ),
                ),
                (
                    "amylase_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Amylase date</i>",
                    ),
                ),
                (
                    "ggt",
                    models.IntegerField(
                        blank=True,
                        help_text="U/L",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>GGT</u>",
                    ),
                ),
                (
                    "ggt_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>GGT date</i>",
                    ),
                ),
                (
                    "albumin",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=6,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="<u>Serum Albumin</u>",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        default="g/L",
                        max_length=15,
                        null=True,
                        verbose_name="<i>Serum Albumin units</i>",
                    ),
                ),
                (
                    "albumin_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Serum Albumin date</i>",
                    ),
                ),
                (
                    "egfr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mL/min/1.73 m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="<u>eGFR</u>",
                    ),
                ),
                (
                    "hbsag",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HbSAg</u>",
                    ),
                ),
                (
                    "hbsag_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HbSAg date</i>",
                    ),
                ),
                (
                    "hcv",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        null=True,
                        verbose_name="<u>HCV</u>",
                    ),
                ),
                (
                    "hcv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>HCV date</i>",
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="<u>CD4 count</u>",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>CD4 date</i>",
                    ),
                ),
                (
                    "vl",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="<u>Viral load</u>",
                    ),
                ),
                (
                    "vl_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_is_past,
                            edc_model.validators.date.date_is_not_now,
                        ],
                        verbose_name="<i>Viral load date</i>",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Biomedical Followup",
                "verbose_name_plural": "Biomedical Followup",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="subjectvisit",
            index=models.Index(
                fields=[
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ],
                name="mapitio_sub_subject_673e62_idx",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="subjectvisit",
            unique_together={
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                ),
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "report_datetime",
                ),
            },
        ),
        migrations.AlterUniqueTogether(
            name="subjectrequisition", unique_together={("panel", "subject_visit")},
        ),
        migrations.AddIndex(
            model_name="ncdhistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_7dcb0e_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="ncdfollowup",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_f025af_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="investigations",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_6168f3_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="indicators",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_242e0f_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="hivhistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_ce1040_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="followup",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_eaecee_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="deathreport",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_769b01_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="complications",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_82a9ae_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="biomedicalhistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_e3b77a_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="biomedicalfollowup",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="mapitio_sub_subject_fb997e_idx",
            ),
        ),
    ]
