"""added api key table

Revision ID: 0002
Revises: 0001
Create Date: 2025-01-06 12:49:31.364945

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op
from sqlmodel.sql.sqltypes import AutoString

# revision identifiers, used by Alembic.
revision: str = "0002"
down_revision: str | None = "0001"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "api_keys",
        sa.Column("uuid", sa.Uuid(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("organization_uuid", sa.Uuid(), nullable=False),
        sa.Column("name", AutoString(), nullable=False),
        sa.Column("expires_at", sa.DateTime(), nullable=False),
        sa.Column("key_hash", AutoString(), nullable=False),
        sa.Column("user_uuid", sa.Uuid(), nullable=False),
        sa.Column("project_uuid", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_uuid"],
            ["organizations.uuid"],
            name=op.f("api_keys_organization_uuid_organizations_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["project_uuid"],
            ["projects.uuid"],
            name=op.f("api_keys_project_uuid_projects_fkey"),
        ),
        sa.ForeignKeyConstraint(
            ["user_uuid"], ["users.uuid"], name=op.f("api_keys_user_uuid_users_fkey")
        ),
        sa.PrimaryKeyConstraint("uuid", name=op.f("api_keys_pkey")),
    )
    op.create_index(
        op.f("api_keys_organization_uuid_idx"),
        "api_keys",
        ["organization_uuid"],
        unique=False,
    )
    op.create_index(
        op.f("api_keys_project_uuid_idx"), "api_keys", ["project_uuid"], unique=False
    )
    op.create_index(
        op.f("api_keys_user_uuid_idx"), "api_keys", ["user_uuid"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("api_keys_user_uuid_idx"), table_name="api_keys")
    op.drop_index(op.f("api_keys_project_uuid_idx"), table_name="api_keys")
    op.drop_index(op.f("api_keys_organization_uuid_idx"), table_name="api_keys")
    op.drop_table("api_keys")
    # ### end Alembic commands ###
