# coding: utf-8

# flake8: noqa

"""
    STACKIT Model Serving API

    This API provides endpoints for the model serving api

    The version of the OpenAPI document: 1.0.0
    Contact: model-serving@mail.schwarz
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# Define package exports
__all__ = [
    "DefaultApi",
    "ApiResponse",
    "ApiClient",
    "HostConfiguration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "ChatModelDetails",
    "CreateTokenPayload",
    "CreateTokenResponse",
    "EmbeddingModelDetails",
    "ErrorMessageResponse",
    "GetChatModelResponse",
    "GetEmbeddingsModelResp",
    "GetTokenResponse",
    "ListModelsResponse",
    "ListTokenResp",
    "MessageResponse",
    "Model",
    "PartialUpdateTokenPayload",
    "SKU",
    "Token",
    "TokenCreated",
    "UpdateTokenResponse",
]

# import apis into sdk package
from stackit.modelserving.api.default_api import DefaultApi as DefaultApi
from stackit.modelserving.api_client import ApiClient as ApiClient

# import ApiClient
from stackit.modelserving.api_response import ApiResponse as ApiResponse
from stackit.modelserving.configuration import HostConfiguration as HostConfiguration
from stackit.modelserving.exceptions import ApiAttributeError as ApiAttributeError
from stackit.modelserving.exceptions import ApiException as ApiException
from stackit.modelserving.exceptions import ApiKeyError as ApiKeyError
from stackit.modelserving.exceptions import ApiTypeError as ApiTypeError
from stackit.modelserving.exceptions import ApiValueError as ApiValueError
from stackit.modelserving.exceptions import OpenApiException as OpenApiException

# import models into sdk package
from stackit.modelserving.models.chat_model_details import (
    ChatModelDetails as ChatModelDetails,
)
from stackit.modelserving.models.create_token_payload import (
    CreateTokenPayload as CreateTokenPayload,
)
from stackit.modelserving.models.create_token_response import (
    CreateTokenResponse as CreateTokenResponse,
)
from stackit.modelserving.models.embedding_model_details import (
    EmbeddingModelDetails as EmbeddingModelDetails,
)
from stackit.modelserving.models.error_message_response import (
    ErrorMessageResponse as ErrorMessageResponse,
)
from stackit.modelserving.models.get_chat_model_response import (
    GetChatModelResponse as GetChatModelResponse,
)
from stackit.modelserving.models.get_embeddings_model_resp import (
    GetEmbeddingsModelResp as GetEmbeddingsModelResp,
)
from stackit.modelserving.models.get_token_response import (
    GetTokenResponse as GetTokenResponse,
)
from stackit.modelserving.models.list_models_response import (
    ListModelsResponse as ListModelsResponse,
)
from stackit.modelserving.models.list_token_resp import ListTokenResp as ListTokenResp
from stackit.modelserving.models.message_response import (
    MessageResponse as MessageResponse,
)
from stackit.modelserving.models.model import Model as Model
from stackit.modelserving.models.partial_update_token_payload import (
    PartialUpdateTokenPayload as PartialUpdateTokenPayload,
)
from stackit.modelserving.models.sku import SKU as SKU
from stackit.modelserving.models.token import Token as Token
from stackit.modelserving.models.token_created import TokenCreated as TokenCreated
from stackit.modelserving.models.update_token_response import (
    UpdateTokenResponse as UpdateTokenResponse,
)
