#!/usr/bin/env python3

import unittest

import importlib
ff1 = importlib.import_module('ubiq_security_fpe.ff1')
ffx = importlib.import_module('ubiq_security_fpe.ffx')

class TestFF1(unittest.TestCase):
    def test_context(self):
        self.assertIsNotNone(
            ff1.Context(bytes([0]*16), bytes([0]*7), 0, 7, 10))

    def cipherTest(self, key, twk, pt, ct, radix, alpha = ffx.DEFAULT_ALPHABET):
        ctx = ff1.Context(bytes(key), bytes(twk), 0, len(twk), radix, alpha)
        self.assertIsNotNone(ctx)
        res = ctx.Encrypt(pt)
        self.assertEqual(res, ct)
        res = ctx.Decrypt(ct)
        self.assertEqual(res, pt)

    def test_nist1(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c],
            [],
            '0123456789', '2433477484', 10)

    def test_nist2(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c],
            [0x39, 0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x30],
            '0123456789', '6124200773', 10)

    def test_nist2_custom(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c],
            [0x39, 0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x30],
            '2345678901', '8346422995', 10, '2345678901')

    def test_nist3(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c],
            [0x37, 0x37, 0x37, 0x37, 0x70, 0x71, 0x72, 0x73, 0x37, 0x37, 0x37],
            '0123456789abcdefghi', 'a9tv40mll9kdu509eum', 36)

    def test_nist3_prime(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c],
            [0x37, 0x37, 0x37, 0x37, 0x70, 0x71, 0x72, 0x73, 0x37, 0x37, 0x37],
            '0123456789abcdefghijklmnopqrstuvwxyz012345',
            'l4zpm8zauhw2zkke9o0i7oi17iojfqog7dmjze3her',
            36)

    def test_nist4(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c,
             0xef, 0x43, 0x59, 0xd8, 0xd5, 0x80, 0xaa, 0x4f],
            [],
            '0123456789', '2830668132', 10)

    def test_nist5(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c,
             0xef, 0x43, 0x59, 0xd8, 0xd5, 0x80, 0xaa, 0x4f],
            [0x39, 0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x30],
            '0123456789', '2496655549', 10)

    def test_nist6(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c,
             0xef, 0x43, 0x59, 0xd8, 0xd5, 0x80, 0xaa, 0x4f],
            [0x37, 0x37, 0x37, 0x37, 0x70, 0x71, 0x72, 0x73, 0x37, 0x37, 0x37],
            '0123456789abcdefghi', 'xbj3kv35jrawxv32ysr', 36)

    def test_nist7(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c,
             0xef, 0x43, 0x59, 0xd8, 0xd5, 0x80, 0xaa, 0x4f,
             0x7f, 0x03, 0x6d, 0x6f, 0x04, 0xfc, 0x6a, 0x94],
            [],
            '0123456789', '6657667009', 10)

    def test_nist8(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c,
             0xef, 0x43, 0x59, 0xd8, 0xd5, 0x80, 0xaa, 0x4f,
             0x7f, 0x03, 0x6d, 0x6f, 0x04, 0xfc, 0x6a, 0x94],
            [0x39, 0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31, 0x30],
            '0123456789', '1001623463', 10)

    def test_nist9(self):
        self.cipherTest(
            [0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
             0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c,
             0xef, 0x43, 0x59, 0xd8, 0xd5, 0x80, 0xaa, 0x4f,
             0x7f, 0x03, 0x6d, 0x6f, 0x04, 0xfc, 0x6a, 0x94],
            [0x37, 0x37, 0x37, 0x37, 0x70, 0x71, 0x72, 0x73, 0x37, 0x37, 0x37],
            '0123456789abcdefghi', 'xs8a0azh2avyalyzuwd', 36)
