# Generated by 'python3 -m parameter_persistence.generate_models'

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Field


class WebBridgeParameters(BaseModel):
    address: Optional[str] = Field(
        None, description="The host address to bind the WebSocket server to"
    )
    asset_uri_allowlist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    best_effort_qos_send_buffer_limit: Optional[int] = Field(
        None,
        description="Connection send buffer limit in bytes for 'best_effort' messages",
    )
    best_effort_qos_topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) for topics that should be forced to use 'best_effort' QoS. Unmatched topics will use 'reliable' QoS if ALL publishers are 'reliable', 'best_effort' if any publishers are 'best_effort'.",
    )
    capabilities: Optional[List[str]] = Field(None, description="Server capabilities")
    certfile: Optional[str] = Field(None, description="Path to the certificate to use for TLS")
    client_topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    disable_load_message: Optional[bool] = Field(
        None,
        description="Do not publish as loaned message when publishing a client message",
    )
    include_hidden: Optional[bool] = Field(None, description="Include hidden topics and services")
    keyfile: Optional[str] = Field(None, description="Path to the private key to use for TLS")
    max_qos_depth: Optional[int] = Field(
        None, description="Maximum depth used for the QoS profile of subscriptions."
    )
    min_qos_depth: Optional[int] = Field(
        None, description="Minimum depth used for the QoS profile of subscriptions."
    )
    param_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    port: Optional[int] = Field(None, description="The TCP port to bind the WebSocket server to")
    send_buffer_limit: Optional[int] = Field(
        None,
        description="Connection send buffer limit in bytes. Messages will be dropped when a connection's send buffer reaches this limit to avoid a queue of outdated messages building up.",
    )
    service_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted service names.",
    )
    tls: Optional[bool] = Field(
        None, description="Use Transport Layer Security for encrypted communication"
    )
    topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted topic names.",
    )
    use_compression: Optional[bool] = Field(
        None,
        description="Use websocket compression (permessage-deflate). Suited for connections with smaller bandwidth, at the cost of additional CPU load.",
    )


class Track(BaseModel):
    stale_timeout: Optional[float] = Field(
        None,
        description="Time in seconds before a track is considered stale and removed",
    )
    spawn_radius: Optional[float] = Field(
        None, description="Radius in meters around the vessel to spawn tracks"
    )
    sources_enabled: Optional[List[str]] = Field(
        None, description="The sources of tracks that will spawn vessels in MIS-SIM"
    )


class OceanDrift(BaseModel):
    speed: Optional[float] = Field(None, description="in m/s")
    direction: Optional[float] = Field(None, description="degrees clockwise from north")
    period: Optional[float] = Field(None, description="in seconds")
    period_amplitude: Optional[float] = Field(None, description="in m/s")


class VesselManagerParameters(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether to enable the vessel manager or not"
    )
    vessels: Optional[str] = Field(None, description="List of vessels")
    hifi_mode: Optional[bool] = Field(
        None, description="Should we use the low-fidelity topic suffix"
    )
    objects_publish_rate: Optional[float] = Field(
        None, description="Rate at which to publish objects in Hz"
    )
    track: Optional[Track] = None
    ocean_drift: Optional[OceanDrift] = None


class DiagnosticUpdater(BaseModel):
    period: Optional[float] = Field(None, description="")
    use_fqn: Optional[bool] = Field(None, description="")


class Storage(BaseModel):
    directory: Optional[str] = Field(None, description="Directory containing recording bag files.")


class UploadQueue(BaseModel):
    size: Optional[int] = Field(None, description="Max number of items in the upload queue.")


class Config(BaseModel):
    access_key_id: Optional[str] = Field(None, description="AWS access key ID")
    secret_access_key: Optional[str] = Field(None, description="AWS secret access key")
    region: Optional[str] = Field(None, description="AWS region")
    endpoint: Optional[str] = Field(None, description="AWS S3 endpoint URL")


class AwsS3(BaseModel):
    config: Optional[Config] = Field(
        None,
        description="JSON schema used to configure and authenticate the remote destination.",
    )


class Config1(BaseModel):
    sas_url: Optional[str] = Field(None, description="Access URL including SAS token")


class AzureBlob(BaseModel):
    config: Optional[Config1] = Field(
        None,
        description="JSON schema used to configure and authenticate the remote destination.",
    )


class Config2(BaseModel):
    account: Optional[str] = Field(None, description="OneDrive account name")
    client_id: Optional[str] = Field(None, description="Client ID for OneDrive")
    client_secret: Optional[str] = Field(None, description="Client secret for OneDrive")
    tenant: Optional[str] = Field(None, description="Tenant ID for OneDrive")


class MicrosoftOnedrive(BaseModel):
    config: Optional[Config2] = Field(
        None,
        description="JSON schema used to configure and authenticate the remote destination.",
    )


class Config3(BaseModel):
    host: Optional[str] = Field(None, description="SFTP host")
    user: Optional[str] = Field(None, description="Host username")
    pass_: Optional[str] = Field(None, alias="pass", description="Host password")


class Sftp(BaseModel):
    config: Optional[Config3] = Field(
        None,
        description="JSON schema used to configure and authenticate the remote destination.",
    )


class UploadDestination(BaseModel):
    name: Optional[str] = Field(None, description="Identifying name of the upload destination.")
    type: Optional[Any] = Field(None, description="Type of upload destination")
    upload_path: Optional[str] = Field(
        None, description="Path at the destination to upload files to."
    )
    aws_s3: Optional[AwsS3] = None
    azure_blob: Optional[AzureBlob] = None
    microsoft_onedrive: Optional[MicrosoftOnedrive] = None
    sftp: Optional[Sftp] = None


class DataHubParameters(BaseModel):
    port: Optional[int] = Field(None, description="Port for the HTTP server.")
    storage: Optional[Storage] = None
    upload_queue: Optional[UploadQueue] = None
    upload_destination: Optional[UploadDestination] = None
    diagnostic_updater: Optional[DiagnosticUpdater] = None


class Buffer(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Enables a recording buffer to capture historical data prior to recording requests.",
    )
    size: Optional[int] = Field(None, description="Size (in bytes) of the recording buffer.")


class ResourceMonitor(BaseModel):
    warning_threshold: Optional[float] = Field(
        None, description="Storage usage threshold which triggers warning."
    )
    critical_threshold: Optional[float] = Field(
        None, description="Storage usage threshold which triggers error."
    )


class StateTimer(BaseModel):
    publish_period: Optional[int] = Field(
        None, description="Period (ms) to publish recording state updates."
    )


class Storage1(BaseModel):
    directory: Optional[str] = Field(None, description="Directory where recordings will be saved.")
    plugin_name: Optional[Any] = Field(None, description="Storage plugin to use.")
    plugin_profile: Optional[Any] = Field(
        None,
        description="Storage plugin preset profile to use to determine write speed and compression ratio. Only used for mcap storage plugin.",
    )


class Topics(BaseModel):
    exclude_regexs: Optional[List[str]] = Field(
        None,
        description="An array of regex patterns to use for topic EXCLUSION from the recording.",
    )
    include_regexs: Optional[List[str]] = Field(
        None,
        description="An array of regex patterns to use for topic INCLUSION in the recording.",
    )


class TriggerTopic(BaseModel):
    enabled: Optional[bool] = Field(
        None,
        description="Enables a trigger topic that can be used to start/stop recordings (example_interfaces/Bool).",
    )


class DataRecorderParameters(BaseModel):
    buffer: Optional[Buffer] = None
    diagnostic_updater: Optional[DiagnosticUpdater] = None
    resource_monitor: Optional[ResourceMonitor] = None
    state_timer: Optional[StateTimer] = None
    storage: Optional[Storage1] = None
    topics: Optional[Topics] = None
    trigger_topic: Optional[TriggerTopic] = None


class StateTimer1(BaseModel):
    publish_period: Optional[int] = Field(
        None, description="Period (ms) to publish playback state updates."
    )


class Storage2(BaseModel):
    directory: Optional[str] = Field(None, description="Directory to play recordings from.")
    plugin_name: Optional[Any] = Field(None, description="Storage plugin to use.")


class DataPlayerParameters(BaseModel):
    diagnostic_updater: Optional[DiagnosticUpdater] = None
    state_timer: Optional[StateTimer1] = None
    storage: Optional[Storage2] = None


class SimulatedClockParameters(BaseModel):
    enabled: Optional[bool] = Field(
        None, description="Whether to enable the simulated clock or not"
    )
    sim_speed: Optional[float] = Field(None, description="Speed at which to run the simulation")
    publish_rate: Optional[float] = Field(
        None, description="Rate at which to publish the clock at?"
    )


class HifiVesselManagerParameters(BaseModel):
    replay_mode: Optional[bool] = Field(None, description="Is the node in replay mode?")


class ScenarioRunnerParameters(BaseModel):
    scenarios: Optional[List[str]] = Field(None, description="List of scenarios")


class NodeConfigurationModel(BaseModel):
    node_name_regex: str = Field(..., title="Node Name Regex")
    parameter_name_regexes: List[str] = Field(..., title="Parameter Name Regexes")


class ParameterPersistenceParameters(BaseModel):
    params_path: Optional[str] = Field(
        None, description="Path to the file where the parameters are stored"
    )
    file_header: Optional[str] = Field(
        None, description="A message to add to the top of the params file"
    )
    path_within_file: Optional[str] = Field(
        None, description="Path within the file to store the parameters"
    )
    persistent_parameters: Optional[List[NodeConfigurationModel]] = Field(
        None, description="Regex describing which parameters should persist"
    )
    ignore_namespace: Optional[str] = Field(
        None,
        description="Which (if any) part of the node namespace to ignore. Treated as regex.",
    )


class Bow(BaseModel):
    contains: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class Analyzers(BaseModel):
    bow: Optional[Bow] = None


class Cameras(BaseModel):
    analyzers: Optional[Analyzers] = None
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class Recorder(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class RoiDetector(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class RoiTracker(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class VesselComputer1(BaseModel):
    path: Optional[str] = Field(None, description="")
    startswith: Optional[List[str]] = Field(None, description="")
    timeout: Optional[float] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class Analyzers1(BaseModel):
    vessel_computer: Optional[VesselComputer1] = None


class VesselComputer(BaseModel):
    analyzers: Optional[Analyzers1] = None
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class DiagnosticAggregatorParameters(BaseModel):
    cameras: Optional[Cameras] = None
    path: Optional[str] = Field(None, description="")
    publish_values: Optional[bool] = Field(None, description="")
    recorder: Optional[Recorder] = None
    roi_detector: Optional[RoiDetector] = None
    roi_tracker: Optional[RoiTracker] = None
    vessel_computer: Optional[VesselComputer] = None


class RoiTrackerParameters(BaseModel):
    detection_threshold: Optional[float] = Field(
        None, description="Detections above this threshold will be tracked"
    )
    iou_threshold: Optional[float] = Field(
        None, description="Iou association threshold for dets to tracks"
    )
    secondary_assoc_threshold: Optional[float] = Field(
        None, description="Secondary association threshold for dets to tracks"
    )
    secondary_assoc_method: Optional[str] = Field(None, description="Secondary association method")
    max_age: Optional[int] = Field(
        None,
        description="Maximum number of consecutive misses before the track is deleted",
    )
    min_hits: Optional[int] = Field(None, description="Min number of detections to create track")
    classification_history_window: Optional[int] = Field(
        None,
        description="Numbers of frames to keep classification history (used for class/probability temporal smoothing)",
    )
    reset_on_old_time: Optional[bool] = Field(
        None, description="Reset the tracker if an old timestamp is received"
    )
    roi_topics: Optional[List[str]] = Field(
        None, description="REQUIRES RESTART. List of topics to subscribe to for ROIs"
    )
    roi_track_topics: Optional[List[str]] = Field(
        None, description="REQUIRES RESTART. List of topics to publish tracked ROIs"
    )
    diagnostic_updater: Optional[DiagnosticUpdater] = None


class CoreUsageAverageERROR(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class CoreUsageAverageWARN(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class CPU(BaseModel):
    Core_Usage_Average_ERROR: Optional[CoreUsageAverageERROR] = Field(
        None, alias="Core Usage Average ERROR"
    )
    Core_Usage_Average_WARN: Optional[CoreUsageAverageWARN] = Field(
        None, alias="Core Usage Average WARN"
    )


class FieldUsedPercentERROR(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class FieldUsedPercentWARN(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class Disk(BaseModel):
    field__Used_Percent_ERROR: Optional[FieldUsedPercentERROR] = Field(
        None, alias="/ Used Percent ERROR"
    )
    field__Used_Percent_WARN: Optional[FieldUsedPercentWARN] = Field(
        None, alias="/ Used Percent WARN"
    )


class UsagePercentERROR(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class UsagePercentWARN(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class RAM(BaseModel):
    Usage_Percent_ERROR: Optional[UsagePercentERROR] = Field(None, alias="Usage Percent ERROR")
    Usage_Percent_WARN: Optional[UsagePercentWARN] = Field(None, alias="Usage Percent WARN")


class DiagnosticUpdater4(BaseModel):
    CPU: Optional[CPU] = None
    Disk: Optional[Disk] = None
    RAM: Optional[RAM] = None
    period: Optional[float] = Field(None, description="")
    use_fqn: Optional[bool] = Field(None, description="")


class SystemResourceMonitorParameters(BaseModel):
    calculation_rate: Optional[float] = Field(None, description="")
    diagnostic_updater: Optional[DiagnosticUpdater4] = None
    diagnostics: Optional[bool] = Field(None, description="")
    diagnostics_log: Optional[bool] = Field(None, description="")
    disk_directories: Optional[List[str]] = Field(None, description="")
    publish: Optional[bool] = Field(None, description="")
    publish_individual_cores: Optional[bool] = Field(None, description="")
    publish_rate: Optional[float] = Field(None, description="")


class GeolocationParameters(BaseModel):
    publish_horizon_rate: Optional[float] = Field(None, description="")
    use_geopose: Optional[bool] = Field(None, description="")
    max_time_diff: Optional[float] = Field(None, description="")
    frame_id_base_link: Optional[str] = Field(None, description="")
    horizon_padding: Optional[int] = Field(None, description="")
    use_geopose_altitude: Optional[bool] = Field(None, description="")
    camera_info_topics: Optional[List[str]] = Field(
        None, description="List of camera info topics to use for geolocation"
    )
    horizon_marker_topics: Optional[List[str]] = Field(
        None, description="List of horizon marker topics to use for geolocation"
    )


class StubRoiPublisherParameters(BaseModel):
    rate: Optional[float] = Field(None, description="Rate of detection (per second)")


class Camera(BaseModel):
    name: Optional[str] = Field(None, description="The name of the camera")
    order: Optional[int] = Field(None, description="The order of the camera")
    type: Optional[str] = Field(None, description="The camera type")


class Crop(BaseModel):
    top: Optional[int] = Field(
        None, description="Number of pixels to crop from the top of the video stream"
    )
    left: Optional[int] = Field(
        None, description="Number of pixels to crop from the left of the video stream"
    )
    bottom: Optional[int] = Field(
        None, description="Number of pixels to crop from the bottom of the video stream"
    )
    right: Optional[int] = Field(
        None, description="Number of pixels to crop from the right of the video stream"
    )


class Rtsp(BaseModel):
    username: Optional[str] = Field(None, description="RTSP Camera username")
    password: Optional[str] = Field(None, description="RTSP Camera password")
    ip_address: Optional[str] = Field(None, description="RTSP Camera IP address")
    port: Optional[int] = Field(None, description="RTSP Camera port")
    stream: Optional[str] = Field(None, description="RTSP Camera stream")
    reference_meta_timestamp: Optional[bool] = Field(
        None,
        description="Enable reference meta timestamp for RTSP stream so that topic is published with the camera timestamp",
    )


class Test(BaseModel):
    pattern: Optional[str] = Field(None, description="Test pattern for videotestsrc")


class Pipeline(BaseModel):
    name: Optional[str] = Field(
        None, description="Node name of main stream for this pipeline to stream from"
    )


class V4l2(BaseModel):
    device: Optional[str] = Field(None, description="V4L2 device path")


class Genicam(BaseModel):
    camera_name: Optional[str] = Field(None, description="GenICam camera name")
    auto_exposure: Optional[bool] = Field(None, description="Enable camera auto exposure")
    auto_gain: Optional[bool] = Field(None, description="Enable camera auto gain")


class RosDds(BaseModel):
    topic: Optional[str] = Field(None, description="Incoming topic for camera stream")


class Custom(BaseModel):
    pipeline: Optional[str] = Field(None, description="Custom camera pipeline")


class Webrtc(BaseModel):
    peer_id: Optional[str] = Field(None, description="Peer ID for WebRTC source")


class SignallingServer(BaseModel):
    host: Optional[str] = Field(None, description="Signalling server host IP")
    port: Optional[int] = Field(None, description="Signalling server port")


class Ue(BaseModel):
    signalling_server: Optional[SignallingServer] = None
    streamer_id: Optional[str] = Field(None, description="Camera ID for the UE Streamer")


class Source(BaseModel):
    type: Optional[str] = Field(None, description="The type of stream source")
    framerate: Optional[int] = Field(
        None, description="Framerate for video stream to scale to (FPS)"
    )
    pixel_height: Optional[int] = Field(
        None, description="Pixel height of scaled video resolution"
    )
    pixel_width: Optional[int] = Field(None, description="Pixel width of scaled video resolution")
    format: Optional[str] = Field(None, description="Format of video stream")
    crop: Optional[Crop] = None
    rtsp: Optional[Rtsp] = None
    test: Optional[Test] = None
    pipeline: Optional[Pipeline] = None
    v4l2: Optional[V4l2] = None
    genicam: Optional[Genicam] = None
    ros_dds: Optional[RosDds] = None
    custom: Optional[Custom] = None
    webrtc: Optional[Webrtc] = None
    ue: Optional[Ue] = None


class Undistort(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable image undistortion")
    k_intrinsic: Optional[List[float]] = Field(None, description="Camera intrinsic matrix")
    distortion_parameters: Optional[List[float]] = Field(
        None, description="Camera distortion parameters"
    )


class SignallingServer1(BaseModel):
    protocol: Optional[str] = Field(None, description="Signalling server protocol. 'ws' or 'wss'")
    host: Optional[str] = Field(None, description="Signalling server host IP")
    port: Optional[int] = Field(None, description="Signalling server port")


class VeryLow(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Very Low Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Very Low Quality max bitrate (bits/s)")


class Low(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Low Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Low Quality max bitrate (bits/s)")


class Medium(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Medium Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Medium Quality max bitrate (bits/s)")


class High(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="High Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="High Quality max bitrate (bits/s)")


class VeryHigh(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Very High Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Very High Quality max bitrate (bits/s)")


class Quality(BaseModel):
    level: Optional[str] = Field(None, description="Quality level for WebRTC publishing")
    very_low: Optional[VeryLow] = None
    low: Optional[Low] = None
    medium: Optional[Medium] = None
    high: Optional[High] = None
    very_high: Optional[VeryHigh] = None


class Webrtc1(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable WebRTC publishing")
    signalling_server: Optional[SignallingServer1] = None
    congestion_control: Optional[str] = Field(None, description="WebRTC congestion control mode")
    quality: Optional[Quality] = None


class Topic(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable image topic publishing")
    name: Optional[str] = Field(None, description="Name of image topic")
    throttle_time: Optional[float] = Field(
        None,
        description="Time kept between rendered buffers for the ROS topic in seconds",
    )
    frame_id: Optional[str] = Field(None, description="Camera frame ID of image stream")


class Publish(BaseModel):
    webrtc: Optional[Webrtc1] = None
    topic: Optional[Topic] = None


class DiagnosticUpdater5(BaseModel):
    period: Optional[float] = Field(None, description="")
    use_fqn: Optional[bool] = Field(None, description="")


class PipelineBowColorParameters(BaseModel):
    namespace_vessel_application: Optional[str] = Field(
        None,
        description="The namespace of the vessel and application, separated by '/'",
    )
    recreate_pipeline_on_eos: Optional[bool] = Field(
        None, description="Enable pipeline recreation on EOS"
    )
    latency_tracer: Optional[bool] = Field(None, description="Enable latency tracer")
    debug_plugins: Optional[List[str]] = Field(
        None, description="List of plugins to enable debug logging for"
    )
    camera: Optional[Camera] = None
    source: Optional[Source] = None
    undistort: Optional[Undistort] = None
    publish: Optional[Publish] = None
    diagnostic_updater: Optional[DiagnosticUpdater5] = None


class GstRosimagesinkBowColorParameters(BaseModel):
    pass


class LookoutConfigManagerParameters(BaseModel):
    launch_package: Optional[str] = Field(None, description="")
    launch_executable: Optional[str] = Field(None, description="")


class LookoutGreenstreamBringupParameters(BaseModel):
    launch_package: Optional[str] = Field(None, description="")
    launch_executable: Optional[str] = Field(None, description="")


class LaunchParameters(BaseModel):
    web_bridge: Optional[WebBridgeParameters] = None
    vessel_manager: Optional[VesselManagerParameters] = None
    data_player: Optional[DataPlayerParameters] = None
    data_recorder: Optional[DataRecorderParameters] = None
    data_hub: Optional[DataHubParameters] = None
    simulated_clock: Optional[SimulatedClockParameters] = None
    hifi_vessel_manager: Optional[HifiVesselManagerParameters] = None
    scenario_runner: Optional[ScenarioRunnerParameters] = None
    parameter_persistence: Optional[ParameterPersistenceParameters] = None
    diagnostic_aggregator: Optional[DiagnosticAggregatorParameters] = None
    roi_tracker: Optional[RoiTrackerParameters] = None
    system_resource_monitor: Optional[SystemResourceMonitorParameters] = None
    geolocation: Optional[GeolocationParameters] = None
    stub_roi_publisher: Optional[StubRoiPublisherParameters] = None
    pipeline_bow_color: Optional[PipelineBowColorParameters] = None
    gst_rosimagesink_bow_color: Optional[GstRosimagesinkBowColorParameters] = None
    lookout_config_manager: Optional[LookoutConfigManagerParameters] = None
    lookout_greenstream_bringup: Optional[LookoutGreenstreamBringupParameters] = None
