# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamsResult',
    'AwaitableGetStreamsResult',
    'get_streams',
    'get_streams_output',
]

@pulumi.output_type
class GetStreamsResult:
    """
    A collection of values returned by getStreams.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, stream_pool_id=None, streams=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_pool_id and not isinstance(stream_pool_id, str):
            raise TypeError("Expected argument 'stream_pool_id' to be a str")
        pulumi.set(__self__, "stream_pool_id", stream_pool_id)
        if streams and not isinstance(streams, list):
            raise TypeError("Expected argument 'streams' to be a list")
        pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the stream.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> Optional[str]:
        """
        The OCID of the stream pool that contains the stream.
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter
    def streams(self) -> Sequence['outputs.GetStreamsStreamResult']:
        """
        The list of streams.
        """
        return pulumi.get(self, "streams")


class AwaitableGetStreamsResult(GetStreamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            stream_pool_id=self.stream_pool_id,
            streams=self.streams)


def get_streams(compartment_id: Optional[str] = None,
                filters: Optional[Sequence[pulumi.InputType['GetStreamsFilterArgs']]] = None,
                id: Optional[str] = None,
                name: Optional[str] = None,
                state: Optional[str] = None,
                stream_pool_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamsResult:
    """
    This data source provides the list of Streams in Oracle Cloud Infrastructure Streaming service.

    Lists the streams in the given compartment id.
    If the compartment id is specified, it will list streams in the compartment, regardless of their stream pool.
    If the stream pool id is specified, the action will be scoped to that stream pool.
    The compartment id and stream pool id cannot be specified at the same time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_streams = oci.Streaming.get_streams(compartment_id=compartment_id,
        id=stream_id,
        name=stream_name,
        state=stream_state,
        stream_pool_id=test_stream_pool["id"])
    ```


    :param str compartment_id: The OCID of the compartment. Is exclusive with the `streamPoolId` parameter. One of them is required.
    :param str id: A filter to return only resources that match the given ID exactly.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param str stream_pool_id: The OCID of the stream pool. Is exclusive with the `compartmentId` parameter. One of them is required.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    __args__['streamPoolId'] = stream_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getStreams:getStreams', __args__, opts=opts, typ=GetStreamsResult).value

    return AwaitableGetStreamsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        stream_pool_id=pulumi.get(__ret__, 'stream_pool_id'),
        streams=pulumi.get(__ret__, 'streams'))


@_utilities.lift_output_func(get_streams)
def get_streams_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetStreamsFilterArgs']]]]] = None,
                       id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       state: Optional[pulumi.Input[Optional[str]]] = None,
                       stream_pool_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamsResult]:
    """
    This data source provides the list of Streams in Oracle Cloud Infrastructure Streaming service.

    Lists the streams in the given compartment id.
    If the compartment id is specified, it will list streams in the compartment, regardless of their stream pool.
    If the stream pool id is specified, the action will be scoped to that stream pool.
    The compartment id and stream pool id cannot be specified at the same time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_streams = oci.Streaming.get_streams(compartment_id=compartment_id,
        id=stream_id,
        name=stream_name,
        state=stream_state,
        stream_pool_id=test_stream_pool["id"])
    ```


    :param str compartment_id: The OCID of the compartment. Is exclusive with the `streamPoolId` parameter. One of them is required.
    :param str id: A filter to return only resources that match the given ID exactly.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param str stream_pool_id: The OCID of the stream pool. Is exclusive with the `compartmentId` parameter. One of them is required.
    """
    ...
