# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TlsMutualAuthenticationArgs', 'TlsMutualAuthentication']

@pulumi.input_type
class TlsMutualAuthenticationArgs:
    def __init__(__self__, *,
                 cert_bundle: pulumi.Input[str],
                 enforced: Optional[pulumi.Input[bool]] = None,
                 include: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TlsMutualAuthentication resource.
        :param pulumi.Input[str] cert_bundle: One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        :param pulumi.Input[bool] enforced: Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        :param pulumi.Input[str] include: Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        :param pulumi.Input[str] name: A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        """
        pulumi.set(__self__, "cert_bundle", cert_bundle)
        if enforced is not None:
            pulumi.set(__self__, "enforced", enforced)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="certBundle")
    def cert_bundle(self) -> pulumi.Input[str]:
        """
        One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        """
        return pulumi.get(self, "cert_bundle")

    @cert_bundle.setter
    def cert_bundle(self, value: pulumi.Input[str]):
        pulumi.set(self, "cert_bundle", value)

    @property
    @pulumi.getter
    def enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        """
        return pulumi.get(self, "enforced")

    @enforced.setter
    def enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforced", value)

    @property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "include", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TlsMutualAuthenticationState:
    def __init__(__self__, *,
                 cert_bundle: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 enforced: Optional[pulumi.Input[bool]] = None,
                 include: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tls_activations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TlsMutualAuthentication resources.
        :param pulumi.Input[str] cert_bundle: One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        :param pulumi.Input[str] created_at: Date and time in ISO 8601 format.
        :param pulumi.Input[bool] enforced: Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        :param pulumi.Input[str] include: Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        :param pulumi.Input[str] name: A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tls_activations: List of alphanumeric strings identifying TLS activations.
        :param pulumi.Input[str] updated_at: Date and time in ISO 8601 format.
        """
        if cert_bundle is not None:
            pulumi.set(__self__, "cert_bundle", cert_bundle)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enforced is not None:
            pulumi.set(__self__, "enforced", enforced)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tls_activations is not None:
            pulumi.set(__self__, "tls_activations", tls_activations)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="certBundle")
    def cert_bundle(self) -> Optional[pulumi.Input[str]]:
        """
        One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        """
        return pulumi.get(self, "cert_bundle")

    @cert_bundle.setter
    def cert_bundle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_bundle", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        """
        return pulumi.get(self, "enforced")

    @enforced.setter
    def enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforced", value)

    @property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "include", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tlsActivations")
    def tls_activations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alphanumeric strings identifying TLS activations.
        """
        return pulumi.get(self, "tls_activations")

    @tls_activations.setter
    def tls_activations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tls_activations", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class TlsMutualAuthentication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_bundle: Optional[pulumi.Input[str]] = None,
                 enforced: Optional[pulumi.Input[bool]] = None,
                 include: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a TlsMutualAuthentication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cert_bundle: One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        :param pulumi.Input[bool] enforced: Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        :param pulumi.Input[str] include: Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        :param pulumi.Input[str] name: A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsMutualAuthenticationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a TlsMutualAuthentication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TlsMutualAuthenticationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsMutualAuthenticationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_bundle: Optional[pulumi.Input[str]] = None,
                 enforced: Optional[pulumi.Input[bool]] = None,
                 include: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsMutualAuthenticationArgs.__new__(TlsMutualAuthenticationArgs)

            if cert_bundle is None and not opts.urn:
                raise TypeError("Missing required property 'cert_bundle'")
            __props__.__dict__["cert_bundle"] = cert_bundle
            __props__.__dict__["enforced"] = enforced
            __props__.__dict__["include"] = include
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["tls_activations"] = None
            __props__.__dict__["updated_at"] = None
        super(TlsMutualAuthentication, __self__).__init__(
            'fastly:index/tlsMutualAuthentication:TlsMutualAuthentication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert_bundle: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            enforced: Optional[pulumi.Input[bool]] = None,
            include: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tls_activations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'TlsMutualAuthentication':
        """
        Get an existing TlsMutualAuthentication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cert_bundle: One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        :param pulumi.Input[str] created_at: Date and time in ISO 8601 format.
        :param pulumi.Input[bool] enforced: Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        :param pulumi.Input[str] include: Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        :param pulumi.Input[str] name: A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tls_activations: List of alphanumeric strings identifying TLS activations.
        :param pulumi.Input[str] updated_at: Date and time in ISO 8601 format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsMutualAuthenticationState.__new__(_TlsMutualAuthenticationState)

        __props__.__dict__["cert_bundle"] = cert_bundle
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enforced"] = enforced
        __props__.__dict__["include"] = include
        __props__.__dict__["name"] = name
        __props__.__dict__["tls_activations"] = tls_activations
        __props__.__dict__["updated_at"] = updated_at
        return TlsMutualAuthentication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certBundle")
    def cert_bundle(self) -> pulumi.Output[str]:
        """
        One or more certificates. Enter each individual certificate blob on a new line. Must be PEM-formatted.
        """
        return pulumi.get(self, "cert_bundle")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def enforced(self) -> pulumi.Output[bool]:
        """
        Determines whether Mutual TLS will fail closed (enforced) or fail open. A true value will require a successful Mutual TLS handshake for the connection to continue and will fail closed if unsuccessful. A false value will fail open and allow the connection to proceed (if this attribute is not set we default to `false`).
        """
        return pulumi.get(self, "enforced")

    @property
    @pulumi.getter
    def include(self) -> pulumi.Output[Optional[str]]:
        """
        Comma-separated list of related objects to include (e.g. `tls_activations` will provide you with the TLS domain names that are related to your Mutual TLS authentication).
        """
        return pulumi.get(self, "include")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A custom name for your mutual authentication. If name is not supplied we will auto-generate one.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tlsActivations")
    def tls_activations(self) -> pulumi.Output[Sequence[str]]:
        """
        List of alphanumeric strings identifying TLS activations.
        """
        return pulumi.get(self, "tls_activations")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Date and time in ISO 8601 format.
        """
        return pulumi.get(self, "updated_at")

