
# Androguard is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Androguard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Androguard.  If not, see <http://www.gnu.org/licenses/>.

# frameworks/base/core/res/AndroidManifest.xml

# This list is also updated periodically with scripts/update_android_permissions.py
# ######################################### PERMISSIONS ###################
# flake8: noqa
DVM_PERMISSIONS = {
    'MANIFEST_PERMISSION': {
        'SEND_SMS': ['dangerous', 'send SMS messages', 'Allows application to send SMS messages. Malicious applications may cost you money by sending messages without your confirmation.'],
        'SEND_SMS_NO_CONFIRMATION': ['dangerous', 'send SMS messages', 'send SMS messages via the Messaging app with no user input or confirmation.'],
        'CALL_PHONE': ['dangerous', 'directly call phone numbers', 'Allows the application to call phone numbers without your intervention. Malicious applications may cause unexpected calls on your phone bill. Note that this does not allow the application to call emergency numbers.'],
        'RECEIVE_SMS': ['dangerous', 'receive SMS', 'Allows application to receive and process SMS messages. Malicious applications may monitor your messages or delete them without showing them to you.'],
        'RECEIVE_MMS': ['dangerous', 'receive MMS', 'Allows application to receive and process MMS messages. Malicious applications may monitor your messages or delete them without showing them to you.'],
        'READ_SMS': ['dangerous', 'read SMS or MMS', 'Allows application to read SMS messages stored on your phone or SIM card. Malicious applications may read your confidential messages.'],
        'WRITE_SMS': ['dangerous', 'edit SMS or MMS', 'Allows application to write to SMS messages stored on your phone or SIM card. Malicious applications may delete your messages.'],
        'RECEIVE_WAP_PUSH': ['dangerous', 'receive WAP', 'Allows application to receive and process WAP messages. Malicious applications may monitor your messages or delete them without showing them to you.'],
        'READ_CONTACTS': ['dangerous', 'read contact data', 'Allows an application to read all of the contact (address) data stored on your phone. Malicious applications can use this to send your data to other people.'],
        'WRITE_CONTACTS': ['dangerous', 'write contact data', 'Allows an application to modify the contact (address) data stored on your phone. Malicious applications can use this to erase or modify your contact data.'],
        'READ_PROFILE': ['dangerous', 'read the user\'s personal profile data', 'Allows an application to read the user\'s personal profile data.'],
        'WRITE_PROFILE': ['dangerous', 'write the user\'s personal profile data', 'Allows an application to write (but not read) the user\'s personal profile data.'],
        'READ_SOCIAL_STREAM': ['dangerous', 'read from the user\'s social stream', 'Allows an application to read from the user\'s social stream.'],
        'WRITE_SOCIAL_STREAM': ['dangerous', 'write the user\'s social stream', 'Allows an application to write (but not read) the user\'s social stream data.'],
        'READ_CALENDAR': ['dangerous', 'read calendar events', 'Allows an application to read all of the calendar events stored on your phone. Malicious applications can use this to send your calendar events to other people.'],
        'WRITE_CALENDAR': ['dangerous', 'add or modify calendar events and send emails to guests', 'Allows an application to add or change the events on your calendar, which may send emails to guests. Malicious applications can use this to erase or modify your calendar events or to send emails to guests.'],
        'READ_USER_DICTIONARY': ['dangerous', 'read user-defined dictionary', 'Allows an application to read any private words, names and phrases that the user may have stored in the user dictionary.'],
        'WRITE_USER_DICTIONARY': ['normal', 'write to user-defined dictionary', 'Allows an application to write new words into the user dictionary.'],
        'READ_HISTORY_BOOKMARKS': ['dangerous', 'read Browser\'s history and bookmarks', 'Allows the application to read all the URLs that the browser has visited and all of the browser\'s bookmarks.'],
        'WRITE_HISTORY_BOOKMARKS': ['dangerous', 'write Browser\'s history and bookmarks', 'Allows an application to modify the browser\'s history or bookmarks stored on your phone. Malicious applications can use this to erase or modify your browser\'s data.'],
        'SET_ALARM': ['normal', 'set alarm in alarm clock', 'Allows the application to set an alarm in an installed alarm clock application. Some alarm clock applications may not implement this feature.'],
        'ACCESS_FINE_LOCATION': ['dangerous', 'fine (GPS) location', 'Access fine location sources, such as the Global Positioning System on the phone, where available. Malicious applications can use this to determine where you are and may consume additional battery power.'],
        'ACCESS_COARSE_LOCATION': ['dangerous', 'coarse (network-based) location', 'Access coarse location sources, such as the mobile network database, to determine an approximate phone location, where available. Malicious applications can use this to determine approximately where you are.'],
        'ACCESS_MOCK_LOCATION': ['dangerous', 'mock location sources for testing', 'Create mock location sources for testing. Malicious applications can use this to override the location and/or status returned by real-location sources such as GPS or Network providers.'],
        'ACCESS_LOCATION_EXTRA_COMMANDS': ['normal', 'access extra location provider commands', 'Access extra location provider commands. Malicious applications could use this to interfere with the operation of the GPS or other location sources.'],
        'INSTALL_LOCATION_PROVIDER': ['signatureOrSystem', 'permission to install a location provider', 'Create mock location sources for testing. Malicious applications can use this to override the location and/or status returned by real-location sources such as GPS or Network providers, or monitor and report your location to an external source.'],
        'INTERNET': ['normal', 'full Internet access', 'Allows an application to create network sockets.'],
        'ACCESS_NETWORK_STATE': ['normal', 'view network status', 'Allows an application to view the status of all networks.'],
        'ACCESS_WIFI_STATE': ['normal', 'view Wi-Fi status', 'Allows an application to view the information about the status of Wi-Fi.'],
        'BLUETOOTH': ['normal', 'create Bluetooth connections', 'Allows applications to connect to paired bluetooth devices.'],
        'NFC': ['normal', 'control Near-Field Communication', 'Allows an application to communicate with Near-Field Communication (NFC) tags, cards and readers.'],
        'USE_SIP': ['dangerous', 'make/receive Internet calls', 'Allows an application to use the SIP service to make/receive Internet calls.'],
        'ACCOUNT_MANAGER': ['signature', 'act as the Account Manager Service', 'Allows an application to make calls to Account Authenticators.'],
        'GET_ACCOUNTS': ['dangerous', 'list accounts', 'Allows access to the list of accounts in the Accounts Service.'],
        'AUTHENTICATE_ACCOUNTS': ['dangerous', 'act as an account authenticator', 'Allows an application to use the account authenticator capabilities of the Account Manager, including creating accounts as well as obtaining and setting their passwords.'],
        'USE_CREDENTIALS': ['dangerous', 'use the authentication credentials of an account', 'Allows an application to request authentication tokens.'],
        'MANAGE_ACCOUNTS': ['dangerous', 'manage the accounts list', 'Allows an application to perform operations like adding and removing accounts and deleting their password.'],
        'MODIFY_AUDIO_SETTINGS': ['normal', 'change your audio settings', 'Allows application to modify global audio settings, such as volume and routing.'],
        'RECORD_AUDIO': ['dangerous', 'record audio', 'Allows application to access the audio record path.'],
        'CAMERA': ['dangerous', 'take pictures and videos', 'Allows application to take pictures and videos with the camera. This allows the application to collect images that the camera is seeing at any time.'],
        'VIBRATE': ['normal', 'control vibrator', 'Allows the application to control the vibrator.'],
        'FLASHLIGHT': ['normal', 'control flashlight', 'Allows the application to control the flashlight.'],
        'ACCESS_USB': ['signatureOrSystem', 'access USB devices', 'Allows the application to access USB devices.'],
        'HARDWARE_TEST': ['signature', 'test hardware', 'Allows the application to control various peripherals for the purpose of hardware testing.'],
        'PROCESS_OUTGOING_CALLS': ['dangerous', 'intercept outgoing calls', 'Allows application to process outgoing calls and change the number to be dialled. Malicious applications may monitor, redirect or prevent outgoing calls.'],
        'MODIFY_PHONE_STATE': ['signatureOrSystem', 'modify phone status', 'Allows the application to control the phone features of the device. An application with this permission can switch networks, turn the phone radio on and off and the like, without ever notifying you.'],
        'READ_PHONE_STATE': ['dangerous', 'read phone state and identity', 'Allows the application to access the phone features of the device. An application with this permission can determine the phone number and serial number of this phone, whether a call is active, the number that call is connected to and so on.'],
        'WRITE_EXTERNAL_STORAGE': ['dangerous', 'read/modify/delete external storage contents', 'Allows an application to write to external storage.'],
        'READ_EXTERNAL_STORAGE': ['dangerous', 'read external storage contents', 'Allows an application to read from external storage.'],
        'WRITE_SETTINGS': ['dangerous', 'modify global system settings', 'Allows an application to modify the system\'s settings data. Malicious applications can corrupt your system\'s configuration.'],
        'WRITE_SECURE_SETTINGS': ['signatureOrSystem', 'modify secure system settings', 'Allows an application to modify the system\'s secure settings data. Not for use by common applications.'],
        'WRITE_GSERVICES': ['signatureOrSystem', 'modify the Google services map', 'Allows an application to modify the Google services map. Not for use by common applications.'],
        'EXPAND_STATUS_BAR': ['normal', 'expand/collapse status bar', 'Allows application to expand or collapse the status bar.'],
        'GET_TASKS': ['dangerous', 'retrieve running applications', 'Allows application to retrieve information about currently and recently running tasks. May allow malicious applications to discover private information about other applications.'],
        'REORDER_TASKS': ['normal', 'reorder applications running', 'Allows an application to move tasks to the foreground and background. Malicious applications can force themselves to the front without your control.'],
        'CHANGE_CONFIGURATION': ['signatureOrSystem', 'change your UI settings', 'Allows an application to change the current configuration, such as the locale or overall font size.'],
        'RESTART_PACKAGES': ['normal', 'kill background processes', 'Allows an application to kill background processes of other applications, even if memory is not low.'],
        'KILL_BACKGROUND_PROCESSES': ['normal', 'kill background processes', 'Allows an application to kill background processes of other applications, even if memory is not low.'],
        'FORCE_STOP_PACKAGES': ['signature', 'force-stop other applications', 'Allows an application to stop other applications forcibly.'],
        'DUMP': ['signatureOrSystem', 'retrieve system internal status', 'Allows application to retrieve internal status of the system. Malicious applications may retrieve a wide variety of private and secure information that they should never commonly need.'],
        'SYSTEM_ALERT_WINDOW': ['dangerous', 'display system-level alerts', 'Allows an application to show system-alert windows. Malicious applications can take over the entire screen of the phone.'],
        'SET_ANIMATION_SCALE': ['dangerous', 'modify global animation speed', 'Allows an application to change the global animation speed (faster or slower animations) at any time.'],
        'PERSISTENT_ACTIVITY': ['dangerous', 'make application always run', 'Allows an application to make parts of itself persistent, so that the system can\'t use it for other applications.'],
        'GET_PACKAGE_SIZE': ['normal', 'measure application storage space', 'Allows an application to find out the space used by any package.'],
        'SET_PREFERRED_APPLICATIONS': ['signature', 'set preferred applications', 'Allows an application to modify your preferred applications. This can allow malicious applications to silently change the applications that are run, spoofing your existing applications to collect private data from you.'],
        'RECEIVE_BOOT_COMPLETED': ['normal', 'automatically start at boot', 'Allows an application to start itself as soon as the system has finished booting. This can make it take longer to start the phone and allow the application to slow down the overall phone by always running.'],
        'BROADCAST_STICKY': ['normal', 'send sticky broadcast', 'Allows an application to send sticky broadcasts, which remain after the broadcast ends. Malicious applications can make the phone slow or unstable by causing it to use too much memory.'],
        'WAKE_LOCK': ['normal', 'prevent phone from sleeping', 'Allows an application to prevent the phone from going to sleep.'],
        'SET_WALLPAPER': ['normal', 'set wallpaper', 'Allows the application to set the system wallpaper.'],
        'SET_WALLPAPER_HINTS': ['normal', 'set wallpaper size hints', 'Allows the application to set the system wallpaper size hints.'],
        'SET_TIME': ['signatureOrSystem', 'set time', 'Allows an application to change the phone\'s clock time.'],
        'SET_TIME_ZONE': ['signatureOrSystem', 'set time zone', 'Allows an application to change the phone\'s time zone.'],
        'MOUNT_UNMOUNT_FILESYSTEMS': ['dangerous', 'mount and unmount file systems', 'Allows the application to mount and unmount file systems for removable storage.'],
        'MOUNT_FORMAT_FILESYSTEMS': ['dangerous', 'format external storage', 'Allows the application to format removable storage.'],
        'ASEC_ACCESS': ['signature', 'get information on internal storage', 'Allows the application to get information on internal storage.'],
        'ASEC_CREATE': ['signature', 'create internal storage', 'Allows the application to create internal storage.'],
        'ASEC_DESTROY': ['signature', 'destroy internal storage', 'Allows the application to destroy internal storage.'],
        'ASEC_MOUNT_UNMOUNT': ['signature', 'mount/unmount internal storage', 'Allows the application to mount/unmount internal storage.'],
        'ASEC_RENAME': ['signature', 'rename internal storage', 'Allows the application to rename internal storage.'],
        'DISABLE_KEYGUARD': ['normal', 'disable keyguard', 'Allows applications to disable the keyguard if it is not secure.'],
        'READ_SYNC_SETTINGS': ['normal', 'read sync settings', 'Allows an application to read the sync settings, such as whether sync is enabled for Contacts.'],
        'WRITE_SYNC_SETTINGS': ['normal', 'write sync settings', 'Allows an application to modify the sync settings, such as whether sync is enabled for Contacts.'],
        'READ_SYNC_STATS': ['normal', 'read sync statistics', 'Allows an application to read the sync stats; e.g. the history of syncs that have occurred.'],
        'WRITE_APN_SETTINGS': ['dangerous', 'write Access Point Name settings', 'Allows an application to modify the APN settings, such as Proxy and Port of any APN.'],
        'SUBSCRIBED_FEEDS_READ': ['normal', 'read subscribed feeds', 'Allows an application to receive details about the currently synced feeds.'],
        'SUBSCRIBED_FEEDS_WRITE': ['dangerous', 'write subscribed feeds', 'Allows an application to modify your currently synced feeds. This could allow a malicious application to change your synced feeds.'],
        'CHANGE_NETWORK_STATE': ['normal', 'change network connectivity', 'Allows applications to change network connectivity state.'],
        'CHANGE_WIFI_STATE': ['normal', 'change Wi-Fi status', 'Allows an application to connect to and disconnect from Wi-Fi access points and to make changes to configured Wi-Fi networks.'],
        'CHANGE_WIFI_MULTICAST_STATE': ['normal', 'allow Wi-Fi Multicast reception', 'Allows an application to receive packets not directly addressed to your device. This can be useful when discovering services offered nearby. It uses more power than the non-multicast mode.'],
        'BLUETOOTH_ADMIN': ['normal', 'bluetooth administration', 'Allows applications to discover and pair bluetooth devices.'],
        'CLEAR_APP_CACHE': ['signatureOrSystem', 'delete all application cache data', 'Allows an application to free phone storage by deleting files in application cache directory. Access is usually very restricted to system process.'],
        'READ_LOGS': ['dangerous', 'read sensitive log data', 'Allows an application to read from the system\'s various log files. This allows it to discover general information about what you are doing with the phone, potentially including personal or private information.'],
        'SET_DEBUG_APP': ['dangerous', 'enable application debugging', 'Allows an application to turn on debugging for another application. Malicious applications can use this to kill other applications.'],
        'SET_PROCESS_LIMIT': ['dangerous', 'limit number of running processes', 'Allows an application to control the maximum number of processes that will run. Never needed for common applications.'],
        'SET_ALWAYS_FINISH': ['dangerous', 'make all background applications close', 'Allows an application to control whether activities are always finished as soon as they go to the background. Never needed for common applications.'],
        'SIGNAL_PERSISTENT_PROCESSES': ['dangerous', 'send Linux signals to applications', 'Allows application to request that the supplied signal be sent to all persistent processes.'],
        'DIAGNOSTIC': ['signature', 'read/write to resources owned by diag', 'Allows an application to read and write to any resource owned by the diag group; for example, files in /dev. This could potentially affect system stability and security. This should ONLY be used for hardware-specific diagnostics by the manufacturer or operator.'],
        'STATUS_BAR': ['signatureOrSystem', 'disable or modify status bar', 'Allows application to disable the status bar or add and remove system icons.'],
        'STATUS_BAR_SERVICE': ['signature', 'status bar', 'Allows the application to be the status bar.'],
        'FORCE_BACK': ['signature', 'force application to close', 'Allows an application to force any activity that is in the foreground to close and go back. Should never be needed for common applications.'],
        'UPDATE_DEVICE_STATS': ['signatureOrSystem', 'modify battery statistics', 'Allows the modification of collected battery statistics. Not for use by common applications.'],
        'INTERNAL_SYSTEM_WINDOW': ['signature', 'display unauthorised windows', 'Allows the creation of windows that are intended to be used by the internal system user interface. Not for use by common applications.'],
        'MANAGE_APP_TOKENS': ['signature', 'manage application tokens', 'Allows applications to create and manage their own tokens, bypassing their common Z-ordering. Should never be needed for common applications.'],
        'INJECT_EVENTS': ['signature', 'press keys and control buttons', 'Allows an application to deliver its own input events (key presses, etc.) to other applications. Malicious applications can use this to take over the phone.'],
        'SET_ACTIVITY_WATCHER': ['signature', 'monitor and control all application launching', 'Allows an application to monitor and control how the system launches activities. Malicious applications may compromise the system completely. This permission is needed only for development, never for common phone usage.'],
        'SHUTDOWN': ['signature', 'partial shutdown', 'Puts the activity manager into a shut-down state. Does not perform a complete shut down.'],
        'STOP_APP_SWITCHES': ['signature', 'prevent app switches', 'Prevents the user from switching to another application.'],
        'READ_INPUT_STATE': ['signature', 'record what you type and actions that you take', 'Allows applications to watch the keys that you press even when interacting with another application (such as entering a password). Should never be needed for common applications.'],
        'BIND_INPUT_METHOD': ['signature', 'bind to an input method', 'Allows the holder to bind to the top-level interface of an input method. Should never be needed for common applications.'],
        'BIND_WALLPAPER': ['signatureOrSystem', 'bind to wallpaper', 'Allows the holder to bind to the top-level interface of wallpaper. Should never be needed for common applications.'],
        'BIND_DEVICE_ADMIN': ['signature', 'interact with device admin', 'Allows the holder to send intents to a device administrator. Should never be needed for common applications.'],
        'SET_ORIENTATION': ['signature', 'change screen orientation', 'Allows an application to change the rotation of the screen at any time. Should never be needed for common applications.'],
        'INSTALL_PACKAGES': ['signatureOrSystem', 'directly install applications', 'Allows an application to install new or updated Android packages. Malicious applications can use this to add new applications with arbitrarily powerful permissions.'],
        'REQUEST_INSTALL_PACKAGES': ['dangerous', 'Allows an application to request installing packages.', 'Malicious applications can use this to try and trick users into installing additional malicious packages.'],
        'CLEAR_APP_USER_DATA': ['signature', 'delete other applications\' data', 'Allows an application to clear user data.'],
        'DELETE_CACHE_FILES': ['signatureOrSystem', 'delete other applications\' caches', 'Allows an application to delete cache files.'],
        'DELETE_PACKAGES': ['signatureOrSystem', 'delete applications', 'Allows an application to delete Android packages. Malicious applications can use this to delete important applications.'],
        'MOVE_PACKAGE': ['signatureOrSystem', 'Move application resources', 'Allows an application to move application resources from internal to external media and vice versa.'],
        'CHANGE_COMPONENT_ENABLED_STATE': ['signatureOrSystem', 'enable or disable application components', 'Allows an application to change whether or not a component of another application is enabled. Malicious applications can use this to disable important phone capabilities. It is important to be careful with permission, as it is possible to bring application components into an unusable, inconsistent or unstable state.'],
        'ACCESS_SURFACE_FLINGER': ['signature', 'access SurfaceFlinger', 'Allows application to use SurfaceFlinger low-level features.'],
        'READ_FRAME_BUFFER': ['signature', 'read frame buffer', 'Allows application to read the content of the frame buffer.'],
        'BRICK': ['signature', 'permanently disable phone', 'Allows the application to disable the entire phone permanently. This is very dangerous.'],
        'REBOOT': ['signatureOrSystem', 'force phone reboot', 'Allows the application to force the phone to reboot.'],
        'DEVICE_POWER': ['signature', 'turn phone on or off', 'Allows the application to turn the phone on or off.'],
        'FACTORY_TEST': ['signature', 'run in factory test mode', 'Run as a low-level manufacturer test, allowing complete access to the phone hardware. Only available when a phone is running in manufacturer test mode.'],
        'BROADCAST_PACKAGE_REMOVED': ['signature', 'send package removed broadcast', 'Allows an application to broadcast a notification that an application package has been removed. Malicious applications may use this to kill any other application running.'],
        'BROADCAST_SMS': ['signature', 'send SMS-received broadcast', 'Allows an application to broadcast a notification that an SMS message has been received. Malicious applications may use this to forge incoming SMS messages.'],
        'BROADCAST_WAP_PUSH': ['signature', 'send WAP-PUSH-received broadcast', 'Allows an application to broadcast a notification that a WAP-PUSH message has been received. Malicious applications may use this to forge MMS message receipt or to replace the content of any web page silently with malicious variants.'],
        'MASTER_CLEAR': ['signatureOrSystem', 'reset system to factory defaults', 'Allows an application to completely reset the system to its factory settings, erasing all data, configuration and installed applications.'],
        'CALL_PRIVILEGED': ['signatureOrSystem', 'directly call any phone numbers', 'Allows the application to call any phone number, including emergency numbers, without your intervention. Malicious applications may place unnecessary and illegal calls to emergency services.'],
        'PERFORM_CDMA_PROVISIONING': ['signatureOrSystem', 'directly start CDMA phone setup', 'Allows the application to start CDMA provisioning. Malicious applications may start CDMA provisioning unnecessarily.'],
        'CONTROL_LOCATION_UPDATES': ['signatureOrSystem', 'control location update notifications', 'Allows enabling/disabling location update notifications from the radio. Not for use by common applications.'],
        'ACCESS_CHECKIN_PROPERTIES': ['signatureOrSystem', 'access check-in properties', 'Allows read/write access to properties uploaded by the check-in service. Not for use by common applications.'],
        'PACKAGE_USAGE_STATS': ['signature', 'update component usage statistics', 'Allows the modification of collected component usage statistics. Not for use by common applications.'],
        'BATTERY_STATS': ['signature', 'modify battery statistics', 'Allows the modification of collected battery statistics. Not for use by common applications.'],
        'BACKUP': ['signatureOrSystem', 'control system back up and restore', 'Allows the application to control the system\'s back-up and restore mechanism. Not for use by common applications.'],
        'BIND_APPWIDGET': ['signatureOrSystem', 'choose widgets', 'Allows the application to tell the system which widgets can be used by which application. With this permission, applications can give access to personal data to other applications. Not for use by common applications.'],
        'CHANGE_BACKGROUND_DATA_SETTING': ['signature', 'change background data usage setting', 'Allows an application to change the background data usage setting.'],
        # Short descriptions are generated by ChatGPT, so they may not be accurate.
        'GLOBAL_SEARCH': ['signatureOrSystem', "allows global search system to access a provider's data.", 'This permission can be used on content providers to allow the global search system to access their data. Typically it used when the provider has some permissions protecting it (which global search would not be expected to hold), and added as a read-only permission to the path in the provider where global search queries are performed. This permission can not be held by regular applications; it is used by applications to protect themselves from everyone else besides global search.'],
        'GLOBAL_SEARCH_CONTROL': ['signature', 'permission without a specified role or function.', 'Permission without a specified role or function.'],
        'SET_WALLPAPER_COMPONENT': ['signatureOrSystem', 'allows setting of wallpaper components.', 'Allows setting of wallpaper components.'],
        'ACCESS_CACHE_FILESYSTEM': ['signatureOrSystem', 'access the cache file system', 'Allows an application to read and write the cache file system.'],
        'COPY_PROTECTED_DATA': ['signature', 'Allows to invoke default container service to copy content. Not for use by common applications.', 'Allows to invoke default container service to copy content. Not for use by common applications.'],
        'C2D_MESSAGE': ['signature', 'Allows cloud to device messaging', 'Allows the application to receive push notifications.'],
        'ADD_VOICEMAIL': ['dangerous', 'add voicemails into the system', 'Allows an application to add voicemails into the system.'],
        'ACCEPT_HANDOVER': ['dangerous', 'enables a calling app to continue a call started in another app.', "Allows a calling app to continue a call which was started in another app.  An example is a video calling app that wants to continue a voice call on the user's mobile network."],
        'ACCESS_NOTIFICATION_POLICY': ['normal', 'marker permission for accessing notification policy.', 'Marker permission for applications that wish to access notification policy.'],
        'ANSWER_PHONE_CALLS': ['dangerous', 'permits an app to answer incoming phone calls.', 'Allows the app to answer an incoming phone call.'],
        'BIND_ACCESSIBILITY_SERVICE': ['signature', 'required by AccessibilityServices for system binding.', 'Must be required by an AccessibilityService, to ensure that only the system can bind to it.'],
        'BIND_AUTOFILL_SERVICE': ['signature', 'required by AutofillServices for system binding.', 'Must be required by a AutofillService, to ensure that only the system can bind to it.'],
        'BIND_CARRIER_MESSAGING_SERVICE': ['signature', 'system-level permission for binding to carrier messaging services.', 'The system process that is allowed to bind to services in carrier apps will have this permission.'],
        'BIND_CARRIER_SERVICES': ['signature', 'system-level permission for binding to carrier services.', 'The system process that is allowed to bind to services in carrier apps will have this permission. Carrier apps should use this permission to protect their services that only the system is allowed to bind to.'],
        'BIND_CHOOSER_TARGET_SERVICE': ['signature', 'required by ChooserTargetServices for system binding.', 'Must be required by a ChooserTargetService, to ensure that only the system can bind to it.'],
        'BIND_CONDITION_PROVIDER_SERVICE': ['signature', 'required by ConditionProviderServices for system binding.', 'Must be required by a ConditionProviderService, to ensure that only the system can bind to it.'],
        'BIND_DREAM_SERVICE': ['signature', 'required by DreamServices for system binding.', 'Must be required by an DreamService, to ensure that only the system can bind to it.'],
        'BIND_INCALL_SERVICE': ['signature', 'required by InCallServices for system binding.', 'Must be required by a InCallService, to ensure that only the system can bind to it.'],
        'BIND_MIDI_DEVICE_SERVICE': ['signature', 'required by MidiDeviceServices for system binding.', 'Must be required by an MidiDeviceService, to ensure that only the system can bind to it.'],
        'BIND_NFC_SERVICE': ['signature', 'required for system binding to NFC services.', 'Must be required by a HostApduService or OffHostApduService to ensure that only the system can bind to it.'],
        'BIND_NOTIFICATION_LISTENER_SERVICE': ['signature', 'required by NotificationListenerServices for system binding.', 'Must be required by an NotificationListenerService, to ensure that only the system can bind to it.'],
        'BIND_PRINT_SERVICE': ['signature', 'required by PrintServices for system binding.', 'Must be required by a PrintService, to ensure that only the system can bind to it.'],
        'BIND_QUICK_SETTINGS_TILE': ['signatureOrSystem', 'allows binding to third-party quick settings tiles.', 'Allows an application to bind to third party quick settings tiles.'],
        'BIND_REMOTEVIEWS': ['signature', 'required by RemoteViewsServices for system binding.', 'Must be required by a RemoteViewsService, to ensure that only the system can bind to it.'],
        'BIND_SCREENING_SERVICE': ['signature', 'required by CallScreeningServices for system binding.', 'Must be required by a CallScreeningService, to ensure that only the system can bind to it.'],
        'BIND_TELECOM_CONNECTION_SERVICE': ['signature', 'required by ConnectionServices for system binding.', 'Must be required by a ConnectionService, to ensure that only the system can bind to it.'],
        'BIND_TEXT_SERVICE': ['signature', 'required by TextServices (e.g., SpellCheckerService) for system binding.', 'Must be required by a TextService (e.g. SpellCheckerService) to ensure that only the system can bind to it.'],
        'BIND_TV_INPUT': ['signature', 'required by TvInputServices for system binding.', 'Must be required by a TvInputService to ensure that only the system can bind to it.'],
        'BIND_VISUAL_VOICEMAIL_SERVICE': ['signature', 'required by VisualVoicemailServices for system binding.', 'Must be required by a link VisualVoicemailService to ensure that only the system can bind to it.'],
        'BIND_VOICE_INTERACTION': ['signature', 'required by VoiceInteractionServices for system binding.', 'Must be required by a VoiceInteractionService, to ensure that only the system can bind to it.'],
        'BIND_VPN_SERVICE': ['signature', 'required by VpnServices for system binding.', 'Must be required by a VpnService, to ensure that only the system can bind to it.'],
        'BIND_VR_LISTENER_SERVICE': ['signature', 'required by VrListenerServices for system binding.', 'Must be required by an VrListenerService, to ensure that only the system can bind to it.'],
        'BLUETOOTH_PRIVILEGED': ['signatureOrSystem', 'allows privileged Bluetooth operations without user interaction.', 'Allows applications to pair bluetooth devices without user interaction, and to allow or disallow phonebook access or message access. This is not available to third party applications.'],
        'BODY_SENSORS': ['dangerous', 'grants access to body sensors, such as heart rate.', 'Allows an application to access data from sensors that the user uses to measure what is happening inside his/her body, such as heart rate.'],
        'CAPTURE_AUDIO_OUTPUT': ['signatureOrSystem', 'allows capturing of audio output.', 'Allows an application to capture audio output.'],
        'CAPTURE_SECURE_VIDEO_OUTPUT': ['normal', 'permits capturing of secure video output.', 'Allows an application to capture secure video output.'],
        'CAPTURE_VIDEO_OUTPUT': ['normal', 'allows capturing of video output.', 'Allows an application to capture video output.'],
        'FOREGROUND_SERVICE': ['normal', 'enables regular apps to use Service.startForeground.', 'Allows a regular application to use Service.startForeground.'],
        'GET_ACCOUNTS_PRIVILEGED': ['signatureOrSystem', 'grants access to the Accounts Service.', 'Allows access to the list of accounts in the Accounts Service.'],
        'INSTALL_SHORTCUT': ['normal', 'permits installation of shortcuts in Launcher.', 'Allows an application to install a shortcut in Launcher.'],
        'INSTANT_APP_FOREGROUND_SERVICE': ['signatureOrSystem', 'allows instant apps to create foreground services.', 'Allows an instant app to create foreground services.'],
        'LOCATION_HARDWARE': ['normal', 'permits use of location features in hardware.', 'Allows an application to use location features in hardware, such as the geofencing api.'],
        'MANAGE_DOCUMENTS': ['signature', 'allows management of document access, typically in a picker.', 'Allows an application to manage access to documents, usually as part of a document picker.'],
        'MANAGE_OWN_CALLS': ['normal', 'enables a calling app to manage its own calls.', 'Allows a calling application which manages it own calls through the self-managed ConnectionService APIs.'],
        'MEDIA_CONTENT_CONTROL': ['normal', 'allows control over media content playback.', 'Allows an application to know what content is playing and control its playback.'],
        'NFC_TRANSACTION_EVENT': ['normal', 'enables receiving NFC transaction events.', 'Allows applications to receive NFC transaction events.'],
        'READ_CALL_LOG': ['dangerous', "grants read access to the user's call log.", "Allows an application to read the user's call log."],
        'READ_PHONE_NUMBERS': ['dangerous', "allows reading of the device's phone number(s).", "Allows read access to the device's phone number(s). This is a subset of the capabilities granted by READ_PHONE_STATE but is exposed to instant applications."],
        'READ_VOICEMAIL': ['signature', 'permits an app to read voicemails in the system.', 'Allows an application to read voicemails in the system.'],
        'REQUEST_COMPANION_RUN_IN_BACKGROUND': ['normal', 'allows a companion app to run in the background.', 'Allows a companion app to run in the background.'],
        'REQUEST_COMPANION_USE_DATA_IN_BACKGROUND': ['normal', 'permits a companion app to use data in the background.', 'Allows a companion app to use data in the background.'],
        'REQUEST_DELETE_PACKAGES': ['normal', 'enables an app to request package deletions.', 'Allows an application to request deleting packages.'],
        'REQUEST_IGNORE_BATTERY_OPTIMIZATIONS': ['normal', 'permission for using Settings.ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS.', 'Permission an application must hold in order to use Settings.ACTION_REQUEST_IGNORE_BATTERY_OPTIMIZATIONS.'],
        'SEND_RESPOND_VIA_MESSAGE': ['signatureOrSystem', 'allows sending respond-via-message requests during calls.', 'Allows an application (Phone) to send a request to other applications to handle the respond-via-message action during incoming calls.'],
        'TRANSMIT_IR': ['normal', "enables use of the device's IR transmitter.", "Allows using the device's IR transmitter, if available."],
        'UNINSTALL_SHORTCUT': ['normal', 'deprecated permission for uninstalling shortcuts.', "Don't use this permission in your app. This permission is no longer supported."],
        'USE_BIOMETRIC': ['normal', 'allows use of device-supported biometric modalities.', 'Allows an app to use device supported biometric modalities.'],
        'USE_FINGERPRINT': ['normal', 'allow use of fingerprint', 'This constant was deprecated in API level 28. Applications should request USE_BIOMETRIC instead.'],
        'WRITE_CALL_LOG': ['dangerous', "allows writing to (but not reading) the user's call log.", "Allows an application to write (but not read) the user's call log data."],
        'WRITE_VOICEMAIL': ['signature', 'enables modification and removal of voicemails.', 'Allows an application to modify and remove existing voicemails in the system.'],
        'ACCESS_BACKGROUND_LOCATION': ['dangerous', 'access location in background', 'Allows an app to access location in the background.'],
        'ACCESS_MEDIA_LOCATION': ['dangerous', 'access any geographic locations', "Allows an application to access any geographic locations persisted in the user's shared collection."],
        'ACTIVITY_RECOGNITION': ['dangerous', 'allow application to recognize physical activity', 'Allows an application to recognize physical activity.'],
        'BIND_CALL_REDIRECTION_SERVICE': ['signature', 'required by CallRedirectionServices for system binding.', 'Must be required by a CallRedirectionService, to ensure that only the system can bind to it.'],
        'BIND_CARRIER_MESSAGING_CLIENT_SERVICE': ['signature', 'required by CarrierMessagingClientServices for system protection.', 'A subclass of CarrierMessagingClientService must be protected with this permission.'],
        'CALL_COMPANION_APP': ['normal', 'enables an InCallService app to function as a calling companion.', "Allows an app which implements the InCallService API to be eligible to be enabled as a calling companion app. This means that the Telecom framework will bind to the app's InCallService implementation when there are calls active. The app can use the InCallService API to view information about calls on the system and control these calls."],
        'REQUEST_PASSWORD_COMPLEXITY': ['normal', 'allows requesting and prompting for screen lock complexity upgrades.', 'Allows an application to request the screen lock complexity and prompt users to update the screen lock to a certain complexity level.'],
        'SMS_FINANCIAL_TRANSACTIONS': ['signature', 'Allows financial apps to read filtered sms messages', 'Allows financial apps to read filtered sms messages. Protection level: signature|appop. This constant was deprecated in API level S.'],
        'START_VIEW_PERMISSION_USAGE': ['signature', 'allows starting the permission usage screen for an app.', 'Allows the holder to start the permission usage screen for an app.'],
        'USE_FULL_SCREEN_INTENT': ['normal', 'required for full screen intents in notifications.', 'Required for apps targeting Build.VERSION_CODES.Q that want to use notification full screen intents.'],
        'ACCESS_CALL_AUDIO': ['signature', 'Application can access call audio', 'Allows an application assigned to the Dialer role to be granted access to the telephony call audio streams, both TX and RX.'],
        'BIND_CONTROLS': ['signatureOrSystem', 'Allows SystemUI to request third party controls.', 'Allows SystemUI to request third party controls. Should only be requested by the System and required by ControlsProviderService declarations.'],
        'BIND_QUICK_ACCESS_WALLET_SERVICE': ['signature', 'required by QuickAccessWalletServices for system binding.', 'Must be required by a QuickAccessWalletService to ensure that only the system can bind to it.'],
        'INTERACT_ACROSS_PROFILES': ['normal', 'enables interaction across profiles in the same group.', 'Allows interaction across profiles in the same profile group.'],
        'LOADER_USAGE_STATS': ['signatureOrSystem', 'allows data loaders to read package access logs.', "Allows a data loader to read a package's access logs. The access logs contain the set of pages referenced over time."],
        'MANAGE_EXTERNAL_STORAGE': ['dangerous', 'Allows an application a broad access to external storage in scoped storage', 'Allows an application a broad access to external storage in scoped storage. Intended to be used by few apps that need to manage files on behalf of the users.'],
        'NFC_PREFERRED_PAYMENT_INFO': ['normal', 'allows receiving NFC preferred payment service info.', 'Allows applications to receive NFC preferred payment service information.'],
        'QUERY_ALL_PACKAGES': ['normal', 'enables querying any normal app on the device.', 'Allows query of any normal app on the device, regardless of manifest declarations.'],
        'READ_PRECISE_PHONE_STATE': ['dangerous', 'allows read-only access to precise phone state.', 'Allows read only access to precise phone state. Allows reading of detailed information about phone state for special-use applications such as dialers, carrier applications, or ims applications.'],
        'READ_APP_BADGE': ['normal', 'show app notification', 'Allows an application to show app icon badges.'],
        'BIND_COMPANION_DEVICE_SERVICE': ['normal', 'required by CompanionDeviceServices for system binding.', 'Must be required by any CompanionDeviceServices to ensure that only the system can bind to it.'],
        'HIDE_OVERLAY_WINDOWS': ['normal', 'Prevent non-system-overlay windows ', 'Allows an app to prevent non-system-overlay windows from being drawn on top of it.'],
        'HIGH_SAMPLING_RATE_SENSORS': ['normal', 'Access higher sampling rate sensor data', 'Allows an app to access sensor data with a sampling rate greater than 200 Hz.'],
        'MANAGE_ONGOING_CALLS': ['signature', 'Query and manage ongoing call details', 'Allows to query ongoing call details and manage ongoing calls.'],
        'REQUEST_COMPANION_PROFILE_WATCH': ['normal', "enables association with a device as a 'watch'.", 'Allows app to request to be associated with a device via CompanionDeviceManager as a "watch".'],
        'REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE': ['normal', 'allows subscribing to companion device presence status notifications.', 'Allows an application to subscribe to notifications about the presence status change of their associated companion device.'],
        'SCHEDULE_EXACT_ALARM': ['normal', 'permits exact alarm scheduling for background work.', 'Allows an app to use exact alarm scheduling APIs to perform timing sensitive background work.'],
        'USE_ICC_AUTH_WITH_DEVICE_IDENTIFIER': ['signature', 'allows reading device identifiers and using ICC-based authentication.', "Allows to read device identifiers and use ICC based authentication like EAP-AKA. Often required in authentication to access the carrier's server and manage services of the subscriber."],
        'ACCESS_BLOBS_ACROSS_USERS': ['normal', 'enables access to data blobs across users.', 'Allows an application to access data blobs across users.'],
        'BIND_CREDENTIAL_PROVIDER_SERVICE': ['signature', 'required by CredentialProviderServices for system binding.', 'Must be required by a CredentialProviderService to ensure that only the system can bind to it.'],
        'BIND_TV_INTERACTIVE_APP': ['signature', 'required by TvInteractiveAppServices for system binding.', 'Must be required by a TvInteractiveAppService to ensure that only the system can bind to it.'],
        'BLUETOOTH_ADVERTISE': ['dangerous', 'required to advertise to nearby Bluetooth devices.', 'Required to be able to advertise to nearby Bluetooth devices.'],
        'BLUETOOTH_CONNECT': ['dangerous', 'necessary for connecting to paired Bluetooth devices.', 'Required to be able to connect to paired Bluetooth devices.'],
        'BLUETOOTH_SCAN': ['dangerous', 'required for discovering and pairing Bluetooth devices.', 'Required to be able to discover and pair nearby Bluetooth devices.'],
        'BODY_SENSORS_BACKGROUND': ['dangerous', 'grants background access to body sensors, like heart rate.', "Allows an application to access data from sensors that the user uses to measure what is happening inside their body, such as heart rate. If you're requesting this permission, you must also request BODY_SENSORS . Requesting this permission by itself doesn't give you Body sensors access."],
        'CONFIGURE_WIFI_DISPLAY': ['normal', 'allows configuring and connecting to Wifi displays.', 'Allows an application to configure and connect to Wifi displays'],
        'CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS': ['normal', 'enables querying metadata of credential candidates.', 'Allows a browser to invoke the set of query apis to get metadata about credential candidates prepared during the CredentialManager.prepareGetCredential API.'],
        'CREDENTIAL_MANAGER_SET_ALLOWED_PROVIDERS': ['normal', 'allows specifying candidate credential providers.', 'Allows specifying candidate credential providers to be queried in Credential Manager get flows, or to be preferred as a default in the Credential Manager create flows.'],
        'CREDENTIAL_MANAGER_SET_ORIGIN': ['normal', 'enables credential manager APIs on behalf of another RP.', 'Allows a browser to invoke credential manager APIs on behalf of another RP.'],
        'DELIVER_COMPANION_MESSAGES': ['normal', 'allows delivery of companion messages to system.', 'Allows an application to deliver companion messages to system'],
        'DETECT_SCREEN_CAPTURE': ['normal', "notifies when a screen capture of the app's windows is attempted.", 'Allows an application to get notified when a screen capture of its windows is attempted.'],
        'ENFORCE_UPDATE_OWNERSHIP': ['normal', 'indicates intent to become the update owner via PackageInstaller.', 'Allows an application to indicate via PackageInstaller.SessionParams.setRequestUpdateOwnership(boolean) that it has the intention of becoming the update owner.'],
        'EXECUTE_APP_ACTION': ['internal', 'allows assistive apps to perform actions inside other apps.', 'Allows an assistive application to perform actions on behalf of users inside of applications.'],
        'FOREGROUND_SERVICE_CAMERA': ['normal', 'allows foreground services with camera use.', 'Allows a regular application to use Service.startForeground with the type "camera".'],
        'FOREGROUND_SERVICE_CONNECTED_DEVICE': ['normal', 'enables foreground services with connected device use.', 'Allows a regular application to use Service.startForeground with the type "connectedDevice".'],
        'FOREGROUND_SERVICE_DATA_SYNC': ['normal', 'permits foreground services for data synchronization.', 'Allows a regular application to use Service.startForeground with the type "dataSync".'],
        'FOREGROUND_SERVICE_HEALTH': ['normal', 'enables foreground services with health-related functionality.', 'Allows a regular application to use Service.startForeground with the type "health".'],
        'FOREGROUND_SERVICE_LOCATION': ['normal', 'allows foreground services with location use.', 'Allows a regular application to use Service.startForeground with the type "location".'],
        'FOREGROUND_SERVICE_MEDIA_PLAYBACK': ['normal', 'enables foreground services for media playback.', 'Allows a regular application to use Service.startForeground with the type "mediaPlayback".'],
        'FOREGROUND_SERVICE_MEDIA_PROJECTION': ['normal', 'allows foreground services for media projection.', 'Allows a regular application to use Service.startForeground with the type "mediaProjection".'],
        'FOREGROUND_SERVICE_MICROPHONE': ['normal', 'permits foreground services with microphone use.', 'Allows a regular application to use Service.startForeground with the type "microphone".'],
        'FOREGROUND_SERVICE_PHONE_CALL': ['normal', 'enables foreground services during phone calls.', 'Allows a regular application to use Service.startForeground with the type "phoneCall".'],
        'FOREGROUND_SERVICE_REMOTE_MESSAGING': ['normal', 'allows foreground services for remote messaging.', 'Allows a regular application to use Service.startForeground with the type "remoteMessaging".'],
        'FOREGROUND_SERVICE_SPECIAL_USE': ['normal', 'enables special-use foreground services.', 'Allows a regular application to use Service.startForeground with the type "specialUse".'],
        'FOREGROUND_SERVICE_SYSTEM_EXEMPTED': ['normal', 'allows system-exempted types of foreground services.', 'Allows a regular application to use Service.startForeground with the type "systemExempted". Apps are allowed to use this type only in the use cases listed in ServiceInfo.FOREGROUND_SERVICE_TYPE_SYSTEM_EXEMPTED .'],
        'LAUNCH_CAPTURE_CONTENT_ACTIVITY_FOR_NOTE': ['internal', 'enables screen content capture for screenshots.', 'Allows an application to capture screen content to perform a screenshot using the intent action Intent.ACTION_LAUNCH_CAPTURE_CONTENT_ACTIVITY_FOR_NOTE .'],
        'LAUNCH_MULTI_PANE_SETTINGS_DEEP_LINK': ['normal', 'enables showing an Activity embedded in the Settings app.', 'An application needs this permission for Settings.ACTION_SETTINGS_EMBED_DEEP_LINK_ACTIVITY to show its Activity embedded in Settings app.'],
        'MANAGE_DEVICE_LOCK_STATE': ['internal', 'allows financed device kiosk apps to interact with Device Lock service.', 'Allows financed device kiosk apps to perform actions on the Device Lock service'],
        'MANAGE_DEVICE_POLICY_ACCESSIBILITY': ['normal', 'enables managing policy related to accessibility.', 'Allows an application to manage policy related to accessibility. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_ACCOUNT_MANAGEMENT': ['normal', 'allows setting policy related to account management.', 'Allows an application to set policy related to account management. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_ACROSS_USERS': ['normal', 'enables setting secure device policies without user data access.', 'Allows an application to set device policies outside the current user that are required for securing device ownership without accessing user data. Holding this permission allows the use of other held MANAGE_DEVICE_POLICY_* permissions across all users on the device provided they do not grant access to user data.'],
        'MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL': ['normal', 'allows setting device policies with access to user data.', 'Allows an application to set device policies outside the current user. Fuller form of MANAGE_DEVICE_POLICY_ACROSS_USERS that removes the restriction on accessing user data. Holding this permission allows the use of any other held MANAGE_DEVICE_POLICY_* permissions across all users on the device.  Constant Value:                "android.permission.MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL"'],
        'MANAGE_DEVICE_POLICY_ACROSS_USERS_SECURITY_CRITICAL': ['normal', 'enables critical security policies for securing user data.', 'Allows an application to set device policies outside the current user that are critical for securing data within the current user. Holding this permission allows the use of other held MANAGE_DEVICE_POLICY_* permissions across all users on the device provided they are required for securing data within the current user.'],
        'MANAGE_DEVICE_POLICY_AIRPLANE_MODE': ['normal', 'permits setting policy related to airplane mode.', 'Allows an application to set policy related to airplane mode. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_APPS_CONTROL': ['normal', 'allows managing policy for modifying applications.', 'Allows an application to manage policy regarding modifying applications. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_APP_RESTRICTIONS': ['normal', 'enables management of application restrictions.', 'Allows an application to manage application restrictions. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_APP_USER_DATA': ['normal', 'allows setting policy for application user data.', 'Allows an application to manage policy related to application user data. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_AUDIO_OUTPUT': ['normal', 'enables policy setting for audio output.', 'Allows an application to set policy related to audio output. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_AUTOFILL': ['normal', 'allows setting policy for autofill services.', 'Allows an application to set policy related to autofill. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_BACKUP_SERVICE': ['normal', 'enables managing backup service policy.', 'Allows an application to manage backup service policy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_BLUETOOTH': ['normal', 'permits setting policy related to Bluetooth.', 'Allows an application to set policy related to bluetooth. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_BUGREPORT': ['normal', 'allows requesting bugreports with user consent.', 'Allows an application to request bugreports with user consent. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_CALLS': ['normal', 'enables managing policy for phone calls.', 'Allows an application to manage calling policy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_CAMERA': ['normal', 'permits policy setting for camera usage.', "Allows an application to set policy related to restricting a user's ability to use or enable and disable the camera. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user."],
        'MANAGE_DEVICE_POLICY_CERTIFICATES': ['normal', 'allows policy management for certificates.', 'Allows an application to set policy related to certificates. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_COMMON_CRITERIA_MODE': ['normal', 'enables policy management for common criteria mode.', 'Allows an application to manage policy related to common criteria mode. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_DEBUGGING_FEATURES': ['normal', 'allows managing policy for debugging features.', 'Allows an application to manage debugging features policy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_DEFAULT_SMS': ['normal', 'permits setting policy for the default SMS application.', 'Allows an application to set policy related to the default sms application. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_DEVICE_IDENTIFIERS': ['normal', 'enables policy management for device identifiers.', 'Allows an application to manage policy related to device identifiers.'],
        'MANAGE_DEVICE_POLICY_DISPLAY': ['normal', 'allows setting policy for display management.', 'Allows an application to set policy related to the display. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_FACTORY_RESET': ['normal', 'enables setting policy for factory resets.', 'Allows an application to set policy related to factory reset. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_FUN': ['normal', 'allows setting policy related to fun activities.', 'Allows an application to set policy related to fun. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_INPUT_METHODS': ['normal', 'permits policy setting for input methods.', 'Allows an application to set policy related to input methods. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_INSTALL_UNKNOWN_SOURCES': ['normal', 'enables policy for installing apps from unknown sources.', 'Allows an application to manage installing from unknown sources policy. MANAGE_SECURITY_CRITICAL_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_KEEP_UNINSTALLED_PACKAGES': ['normal', 'allows keeping uninstalled packages per policy.', 'Allows an application to set policy related to keeping uninstalled packages. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_KEYGUARD': ['normal', 'enables managing policy for keyguard settings.', 'Allows an application to manage policy related to keyguard. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_SECURITY_CRITICAL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_LOCALE': ['normal', 'allows setting policy for locale management.', 'Allows an application to set policy related to locale. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_LOCATION': ['normal', 'enables policy setting for location services.', 'Allows an application to set policy related to location. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_LOCK': ['normal', 'permits locking profiles or devices per policy.', 'Allows an application to lock a profile or the device with the appropriate cross-user permission. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_LOCK_CREDENTIALS': ['normal', 'enables policy setting for lock credentials.', 'Allows an application to set policy related to lock credentials. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_SECURITY_CRITICAL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_LOCK_TASK': ['normal', 'allows managing lock task policy.', 'Allows an application to manage lock task policy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_METERED_DATA': ['normal', 'permits policy management for metered data.', 'Allows an application to manage policy related to metered data. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_MICROPHONE': ['normal', 'allows policy setting for microphone usage.', "Allows an application to set policy related to restricting a user's ability to use or enable and disable the microphone. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user."],
        'MANAGE_DEVICE_POLICY_MOBILE_NETWORK': ['normal', 'enables setting policy for mobile networks.', 'Allows an application to set policy related to mobile networks. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_MODIFY_USERS': ['normal', 'allows policy management to prevent user modifications.', 'Allows an application to manage policy preventing users from modifying users. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user'],
        'MANAGE_DEVICE_POLICY_MTE': ['normal', 'enables policy management for the Memory Tagging Extension.', 'Allows an application to manage policy related to the Memory Tagging Extension (MTE).'],
        'MANAGE_DEVICE_POLICY_NEARBY_COMMUNICATION': ['normal', 'allows policy setting for nearby communications.', 'Allows an application to set policy related to nearby communications (e.g.Beam and nearby streaming). Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_NETWORK_LOGGING': ['normal', 'enables setting policy for network logging.', 'Allows an application to set policy related to network logging. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_ORGANIZATION_IDENTITY': ['normal', 'allows managing the identity of the managing organization.', 'Allows an application to manage the identity of the managing organization. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_OVERRIDE_APN': ['normal', 'permits policy setting for overriding APNs.', 'Allows an application to set policy related to override APNs. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PACKAGE_STATE': ['normal', 'enables policy for hiding and suspending packages.', 'Allows an application to set policy related to hiding and suspending packages. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PHYSICAL_MEDIA': ['normal', 'allows setting policies for physical media usage.', 'Allows an application to set policy related to physical media. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PRINTING': ['normal', 'allows setting policies for printing services.', 'Allows an application to set policy related to printing. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PRIVATE_DNS': ['normal', 'allows setting policies for private DNS management.', 'Allows an application to set policy related to private DNS. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PROFILES': ['normal', 'allows setting policies for user profiles.', 'Allows an application to set policy related to profiles. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PROFILE_INTERACTION': ['normal', 'allows setting policies for interactions between user profiles.', 'Allows an application to set policy related to interacting with profiles (e.g.Disallowing cross-profile copy and paste). Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_PROXY': ['normal', 'allows setting a global HTTP proxy independently of network.', 'Allows an application to set a network-independent global HTTP proxy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_QUERY_SYSTEM_UPDATES': ['normal', 'allows querying system updates.', 'Allows an application query system updates. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_RESET_PASSWORD': ['normal', 'allows force setting a new device unlock password or profile challenge.', 'Allows an application to force set a new device unlock password or a managed profile challenge on current user. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_RESTRICT_PRIVATE_DNS': ['normal', 'allows restricting user configuration of private DNS.', 'Allows an application to set policy related to restricting the user from configuring private DNS. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_RUNTIME_PERMISSIONS': ['normal', 'allows setting runtime permissions for packages.', 'Allows an application to set the grant state of runtime permissions on packages. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_RUN_IN_BACKGROUND': ['normal', 'allows setting policies for background process management.', 'Allows an application to set policy related to users running in the background. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SAFE_BOOT': ['normal', 'allows managing policies for safe boot mode.', 'Allows an application to manage safe boot policy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SCREEN_CAPTURE': ['normal', 'allows setting policies for screen capture functionality.', 'Allows an application to set policy related to screen capture. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SCREEN_CONTENT': ['normal', 'allows setting policies for the usage of screen contents.', 'Allows an application to set policy related to the usage of the contents of the screen. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SECURITY_LOGGING': ['normal', 'allows setting policies for security logging.', 'Allows an application to set policy related to security logging. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SETTINGS': ['normal', 'allows setting general device policies.', 'Allows an application to set policy related to settings. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SMS': ['normal', 'allows setting policies for SMS functionality.', 'Allows an application to set policy related to sms. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_STATUS_BAR': ['normal', 'allows setting policies for the status bar.', 'Allows an application to set policy related to the status bar.'],
        'MANAGE_DEVICE_POLICY_SUPPORT_MESSAGE': ['normal', 'allows setting support messages for policy-affected actions.', 'Allows an application to set support messages for when a user action is affected by an active policy. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SUSPEND_PERSONAL_APPS': ['normal', 'allows suspending personal apps through policy settings.', 'Allows an application to set policy related to suspending personal apps. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SYSTEM_APPS': ['normal', 'allows managing policies related to system apps.', 'Allows an application to manage policy related to system apps. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SYSTEM_DIALOGS': ['normal', 'allows setting policies for system dialogs.', 'Allows an application to set policy related to system dialogs. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_SYSTEM_UPDATES': ['normal', 'allows setting policies for system updates.', 'Allows an application to set policy related to system updates. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_TIME': ['normal', 'allows managing policies related to time settings.', 'Allows an application to manage device policy relating to time. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_USB_DATA_SIGNALLING': ['normal', 'allows setting policies for USB data signalling.', 'Allows an application to set policy related to usb data signalling.'],
        'MANAGE_DEVICE_POLICY_USB_FILE_TRANSFER': ['normal', 'allows setting policies for USB file transfers.', 'Allows an application to set policy related to usb file transfers. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_USERS': ['normal', 'allows setting policies related to user management.', 'Allows an application to set policy related to users. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_VPN': ['normal', 'allows setting policies for VPN usage.', 'Allows an application to set policy related to VPNs. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_WALLPAPER': ['normal', 'allows setting policies for wallpaper management.', 'Allows an application to set policy related to the wallpaper. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_WIFI': ['normal', 'allows setting policies for WiFi connectivity.', 'Allows an application to set policy related to Wifi. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_WINDOWS': ['normal', 'allows setting policies for window management.', 'Allows an application to set policy related to windows. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS_FULL is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_DEVICE_POLICY_WIPE_DATA': ['normal', 'allows managing policies for data wiping.', 'Allows an application to manage policy related to wiping data. Manifest.permission#MANAGE_DEVICE_POLICY_ACROSS_USERS is required to call APIs protected by this permission on users different to the calling user.'],
        'MANAGE_MEDIA': ['signature', 'allows modification and deletion of media files without user confirmation.', 'Allows an application to modify and delete media files on this device or any connected storage device without user confirmation. Applications must already be granted the READ_EXTERNAL_STORAGE or MANAGE_EXTERNAL_STORAGE } permissions for this permission to take effect.'],
        'MANAGE_WIFI_INTERFACES': ['normal', 'allows managing conflicts between Wi-Fi interface requests.', 'Allows applications to get notified when a Wi-Fi interface request cannot be satisfied without tearing down one or more other interfaces, and provide a decision whether to approve the request or reject it. Not for use by third-party applications.'],
        'MANAGE_WIFI_NETWORK_SELECTION': ['normal', 'allows privileged management of Wi-Fi network selection.', 'This permission is used to let OEMs grant their trusted app access to a subset of privileged wifi APIs to improve wifi performance. Allows applications to manage Wi-Fi network selection related features such as enable or disable global auto-join, modify connectivity scan intervals, and approve Wi-Fi Direct connections. Not for use by third-party applications.'],
        'NEARBY_WIFI_DEVICES': ['dangerous', 'required for advertising and connecting to nearby devices via Wi-Fi.', 'Required to be able to advertise and connect to nearby devices via Wi-Fi.'],
        'OVERRIDE_WIFI_CONFIG': ['normal', 'allows modification of any Wi-Fi configuration.', 'Allows an application to modify any wifi configuration, even if created by another application. Once reconfigured the original creator cannot make any further modifications. Not for use by third-party applications.'],
        'POST_NOTIFICATIONS': ['dangerous', 'allows an app to post notifications.', 'Allows an app to post notifications'],
        'PROVIDE_OWN_AUTOFILL_SUGGESTIONS': ['internal', 'allows providing autofill suggestions using the autofill framework.', 'Allows an application to display its suggestions using the autofill framework.'],
        'PROVIDE_REMOTE_CREDENTIALS': ['signature', 'allows storing and retrieving credentials from a remote device.', 'Allows an application to be able to store and retrieve credentials from a remote device.'],
        'READ_ASSISTANT_APP_SEARCH_DATA': ['normal', 'allows querying global AppSearch data visible to the Assistant role.', "Allows an application to query over global data in AppSearch that's visible to the ASSISTANT role."],
        'READ_BASIC_PHONE_STATE': ['normal', 'allows read-only access to basic phone state information.', 'Allows read only access to phone state with a non dangerous permission, including the information like cellular network type, software version.'],
        'READ_HOME_APP_SEARCH_DATA': ['normal', 'allows querying global AppSearch data visible to the Home role.', "Allows an application to query over global data in AppSearch that's visible to the HOME role."],
        'READ_MEDIA_AUDIO': ['dangerous', 'allows reading audio files from external storage.', 'Allows an application to read audio files from external storage.'],
        'READ_MEDIA_IMAGES': ['dangerous', 'allows reading image files from external storage.', 'Allows an application to read image files from external storage.'],
        'READ_MEDIA_VIDEO': ['dangerous', 'allows reading video files from external storage.', 'Allows an application to read video files from external storage.'],
        'READ_MEDIA_VISUAL_USER_SELECTED': ['dangerous', 'allows reading user-selected image or video files from external storage.', 'Allows an application to read image or video files from external storage that a user has selected via the permission prompt photo picker. Apps can check this permission to verify that a user has decided to use the photo picker, instead of granting access to READ_MEDIA_IMAGES or READ_MEDIA_VIDEO . It does not prevent apps from accessing the standard photo picker manually. This permission should be requested alongside READ_MEDIA_IMAGES and/or READ_MEDIA_VIDEO , depending on which type of media is desired.'],
        'READ_NEARBY_STREAMING_POLICY': ['normal', 'allows reading nearby streaming policy settings.', 'Allows an application to read nearby streaming policy. The policy controls whether to allow the device to stream its notifications and apps to nearby devices. Applications that are not the device owner will need this permission to call DevicePolicyManager.getNearbyNotificationStreamingPolicy() or DevicePolicyManager.getNearbyAppStreamingPolicy() .'],
        'REQUEST_COMPANION_PROFILE_APP_STREAMING': ['normal', 'allows requesting association with a virtual display for app streaming.', 'Allows application to request to be associated with a virtual display capable of streaming Android applications ( AssociationRequest.DEVICE_PROFILE_APP_STREAMING ) by CompanionDeviceManager . Not for use by third-party applications.'],
        'REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION': ['normal', 'allows requesting association with a vehicle head unit for automotive projection.', 'Allows application to request to be associated with a vehicle head unit capable of automotive projection ( AssociationRequest.DEVICE_PROFILE_AUTOMOTIVE_PROJECTION ) by CompanionDeviceManager . Not for use by third-party applications.'],
        'REQUEST_COMPANION_PROFILE_COMPUTER': ['normal', 'allows requesting association with a computer for shared functionality.', 'Allows application to request to be associated with a computer to share functionality and/or data with other devices, such as notifications, photos and media ( AssociationRequest.DEVICE_PROFILE_COMPUTER ) by CompanionDeviceManager . Not for use by third-party applications.'],
        'REQUEST_COMPANION_PROFILE_GLASSES': ['normal', "allows requesting association with a device as 'glasses'.", 'Allows app to request to be associated with a device via CompanionDeviceManager as "glasses"'],
        'REQUEST_COMPANION_PROFILE_NEARBY_DEVICE_STREAMING': ['normal', 'allows requesting to stream content to a nearby device.', 'Allows application to request to stream content from an Android host to a nearby device ( AssociationRequest.DEVICE_PROFILE_NEARBY_DEVICE_STREAMING ) by CompanionDeviceManager . Not for use by third-party applications.'],
        'REQUEST_COMPANION_SELF_MANAGED': ['normal', 'allows creating a self-managed companion device association.', 'Allows an application to create a "self-managed" association.'],
        'REQUEST_COMPANION_START_FOREGROUND_SERVICES_FROM_BACKGROUND': ['normal', 'allows a companion app to start foreground services from the background.', 'Allows a companion app to start a foreground service from the background.'],
        'RUN_USER_INITIATED_JOBS': ['normal', 'allows using the user-initiated jobs API.', 'Allows applications to use the user-initiated jobs API. For more details see JobInfo.Builder.setUserInitiated(boolean) .'],
        'START_FOREGROUND_SERVICES_FROM_BACKGROUND': ['normal', 'allows starting foreground services from the background.', "Allows an application to start foreground services from the background at any time. This permission is not for use by third-party applications , with the only exception being if the app is the default SMS app. Otherwise, it's only usable by privileged apps, app verifier app, and apps with any of the EMERGENCY or SYSTEM GALLERY roles."],
        'START_VIEW_APP_FEATURES': ['signature', 'allows starting a screen listing app features.', 'Allows the holder to start the screen with a list of app features.'],
        'SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE': ['signature', 'allows subscribing to the keyguard locked state.', 'Allows an application to subscribe to keyguard locked (i.e., showing) state.'],
        'TURN_SCREEN_ON': ['normal', 'allows turning the screen on, for use by home automation apps.', 'Allows an app to turn on the screen on, e.g. with PowerManager.ACQUIRE_CAUSES_WAKEUP . Intended to only be used by home automation apps.'],
        'UPDATE_PACKAGES_WITHOUT_USER_ACTION': ['normal', 'allows updating packages without requiring user action.', 'Allows an application to indicate via PackageInstaller.SessionParams.setRequireUserAction(int) that user action should not be required for an app update.'],
        'USE_EXACT_ALARM': ['normal', 'allows using exact alarms without user permission.', 'Allows apps to use exact alarms just like with SCHEDULE_EXACT_ALARM but without needing to request this permission from the user. This is only intended for use by apps that rely on exact alarms for their core functionality. You should continue using SCHEDULE_EXACT_ALARM if your app needs exact alarms for a secondary feature that users may or may not use within your app.  Keep in mind that this is a powerful permission and app stores may enforce policies to audit and review the use of this permission. Such audits may involve removal from the app store if the app is found to be misusing this permission.'],
        'UWB_RANGING': ['dangerous', 'required for ranging to devices using ultra-wideband.', 'Required to be able to range to devices using ultra-wideband.'],
    },

    'SPECIAL_PERMISSIONS': {
        'com.sec.android.provider.badge.permission.READ': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for samsung phones.'],
        'com.sec.android.provider.badge.permission.WRITE': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for samsung phones.'],
        'com.htc.launcher.permission.READ_SETTINGS': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for htc phones.'],
        'com.htc.launcher.permission.UPDATE_SHORTCUT': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for htc phones.'],
        'com.sonyericsson.home.permission.BROADCAST_BADGE': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for sony phones.'],
        'com.sonymobile.home.permission.PROVIDER_INSERT_BADGE': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for sony phones.'],
        'com.anddoes.launcher.permission.UPDATE_COUNT': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for apex.'],
        'com.majeur.launcher.permission.UPDATE_BADGE': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for solid.'],
        'com.huawei.android.launcher.permission.READ_SETTINGS': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for huawei phones.'],
        'com.huawei.android.launcher.permission.WRITE_SETTINGS': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for huawei phones.'],
        'com.huawei.android.launcher.permission.CHANGE_BADGE': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for huawei phones.'],
        'com.oppo.launcher.permission.READ_SETTINGS': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for oppo phones.'],
        'com.oppo.launcher.permission.WRITE_SETTINGS': ['normal', 'show notification count on app', 'Show notification count or badge on application launch icon for oppo phones.'],
        'com.google.android.gms.permission.AD_ID': ['normal', 'application shows advertisements', 'This app uses a Google advertising ID and can possibly serve advertisements.'],
        'com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE': ['normal', 'permission defined by google', 'A custom permission defined by Google.'],
        'com.google.android.c2dm.permission.RECEIVE': ['normal', 'recieve push notifications', 'Allows an application to receive push notifications from cloud.'],
        'com.android.vending.BILLING': ['normal', 'application has in-app purchases', 'Allows an application to make in-app purchases from Google Play.'],
        'android.permission.ACCESS_ADSERVICES_TOPICS': ['normal', 'allow applications to access advertising service topics', 'This enables the app to retrieve information related to advertising topics or interests, which can be used for targeted advertising purposes.'],
        'android.permission.ACCESS_ADSERVICES_ATTRIBUTION': ['normal', 'allow applications to access advertising service attribution', 'This enables the app to retrieve information related to advertising attribution, which can be used for targeted advertising purposes. App can gather data about how users interact with ads, such as clicks or impressions, to measure the effectiveness of advertising campaigns.'],
        'android.permission.ACCESS_ADSERVICES_AD_ID': ['normal', 'allow app to access the device\'s advertising ID.', 'This ID is a unique, user-resettable identifier provided by Google\'s advertising services, allowing apps to track user behavior for advertising purposes while maintaining user privacy.'],
        'oppo.permission.OPPO_COMPONENT_SAFE': ['signature', 'permission specific to OPPO devices', 'It is used to grant apps the ability to access certain system-level features or components that are otherwise restricted for security reasons. This permission ensures that only trusted applications can interact with sensitive parts of the OPPO system.'],
        'com.huawei.permission.external_app_settings.USE_COMPONENT': ['signature', 'permission specific to Huawei devices', 'It is used to grant apps the ability to access certain system-level features or components that are otherwise restricted for security reasons. This permission ensures that only trusted applications can interact with sensitive parts of the Huawei system.'],

    },

    'MANIFEST_PERMISSION_GROUP': {
        'ACCOUNTS': 'Permissions for direct access to the accounts managed by the Account Manager.',
        'COST_MONEY': 'Used for permissions that can be used to make the user spend money without their direct involvement.',
        'DEVELOPMENT_TOOLS': 'Group of permissions that are related to development features.',
        'HARDWARE_CONTROLS': 'Used for permissions that provide direct access to the hardware on the device.',
        'LOCATION': 'Used for permissions that allow access to the user\'s current location.',
        'MESSAGES': 'Used for permissions that allow an application to send messages on behalf of the user or intercept messages being received by the user.',
        'NETWORK': 'Used for permissions that provide access to networking services.',
        'PERSONAL_INFO': 'Used for permissions that provide access to the user\'s private data, such as contacts, calendar events, e-mail messages, etc.',
        'PHONE_CALLS': 'Used for permissions that are associated with accessing and modifyign telephony state: intercepting outgoing calls, reading and modifying the phone state.',
        'STORAGE': 'Group of permissions that are related to SD card access.',
        'SYSTEM_TOOLS': 'Group of permissions that are related to system APIs.',
    },
}
