"""add department keys to filter models

Revision ID: 9d3bb33c6fc6
Revises: 8e67c183bed7
Create Date: 2024-10-11 15:52:29.740222

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = '9d3bb33c6fc6'
down_revision = '8e67c183bed7'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('search_filter', schema=None) as batch_op:
        batch_op.add_column(sa.Column('department_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True))
        batch_op.create_foreign_key(None, 'department', ['department_id'], ['id'])

    with op.batch_alter_table('search_filter_group', schema=None) as batch_op:
        batch_op.add_column(sa.Column('department_id', sqlalchemy_utils.types.uuid.UUIDType(binary=False), default=uuid.uuid4, nullable=True))
        batch_op.create_foreign_key(None, 'department', ['department_id'], ['id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('search_filter_group', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_column('department_id')

    with op.batch_alter_table('search_filter', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_column('department_id')

    # ### end Alembic commands ###
