"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        this.loadBalancer = defaults.ObtainAlb(this, id, {
            vpc: this.vpc,
            publicApi: props.publicApi,
            existingLoadBalancerObj: props.existingLoadBalancerObj,
            loadBalancerProps: props.loadBalancerProps,
            logAccessLogs: props.logAlbAccessLogs,
            loggingBucketProps: props.albLoggingBucketProps
        });
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        let newListener;
        if (this.loadBalancer.listeners.length === 0) {
            newListener = true;
        }
        else {
            newListener = false;
        }
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        const newTargetGroup = defaults.AddLambdaTarget(this, `tg${this.loadBalancer.listeners.length + 1}`, this.listener, this.lambdaFunction, props.ruleProps, props.targetProps);
        // this.listener needs to be set on the construct.
        // could be above: else { defaults.GetActiveListener }
        // do we then move that funcionality back into the construct (not the function). If so do
        // we leave it in AddNewTarget or just do it here and pass the listener?
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "2.43.0" };
//# sourceMappingURL=data:application/json;base64,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