"""add attachment table

Revision ID: 0ec3762a745d
Revises: 3476e147e632
Create Date: 2020-04-12 20:20:42.652468

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "0ec3762a745d"
down_revision = "3476e147e632"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "attachment_file",
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("name", sa.String(length=250), nullable=True),
        sa.Column("size", sa.Integer(), nullable=True),
        sa.Column("extension", sa.String(length=6), nullable=True),
        sa.Column(
            "comment_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["comment_id"],
            ["comment.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name", "comment_id", name="attachment_uc"),
    )
    op.create_index(
        op.f("ix_attachment_file_comment_id"),
        "attachment_file",
        ["comment_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_attachment_file_comment_id"), table_name="attachment_file"
    )
    op.drop_table("attachment_file")
    # ### end Alembic commands ###
