from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

class vtkCellGridComputeSurface(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetSideAttribute() -> vtkStringToken: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkCellGridComputeSurface: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkCellGridComputeSurface: ...

class vtkDGBoundsResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDGBoundsResponder: ...
    def Query(self, query:vtkCellGridBoundsQuery, cellType:vtkCellMetadata, caches:vtkCellGridResponders) -> bool: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDGBoundsResponder: ...

class vtkDGCell(vtkmodules.vtkCommonDataModel.vtkCellMetadata):
    class Shape(int): ...
    Edge:'Shape'
    Hexahedron:'Shape'
    Pyramid:'Shape'
    Quadrilateral:'Shape'
    Tetrahedron:'Shape'
    Triangle:'Shape'
    Vertex:'Shape'
    Wedge:'Shape'
    def FillReferencePoints(self, arr:vtkTypeFloat32Array) -> None: ...
    def FillSideConnectivity(self, arr:vtkTypeInt32Array) -> None: ...
    def FillSideOffsetsAndShapes(self, arr:vtkTypeInt32Array) -> None: ...
    def GetDimension(self) -> int: ...
    def GetNumberOfCorners(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> vtkTypeFloat32Array: ...
    def GetShape(self) -> Shape: ...
    @staticmethod
    def GetShapeCornerCount(shape:Shape) -> int: ...
    @staticmethod
    def GetShapeDimension(shape:Shape) -> int: ...
    @staticmethod
    def GetShapeName(shape:Shape) -> vtkStringToken: ...
    @overload
    def GetSideConnectivity(self, side:int) -> (int, ...): ...
    @overload
    def GetSideConnectivity(self) -> vtkTypeInt32Array: ...
    def GetSideOffsetsAndShapes(self) -> vtkTypeInt32Array: ...
    def GetSideShape(self, side:int) -> Shape: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDGCell: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDGCell: ...

class vtkDGHex(vtkDGCell):
    def GetDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> vtkTypeFloat32Array: ...
    @overload
    def GetSideConnectivity(self, side:int) -> (int, ...): ...
    @overload
    def GetSideConnectivity(self) -> vtkTypeInt32Array: ...
    def GetSideOffsetsAndShapes(self) -> vtkTypeInt32Array: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDGHex: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDGHex: ...

class vtkDGSidesResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDGSidesResponder: ...
    def Query(self, query:vtkCellGridSidesQuery, cellType:vtkCellMetadata, caches:vtkCellGridResponders) -> bool: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDGSidesResponder: ...

class vtkDGTet(vtkDGCell):
    def GetDimension(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfCorners(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> vtkTypeFloat32Array: ...
    @overload
    def GetSideConnectivity(self, side:int) -> (int, ...): ...
    @overload
    def GetSideConnectivity(self) -> vtkTypeInt32Array: ...
    def GetSideOffsetsAndShapes(self) -> vtkTypeInt32Array: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkDGTet: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkDGTet: ...

