# Third-party dictionaries (not bundled)

Dictionaries are **not** bundled in wheel/sdist. Users fetch `.marisa.zst` assets separately.


| Code | Language | File | LicenseID | LicenseURL | Notes |
|---:|---|---|---|---|---|
| af | Afrikaans | af.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | Hunspell/MySpell base |
| an | Aragonese | an.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| ar | Arabic | ar.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Ayaspell; tri-licensed; using MPL-1.1 |
| as | Assamese | as.marisa.zst | GPL-3.0-only | https://www.gnu.org/licenses/gpl-3.0.txt | Lachit |
| be | Belarusian | be.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Includes Belarusian Grammar DB |
| bg | Bulgarian | bg.marisa.zst | GPL-2.0 | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| bn | Bengali | bn.marisa.zst | GPL-2.0 | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| br | Breton | br.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | An Drouizig |
| bs | Bosnian | bs.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| ca | Catalan | ca.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| cs | Czech | cs.marisa.zst | CC0-1.0 | https://creativecommons.org/publicdomain/zero/1.0/ | Czech CC0 dictionaries |
| da | Danish | da.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Stavekontrolden (tri-licensed) |
| de | German | de.marisa.zst | GPL-2.0 | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| el | Greek | el.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| en | English | en.marisa.zst | Various | TBA | SCOWL, WordNet 1.6, UKACD |
| eo | Esperanto | eo.marisa.zst | GPL-3.0 | https://www.gnu.org/licenses/gpl-3.0.txt | Hunspell |
| es | Spanish | es.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| et | Estonian | et.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| fa | Persian | fa.marisa.zst | Apache-2.0 | https://www.apache.org/licenses/LICENSE-2.0.txt | Lilak |
| fr | French | fr.marisa.zst | MPL-2.0 | https://www.mozilla.org/MPL/2.0/ | Grammalecte |
| gd | Scottish Gaelic | gd.marisa.zst | GPL-3.0-or-later | https://www.gnu.org/licenses/gpl-3.0.txt | Hunspell |
| gn | Guarani | gn.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| gu | Gujarati | gu_IN.marisa.zst | GPL (unspecified) | TBA | OpenOffice.org |
| he | Hebrew | he.marisa.zst | AGPL-3.0 | https://www.gnu.org/licenses/agpl-3.0.txt | from Hspell 1.4 |
| hi | Hindi | hi.marisa.zst | GPL-2.0-or-later | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | GNU Aspell |
| hr | Croatian | hr.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| id | Indonesian | id.marisa.zst | LGPL-3.0 | https://www.gnu.org/licenses/lgpl-3.0.txt | Hunspell |
| is | Icelandic | is.marisa.zst | Mixed | TBA | PD + CC BY-SA 3.0 + CC BY 4.0 |
| it | Italian | it.marisa.zst | GPL-3.0-only | https://www.gnu.org/licenses/gpl-3.0.txt | Italian Writing Aids |
| ja | Japanese | ja.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| kmr | Kurmanji Kurdish | kmr.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| kn | Kannada | kn.marisa.zst | GPL-2.0+ | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| ku | Central Kurdish | ku.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| lo | Lao | lo.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | Hunspell |
| lt | Lithuanian | lt.marisa.zst | BSD-3-Clause | https://opensource.org/license/bsd-3-clause/ | ispell-lt |
| lv | Latvian | lv.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | Hunspell |
| mr | Marathi | mr.marisa.zst | GPL-2.0 | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| nb | Norwegian Bokmål | nb.marisa.zst | GPL-2.0-or-later | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | spell-norwegian |
| nn | Norwegian Nynorsk | nn.marisa.zst | GPL-2.0-or-later | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | spell-norwegian |
| ne | Nepali | ne.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | MPP 1.1 |
| nl | Dutch | nl.marisa.zst | BSD-3-Clause | https://opensource.org/license/bsd-3-clause/ | OpenTaal 2.10G |
| oc | Occitan | oc.marisa.zst | GPL-2.0-or-later | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| or | Odia | or.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| pa | Punjabi | pa.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| pl | Polish | pl.marisa.zst | Apache-2.0 | https://www.apache.org/licenses/LICENSE-2.0.txt | Multi-licensed; using Apache-2.0 |
| pt | Portuguese | pt.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| ro | Romanian | ro.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| ru | Russian | ru.marisa.zst | BSD-3-Clause-like | TBA | Lebedev list; mod. Németh |
| sa | Sanskrit | sa.marisa.zst | CC BY-SA 4.0 | https://creativecommons.org/licenses/by-sa/4.0/ | Kaikki.org derived |
| si | Sinhala | si.marisa.zst | GPL-3.0-or-later | https://www.gnu.org/licenses/gpl-3.0.txt | Hunspell |
| sk | Slovak | sk.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Tri-licensed; using MPL-1.1 |
| sl | Slovenian | sl.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | Hunspell |
| sq | Albanian | sq.marisa.zst | GPL-2.0-or-later | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| sr | Serbian (Cyr/Latn) | sr.marisa.zst | MPL-2.0 | https://www.mozilla.org/MPL/2.0/ | Tri-licensed; using MPL-2.0 |
| sv | Swedish | sv.marisa.zst | LGPL-3.0-only | https://www.gnu.org/licenses/lgpl-3.0.txt | Hunspell |
| sw | Swahili | sw.marisa.zst | LGPL-2.1 | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | Hunspell |
| ta | Tamil | ta.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Hunspell |
| te | Telugu | te.marisa.zst | GPL-2.0-or-later | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
| th | Thai | th.marisa.zst | LGPL-2.1-or-later | https://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt | Hunspell |
| tr | Turkish | tr.marisa.zst | MIT | https://opensource.org/license/mit/ | Harun Reşit Zafer list |
| uk | Ukrainian | uk.marisa.zst | MPL-1.1 | https://www.mozilla.org/MPL/1.1/ | Hunspell |
| vi | Vietnamese | vi.marisa.zst | GPL-2.0-only | https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt | Hunspell |
