# SPDX-FileCopyrightText: 2024–2025 Mattia Rubino
# SPDX-License-Identifier: AGPL-3.0-or-later

from typing import Any, Dict


REMOTE_BASE = "https://raw.githubusercontent.com/textwizard-dev/textwizard/main/corpus/dictionaries"


LANG_INFO: Dict[str, Dict[str, Any]] = {
    "af": {"name": "Afrikaans", "dict_file": "af.marisa.zst"},
    "an": {"name": "Aragonese", "dict_file": "an.marisa.zst"},
    "ar": {"name": "Arabic", "dict_file": "ar.marisa.zst"},
    "as": {"name": "Assamese", "dict_file": "as.marisa.zst"},
    "be": {"name": "Belarusian", "dict_file": "be.marisa.zst"},
    "bg": {"name": "Bulgarian", "dict_file": "bg.marisa.zst"},
    "bn": {"name": "Bengali", "dict_file": "bn.marisa.zst"},
    "bo": {"name": "Tibetan", "dict_file": "bo.marisa.zst"},
    "br": {"name": "Breton", "dict_file": "br.marisa.zst"},
    "bs": {"name": "Bosnian", "dict_file": "bs.marisa.zst"},
    "ca": {"name": "Catalan", "dict_file": "ca.marisa.zst"},
    "cs": {"name": "Czech", "dict_file": "cs.marisa.zst"},
    "da": {"name": "Danish", "dict_file": "da.marisa.zst"},
    "de": {"name": "German", "dict_file": "de.marisa.zst"},
    "el": {"name": "Greek", "dict_file": "el.marisa.zst"},
    "en": {"name": "English", "dict_file": "en.marisa.zst"},
    "eo": {"name": "Esperanto", "dict_file": "eo.marisa.zst"},
    "es": {"name": "Spanish","dict_file": "es.marisa.zst"},
    "et": {"name": "Estonian", "dict_file": "et.marisa.zst"},
    "fa": {"name": "Persian", "dict_file": "fa.marisa.zst"},
    "fr": {"name": "French", "dict_file": "fr.marisa.zst"},
    "gd": {"name": "Scottish Gaelic", "dict_file": "gd.marisa.zst"},
    "gn": {"name": "Guarani", "dict_file": "gn.marisa.zst"},
    "gu": {"name": "Gujarati", "dict_file": "gu_IN.marisa.zst"},
    "he": {"name": "Hebrew", "dict_file": "he.marisa.zst"},
    "hi": {"name": "Hindi", "dict_file": "hi.marisa.zst"},
    "hr": {"name": "Croatian", "dict_file": "hr.marisa.zst"},
    "id": {"name": "Indonesian", "dict_file": "id.marisa.zst"},
    "is": {"name": "Icelandic", "dict_file": "is.marisa.zst"},
    "it": {"name": "Italian", "dict_file": "it.marisa.zst"},
    "ja": {"name": "Japanese", "dict_file": "ja.marisa.zst"},
    "kmr": {"name": "Kurmanji Kurdish", "dict_file": "kmr.marisa.zst"},
    "kn": {"name": "Kannada", "dict_file": "kn.marisa.zst"},
    "ku": {"name": "Central Kurdish", "dict_file": "ku.marisa.zst"},
    "lo": {"name": "Lao", "dict_file": "lo.marisa.zst"},
    "lt": {"name": "Lithuanian", "dict_file": "lt.marisa.zst"},
    "lv": {"name": "Latvian", "dict_file": "lv.marisa.zst"},
    "mr": {"name": "Marathi", "dict_file": "mr.marisa.zst"},
    "nb": {"name": "Norwegian Bokmål", "dict_file": "nb.marisa.zst"},
    "ne": {"name": "Nepali", "dict_file": "ne.marisa.zst"},
    "nl": {"name": "Dutch", "dict_file": "nl.marisa.zst"},
    "nn": {"name": "Norwegian Nynorsk", "dict_file": "nn.marisa.zst"},
    "oc": {"name": "Occitan", "dict_file": "oc.marisa.zst"},
    "or": {"name": "Odia", "dict_file": "or.marisa.zst"},
    "pa": {"name": "Punjabi", "dict_file": "pa.marisa.zst"},
    "pl": {"name": "Polish", "dict_file": "pl.marisa.zst"},
    "pt": {"name": "Portuguese", "dict_file": "pt.marisa.zst"},
    "ro": {"name": "Romanian", "dict_file": "ro.marisa.zst"},
    "ru": {"name": "Russian", "dict_file": "ru.marisa.zst"},
    "sa": {"name": "Sanskrit", "dict_file": "sa.marisa.zst"},
    "si": {"name": "Sinhala", "dict_file": "si.marisa.zst"},
    "sk": {"name": "Slovak", "dict_file": "sk.marisa.zst"},
    "sl": {"name": "Slovenian", "dict_file": "sl.marisa.zst"},
    "sq": {"name": "Albanian", "dict_file": "sq.marisa.zst"},
    "sr": {"name": "Serbian", "dict_file": "sr.marisa.zst"},
    "sv": {"name": "Swedish", "dict_file": "sv.marisa.zst"},
    "sw": {"name": "Swahili", "dict_file": "sw.marisa.zst"},
    "ta": {"name": "Tamil", "dict_file": "ta.marisa.zst"},
    "te": {"name": "Telugu", "dict_file": "te.marisa.zst"},
    "th": {"name": "Thai", "dict_file": "th.marisa.zst"},
    "tr": {"name": "Turkish", "dict_file": "tr.marisa.zst"},
    "uk": {"name": "Ukrainian", "dict_file": "uk.marisa.zst"},
    "vi": {"name": "Vietnamese", "dict_file": "vi.marisa.zst"},
}

