/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from "@aws-cdk/aws-lambda";
import * as sagemaker from "@aws-cdk/aws-sagemaker";
import * as iam from "@aws-cdk/aws-iam";
import { Construct } from "@aws-cdk/core";
import * as ec2 from "@aws-cdk/aws-ec2";
/**
 * @summary The properties for the LambdaToSagemaker Construct
 */
export interface LambdaToSagemakerProps {
    /**
     * Existing instance of Lambda Function object, if this is set then the lambdaFunctionProps is ignored.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function.
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly sagemakerNotebookProps?: sagemaker.CfnNotebookInstanceProps | any;
    /**
     * Optional user provided props to deploy inside vpc.
     *
     * @default - true
     */
    readonly deployInsideVpc?: boolean;
    /**
     * Existing instance of notebook object.
     *
     * If this is set then the sagemakerNotebookProps is ignored
     *
     * @default - None
     */
    readonly existingNotebookObj?: sagemaker.CfnNotebookInstance;
}
/**
 * @summary The LambdaToSagemaker class.
 */
export declare class LambdaToSagemaker extends Construct {
    readonly lambdaFunction: lambda.Function;
    readonly sagemakerNotebook: sagemaker.CfnNotebookInstance;
    readonly sagemakerRole: iam.Role;
    readonly vpc?: ec2.Vpc;
    readonly securityGroup?: ec2.SecurityGroup;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the LambdaToSagemaker class.
     * @since 1.69.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: LambdaToSagemakerProps);
}
