# Generated by Django 4.2.6 on 2023-10-06 22:56

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("artd_partner", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="NequiCredential",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Created at",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="Updated at", verbose_name="Updated at"
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True, help_text="Status", verbose_name="Status"
                    ),
                ),
                (
                    "client_id",
                    models.CharField(
                        help_text="Client ID", max_length=255, verbose_name="Client ID"
                    ),
                ),
                (
                    "client_secret",
                    models.CharField(
                        help_text="Client Secret",
                        max_length=255,
                        verbose_name="Client Secret",
                    ),
                ),
                (
                    "api_key",
                    models.CharField(
                        help_text="API Key", max_length=255, verbose_name="API Key"
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        unique=True,
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Nequi Credential",
                "verbose_name_plural": "Nequi Credentials",
            },
        ),
        migrations.CreateModel(
            name="NequiTransaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Created at",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, help_text="Updated at", verbose_name="Updated at"
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True, help_text="Status", verbose_name="Status"
                    ),
                ),
                (
                    "transaction_id",
                    models.CharField(
                        help_text="Transaction ID",
                        max_length=255,
                        verbose_name="Transaction ID",
                    ),
                ),
                (
                    "transaction_type",
                    models.CharField(
                        choices=[
                            ("PAYMENT", "PAYMENT"),
                            ("REVERSAL", "REVERSAL"),
                            ("REFUND", "REFUND"),
                            ("REVERSAL_REFUND", "REVERSAL_REFUND"),
                            ("REVERSAL_PAYMENT", "REVERSAL_PAYMENT"),
                            ("CANCEL", "CANCEL"),
                        ],
                        default="PAYMENT",
                        help_text="Transaction Type",
                        max_length=255,
                        verbose_name="Transaction Type",
                    ),
                ),
                (
                    "other_data",
                    models.JSONField(
                        blank=True,
                        help_text="Other Data",
                        null=True,
                        verbose_name="Other Data",
                    ),
                ),
                (
                    "nequi_credential",
                    models.ForeignKey(
                        help_text="Nequi Credential",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_nequi.nequicredential",
                        verbose_name="Nequi Credential",
                    ),
                ),
            ],
            options={
                "verbose_name": "Nequi Transaction",
                "verbose_name_plural": "Nequi Transactions",
            },
        ),
    ]
