"""Nasdaq Data Link Series ID Dictionaries."""

# pylint: disable=too-many-lines, line-too-long

SP500MULTIPLES = {
    "shiller_pe_month": "MULTPL/SHILLER_PE_RATIO_MONTH",
    "shiller_pe_year": "MULTPL/SHILLER_PE_RATIO_YEAR",
    "pe_year": "MULTPL/SP500_PE_RATIO_YEAR",
    "pe_month": "MULTPL/SP500_PE_RATIO_MONTH",
    "dividend_year": "MULTPL/SP500_DIV_YEAR",
    "dividend_month": "MULTPL/SP500_DIV_MONTH",
    "dividend_growth_quarter": "MULTPL/SP500_DIV_GROWTH_QUARTER",
    "dividend_growth_year": "MULTPL/SP500_DIV_GROWTH_YEAR",
    "dividend_yield_year": "MULTPL/SP500_DIV_YIELD_YEAR",
    "dividend_yield_month": "MULTPL/SP500_DIV_YIELD_MONTH",
    "earnings_year": "MULTPL/SP500_EARNINGS_YEAR",
    "earnings_month": "MULTPL/SP500_EARNINGS_MONTH",
    "earnings_growth_year": "MULTPL/SP500_EARNINGS_GROWTH_YEAR",
    "earnings_growth_quarter": "MULTPL/SP500_EARNINGS_GROWTH_QUARTER",
    "real_earnings_growth_year": "MULTPL/SP500_REAL_EARNINGS_GROWTH_YEAR",
    "real_earnings_growth_quarter": "MULTPL/SP500_REAL_EARNINGS_GROWTH_QUARTER",
    "earnings_yield_year": "MULTPL/SP500_EARNINGS_YIELD_YEAR",
    "earnings_yield_month": "MULTPL/SP500_EARNINGS_YIELD_MONTH",
    "real_price_month": "MULTPL/SP500_REAL_PRICE_YEAR",
    "real_price_year": "MULTPL/SP500_REAL_PRICE_MONTH",
    "inflation_adjusted_price_year": "MULTPL/SP500_INFLADJ_YEAR",
    "inflation_adjusted_price_month": "MULTPL/SP500_INFLADJ_MONTH",
    "sales_year": "MULTPL/SP500_SALES_YEAR",
    "sales_quarter": "MULTPL/SP500_SALES_QUARTER",
    "sales_growth_year": "MULTPL/SP500_SALES_GROWTH_YEAR",
    "sales_growth_quarter": "MULTPL/SP500_SALES_GROWTH_Quarter",
    "real_sales_year": "MULTPL/SP500_REAL_SALES_YEAR",
    "real_sales_quarter": "MULTPL/SP500_REAL_SALES_QUARTER",
    "real_sales_growth_year": "MULTPL/SP500_REAL_SALES_GROWTH_YEAR",
    "real_sales_growth_quarter": "MULTPL/SP500_REAL_SALES_GROWTH_QUARTER",
    "price_to_sales_year": "MULTPL/SP500_PSR_YEAR",
    "price_to_sales_quarter": "MULTPL/SP500_PSR_QUARTER",
    "price_to_book_value_year": "MULTPL/SP500_PBV_RATIO_YEAR",
    "price_to_book_value_quarter": "MULTPL/SP500_PBV_RATIO_QUARTER",
    "book_value_year": "MULTPL/SP500_BVPS_YEAR",
    "book_value_quarter": "MULTPL/SP500_BVPS_QUARTER",
}

CFTC = {
    "098662": {
        "Name": "USD Index (ICUS)",
        "Category": "Currencies",
        "Subcategory": "US Dollar Index",
        "Units": "U.S. Dollar Index x $1000",
        "Code": "098662",
        "Symbol": "DX=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=098662",
        "Specs": "https://www.theice.com/products/194/US-Dollar-Index-Futures",
    },
    "045601": {
        "Name": "Fed Funds (CBT)",
        "Category": "Interest",
        "Subcategory": "Treasuries",
        "Units": "Contracts of $5,000,000",
        "Code": "045601",
        "Symbol": "ZQ=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=045601",
        "Specs": "https://www.cmegroup.com/markets/interest-rates/stirs/30-day-federal-fund.contractSpecs.html",
    },
    "020604": {
        "Name": "Ultra US Treasury Bond (CBT)",
        "Category": "Interest",
        "Subcategory": "Treasuries",
        "Units": "Contracts of $100,000",
        "Code": "020604",
        "Symbol": "UB=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=020604",
        "Specs": "https://www.cmegroup.com/markets/interest-rates/us-treasury/ultra-t-bond.contractSpecs.options.html",
    },
    "042601": {
        "Name": "Two-Year Treasury Note Futures (CBT)",
        "Category": "Interest",
        "Subcategory": "Treasuries",
        "Units": "Contracts of $200,000 Face Value",
        "Code": "042601",
        "Symbol": "ZT=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=042601",
        "Specs": "https://www.cmegroup.com/markets/interest-rates/us-treasury/2-year-us-treasury-note.contractSpecs.html",
    },
    "044601": {
        "Name": "Five-Year Treasury Note Futures (CBT)",
        "Category": "Interest",
        "Subcategory": "Treasuries",
        "Units": "Contracts of $100,000 Face Value",
        "Code": "044601",
        "Symbol": "ZF=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=044601",
        "Specs": "https://www.cmegroup.com/markets/interest-rates/us-treasury/5-year-us-treasury-note.contractSpecs.html",
    },
    "043602": {
        "Name": "Ten-Year Treasury Note Futures (CBT)",
        "Category": "Interest",
        "Subcategory": "Treasuries",
        "Units": "Contracts of $100,000 Face Value",
        "Code": "043602",
        "Symbol": "ZN=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=043602",
        "Specs": "https://www.cmegroup.com/markets/interest-rates/us-treasury/10-year-us-treasury-note.contractSpecs.html",  # noqa
    },
    "043607": {
        "Name": "Ultra Ten-Year US Treasury Note (CBT)",
        "Category": "Interest",
        "Subcategory": "Treasuries",
        "Units": "Contracts of $100,000 Face Value",
        "Code": "043607",
        "Symbol": "TN=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=043607",
        "Specs": "https://www.cmegroup.com/markets/interest-rates/us-treasury/ultra-10-year-us-treasury-note.contractSpecs.html",  # noqa
    },
    "13874P": {
        "Name": "S&P 500 Consolidated (CME)",
        "Category": "Index",
        "Subcategory": "S&P 500",
        "Units": "S&P 500 Index X $250",
        "Code": "13874P",
        "Symbol": "^GSPC",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=13874P",
        "Specs": "https://www.cmegroup.com/trading/equity-index/us-index/sp-index-futures-and-options.html",
    },
    "13874N": {
        "Name": "S&P 500 Total Return Index (CME)",
        "Category": "Index",
        "Subcategory": "S&P 500",
        "Units": "S&P 500 Index X $25",
        "Code": "13874N",
        "Symbol": "^SP500TR",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=13874N",
        "Specs": "https://www.cmegroup.com/markets/equities/sp/sp-500-total-return.contractSpecs.html",
    },
    "13874W": {
        "Name": "AIR S&P 500 Total Return Index (CME)",
        "Category": "Index",
        "Subcategory": "S&P 500",
        "Units": "AIR S&P 500 Index X $25",
        "Code": "13874W",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=13874W",
        "Specs": "https://www.cmegroup.com/markets/equities/sp/adjusted-interest-rate-sp500-total-return.contractSpecs.html",  # noqa
    },
    "13874A": {
        "Name": "E-Mini S&P 500 Index (CME)",
        "Category": "Index",
        "Subcategory": "S&P 500",
        "Units": "S&P 500 Index X $50",
        "Code": "13874A",
        "Symbol": "ES=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=13874A",
        "Specs": "https://www.cmegroup.com/markets/equities/sp/e-mini-sandp500.contractSpecs.html",
    },
    "13874U": {
        "Name": "Micro E-Mini S&P 500 Index (CME)",
        "Category": "Index",
        "Subcategory": "S&P 500",
        "Units": "S&P 500 Index X $5",
        "Code": "13874U",
        "Symbol": "MES=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=13874U",
        "Specs": "https://www.cmegroup.com/markets/equities/sp/e-mini-sandp500.contractSpecs.html",
    },
    "20974P": {
        "Name": "NASDAQ 100 Consolidated (CME)",
        "Category": "Index",
        "Subcategory": "NASDAQ",
        "Units": "NASDAQ 100 Index X $100",
        "Code": "20974P",
        "Symbol": "^NDX",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=20974P",
        "Specs": "https://www.cmegroup.com/trading/equity-index/nasdaq-index-futures-and-options.html",
    },
    "209742": {
        "Name": "E-Mini NASDAQ 100 Index (CME)",
        "Category": "Index",
        "Subcategory": "NASDAQ",
        "Units": "NASDAQ 100 Index X $20",
        "Code": "209742",
        "Symbol": "NQ=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=209742",
        "Specs": "https://www.cmegroup.com/markets/equities/nasdaq/e-mini-nasdaq-100.contractSpecs.html",
    },
    "209747": {
        "Name": "Micro E-Mini NASDAQ 100 Index (CME)",
        "Category": "Index",
        "Subcategory": "NASDAQ",
        "Units": "NASDAQ 100 Index X $2",
        "Code": "209747",
        "Symbol": "MNQ=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=209747",
        "Specs": "https://www.cmegroup.com/markets/equities/nasdaq/micro-e-mini-nasdaq-100.contractSpecs.html",
    },
    "12460P": {
        "Name": "DJIA Consolidated (CBT)",
        "Category": "Index",
        "Subcategory": "Dow Jones",
        "Units": "Dow Jones Index X $10",
        "Code": "12460P",
        "Symbol": "^DJI",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=12460P",
        "Specs": "https://www.cmegroup.com/markets/products.html#assetClass=4&search=dow%20jones",
    },
    "124603": {
        "Name": "E-Mini Dow Jones (CBT)",
        "Category": "Index",
        "Subcategory": "Dow Jones",
        "Units": "Dow Jones Index X $5",
        "Code": "124603",
        "Symbol": "YM=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=124603",
        "Specs": "https://www.cmegroup.com/markets/equities/dow-jones/e-mini-dow.contractSpecs.html",
    },
    "124606": {
        "Name": "Dow Jones U.S. Real Estate Index (CBT)",
        "Category": "Index",
        "Subcategory": "Dow Jones",
        "Units": "DJ US Real Estate Index X $100",
        "Code": "124606",
        "Symbol": "RX=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=124606",
        "Specs": "https://www.cmegroup.com/markets/equities/dow-jones/dow-jones-rei.contractSpecs.html",
    },
    "239742": {
        "Name": "E-Mini Russell 2000 Index (CME)",
        "Category": "Index",
        "Subcategory": "Russell",
        "Units": "Russell 2000 Index X $50",
        "Code": "239742",
        "Symbol": "RTY=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=239742",
        "Specs": "https://www.cmegroup.com/markets/equities/russell/e-mini-russell-2000.contractSpecs.html",
    },
    "239744": {
        "Name": "E-Mini Russell 1000 Value Index (CME)",
        "Category": "Index",
        "Subcategory": "Russell",
        "Units": "Russell 1000 Value Index X $50",
        "Code": "239744",
        "Symbol": "RSV=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=239744",
        "Specs": "https://www.cmegroup.com/markets/equities/russell/e-mini-russell-1000-value-index.contractSpecs.html",
    },
    "1170E1": {
        "Name": "VIX Futures (CBOE)",
        "Category": "Index",
        "Subcategory": "VIX",
        "Units": "VIX Index X $1000",
        "Code": "1170E1",
        "Symbol": "^VIX",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=1170E1",
        "Specs": "https://www.cboe.com/tradable_products/vix/vix_futures/specifications/",
    },
    "221602": {
        "Name": "Bloomberg Commodity Index (CBT)",
        "Category": "Index",
        "Subcategory": "Commodities",
        "Units": "Index X $100",
        "Code": "221602",
        "Symbol": "AW=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=221602",
        "Specs": "https://www.cmegroup.com/markets/agriculture/commodity-indices/bloomberg-commodity-index.contractSpecs.html",  # noqa
    },
    "0233AN": {
        "Name": "Michon Financial Index",
        "Category": "Index",
        "Subcategory": "Commodities",
        "Units": "Contract size: 2500 MMBTus",
        "Code": "0233AN",
        "Symbol": "NGT=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=0233AN",
        "Specs": "https://www.theice.com/products/6590188/Michcon-Index-Future",
    },
    "02339Q": {
        "Name": "Chicago Citygate Index",
        "Category": "Energy",
        "Subcategory": "Natural Gas",
        "Units": "Contract size: 2500 MMBTus",
        "Code": "02339Q",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=02339Q",
        "Specs": "https://www.theice.com/products/6590179/Chicago-Index-Future",
    },
    "02339U": {
        "Name": "CIG Rockies Basis",
        "Category": "Energy",
        "Subcategory": "Natural Gas",
        "Units": "Contract size: 2500 MMBTus",
        "Code": "02339U",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=02339U",
        "Specs": "https://www.theice.com/products/6590129/CIG-Rockies-Basis-Future",
    },
    "0233A2": {
        "Name": "DOMINION SOUTH POINT",
        "Category": "Energy",
        "Subcategory": "Natural Gas",
        "Units": "Contract size: 2500 MMBTus",
        "Code": "0233A2",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=0233A2",
        "Specs": "https://www.theice.com/products/6590181/Eastern-Gas-South-Index-Future",
    },
    "244041": {
        "Name": "MSCI EAFE (ICUS)",
        "Category": "Index",
        "Subcategory": "MSCI",
        "Units": "MSCI EAFE Index Level X $50 USD",
        "Code": "244041",
        "Symbol": "MFS=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=244041",
        "Specs": "https://www.theice.com/products/31196848/MSCI-EAFE-Index-Future",
    },
    "244042": {
        "Name": "MSCI EM Index (ICUS)",
        "Category": "Index",
        "Subcategory": "MSCI",
        "Units": "MSCI Emerging Markets Index X $50 USD",
        "Code": "244042",
        "Symbol": "MME=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=244042",
        "Specs": "https://www.theice.com/products/31196851/MSCI-Emerging-Markets-Index-Future",
    },
    "0063DA": {
        "Name": "PA Solar Alternative Energy Credit Future (IFED)",
        "Category": "Energy",
        "Subcategory": "Renewables",
        "Units": "10 MWh representing 10 Qualifying SRECs",
        "Code": "0063DA",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=0063DA",
        "Specs": "https://www.theice.com/products/65898879/Pennsylvania-Solar-Alternative-Energy-Credit-Future",
    },
    "075651": {
        "Name": "Palladium Futures (NYME)",
        "Category": "Metals",
        "Subcategory": "Palladium",
        "Units": "Contracts of 100 Troy Ounces",
        "Code": "075651",
        "Symbol": "PA=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=075651",
        "Specs": "https://www.cmegroup.com/trading/metals/precious/palladium_contractSpecs_futures.html",
    },
    "076651": {
        "Name": "Platinum Futures (NYME)",
        "Category": "Metals",
        "Subcategory": "Platinum",
        "Units": "Contracts of 50 Troy Ounces",
        "Code": "076651",
        "Symbol": "PL=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=076651",
        "Specs": "https://www.cmegroup.com/trading/metals/precious/platinum_contractSpecs_futures.html",
    },
    "085692": {
        "Name": "Copper #1 Futures (CMX)",
        "Category": "Metals",
        "Subcategory": "Copper",
        "Units": "Contracts of 25,000 pounds",
        "Code": "085692",
        "Symbol": "HG=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=085692",
        "Specs": "https://www.cmegroup.com/markets/metals/base/copper.contractSpecs.html",
    },
    "191693": {
        "Name": "Aluminum MWP Futures (CMX)",
        "Category": "Metals",
        "Subcategory": "Aluminum",
        "Units": "Contracts of 25 Metric Tonnes (55,116 pounds)",
        "Code": "191693",
        "Symbol": "ALI=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=191693",
        "Specs": "https://www.cmegroup.com/markets/metals/base/aluminum.contractSpecs.html",
    },
    "088691": {
        "Name": "Gold Futures (CMX)",
        "Category": "Metals",
        "Subcategory": "Gold",
        "Units": "Contracts of 100 Troy Ounces",
        "Code": "088691",
        "Symbol": "GC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=088691",
        "Specs": "https://www.cmegroup.com/markets/metals/precious/gold.contractSpecs.html",
    },
    "088695": {
        "Name": "Micro Gold Futures (CMX)",
        "Category": "Metals",
        "Subcategory": "Gold",
        "Units": "Contracts of 10 Troy Ounces",
        "Code": "088695",
        "Symbol": "MGC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=088695",
        "Specs": "https://www.cmegroup.com/markets/metals/precious/e-micro-gold.contractSpecs.html",
    },
    "084691": {
        "Name": "Silver Futures (CMX)",
        "Category": "Metals",
        "Subcategory": "Silver",
        "Units": "Contracts of 5,000 Troy Ounces",
        "Code": "084691",
        "Symbol": "SI=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=084691",
        "Specs": "https://www.cmegroup.com/markets/metals/precious/silver.contractSpecs.html",
    },
    "00665T": {
        "Name": "Mini-Silver Futures (ICUS)",
        "Category": "Metals",
        "Subcategory": "Silver",
        "Units": "Contracts of 1,000 Troy Ounces",
        "Code": "00665T",
        "Symbol": "YI=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=00665T",
        "Specs": "https://www.theice.com/products/31500923/Mini-Silver-Future",
    },
    "073732": {
        "Name": "Cocoa Futures (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "Cocoa",
        "Units": "Contracts of 10 Metric Tonnes",
        "Code": "073732",
        "Symbol": "CC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=073732",
        "Specs": "https://www.theice.com/products/7/Cocoa-Futures",
    },
    "135731": {
        "Name": "Canola Futures (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "Canola",
        "Units": "Contracts of 20 Metric Tonnes",
        "Code": "135731",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=135731",
        "Specs": "https://www.theice.com/products/251/Canola-Futures",
    },
    "058643": {
        "Name": "Random Length Lumber Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Lumber",
        "Units": "Contracts of 110,000 Board Feet",
        "Code": "058643",
        "Symbol": "LBS=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=058643",
        "Specs": "https://www.cmegroup.com/markets/agriculture/lumber-and-softs/random-length-lumber.contractSpecs.html",
    },
    "033661": {
        "Name": "Cotton #2 Futures (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "Cotton",
        "Units": "Contracts of 50,000 pounds",
        "Code": "033661",
        "Symbol": "CT=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=033661",
        "Specs": "https://www.theice.com/products/254/Cotton-No-2-Futures",
    },
    "040701": {
        "Name": "Frozen Concentrated Orange Juice Futures (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "OJ",
        "Units": "Contracts of 15,000 pounds",
        "Code": "040701",
        "Symbol": "OJ=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=040701",
        "Specs": "https://www.theice.com/products/30/FCOJ-A-Futures",
    },
    "083731": {
        "Name": "Coffee Futures (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "Coffee",
        "Units": "Contracts of 37,500 pounds",
        "Code": "083731",
        "Symbol": "KC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=083731",
        "Specs": "https://www.theice.com/products/15/Coffee-C-Futures",
    },
    "083736": {
        "Name": "Coffee Calendar Spread Options (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "Coffee",
        "Units": "Contracts of 37,500 pounds",
        "Code": "083736",
        "Symbol": "KC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=083736",
        "Specs": "https://www.theice.com/products/67445363/Coffee-C-1-Month-Calendar-Spread-Option",
    },
    "080732": {
        "Name": "Sugar #11 Futures (ICUS)",
        "Category": "Agriculture",
        "Subcategory": "Sugar",
        "Units": "Contracts of 112,000 pounds",
        "Code": "080732",
        "Symbol": "SF=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=080732",
        "Specs": "https://www.theice.com/products/23/Sugar-No-11-Futures",
    },
    "052645": {
        "Name": "Dry Whey Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Dairy",
        "Units": "Contracts of 44,000 pounds",
        "Code": "052645",
        "Symbol": "DY=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=052645",
        "Specs": "https://www.cmegroup.com/markets/agriculture/dairy/dry-whey.contractSpecs.html",
    },
    "005602": {
        "Name": "Soybeans Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Soy",
        "Units": "Contracts of 5,000 bushels",
        "Code": "005602",
        "Symbol": "ZS=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=005602",
        "Specs": "https://www.cmegroup.com/markets/agriculture/oilseeds/soybean.contractSpecs.html",
    },
    "005603": {
        "Name": "Mini Soybeans Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Soy",
        "Units": "Contracts of 1,000 bushels",
        "Code": "005603",
        "Symbol": "XK=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=005603",
        "Specs": "https://www.cmegroup.com/markets/agriculture/oilseeds/mini-sized-soybean.contractSpecs.html",
    },
    "026603": {
        "Name": "Soybean Meal Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Soy",
        "Units": "Contracts of 100 short tons",
        "Code": "026603",
        "Symbol": "ZM=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=026603",
        "Specs": "https://www.cmegroup.com/markets/agriculture/oilseeds/soybean-meal.contractSpecs.html",
    },
    "256741": {
        "Name": "S&P GSCI Commodity Index Futures (CBT)",
        "Category": "Index",
        "Subcategory": "Commodities",
        "Units": "GSCI X $250",
        "Code": "256741",
        "Symbol": "GD=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=256741",
        "Specs": "https://www.cmegroup.com/markets/agriculture/commodity-indices/gsci.contractSpecs.html",
    },
    "007601": {
        "Name": "Soybean Oil Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Soy",
        "Units": "Contracts of 60,000 pounds",
        "Code": "007601",
        "Symbol": "ZL=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=007601",
        "Specs": "https://www.cmegroup.com/markets/agriculture/oilseeds/soybean-oil.contractSpecs.html",
    },
    "001612": {
        "Name": "Commitment of Traders - KC HRW Wheat Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Grains",
        "Units": "Contracts of 5,000 Bushels",
        "Code": "001612",
        "Symbol": "KE=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=001612",
        "Specs": "https://www.cmegroup.com/markets/agriculture/grains/kc-wheat.contractSpecs.html",
    },
    "001626": {
        "Name": "Commitment of Traders - KC HRSpring Wheat Futures (MGE)",
        "Category": "Agriculture",
        "Subcategory": "Grains",
        "Units": "Contracts of 5,000 Bushels",
        "Code": "001626",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=001626",
        "Specs": "https://www.mgex.com/quotes.html?j1_module=futureDetail&j1_symbol=MW%2A1&j1_region=US&j1_selected=futureProfile",  # noqa
    },
    "001602": {
        "Name": "Commitment of Traders - Chicago SRW Wheat Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Grains",
        "Units": "Contracts of 5,000 Bushels",
        "Code": "001602",
        "Symbol": "ZW=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=001602",
        "Specs": "https://www.cmegroup.com/markets/agriculture/grains/wheat.contractSpecs.html",
    },
    "004603": {
        "Name": "Oats Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Grains",
        "Units": "Contracts of 5,000 Bushels",
        "Code": "004603",
        "Symbol": "ZO=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=004603",
        "Specs": "https://www.cmegroup.com/markets/agriculture/grains/oats.contractSpecs.html",
    },
    "039601": {
        "Name": "Rought Rice Futures (CBT)",
        "Category": "Agriculture",
        "Subcategory": "Grains",
        "Units": "Contracts of 200,000 pounds",
        "Code": "039601",
        "Symbol": "ZR=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=039601",
        "Specs": "https://www.cmegroup.com/markets/agriculture/grains/rough-rice.contractSpecs.html",
    },
    "054642": {
        "Name": "Lean Hog Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Meats",
        "Units": "Contracts of 40,000 Pounds",
        "Code": "054642",
        "Symbol": "HE=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=054642",
        "Specs": "https://www.cmegroup.com/markets/agriculture/livestock/lean-hogs.contractSpecs.html",
    },
    "057642": {
        "Name": "Live Cattle (CME)",
        "Category": "Agriculture",
        "Subcategory": "Meats",
        "Units": "Contracts of 40,000 Pounds",
        "Code": "057642",
        "Symbol": "LE=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=057642",
        "Specs": "https://www.cmegroup.com/markets/agriculture/livestock/live-cattle.contractSpecs.html",
    },
    "061641": {
        "Name": "Feeder Cattle (CME)",
        "Category": "Agriculture",
        "Subcategory": "Meats",
        "Units": "Contracts of 50,000 Pounds",
        "Code": "061641",
        "Symbol": "GF=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=061641",
        "Specs": "https://www.cmegroup.com/markets/agriculture/livestock/feeder-cattle.contractSpecs.html",
    },
    "063642": {
        "Name": "Cash-Settled Cheese Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Dairy",
        "Units": "Contracts of 20,000 Pounds",
        "Code": "063642",
        "Symbol": "CSC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=",
        "Specs": "https://www.cmegroup.com/markets/agriculture/dairy/cheese.contractSpecs.html",
    },
    "052641": {
        "Name": "Class III Milk Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Dairy",
        "Units": "Contracts of 200,000 Pounds",
        "Code": "052641",
        "Symbol": "DC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=052641",
        "Specs": "https://www.cmegroup.com/markets/agriculture/dairy/class-iii-milk.contractSpecs.html",
    },
    "052644": {
        "Name": "Class IV Milk Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Dairy",
        "Units": "Contracts of 200,000 Pounds",
        "Code": "052644",
        "Symbol": "GDK=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=052644",
        "Specs": "https://www.cmegroup.com/markets/agriculture/dairy/class-iv-milk.contractSpecs.html",
    },
    "052642": {
        "Name": "Non Fat Dry Milk Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Dairy",
        "Units": "Contracts of 44,000 Pounds",
        "Code": "052642",
        "Symbol": "GNF=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=052642",
        "Specs": "https://www.cmegroup.com/markets/agriculture/dairy/nonfat-dry-milk.contractSpecs.html",
    },
    "050642": {
        "Name": "Cash-Settled Butter (CME)",
        "Category": "Agriculture",
        "Subcategory": "Dairy",
        "Units": "Contracts of 20,000 Pounds",
        "Code": "050642",
        "Symbol": "CB=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=050642",
        "Specs": "https://www.cmegroup.com/markets/agriculture/dairy/nonfat-dry-milk.contractSpecs.html",
    },
    "002602": {
        "Name": "Corn Futures (CME)",
        "Category": "Agriculture",
        "Subcategory": "Corn",
        "Units": "Contracts of 5,000 Bushels",
        "Code": "002602",
        "Symbol": "ZC=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=002602",
        "Specs": "https://www.cmegroup.com/markets/agriculture/grains/corn.contractSpecs.futures.html",
    },
    "03565B": {
        "Name": "Henry Hub Natural Gas Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Natural Gas",
        "Units": "Contracts of 2,500 MMBTU's",
        "Code": "03565B",
        "Symbol": "NG=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=03565B",
        "Specs": "https://www.cmegroup.com/markets/energy/natural-gas/natural-gas.contractSpecs.html",
    },
    "022651": {
        "Name": "NY Harbor ULSD Heating Oil Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 42,000 Gallons",
        "Code": "022651",
        "Symbol": "HO=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=022651",
        "Specs": "https://www.cmegroup.com/markets/energy/refined-products/heating-oil.contractSpecs.html",
    },
    "111659": {
        "Name": "RBOB Gasoline Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 42,000 Gallons",
        "Code": "111659",
        "Symbol": "RB=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=111659",
        "Specs": "https://www.cmegroup.com/markets/energy/refined-products/rbob-gasoline.contractSpecs.html",
    },
    "86665A": {
        "Name": "Naphta Crack Spread Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 1,000 Barrels ",
        "Code": "86665A",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=86665A",
        "Specs": "https://www.cmegroup.com/markets/energy/refined-products/european-naphtha-crack-spread-swap.contractSpecs.html",  # noqa
    },
    "06665T": {
        "Name": "Conway Propane Swap (OPIS) (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 42,000 Gallons",
        "Code": "06665T",
        "Symbol": "A8K",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06665T",
        "Specs": "https://www.cmegroup.com/markets/energy/petrochemicals/conway-propane-opis-swap.contractSpecs.html",
    },
    "067A71": {
        "Name": "WTI Midland (Argus) vs. WTI Trade Month Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "067A71",
        "Symbol": "WTT",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=067A71",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/wti-midland-argus-vs-wti-trade-month.contractSpecs.html",  # noqa
    },
    "0676A5": {
        "Name": "WTI Houston (Argus) vs. WTI Trade Month Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "0676A5",
        "Symbol": "HTT",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=0676A5",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/wti-houston-argus-vs-wti-trade-month.contractSpecs.html",  # noqa
    },
    "06765A": {
        "Name": "WTI Crude Oil Financial Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "06765A",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06765A",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/west-texas-intermediate-wti-crude-oil-calendar-swap-futures.contractSpecs.html",  # noqa
    },
    "067651": {
        "Name": "WTI Physical Settlement Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "067651",
        "Symbol": "CL=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=067651",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/light-sweet-crude.contractSpecs.html",
    },
    "06765T": {
        "Name": "Brent Last Day Financial Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "06765T",
        "Symbol": "BZ=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06765T",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/brent-crude-oil-last-day.contractSpecs.html",
    },
    "06765Z": {
        "Name": "WTI-Brent Spread Option Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "06765Z",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06765Z",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/wti-brent-ice-bullet-swap-futures.contractSpecs.html",
    },
    "299741": {
        "Name": "Euro FX/British Pound XRate Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "EUR/GBP",
        "Units": "Contracts of EUR 125,000",
        "Code": "299741",
        "Symbol": "RP=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=299741",
        "Specs": "https://www.cmegroup.com/markets/fx/cross-rates/euro-fx-british-pound.contractSpecs.html",
    },
    "097741": {
        "Name": "Japanese Yen Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/JPY",
        "Units": "Contracts of Contracts of JPY 12,500,000",
        "Code": "097741",
        "Symbol": "6J=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=097741",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/japanese-yen.contractSpecs.html",
    },
    "099741": {
        "Name": "Euro FX Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/EUR",
        "Units": "Contracts of EUR 125,000",
        "Code": "099741",
        "Symbol": "6E=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=099741",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/euro-fx.contractSpecs.html",
    },
    "090741": {
        "Name": "Canadian Dollar Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/CAD",
        "Units": "Contracts of CAD 100,000",
        "Code": "090741",
        "Symbol": "6C=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=090741",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/canadian-dollar.contractSpecs.html",
    },
    "096742": {
        "Name": "British Pound Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/GBP",
        "Units": "Contracts of GBP 62,500",
        "Code": "096742",
        "Symbol": "6B=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=096742",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/british-pound.contractSpecs.html",
    },
    "232741": {
        "Name": "Australian Dollar Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/AUD",
        "Units": "Contracts of AUD 100,000",
        "Code": "232741",
        "Symbol": "6A=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=232741",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/australian-dollar.contractSpecs.html",
    },
    "095741": {
        "Name": "Mexican Peso Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/MXY",
        "Units": "Contracts of 500,000 Mexican Pesos",
        "Code": "095741",
        "Symbol": "6M=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=095741",
        "Specs": "https://www.cmegroup.com/markets/fx/emerging-market/mexican-peso.contractSpecs.html",
    },
    "112741": {
        "Name": "New Zealand Dollar Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/NZD",
        "Units": "Contracts of NZD 100,000",
        "Code": "112741",
        "Symbol": "6N=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=112741",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/new-zealand-dollar.contractSpecs.html",
    },
    "092741": {
        "Name": "Swiss Franc Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/CHF",
        "Units": "Contracts of CHF 125,000",
        "Code": "092741",
        "Symbol": "6S=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=092741",
        "Specs": "https://www.cmegroup.com/markets/fx/g10/swiss-franc.contractSpecs.html",
    },
    "102741": {
        "Name": "Brazilian Real Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/BRL",
        "Units": "Contracts of BRL 100,000",
        "Code": "102741",
        "Symbol": "6L=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=102741",
        "Specs": "https://www.cmegroup.com/markets/fx/emerging-market/brazilian-real.contractSpecs.html",
    },
    "122741": {
        "Name": "South African Rand Futures (CME)",
        "Category": "Currencies",
        "Subcategory": "USD/ZAR",
        "Units": "Contracts of ZAR 500,000",
        "Code": "122741",
        "Symbol": "6Z=F",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=122741",
        "Specs": "https://www.cmegroup.com/markets/fx/emerging-market/south-african-rand.contractSpecs.html",
    },
    "021397": {
        "Name": "Marine Fuel Oil 0.5% FOB USGC Futures (IFED)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "021397",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=021397",
        "Specs": "https://www.theice.com/products/71085678/Fuel-Oil-Outright-Marine-Fuel-05-FOB-USGC-Barges-Platts-Future",  # noqa
    },
    "02141C": {
        "Name": "Fuel Oil -3% USGC vs. 3.5% FOB RDAM (IFED)",
        "Category": "Energy",
        "Subcategory": "Spread",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "02141B",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=02141C",
        "Specs": "https://www.theice.com/products/6753390/Fuel-Oil-Diff-USGC-HSFO-Platts-vs-Fuel-Oil-35-FOB-Rotterdam-Barges-Platts-Future-in-bbls",  # noqa
    },
    "02141B": {
        "Name": "USGC HSFO (Platts) Futures (IFED)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "02141B",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=02141B",
        "Specs": "https://www.theice.com/products/6753543/Fuel-Oil-Outright-USGC-HSFO-Platts-Future",
    },
    "02141R": {
        "Name": "USGC HSFO (Platts) vs. Brent 1st Line (IFED)",
        "Category": "Energy",
        "Subcategory": "Spread",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "02141R",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=02141R",
        "Specs": "https://www.theice.com/products/6753290/Fuel-Oil-Crack-USGC-HSFO-Platts-vs-Brent-1st-Line-Future",
    },
    "02165A": {
        "Name": "Gulf #6 Fuel 3.0% Sulfur Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "02165A",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=02165A",
        "Specs": "https://www.cmegroup.com/markets/energy/refined-products/gulf-coast-no-6-fuel-oil-30pct-sulfur-platts-swap.contractSpecs.html",  # noqa
    },
    "025608": {
        "Name": "Ethanol T2 FOB Futures Including Duty (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 100 Cubic Meters (EUR)",
        "Code": "025608",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=025608",
        "Specs": "https://www.cmegroup.com/markets/energy/biofuels/ethanol-platts-t2-fob-rotterdam-including-duty-swap-futures.contractSpecs.html",  # noqa
    },
    "025651": {
        "Name": "Ethanol Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 42,000 Gallons",
        "Code": "025651",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=025651",
        "Specs": "https://www.cmegroup.com/markets/energy/biofuels/new-york-ethanol-platts-swap.contractSpecs.html",
    },
    "03265J": {
        "Name": "Mini European Naphtha CIF NWE (Platts) Futures (NYM)",
        "Category": "Energy",
        "Subcategory": "Petroleum Products",
        "Units": "Contracts of 100 Metric Tons",
        "Code": "03265J",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=03265J",
        "Specs": "https://www.cmegroup.com/markets/energy/refined-products/mini-european-naphtha-platts-cif-nwe-swap-futures.contractSpecs.html",  # noqa
    },
    "06739C": {
        "Name": "Crude Diff Argus WCS vs. WTI 1st (IFED)",
        "Category": "Energy",
        "Subcategory": "Crude Oil",
        "Units": "Contracts of 42,000 Gallons",
        "Code": "06739C",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06739C",
        "Specs": "https://www.theice.com/products/67689141/Crude-Diff-Argus-WCS-Houston-Crude-Oil-Trade-Month-Future",
    },
    "067411": {
        "Name": "Light Sweet WTI Futures (ICEU)",
        "Category": "Energy",
        "Subcategory": "Crude Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "067411",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=067411",
        "Specs": "https://www.theice.com/products/213/WTI-Crude-Futures",
    },
    "06742T": {
        "Name": "Crude Diff - ICE SW 1A Index Futures (IFED)",
        "Category": "Energy",
        "Subcategory": "Crude Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "06742T",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06742T",
        "Specs": "https://www.theice.com/products/31687075/Crude-Diff-ICE-SW-1a-Index-Future",
    },
    "06742G": {
        "Name": "Crude Diff - ICE WCS 1A Index Futures (IFED)",
        "Category": "Energy",
        "Subcategory": "Crude Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "06742G",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06742G",
        "Specs": "https://www.theice.com/products/27066814/Crude-Diff-ICE-WCS-1A-Index-Future",
    },
    "06765C": {
        "Name": "Crude Oil Average Price Options Futres (NYM)",
        "Category": "Energy",
        "Subcategory": "Crude Oil",
        "Units": "Contracts of 1,000 Barrels",
        "Code": "06765C",
        "Symbol": "",
        "Permalink": "https://data.nasdaq.com/data/CFTC-commodity-futures-trading-commission-reports?keyword=06765C",
        "Specs": "https://www.cmegroup.com/markets/energy/crude-oil/west-texas-intermediate-wti-crude-oil-calendar-swap-futures.contractSpecs.options.html#optionProductId=2767",  # noqa
    },
}
