# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPromptScreenPartialsResult',
    'AwaitableGetPromptScreenPartialsResult',
    'get_prompt_screen_partials',
    'get_prompt_screen_partials_output',
]

@pulumi.output_type
class GetPromptScreenPartialsResult:
    """
    A collection of values returned by getPromptScreenPartials.
    """
    def __init__(__self__, id=None, prompt_type=None, screen_partials=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if prompt_type and not isinstance(prompt_type, str):
            raise TypeError("Expected argument 'prompt_type' to be a str")
        pulumi.set(__self__, "prompt_type", prompt_type)
        if screen_partials and not isinstance(screen_partials, list):
            raise TypeError("Expected argument 'screen_partials' to be a list")
        pulumi.set(__self__, "screen_partials", screen_partials)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> builtins.str:
        """
        The type of prompt to customize.
        """
        return pulumi.get(self, "prompt_type")

    @property
    @pulumi.getter(name="screenPartials")
    def screen_partials(self) -> Sequence['outputs.GetPromptScreenPartialsScreenPartialResult']:
        """
        The screen partials associated with the prompt type.
        """
        return pulumi.get(self, "screen_partials")


class AwaitableGetPromptScreenPartialsResult(GetPromptScreenPartialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPromptScreenPartialsResult(
            id=self.id,
            prompt_type=self.prompt_type,
            screen_partials=self.screen_partials)


def get_prompt_screen_partials(prompt_type: Optional[builtins.str] = None,
                               screen_partials: Optional[Sequence[Union['GetPromptScreenPartialsScreenPartialArgs', 'GetPromptScreenPartialsScreenPartialArgsDict']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPromptScreenPartialsResult:
    """
    Data source to retrieve a specific Auth0 prompt screen partials by `prompt_type`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    prompt_screen_partials = auth0.get_prompt_screen_partials(prompt_type="prompt-name")
    ```


    :param builtins.str prompt_type: The type of prompt to customize.
    :param Sequence[Union['GetPromptScreenPartialsScreenPartialArgs', 'GetPromptScreenPartialsScreenPartialArgsDict']] screen_partials: The screen partials associated with the prompt type.
    """
    __args__ = dict()
    __args__['promptType'] = prompt_type
    __args__['screenPartials'] = screen_partials
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getPromptScreenPartials:getPromptScreenPartials', __args__, opts=opts, typ=GetPromptScreenPartialsResult).value

    return AwaitableGetPromptScreenPartialsResult(
        id=pulumi.get(__ret__, 'id'),
        prompt_type=pulumi.get(__ret__, 'prompt_type'),
        screen_partials=pulumi.get(__ret__, 'screen_partials'))
def get_prompt_screen_partials_output(prompt_type: Optional[pulumi.Input[builtins.str]] = None,
                                      screen_partials: Optional[pulumi.Input[Optional[Sequence[Union['GetPromptScreenPartialsScreenPartialArgs', 'GetPromptScreenPartialsScreenPartialArgsDict']]]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPromptScreenPartialsResult]:
    """
    Data source to retrieve a specific Auth0 prompt screen partials by `prompt_type`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    prompt_screen_partials = auth0.get_prompt_screen_partials(prompt_type="prompt-name")
    ```


    :param builtins.str prompt_type: The type of prompt to customize.
    :param Sequence[Union['GetPromptScreenPartialsScreenPartialArgs', 'GetPromptScreenPartialsScreenPartialArgsDict']] screen_partials: The screen partials associated with the prompt type.
    """
    __args__ = dict()
    __args__['promptType'] = prompt_type
    __args__['screenPartials'] = screen_partials
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getPromptScreenPartials:getPromptScreenPartials', __args__, opts=opts, typ=GetPromptScreenPartialsResult)
    return __ret__.apply(lambda __response__: GetPromptScreenPartialsResult(
        id=pulumi.get(__response__, 'id'),
        prompt_type=pulumi.get(__response__, 'prompt_type'),
        screen_partials=pulumi.get(__response__, 'screen_partials')))
