# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserRolesArgs', 'UserRoles']

@pulumi.input_type
class UserRolesArgs:
    def __init__(__self__, *,
                 roles: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 user_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a UserRoles resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Set of IDs of roles assigned to the user.
        :param pulumi.Input[builtins.str] user_id: ID of the user.
        """
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Set of IDs of roles assigned to the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _UserRolesState:
    def __init__(__self__, *,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserRoles resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Set of IDs of roles assigned to the user.
        :param pulumi.Input[builtins.str] user_id: ID of the user.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of IDs of roles assigned to the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


class UserRoles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can manage assigned roles for a user.

        !> This resource manages all the roles assigned to a user. In contrast, the `UserRole` resource only appends a
        role to a user. To avoid potential issues, it is recommended not to use this resource in conjunction with the
        `UserRole` resource when managing roles for the same user id.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # Example:
        admin = auth0.Role("admin",
            name="admin",
            description="Administrator")
        user = auth0.User("user",
            connection_name="Username-Password-Authentication",
            username="unique_username",
            name="Firstname Lastname",
            email="test@test.com",
            password="passpass$12$12")
        user_roles = auth0.UserRoles("user_roles",
            user_id=user.id,
            roles=[admin.id])
        ```

        ## Import

        This resource can be imported using the user ID.

        Example:

        ```sh
        $ pulumi import auth0:index/userRoles:UserRoles user_roles "auth0|111111111111111111111111"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Set of IDs of roles assigned to the user.
        :param pulumi.Input[builtins.str] user_id: ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserRolesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage assigned roles for a user.

        !> This resource manages all the roles assigned to a user. In contrast, the `UserRole` resource only appends a
        role to a user. To avoid potential issues, it is recommended not to use this resource in conjunction with the
        `UserRole` resource when managing roles for the same user id.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # Example:
        admin = auth0.Role("admin",
            name="admin",
            description="Administrator")
        user = auth0.User("user",
            connection_name="Username-Password-Authentication",
            username="unique_username",
            name="Firstname Lastname",
            email="test@test.com",
            password="passpass$12$12")
        user_roles = auth0.UserRoles("user_roles",
            user_id=user.id,
            roles=[admin.id])
        ```

        ## Import

        This resource can be imported using the user ID.

        Example:

        ```sh
        $ pulumi import auth0:index/userRoles:UserRoles user_roles "auth0|111111111111111111111111"
        ```

        :param str resource_name: The name of the resource.
        :param UserRolesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserRolesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserRolesArgs.__new__(UserRolesArgs)

            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(UserRoles, __self__).__init__(
            'auth0:index/userRoles:UserRoles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            user_id: Optional[pulumi.Input[builtins.str]] = None) -> 'UserRoles':
        """
        Get an existing UserRoles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Set of IDs of roles assigned to the user.
        :param pulumi.Input[builtins.str] user_id: ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserRolesState.__new__(_UserRolesState)

        __props__.__dict__["roles"] = roles
        __props__.__dict__["user_id"] = user_id
        return UserRoles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Set of IDs of roles assigned to the user.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "user_id")

