# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[builtins.str] script: Code to be executed when the rule runs.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether the rule is enabled.
        :param pulumi.Input[builtins.str] name: Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        :param pulumi.Input[builtins.int] order: Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        """
        pulumi.set(__self__, "script", script)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[builtins.str]:
        """
        Code to be executed when the rule runs.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 script: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether the rule is enabled.
        :param pulumi.Input[builtins.str] name: Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        :param pulumi.Input[builtins.int] order: Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        :param pulumi.Input[builtins.str] script: Code to be executed when the rule runs.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Code to be executed when the rule runs.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 script: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        With Auth0, you can create custom Javascript snippets that run in a secure, isolated sandbox as part of your authentication pipeline, which are otherwise known as rules. This resource allows you to create and manage rules. You can create global variable for use with rules by using the `RuleConfig` resource.

        !> This resource is deprecated. Refer to the [guide on how to migrate from rules to actions](https://auth0.com/docs/customize/actions/migrate/migrate-from-rules-to-actions) and manage your actions using the `Action` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_rule = auth0.Rule("my_rule",
            name="empty-rule",
            script=\"\"\"    function (user, context, callback) {
              callback(null, user, context);
            }
        \"\"\",
            enabled=True)
        ```

        ## Import

        Existing rules can be imported using their ID.

        Example:

        ```sh
        $ pulumi import auth0:index/rule:Rule my_rule "rul_XXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether the rule is enabled.
        :param pulumi.Input[builtins.str] name: Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        :param pulumi.Input[builtins.int] order: Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        :param pulumi.Input[builtins.str] script: Code to be executed when the rule runs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With Auth0, you can create custom Javascript snippets that run in a secure, isolated sandbox as part of your authentication pipeline, which are otherwise known as rules. This resource allows you to create and manage rules. You can create global variable for use with rules by using the `RuleConfig` resource.

        !> This resource is deprecated. Refer to the [guide on how to migrate from rules to actions](https://auth0.com/docs/customize/actions/migrate/migrate-from-rules-to-actions) and manage your actions using the `Action` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_rule = auth0.Rule("my_rule",
            name="empty-rule",
            script=\"\"\"    function (user, context, callback) {
              callback(null, user, context);
            }
        \"\"\",
            enabled=True)
        ```

        ## Import

        Existing rules can be imported using their ID.

        Example:

        ```sh
        $ pulumi import auth0:index/rule:Rule my_rule "rul_XXXXXXXXXXXXX"
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 script: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["order"] = order
            if script is None and not opts.urn:
                raise TypeError("Missing required property 'script'")
            __props__.__dict__["script"] = script
        super(Rule, __self__).__init__(
            'auth0:index/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            order: Optional[pulumi.Input[builtins.int]] = None,
            script: Optional[pulumi.Input[builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether the rule is enabled.
        :param pulumi.Input[builtins.str] name: Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        :param pulumi.Input[builtins.int] order: Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        :param pulumi.Input[builtins.str] script: Code to be executed when the rule runs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["order"] = order
        __props__.__dict__["script"] = script
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the rule. May only contain alphanumeric characters, spaces, and hyphens. May neither start nor end with hyphens or spaces.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> pulumi.Output[builtins.int]:
        """
        Order in which the rule executes relative to other rules. Lower-valued rules execute first.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output[builtins.str]:
        """
        Code to be executed when the rule runs.
        """
        return pulumi.get(self, "script")

