"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeServer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ocf = require("@open-constructs/aws-cdk");
const ec2 = require("aws-cdk-lib/aws-ec2");
const iam = require("aws-cdk-lib/aws-iam");
const cdk_preinstalled_amazon_linux_ec2_1 = require("cdk-preinstalled-amazon-linux-ec2");
const constructs_1 = require("constructs");
class CodeServer extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const vpc = props.vpc ?? new ec2.Vpc(this, 'Vpc', {
            maxAzs: 1,
            natGateways: 0,
            subnetConfiguration: [
                {
                    cidrMask: 26,
                    name: 'Public',
                    subnetType: ec2.SubnetType.PUBLIC,
                },
            ],
        });
        const instance = new cdk_preinstalled_amazon_linux_ec2_1.PreinstalledAmazonLinuxInstance(this, 'Instance', {
            vpc,
            instanceType: props.instanceType ?? ec2.InstanceType.of(ec2.InstanceClass.C7G, ec2.InstanceSize.XLARGE2),
            ssmSessionPermissions: true,
            blockDevices: [
                {
                    // Attach as a root device
                    deviceName: '/dev/xvda',
                    volume: ec2.BlockDeviceVolume.ebs(props.volumeSize ?? 30, {
                        deleteOnTermination: true,
                        encrypted: false,
                    }),
                },
            ],
            machineImage: new ec2.AmazonLinuxImage({
                generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2023,
                cpuType: props.cpuType ?? ec2.AmazonLinuxCpuType.ARM_64,
            }),
            vpcSubnets: {
                subnetType: ec2.SubnetType.PUBLIC,
            },
            preinstalledSoftware: {
                packages: [
                    cdk_preinstalled_amazon_linux_ec2_1.PreinstalledSoftwarePackage.NODEJS,
                    cdk_preinstalled_amazon_linux_ec2_1.PreinstalledSoftwarePackage.VSCODE,
                    cdk_preinstalled_amazon_linux_ec2_1.PreinstalledSoftwarePackage.GIT,
                ],
            },
        });
        instance.addUserData('npm install -g yarn', 
        // Install make and other build tools for setup of CDK
        "sudo dnf groupinstall -y 'Development Tools'", 
        // Increase memory for Node.js
        "echo 'export NODE_OPTIONS=--max-old-space-size=8192' >> /etc/profile.d/myenv.sh", 'chmod +x /etc/profile.d/myenv.sh', 
        // Enable linger for ec2-user to allow running services without a user logged in
        'sudo loginctl enable-linger ec2-user');
        instance.addToRolePolicy(props.policy ?? new iam.PolicyStatement({
            actions: ['*'],
            resources: ['*'],
        }));
        const eicEndpoint = new ocf.aws_ec2.InstanceConnectEndpoint(this, 'InstanceConnectEndpoint', {
            vpc,
        });
        // Opening Security Group from EIC Endpoint to EC2 Instance
        eicEndpoint.connections.allowTo(instance, ec2.Port.tcp(22));
    }
}
exports.CodeServer = CodeServer;
_a = JSII_RTTI_SYMBOL_1;
CodeServer[_a] = { fqn: "cdk-code-server.CodeServer", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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