r'''
# CDK VSCode Server Construct

This is a CDK Construct for creating a VSCode server on an Amazon Linux EC2 instance.

[![View on Construct Hub](https://constructs.dev/badge?package=cdk-code-server)](https://constructs.dev/packages/cdk-code-server)

[![Open in Visual Studio Code](https://img.shields.io/static/v1?logo=visualstudiocode&label=&message=Open%20in%20Visual%20Studio%20Code&labelColor=2c2c32&color=007acc&logoColor=007acc)](https://open.vscode.dev/badmintoncryer/cdk-code-server)
[![npm version](https://badge.fury.io/js/cdk-code-server.svg)](https://badge.fury.io/js/cdk-code-server)
[![Build Status](https://github.com/badmintoncryer/cdk-code-server/actions/workflows/build.yml/badge.svg)](https://github.com/badmintoncryer/cdk-code-server/actions/workflows/build.yml)
[![Release Status](https://github.com/badmintoncryer/cdk-code-server/actions/workflows/release.yml/badge.svg)](https://github.com/badmintoncryer/cdk-code-server/actions/workflows/release.yml)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![npm downloads](https://img.shields.io/npm/dm/cdk-code-server.svg?style=flat)](https://www.npmjs.com/package/cdk-code-server)

![CDK VSCode Server Construct](./images/code-server.png)

You can easily access Visual Studio Code Server through your browser and start development.

In the EC2 security group's inbound rules, communication from the Internet is not allowed, ensuring secure access to the VSCode server.
Additionally, by passing the IAM policy to be attached to the EC2 instance as a property, you can grant appropriate permissions for AWS access within VSCode.

## Usage

Install the package:

```bash
npm install cdk-code-server
```

Use it in your CDK stack:

```python
import { CodeServer } from 'cdk-code-server';

new CodeServer(this, 'CodeServer');
```

You can customize the instance type, vpc, and other properties:

```python
import { CodeServer } from 'cdk-code-server';
import * as ec2 from 'aws-cdk-lib/aws-ec2';

// Use an existing VPC
declare const vpc: ec2.IVpc;
// Use an existing policy as a instance role
declare const policy: iam.PolicyStatememnt;

new CodeServer(this, 'CodeServer', {
  vpc,
  // Specify the instance type
  // Default is c7g.2xlarge
  instanceType: ec2.InstanceType.of(ec2.InstanceClass.T3, ec2.InstanceSize.MEDIUM),
  // Specify the CPU architecture
  // Default is ec2.AmazonLinuxCpuType.ARM_64
  cpuType: ec2.AmazonLinuxCpuType.X86_64,
  // Specify the IAM policy for the instance role
  // Default is a policy that has an administrator access
  policy,
  // Specify the size of the EBS volume
  // Default is 30 GB
  volumeSize: 100,
});
```

## Setup VSCode Server

After the stack is deployed, you can access to the server via EC2 instance connect endpoint(EIC endpoint) and create connection to the VSCode server:

### Access to the EC2 instance

Access the EC2 management console in the AWS Console, and connect to your EC2 instance via the EIC Endpoint.

Select the Instance ID > Connect > EC2 Instance Connect > Connect using EC2 Instance Connect Endpoint > Connect

If the following screen is displayed, you're all set.

![EC2 Instance Connect](./images/console.png)

### Start the VSCode server

Execute the following command to start the VSCode server:

```sh
[ec2-user@ip-10-0-0-23 ~]$ code tunnel service install
[2024-06-10 02:10:42] info Using GitHub for authentication, run `code tunnel user login --provider <provider>` option to change this.
To grant access to the server, please log into https://github.com/login/device and use code 3811-9932
```

Next, open your browser and go to [https://github.com/login/device](https://github.com/login/device), enter the code, and complete the authentication.

In the example above, enter '3811-9932' > Continue > Continue > Authorize-Visual-Studio-Code.

Return to the EC2 instance, run the code tunnel again, and open the displayed URL [https://vscode.dev/tunnel/ip-{privateIp}{region}](https://vscode.dev/tunnel/ip-%7BprivateIp%7D%7Bregion%7D) in your browser.

```sh
[ec2-user@ip-10-0-0-23 ~]$ code tunnel
*
* Visual Studio Code Server
*
* By using the software, you agree to
* the Visual Studio Code Server License Terms (https://aka.ms/vscode-server-license) and
* the Microsoft Privacy Statement (https://privacy.microsoft.com/en-US/privacystatement).
*
[2024-06-10 02:11:44] info Creating tunnel with the name: ip-10-0-0-23ap-north
[2024-06-10 02:11:44] info Open this link in your browser https://vscode.dev/tunnel/ip-10-0-0-23ap-north

Connected to an existing tunnel process running on this machine.

Open this link in your browser https://vscode.dev/tunnel/ip-10-0-0-23ap-north
```

VSCode will open, and you'll be prompted with "What type of account did you use to start this tunnel?" Select `GitHub`.

At this point, the GitHub authentication screen may appear again, so press Authorize.

Once you open the terminal, you’re all set.

![VSCode](./images/vscode.png)
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import aws_cdk.aws_ec2 as _aws_cdk_aws_ec2_ceddda9d
import aws_cdk.aws_iam as _aws_cdk_aws_iam_ceddda9d
import constructs as _constructs_77d1e7e8


class CodeServer(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-code-server.CodeServer",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        cpu_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.AmazonLinuxCpuType] = None,
        instance_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.InstanceType] = None,
        policy: typing.Optional[_aws_cdk_aws_iam_ceddda9d.PolicyStatement] = None,
        volume_size: typing.Optional[jsii.Number] = None,
        vpc: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.IVpc] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param cpu_type: 
        :param instance_type: 
        :param policy: 
        :param volume_size: 
        :param vpc: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a3dc073ef85aeeab8ffd2fe5c32c737ce76d0e4197f8d84ff2cfe4d4ae5bf187)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CodeServerProps(
            cpu_type=cpu_type,
            instance_type=instance_type,
            policy=policy,
            volume_size=volume_size,
            vpc=vpc,
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk-code-server.CodeServerProps",
    jsii_struct_bases=[],
    name_mapping={
        "cpu_type": "cpuType",
        "instance_type": "instanceType",
        "policy": "policy",
        "volume_size": "volumeSize",
        "vpc": "vpc",
    },
)
class CodeServerProps:
    def __init__(
        self,
        *,
        cpu_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.AmazonLinuxCpuType] = None,
        instance_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.InstanceType] = None,
        policy: typing.Optional[_aws_cdk_aws_iam_ceddda9d.PolicyStatement] = None,
        volume_size: typing.Optional[jsii.Number] = None,
        vpc: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.IVpc] = None,
    ) -> None:
        '''
        :param cpu_type: 
        :param instance_type: 
        :param policy: 
        :param volume_size: 
        :param vpc: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb583e2cef71433ccfaa187bf48195bf7085ded509b20a2c01dc80cffe3f0229)
            check_type(argname="argument cpu_type", value=cpu_type, expected_type=type_hints["cpu_type"])
            check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
            check_type(argname="argument policy", value=policy, expected_type=type_hints["policy"])
            check_type(argname="argument volume_size", value=volume_size, expected_type=type_hints["volume_size"])
            check_type(argname="argument vpc", value=vpc, expected_type=type_hints["vpc"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if cpu_type is not None:
            self._values["cpu_type"] = cpu_type
        if instance_type is not None:
            self._values["instance_type"] = instance_type
        if policy is not None:
            self._values["policy"] = policy
        if volume_size is not None:
            self._values["volume_size"] = volume_size
        if vpc is not None:
            self._values["vpc"] = vpc

    @builtins.property
    def cpu_type(self) -> typing.Optional[_aws_cdk_aws_ec2_ceddda9d.AmazonLinuxCpuType]:
        result = self._values.get("cpu_type")
        return typing.cast(typing.Optional[_aws_cdk_aws_ec2_ceddda9d.AmazonLinuxCpuType], result)

    @builtins.property
    def instance_type(self) -> typing.Optional[_aws_cdk_aws_ec2_ceddda9d.InstanceType]:
        result = self._values.get("instance_type")
        return typing.cast(typing.Optional[_aws_cdk_aws_ec2_ceddda9d.InstanceType], result)

    @builtins.property
    def policy(self) -> typing.Optional[_aws_cdk_aws_iam_ceddda9d.PolicyStatement]:
        result = self._values.get("policy")
        return typing.cast(typing.Optional[_aws_cdk_aws_iam_ceddda9d.PolicyStatement], result)

    @builtins.property
    def volume_size(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("volume_size")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def vpc(self) -> typing.Optional[_aws_cdk_aws_ec2_ceddda9d.IVpc]:
        result = self._values.get("vpc")
        return typing.cast(typing.Optional[_aws_cdk_aws_ec2_ceddda9d.IVpc], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CodeServerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "CodeServer",
    "CodeServerProps",
]

publication.publish()

def _typecheckingstub__a3dc073ef85aeeab8ffd2fe5c32c737ce76d0e4197f8d84ff2cfe4d4ae5bf187(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    cpu_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.AmazonLinuxCpuType] = None,
    instance_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.InstanceType] = None,
    policy: typing.Optional[_aws_cdk_aws_iam_ceddda9d.PolicyStatement] = None,
    volume_size: typing.Optional[jsii.Number] = None,
    vpc: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.IVpc] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__fb583e2cef71433ccfaa187bf48195bf7085ded509b20a2c01dc80cffe3f0229(
    *,
    cpu_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.AmazonLinuxCpuType] = None,
    instance_type: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.InstanceType] = None,
    policy: typing.Optional[_aws_cdk_aws_iam_ceddda9d.PolicyStatement] = None,
    volume_size: typing.Optional[jsii.Number] = None,
    vpc: typing.Optional[_aws_cdk_aws_ec2_ceddda9d.IVpc] = None,
) -> None:
    """Type checking stubs"""
    pass
