# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FormArgs', 'Form']

@pulumi.input_type
class FormArgs:
    def __init__(__self__, *,
                 ending: Optional[pulumi.Input[builtins.str]] = None,
                 languages: Optional[pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[builtins.str]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 style: Optional[pulumi.Input[builtins.str]] = None,
                 translations: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Form resource.
        :param pulumi.Input[builtins.str] ending: Submission configuration of the form. (JSON encoded)
        :param pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]] languages: Language specific configuration for the form.
        :param pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]] messages: Message specific configuration for the form.
        :param pulumi.Input[builtins.str] name: Name of the form.
        :param pulumi.Input[builtins.str] nodes: Nodes of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] start: Input setup of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] style: Style specific configuration for the form. (JSON encoded)
        :param pulumi.Input[builtins.str] translations: Translations of the form. (JSON encoded)
        """
        if ending is not None:
            pulumi.set(__self__, "ending", ending)
        if languages is not None:
            pulumi.set(__self__, "languages", languages)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if style is not None:
            pulumi.set(__self__, "style", style)
        if translations is not None:
            pulumi.set(__self__, "translations", translations)

    @property
    @pulumi.getter
    def ending(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Submission configuration of the form. (JSON encoded)
        """
        return pulumi.get(self, "ending")

    @ending.setter
    def ending(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ending", value)

    @property
    @pulumi.getter
    def languages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]]]:
        """
        Language specific configuration for the form.
        """
        return pulumi.get(self, "languages")

    @languages.setter
    def languages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]]]):
        pulumi.set(self, "languages", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]]]:
        """
        Message specific configuration for the form.
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the form.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Nodes of the form. (JSON encoded)
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input setup of the form. (JSON encoded)
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def style(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Style specific configuration for the form. (JSON encoded)
        """
        return pulumi.get(self, "style")

    @style.setter
    def style(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "style", value)

    @property
    @pulumi.getter
    def translations(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Translations of the form. (JSON encoded)
        """
        return pulumi.get(self, "translations")

    @translations.setter
    def translations(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "translations", value)


@pulumi.input_type
class _FormState:
    def __init__(__self__, *,
                 ending: Optional[pulumi.Input[builtins.str]] = None,
                 languages: Optional[pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[builtins.str]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 style: Optional[pulumi.Input[builtins.str]] = None,
                 translations: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Form resources.
        :param pulumi.Input[builtins.str] ending: Submission configuration of the form. (JSON encoded)
        :param pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]] languages: Language specific configuration for the form.
        :param pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]] messages: Message specific configuration for the form.
        :param pulumi.Input[builtins.str] name: Name of the form.
        :param pulumi.Input[builtins.str] nodes: Nodes of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] start: Input setup of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] style: Style specific configuration for the form. (JSON encoded)
        :param pulumi.Input[builtins.str] translations: Translations of the form. (JSON encoded)
        """
        if ending is not None:
            pulumi.set(__self__, "ending", ending)
        if languages is not None:
            pulumi.set(__self__, "languages", languages)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if style is not None:
            pulumi.set(__self__, "style", style)
        if translations is not None:
            pulumi.set(__self__, "translations", translations)

    @property
    @pulumi.getter
    def ending(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Submission configuration of the form. (JSON encoded)
        """
        return pulumi.get(self, "ending")

    @ending.setter
    def ending(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ending", value)

    @property
    @pulumi.getter
    def languages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]]]:
        """
        Language specific configuration for the form.
        """
        return pulumi.get(self, "languages")

    @languages.setter
    def languages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FormLanguageArgs']]]]):
        pulumi.set(self, "languages", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]]]:
        """
        Message specific configuration for the form.
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FormMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the form.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Nodes of the form. (JSON encoded)
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input setup of the form. (JSON encoded)
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def style(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Style specific configuration for the form. (JSON encoded)
        """
        return pulumi.get(self, "style")

    @style.setter
    def style(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "style", value)

    @property
    @pulumi.getter
    def translations(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Translations of the form. (JSON encoded)
        """
        return pulumi.get(self, "translations")

    @translations.setter
    def translations(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "translations", value)


@pulumi.type_token("auth0:index/form:Form")
class Form(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ending: Optional[pulumi.Input[builtins.str]] = None,
                 languages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormLanguageArgs', 'FormLanguageArgsDict']]]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormMessageArgs', 'FormMessageArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[builtins.str]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 style: Optional[pulumi.Input[builtins.str]] = None,
                 translations: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        With this resource, you can create and manage Forms for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # Example:
        my_form = auth0.Form("my_form",
            name="My KYC Form",
            start=json.dumps({
                "coordinates": {
                    "x": 0,
                    "y": 0,
                },
                "next_node": "step_ggeX",
            }),
            nodes=json.dumps([{
                "alias": "New step",
                "config": {
                    "components": [
                        {
                            "category": "FIELD",
                            "config": {
                                "max_length": 50,
                                "min_length": 1,
                                "multiline": False,
                            },
                            "id": "full_name",
                            "label": "Your Name",
                            "required": True,
                            "sensitive": False,
                            "type": "TEXT",
                        },
                        {
                            "category": "BLOCK",
                            "config": {
                                "text": "Continue",
                            },
                            "id": "next_button_3FbA",
                            "type": "NEXT_BUTTON",
                        },
                    ],
                    "next_node": "$ending",
                },
                "coordinates": {
                    "x": 500,
                    "y": 0,
                },
                "id": "step_ggeX",
                "type": "STEP",
            }]),
            ending=json.dumps({
                "after_submit": {
                    "flow_id": "<my_flow_id>",
                },
                "coordinates": {
                    "x": 1250,
                    "y": 0,
                },
                "resume_flow": True,
            }),
            style=json.dumps({
                "css": \"\"\"h1 {
          color: white;
          text-align: center;
        }\"\"\",
            }),
            translations=json.dumps({
                "es": {
                    "components": {
                        "rich_text_uctu": {
                            "config": {
                                "content": "<h2>Help us verify your personal information</h2><p>We want to learn more about you so that we can validate and protect your account...</p>",
                            },
                        },
                    },
                    "messages": {
                        "custom": {},
                        "errors": {
                            "ERR_ACCEPTANCE_REQUIRED": "Por favor, marca este campo para continuar.",
                        },
                    },
                },
            }),
            messages=[{
                "errors": json.dumps({
                    "ERR_REQUIRED_PROPERTY": "This field is required for user kyc.",
                }),
            }],
            languages=[{
                "default": "en",
                "primary": "en",
            }])
        ```

        ## Import

        This resource can be imported using the form ID.

        Example:

        ```sh
        $ pulumi import auth0:index/form:Form my_form "ap_ojkKbiPMG6J5E5VCKdeCzK"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ending: Submission configuration of the form. (JSON encoded)
        :param pulumi.Input[Sequence[pulumi.Input[Union['FormLanguageArgs', 'FormLanguageArgsDict']]]] languages: Language specific configuration for the form.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FormMessageArgs', 'FormMessageArgsDict']]]] messages: Message specific configuration for the form.
        :param pulumi.Input[builtins.str] name: Name of the form.
        :param pulumi.Input[builtins.str] nodes: Nodes of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] start: Input setup of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] style: Style specific configuration for the form. (JSON encoded)
        :param pulumi.Input[builtins.str] translations: Translations of the form. (JSON encoded)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FormArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can create and manage Forms for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_auth0 as auth0

        # Example:
        my_form = auth0.Form("my_form",
            name="My KYC Form",
            start=json.dumps({
                "coordinates": {
                    "x": 0,
                    "y": 0,
                },
                "next_node": "step_ggeX",
            }),
            nodes=json.dumps([{
                "alias": "New step",
                "config": {
                    "components": [
                        {
                            "category": "FIELD",
                            "config": {
                                "max_length": 50,
                                "min_length": 1,
                                "multiline": False,
                            },
                            "id": "full_name",
                            "label": "Your Name",
                            "required": True,
                            "sensitive": False,
                            "type": "TEXT",
                        },
                        {
                            "category": "BLOCK",
                            "config": {
                                "text": "Continue",
                            },
                            "id": "next_button_3FbA",
                            "type": "NEXT_BUTTON",
                        },
                    ],
                    "next_node": "$ending",
                },
                "coordinates": {
                    "x": 500,
                    "y": 0,
                },
                "id": "step_ggeX",
                "type": "STEP",
            }]),
            ending=json.dumps({
                "after_submit": {
                    "flow_id": "<my_flow_id>",
                },
                "coordinates": {
                    "x": 1250,
                    "y": 0,
                },
                "resume_flow": True,
            }),
            style=json.dumps({
                "css": \"\"\"h1 {
          color: white;
          text-align: center;
        }\"\"\",
            }),
            translations=json.dumps({
                "es": {
                    "components": {
                        "rich_text_uctu": {
                            "config": {
                                "content": "<h2>Help us verify your personal information</h2><p>We want to learn more about you so that we can validate and protect your account...</p>",
                            },
                        },
                    },
                    "messages": {
                        "custom": {},
                        "errors": {
                            "ERR_ACCEPTANCE_REQUIRED": "Por favor, marca este campo para continuar.",
                        },
                    },
                },
            }),
            messages=[{
                "errors": json.dumps({
                    "ERR_REQUIRED_PROPERTY": "This field is required for user kyc.",
                }),
            }],
            languages=[{
                "default": "en",
                "primary": "en",
            }])
        ```

        ## Import

        This resource can be imported using the form ID.

        Example:

        ```sh
        $ pulumi import auth0:index/form:Form my_form "ap_ojkKbiPMG6J5E5VCKdeCzK"
        ```

        :param str resource_name: The name of the resource.
        :param FormArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FormArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ending: Optional[pulumi.Input[builtins.str]] = None,
                 languages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormLanguageArgs', 'FormLanguageArgsDict']]]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormMessageArgs', 'FormMessageArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[builtins.str]] = None,
                 start: Optional[pulumi.Input[builtins.str]] = None,
                 style: Optional[pulumi.Input[builtins.str]] = None,
                 translations: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FormArgs.__new__(FormArgs)

            __props__.__dict__["ending"] = ending
            __props__.__dict__["languages"] = languages
            __props__.__dict__["messages"] = messages
            __props__.__dict__["name"] = name
            __props__.__dict__["nodes"] = nodes
            __props__.__dict__["start"] = start
            __props__.__dict__["style"] = style
            __props__.__dict__["translations"] = translations
        super(Form, __self__).__init__(
            'auth0:index/form:Form',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ending: Optional[pulumi.Input[builtins.str]] = None,
            languages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormLanguageArgs', 'FormLanguageArgsDict']]]]] = None,
            messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FormMessageArgs', 'FormMessageArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nodes: Optional[pulumi.Input[builtins.str]] = None,
            start: Optional[pulumi.Input[builtins.str]] = None,
            style: Optional[pulumi.Input[builtins.str]] = None,
            translations: Optional[pulumi.Input[builtins.str]] = None) -> 'Form':
        """
        Get an existing Form resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ending: Submission configuration of the form. (JSON encoded)
        :param pulumi.Input[Sequence[pulumi.Input[Union['FormLanguageArgs', 'FormLanguageArgsDict']]]] languages: Language specific configuration for the form.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FormMessageArgs', 'FormMessageArgsDict']]]] messages: Message specific configuration for the form.
        :param pulumi.Input[builtins.str] name: Name of the form.
        :param pulumi.Input[builtins.str] nodes: Nodes of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] start: Input setup of the form. (JSON encoded)
        :param pulumi.Input[builtins.str] style: Style specific configuration for the form. (JSON encoded)
        :param pulumi.Input[builtins.str] translations: Translations of the form. (JSON encoded)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FormState.__new__(_FormState)

        __props__.__dict__["ending"] = ending
        __props__.__dict__["languages"] = languages
        __props__.__dict__["messages"] = messages
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["start"] = start
        __props__.__dict__["style"] = style
        __props__.__dict__["translations"] = translations
        return Form(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ending(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Submission configuration of the form. (JSON encoded)
        """
        return pulumi.get(self, "ending")

    @property
    @pulumi.getter
    def languages(self) -> pulumi.Output[Optional[Sequence['outputs.FormLanguage']]]:
        """
        Language specific configuration for the form.
        """
        return pulumi.get(self, "languages")

    @property
    @pulumi.getter
    def messages(self) -> pulumi.Output[Optional[Sequence['outputs.FormMessage']]]:
        """
        Message specific configuration for the form.
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the form.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Nodes of the form. (JSON encoded)
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def start(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Input setup of the form. (JSON encoded)
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def style(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Style specific configuration for the form. (JSON encoded)
        """
        return pulumi.get(self, "style")

    @property
    @pulumi.getter
    def translations(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Translations of the form. (JSON encoded)
        """
        return pulumi.get(self, "translations")

