# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCustomDomainResult',
    'AwaitableGetCustomDomainResult',
    'get_custom_domain',
    'get_custom_domain_output',
]

@pulumi.output_type
class GetCustomDomainResult:
    """
    A collection of values returned by getCustomDomain.
    """
    def __init__(__self__, certificates=None, custom_client_ip_header=None, custom_domain_id=None, domain=None, domain_metadata=None, id=None, origin_domain_name=None, primary=None, status=None, tls_policy=None, type=None, verifications=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if custom_client_ip_header and not isinstance(custom_client_ip_header, str):
            raise TypeError("Expected argument 'custom_client_ip_header' to be a str")
        pulumi.set(__self__, "custom_client_ip_header", custom_client_ip_header)
        if custom_domain_id and not isinstance(custom_domain_id, str):
            raise TypeError("Expected argument 'custom_domain_id' to be a str")
        pulumi.set(__self__, "custom_domain_id", custom_domain_id)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domain_metadata and not isinstance(domain_metadata, dict):
            raise TypeError("Expected argument 'domain_metadata' to be a dict")
        pulumi.set(__self__, "domain_metadata", domain_metadata)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if origin_domain_name and not isinstance(origin_domain_name, str):
            raise TypeError("Expected argument 'origin_domain_name' to be a str")
        pulumi.set(__self__, "origin_domain_name", origin_domain_name)
        if primary and not isinstance(primary, bool):
            raise TypeError("Expected argument 'primary' to be a bool")
        pulumi.set(__self__, "primary", primary)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tls_policy and not isinstance(tls_policy, str):
            raise TypeError("Expected argument 'tls_policy' to be a str")
        pulumi.set(__self__, "tls_policy", tls_policy)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if verifications and not isinstance(verifications, list):
            raise TypeError("Expected argument 'verifications' to be a list")
        pulumi.set(__self__, "verifications", verifications)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetCustomDomainCertificateResult']:
        """
        The Custom Domain certificate.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="customClientIpHeader")
    def custom_client_ip_header(self) -> builtins.str:
        """
        The HTTP header to fetch the client's IP address. Cannot be set on auth0_managed domains.
        """
        return pulumi.get(self, "custom_client_ip_header")

    @property
    @pulumi.getter(name="customDomainId")
    def custom_domain_id(self) -> Optional[builtins.str]:
        """
        The ID of the Custom Domain.
        """
        return pulumi.get(self, "custom_domain_id")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        Name of the custom domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainMetadata")
    def domain_metadata(self) -> Mapping[str, builtins.str]:
        """
        Metadata associated with the Custom Domain. Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "domain_metadata")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="originDomainName")
    def origin_domain_name(self) -> builtins.str:
        """
        Once the configuration status is `ready`, the DNS name of the Auth0 origin server that handles traffic for the custom domain.
        """
        return pulumi.get(self, "origin_domain_name")

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        Indicates whether this is a primary domain.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Configuration status for the custom domain. Options include `disabled`, `pending`, `pending_verification`, and `ready`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> builtins.str:
        """
        TLS policy for the custom domain. Available options are: `compatible` or `recommended`. Compatible includes TLS 1.0, 1.1, 1.2, and recommended only includes TLS 1.2. Cannot be set on self_managed domains.
        """
        return pulumi.get(self, "tls_policy")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Provisioning type for the custom domain. Options include `auth0_managed_certs` and `self_managed_certs`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def verifications(self) -> Sequence['outputs.GetCustomDomainVerificationResult']:
        """
        Configuration settings for verification.
        """
        return pulumi.get(self, "verifications")


class AwaitableGetCustomDomainResult(GetCustomDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomDomainResult(
            certificates=self.certificates,
            custom_client_ip_header=self.custom_client_ip_header,
            custom_domain_id=self.custom_domain_id,
            domain=self.domain,
            domain_metadata=self.domain_metadata,
            id=self.id,
            origin_domain_name=self.origin_domain_name,
            primary=self.primary,
            status=self.status,
            tls_policy=self.tls_policy,
            type=self.type,
            verifications=self.verifications)


def get_custom_domain(custom_domain_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomDomainResult:
    """
    Data source to retrieve the custom domain configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    my_custom_domain = auth0.CustomDomain("my_custom_domain",
        domain="example.auth.tempdomain.com",
        type="auth0_managed_certs",
        tls_policy="recommended",
        domain_metadata={
            "key1": "value1",
            "key2": "value2",
        })
    test = auth0.get_custom_domain_output(custom_domain_id=my_custom_domain.id)
    ```


    :param builtins.str custom_domain_id: The ID of the Custom Domain.
    """
    __args__ = dict()
    __args__['customDomainId'] = custom_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getCustomDomain:getCustomDomain', __args__, opts=opts, typ=GetCustomDomainResult).value

    return AwaitableGetCustomDomainResult(
        certificates=pulumi.get(__ret__, 'certificates'),
        custom_client_ip_header=pulumi.get(__ret__, 'custom_client_ip_header'),
        custom_domain_id=pulumi.get(__ret__, 'custom_domain_id'),
        domain=pulumi.get(__ret__, 'domain'),
        domain_metadata=pulumi.get(__ret__, 'domain_metadata'),
        id=pulumi.get(__ret__, 'id'),
        origin_domain_name=pulumi.get(__ret__, 'origin_domain_name'),
        primary=pulumi.get(__ret__, 'primary'),
        status=pulumi.get(__ret__, 'status'),
        tls_policy=pulumi.get(__ret__, 'tls_policy'),
        type=pulumi.get(__ret__, 'type'),
        verifications=pulumi.get(__ret__, 'verifications'))
def get_custom_domain_output(custom_domain_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomDomainResult]:
    """
    Data source to retrieve the custom domain configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    my_custom_domain = auth0.CustomDomain("my_custom_domain",
        domain="example.auth.tempdomain.com",
        type="auth0_managed_certs",
        tls_policy="recommended",
        domain_metadata={
            "key1": "value1",
            "key2": "value2",
        })
    test = auth0.get_custom_domain_output(custom_domain_id=my_custom_domain.id)
    ```


    :param builtins.str custom_domain_id: The ID of the Custom Domain.
    """
    __args__ = dict()
    __args__['customDomainId'] = custom_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getCustomDomain:getCustomDomain', __args__, opts=opts, typ=GetCustomDomainResult)
    return __ret__.apply(lambda __response__: GetCustomDomainResult(
        certificates=pulumi.get(__response__, 'certificates'),
        custom_client_ip_header=pulumi.get(__response__, 'custom_client_ip_header'),
        custom_domain_id=pulumi.get(__response__, 'custom_domain_id'),
        domain=pulumi.get(__response__, 'domain'),
        domain_metadata=pulumi.get(__response__, 'domain_metadata'),
        id=pulumi.get(__response__, 'id'),
        origin_domain_name=pulumi.get(__response__, 'origin_domain_name'),
        primary=pulumi.get(__response__, 'primary'),
        status=pulumi.get(__response__, 'status'),
        tls_policy=pulumi.get(__response__, 'tls_policy'),
        type=pulumi.get(__response__, 'type'),
        verifications=pulumi.get(__response__, 'verifications')))
