/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.task;

import io.ray.api.BaseActorHandle;
import io.ray.api.PlacementGroups;
import io.ray.api.Ray;
import io.ray.api.id.ActorId;
import io.ray.api.id.ObjectId;
import io.ray.api.id.PlacementGroupId;
import io.ray.api.options.ActorCreationOptions;
import io.ray.api.options.CallOptions;
import io.ray.api.options.PlacementGroupCreationOptions;
import io.ray.api.placementgroup.PlacementGroup;
import io.ray.runtime.actor.NativeActorHandle;
import io.ray.runtime.functionmanager.FunctionDescriptor;
import io.ray.runtime.placementgroup.PlacementGroupImpl;
import io.ray.runtime.task.FunctionArg;
import io.ray.runtime.task.TaskSubmitter;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NativeTaskSubmitter
implements TaskSubmitter {
    @Override
    public List<ObjectId> submitTask(FunctionDescriptor functionDescriptor, List<FunctionArg> args, int numReturns, CallOptions options) {
        List<byte[]> returnIds = NativeTaskSubmitter.nativeSubmitTask(functionDescriptor, functionDescriptor.hashCode(), args, numReturns, options);
        if (returnIds == null) {
            return ImmutableList.of();
        }
        return returnIds.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    @Override
    public BaseActorHandle createActor(FunctionDescriptor functionDescriptor, List<FunctionArg> args, ActorCreationOptions options) throws IllegalArgumentException {
        if (options != null) {
            if (options.group != null) {
                PlacementGroupImpl group = (PlacementGroupImpl)options.group;
                Preconditions.checkArgument(options.bundleIndex == -1 || options.bundleIndex >= 0 && options.bundleIndex < group.getBundles().size(), String.format("Bundle index %s is invalid, the correct bundle index should be either in the range of 0 to the number of bundles or -1 which means put the task to any available bundles.", options.bundleIndex));
            }
            if (StringUtils.isNotBlank(options.name)) {
                Optional actor = Ray.getActor(options.name);
                Preconditions.checkArgument(!actor.isPresent(), String.format("Actor of name %s exists", options.name));
            }
        }
        byte[] actorId = NativeTaskSubmitter.nativeCreateActor(functionDescriptor, functionDescriptor.hashCode(), args, options);
        return NativeActorHandle.create(actorId, functionDescriptor.getLanguage());
    }

    @Override
    public BaseActorHandle getActor(ActorId actorId) {
        return NativeActorHandle.create(actorId.getBytes());
    }

    @Override
    public List<ObjectId> submitActorTask(BaseActorHandle actor, FunctionDescriptor functionDescriptor, List<FunctionArg> args, int numReturns, CallOptions options) {
        Preconditions.checkState(actor instanceof NativeActorHandle);
        List<byte[]> returnIds = NativeTaskSubmitter.nativeSubmitActorTask(actor.getId().getBytes(), functionDescriptor, functionDescriptor.hashCode(), args, numReturns, options);
        if (returnIds == null) {
            return ImmutableList.of();
        }
        return returnIds.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    @Override
    public PlacementGroup createPlacementGroup(PlacementGroupCreationOptions creationOptions) {
        if (StringUtils.isNotBlank(creationOptions.name)) {
            PlacementGroup placementGroup = PlacementGroups.getPlacementGroup(creationOptions.name);
            Preconditions.checkArgument(placementGroup == null, String.format("Placement group with name %s exists!", creationOptions.name));
        }
        byte[] bytes = NativeTaskSubmitter.nativeCreatePlacementGroup(creationOptions);
        return new PlacementGroupImpl.Builder().setId(PlacementGroupId.fromBytes(bytes)).setName(creationOptions.name).setBundles(creationOptions.bundles).setStrategy(creationOptions.strategy).build();
    }

    @Override
    public void removePlacementGroup(PlacementGroupId id) {
        NativeTaskSubmitter.nativeRemovePlacementGroup(id.getBytes());
    }

    @Override
    public boolean waitPlacementGroupReady(PlacementGroupId id, int timeoutSeconds) {
        return NativeTaskSubmitter.nativeWaitPlacementGroupReady(id.getBytes(), timeoutSeconds);
    }

    private static native List<byte[]> nativeSubmitTask(FunctionDescriptor var0, int var1, List<FunctionArg> var2, int var3, CallOptions var4);

    private static native byte[] nativeCreateActor(FunctionDescriptor var0, int var1, List<FunctionArg> var2, ActorCreationOptions var3);

    private static native List<byte[]> nativeSubmitActorTask(byte[] var0, FunctionDescriptor var1, int var2, List<FunctionArg> var3, int var4, CallOptions var5);

    private static native byte[] nativeCreatePlacementGroup(PlacementGroupCreationOptions var0);

    private static native void nativeRemovePlacementGroup(byte[] var0);

    private static native boolean nativeWaitPlacementGroupReady(byte[] var0, int var1);
}

