/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.aeonbits.owner.Util;
import org.aeonbits.owner.VariablesExpander;

class ConfigURIFactory {
    private static final String CLASSPATH_PROTOCOL = "classpath:";
    private static final String FILE_PROTOCOL = "file:";
    private final transient ClassLoader classLoader;
    private final VariablesExpander expander;

    ConfigURIFactory(ClassLoader classLoader, VariablesExpander expander) {
        this.classLoader = classLoader;
        this.expander = expander;
    }

    URI newURI(String spec) throws URISyntaxException {
        String expanded = this.expand(spec);
        String fixed = Util.fixBackslashesToSlashes(expanded);
        if (fixed.startsWith(CLASSPATH_PROTOCOL)) {
            String path = fixed.substring(CLASSPATH_PROTOCOL.length());
            URL url = this.classLoader.getResource(path);
            if (url == null) {
                return null;
            }
            return url.toURI();
        }
        if (fixed.startsWith(FILE_PROTOCOL)) {
            String path = Util.fixSpacesToPercentTwenty(fixed);
            return new URI(path);
        }
        return new URI(fixed);
    }

    private String expand(String path) {
        return this.expander.expand(path);
    }

    String toClasspathURLSpec(String name) {
        return CLASSPATH_PROTOCOL + name.replace('.', '/');
    }
}

