/*
 * Decompiled with CFR 0.152.
 */
package org.ray.api.id;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public abstract class BaseId
implements Serializable {
    private static final long serialVersionUID = 8588849129675565761L;
    private final byte[] id;
    private int hashCodeCache = 0;
    private Boolean isNilCache = null;

    protected BaseId(byte[] id) {
        if (id.length != this.size()) {
            throw new IllegalArgumentException("Failed to construct BaseId, expect " + this.size() + " bytes, but got " + id.length + " bytes.");
        }
        this.id = id;
    }

    public byte[] getBytes() {
        return this.id;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.id);
    }

    public boolean isNil() {
        if (this.isNilCache == null) {
            boolean localIsNil = true;
            for (int i = 0; i < this.size(); ++i) {
                if (this.id[i] == -1) continue;
                localIsNil = false;
                break;
            }
            this.isNilCache = localIsNil;
        }
        return this.isNilCache;
    }

    public abstract int size();

    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.hashCodeCache = Arrays.hashCode(this.id);
        }
        return this.hashCodeCache;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BaseId r = (BaseId)obj;
        return Arrays.equals(this.id, r.id);
    }

    public String toString() {
        return DatatypeConverter.printHexBinary(this.id).toLowerCase();
    }

    protected static byte[] hexString2Bytes(String hex) {
        return DatatypeConverter.parseHexBinary(hex);
    }

    protected static byte[] byteBuffer2Bytes(ByteBuffer bb) {
        byte[] id = new byte[bb.remaining()];
        bb.get(id);
        return id;
    }
}

