/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.context;

import com.google.common.base.Preconditions;
import java.util.List;
import org.ray.api.id.ActorId;
import org.ray.api.id.JobId;
import org.ray.api.runtimecontext.NodeInfo;
import org.ray.api.runtimecontext.RuntimeContext;
import org.ray.runtime.AbstractRayRuntime;
import org.ray.runtime.config.RunMode;
import org.ray.runtime.generated.Common;

public class RuntimeContextImpl
implements RuntimeContext {
    private AbstractRayRuntime runtime;

    public RuntimeContextImpl(AbstractRayRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public JobId getCurrentJobId() {
        return this.runtime.getWorkerContext().getCurrentJobId();
    }

    @Override
    public ActorId getCurrentActorId() {
        ActorId actorId = this.runtime.getWorkerContext().getCurrentActorId();
        Preconditions.checkState(actorId != null && !actorId.isNil(), "This method should only be called from an actor.");
        return actorId;
    }

    @Override
    public boolean wasCurrentActorReconstructed() {
        Common.TaskType currentTaskType = this.runtime.getWorkerContext().getCurrentTaskType();
        Preconditions.checkState(currentTaskType == Common.TaskType.ACTOR_CREATION_TASK, "This method can only be called from an actor creation task.");
        if (this.isSingleProcess()) {
            return false;
        }
        return this.runtime.getGcsClient().actorExists(this.getCurrentActorId());
    }

    @Override
    public String getRayletSocketName() {
        return this.runtime.getRayConfig().rayletSocketName;
    }

    @Override
    public String getObjectStoreSocketName() {
        return this.runtime.getRayConfig().objectStoreSocketName;
    }

    @Override
    public boolean isSingleProcess() {
        return RunMode.SINGLE_PROCESS == this.runtime.getRayConfig().runMode;
    }

    @Override
    public List<NodeInfo> getAllNodeInfo() {
        return this.runtime.getGcsClient().getAllNodeInfo();
    }
}

