/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.functionmanager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.ray.api.annotation.RayRemote;
import org.ray.runtime.functionmanager.JavaFunctionDescriptor;

public class RayFunction {
    public final Executable executable;
    public final ClassLoader classLoader;
    public final JavaFunctionDescriptor functionDescriptor;

    public RayFunction(Executable executable, ClassLoader classLoader, JavaFunctionDescriptor functionDescriptor) {
        this.executable = executable;
        this.classLoader = classLoader;
        this.functionDescriptor = functionDescriptor;
    }

    public boolean isConstructor() {
        return this.executable instanceof Constructor;
    }

    public Constructor<?> getConstructor() {
        return (Constructor)this.executable;
    }

    public Method getMethod() {
        return (Method)this.executable;
    }

    public JavaFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public RayRemote getRayRemoteAnnotation() {
        RayRemote rayRemote = this.isConstructor() ? this.executable.getDeclaringClass().getAnnotation(RayRemote.class) : this.executable.getAnnotation(RayRemote.class);
        return rayRemote;
    }

    public boolean hasReturn() {
        if (this.isConstructor()) {
            return true;
        }
        return !this.getMethod().getReturnType().equals(Void.TYPE);
    }

    public String toString() {
        return this.executable.toString();
    }
}

