/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.object;

import java.util.List;
import java.util.stream.Collectors;
import org.ray.api.id.BaseId;
import org.ray.api.id.ObjectId;
import org.ray.runtime.context.WorkerContext;
import org.ray.runtime.object.NativeRayObject;
import org.ray.runtime.object.ObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeObjectStore
extends ObjectStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeObjectStore.class);
    private final long nativeCoreWorkerPointer;

    public NativeObjectStore(WorkerContext workerContext, long nativeCoreWorkerPointer) {
        super(workerContext);
        this.nativeCoreWorkerPointer = nativeCoreWorkerPointer;
    }

    @Override
    public ObjectId putRaw(NativeRayObject obj) {
        return new ObjectId(NativeObjectStore.nativePut(this.nativeCoreWorkerPointer, obj));
    }

    @Override
    public void putRaw(NativeRayObject obj, ObjectId objectId) {
        NativeObjectStore.nativePut(this.nativeCoreWorkerPointer, objectId.getBytes(), obj);
    }

    @Override
    public List<NativeRayObject> getRaw(List<ObjectId> objectIds, long timeoutMs) {
        return NativeObjectStore.nativeGet(this.nativeCoreWorkerPointer, NativeObjectStore.toBinaryList(objectIds), timeoutMs);
    }

    @Override
    public List<Boolean> wait(List<ObjectId> objectIds, int numObjects, long timeoutMs) {
        return NativeObjectStore.nativeWait(this.nativeCoreWorkerPointer, NativeObjectStore.toBinaryList(objectIds), numObjects, timeoutMs);
    }

    @Override
    public void delete(List<ObjectId> objectIds, boolean localOnly, boolean deleteCreatingTasks) {
        NativeObjectStore.nativeDelete(this.nativeCoreWorkerPointer, NativeObjectStore.toBinaryList(objectIds), localOnly, deleteCreatingTasks);
    }

    private static List<byte[]> toBinaryList(List<ObjectId> ids) {
        return ids.stream().map(BaseId::getBytes).collect(Collectors.toList());
    }

    private static native byte[] nativePut(long var0, NativeRayObject var2);

    private static native void nativePut(long var0, byte[] var2, NativeRayObject var3);

    private static native List<NativeRayObject> nativeGet(long var0, List<byte[]> var2, long var3);

    private static native List<Boolean> nativeWait(long var0, List<byte[]> var2, int var3, long var4);

    private static native void nativeDelete(long var0, List<byte[]> var2, boolean var3, boolean var4);
}

