/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.util.generator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.ray.runtime.util.generator.BaseGenerator;

public class RayCallGenerator
extends BaseGenerator {
    private String build() {
        int i;
        this.sb = new StringBuilder();
        this.newLine("// generated automatically, do not modify.");
        this.newLine("");
        this.newLine("package org.ray.api;");
        this.newLine("");
        for (i = 0; i <= 6; ++i) {
            this.newLine("import org.ray.api.function.RayFunc" + i + ";");
        }
        for (i = 0; i <= 6; ++i) {
            this.newLine("import org.ray.api.function.RayFuncVoid" + i + ";");
        }
        this.newLine("import org.ray.api.options.ActorCreationOptions;");
        this.newLine("import org.ray.api.options.CallOptions;");
        this.newLine("");
        this.newLine("/**");
        this.newLine(" * This class provides type-safe interfaces for `Ray.call` and `Ray.createActor`.");
        this.newLine(" **/");
        this.newLine("@SuppressWarnings({\"rawtypes\", \"unchecked\"})");
        this.newLine("class RayCall {");
        this.newLine(1, "// =======================================");
        this.newLine(1, "// Methods for remote function invocation.");
        this.newLine(1, "// =======================================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, false, true, false);
            this.buildCalls(i, false, false, true, true);
            this.buildCalls(i, false, false, false, false);
            this.buildCalls(i, false, false, false, true);
        }
        this.newLine(1, "// ===========================================");
        this.newLine(1, "// Methods for remote actor method invocation.");
        this.newLine(1, "// ===========================================");
        for (i = 0; i <= 5; ++i) {
            this.buildCalls(i, true, false, true, false);
            this.buildCalls(i, true, false, false, false);
        }
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Methods for actor creation.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildCalls(i, false, true, true, false);
            this.buildCalls(i, false, true, true, true);
        }
        this.newLine(1, "// ===========================");
        this.newLine(1, "// Cross-language methods.");
        this.newLine(1, "// ===========================");
        for (i = 0; i <= 6; ++i) {
            this.buildPyCalls(i, false, false, false);
            this.buildPyCalls(i, false, false, true);
        }
        for (i = 0; i <= 5; ++i) {
            this.buildPyCalls(i, true, false, false);
        }
        for (i = 0; i <= 6; ++i) {
            this.buildPyCalls(i, false, true, false);
            this.buildPyCalls(i, false, true, true);
        }
        this.newLine("}");
        return this.sb.toString();
    }

    private void buildCalls(int numParameters, boolean forActor, boolean forActorCreation, boolean hasReturn, boolean hasOptionsParam) {
        String genericTypes = "";
        for (int i = 0; i < numParameters; ++i) {
            genericTypes = genericTypes + "T" + i + ", ";
        }
        if (forActor) {
            genericTypes = "A, " + genericTypes;
        }
        if (forActorCreation) {
            genericTypes = genericTypes + "A, ";
        } else if (hasReturn) {
            genericTypes = genericTypes + "R, ";
        }
        if (!genericTypes.isEmpty()) {
            genericTypes = genericTypes.substring(0, genericTypes.length() - 2);
            genericTypes = "<" + genericTypes + ">";
        }
        String returnType = forActorCreation ? "RayActor<A>" : (hasReturn ? "RayObject<R>" : "void");
        String argsDeclarationPrefix = String.format("RayFunc%s%d%s f, ", hasReturn ? "" : "Void", !forActor ? numParameters : numParameters + 1, genericTypes);
        if (forActor) {
            argsDeclarationPrefix = argsDeclarationPrefix + "RayActor<A> actor, ";
        }
        String callFunc = forActorCreation ? "createActor" : "call";
        for (String param : this.generateParameters(numParameters)) {
            String argsDeclaration = argsDeclarationPrefix + param;
            if (hasOptionsParam) {
                argsDeclaration = argsDeclaration + (forActorCreation ? "ActorCreationOptions options, " : "CallOptions options, ");
            }
            argsDeclaration = argsDeclaration.substring(0, argsDeclaration.length() - 2);
            this.newLine(1, String.format("public static%s %s %s(%s) {", genericTypes.isEmpty() ? "" : " " + genericTypes, returnType, callFunc, argsDeclaration));
            String args = "";
            for (int i = 0; i < numParameters; ++i) {
                args = args + "t" + i + ", ";
            }
            if (!args.isEmpty()) {
                args = args.substring(0, args.length() - 2);
            }
            this.newLine(2, String.format("Object[] args = new Object[]{%s};", args));
            String callFuncArgs = "f, ";
            if (forActor) {
                callFuncArgs = callFuncArgs + "actor, ";
            }
            callFuncArgs = callFuncArgs + "args, ";
            callFuncArgs = callFuncArgs + (forActor ? "" : (hasOptionsParam ? "options, " : "null, "));
            callFuncArgs = callFuncArgs.substring(0, callFuncArgs.length() - 2);
            this.newLine(2, String.format("%sRay.internal().%s(%s);", hasReturn ? "return " : "", callFunc, callFuncArgs));
            this.newLine(1, "}");
        }
    }

    private void buildPyCalls(int numParameters, boolean forActor, boolean forActorCreation, boolean hasOptionsParam) {
        String argList = "";
        String paramList = "";
        for (int i = 0; i < numParameters; ++i) {
            paramList = paramList + "Object obj" + i + ", ";
            argList = argList + "obj" + i + ", ";
        }
        if (argList.endsWith(", ")) {
            argList = argList.substring(0, argList.length() - 2);
        }
        if (paramList.endsWith(", ")) {
            paramList = paramList.substring(0, paramList.length() - 2);
        }
        String paramPrefix = "";
        String funcArgs = "";
        if (forActorCreation) {
            paramPrefix = paramPrefix + "String moduleName, String className";
            funcArgs = funcArgs + "moduleName, className";
        } else if (forActor) {
            paramPrefix = paramPrefix + "RayPyActor pyActor, String functionName";
            funcArgs = funcArgs + "pyActor, functionName";
        } else {
            paramPrefix = paramPrefix + "String moduleName, String functionName";
            funcArgs = funcArgs + "moduleName, functionName";
        }
        if (numParameters > 0) {
            paramPrefix = paramPrefix + ", ";
        }
        String optionsParam = hasOptionsParam ? (forActorCreation ? ", ActorCreationOptions options" : ", CallOptions options") : "";
        String optionsArg = forActor ? "" : (hasOptionsParam ? ", options" : ", null");
        String returnType = !forActorCreation ? "RayObject" : "RayPyActor";
        String funcName = !forActorCreation ? "callPy" : "createPyActor";
        funcArgs = funcArgs + ", args";
        this.newLine(1, String.format("public static %s %s(%s%s) {", returnType, funcName, paramPrefix + paramList, optionsParam));
        this.newLine(2, String.format("Object[] args = new Object[]{%s};", argList));
        this.newLine(2, String.format("return Ray.internal().%s(%s%s);", funcName, funcArgs, optionsArg));
        this.newLine(1, "}");
    }

    private List<String> generateParameters(int numParams) {
        ArrayList<String> res = new ArrayList<String>();
        this.dfs(0, numParams, "", res);
        return res;
    }

    private void dfs(int pos, int numParams, String cur, List<String> res) {
        if (pos >= numParams) {
            res.add(cur);
            return;
        }
        String nextParameter = String.format("T%d t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
        nextParameter = String.format("RayObject<T%d> t%d, ", pos, pos);
        this.dfs(pos + 1, numParams, cur + nextParameter, res);
    }

    public static void main(String[] args) throws IOException {
        String path = System.getProperty("user.dir") + "/api/src/main/java/org/ray/api/RayCall.java";
        FileUtils.write(new File(path), (CharSequence)new RayCallGenerator().build(), Charset.defaultCharset());
    }
}

