/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.api.stream;

import java.util.Collection;
import org.ray.streaming.api.context.StreamingContext;
import org.ray.streaming.api.function.impl.SourceFunction;
import org.ray.streaming.api.function.internal.CollectionSourceFunction;
import org.ray.streaming.api.partition.impl.RoundRobinPartition;
import org.ray.streaming.api.stream.DataStream;
import org.ray.streaming.api.stream.StreamSource;
import org.ray.streaming.operator.impl.SourceOperator;

public class DataStreamSource<T>
extends DataStream<T>
implements StreamSource<T> {
    public DataStreamSource(StreamingContext streamingContext, SourceFunction<T> sourceFunction) {
        super(streamingContext, new SourceOperator<T>(sourceFunction));
        this.partition = new RoundRobinPartition();
    }

    public static <T> DataStreamSource<T> buildSource(StreamingContext context, Collection<T> values) {
        return new DataStreamSource<T>(context, new CollectionSourceFunction<T>(values));
    }

    @Override
    public DataStreamSource<T> setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }
}

