/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ray.api.RayActor;
import org.ray.api.id.ActorId;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionEdge;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;
import org.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertexState;
import org.ray.streaming.runtime.worker.JobWorker;

public class ExecutionVertex
implements Serializable {
    private final int vertexId;
    private final int vertexIndex;
    private final String vertexName;
    private ExecutionVertexState state = ExecutionVertexState.TO_ADD;
    private RayActor<JobWorker> workerActor;
    private List<ExecutionEdge> inputEdges = new ArrayList<ExecutionEdge>();
    private List<ExecutionEdge> outputEdges = new ArrayList<ExecutionEdge>();

    public ExecutionVertex(int jobVertexId, int index, ExecutionJobVertex executionJobVertex) {
        this.vertexId = this.generateExecutionVertexId(jobVertexId, index);
        this.vertexIndex = index;
        this.vertexName = executionJobVertex.getJobVertexName() + "-" + this.vertexIndex;
    }

    private int generateExecutionVertexId(int jobVertexId, int index) {
        return jobVertexId * 100000 + index;
    }

    public int getVertexId() {
        return this.vertexId;
    }

    public int getVertexIndex() {
        return this.vertexIndex;
    }

    public ExecutionVertexState getState() {
        return this.state;
    }

    public void setState(ExecutionVertexState state) {
        this.state = state;
    }

    public boolean is2Add() {
        return this.state == ExecutionVertexState.TO_ADD;
    }

    public boolean isRunning() {
        return this.state == ExecutionVertexState.RUNNING;
    }

    public boolean is2Delete() {
        return this.state == ExecutionVertexState.TO_DEL;
    }

    public RayActor<JobWorker> getWorkerActor() {
        return this.workerActor;
    }

    public ActorId getWorkerActorId() {
        return this.workerActor.getId();
    }

    public void setWorkerActor(RayActor<JobWorker> workerActor) {
        this.workerActor = workerActor;
    }

    public List<ExecutionEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public List<ExecutionEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("vertexId", this.vertexId).add("vertexIndex", this.vertexIndex).add("vertexName", this.vertexName).add("state", this.state).add("workerActor", this.workerActor).add("inputEdges", this.inputEdges).add("outputEdges", this.outputEdges).toString();
    }
}

