import { Resource, IResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * (experimental) Represents an AWS IoT Events input.
 *
 * @experimental
 */
export interface IInput extends IResource {
    /**
     * (experimental) The name of the input.
     *
     * @experimental
     * @attribute true
     */
    readonly inputName: string;
}
/**
 * (experimental) Properties for defining an AWS IoT Events input.
 *
 * @experimental
 */
export interface InputProps {
    /**
     * (experimental) The name of the input.
     *
     * @default - CloudFormation will generate a unique name of the input
     * @experimental
     */
    readonly inputName?: string;
    /**
     * (experimental) An expression that specifies an attribute-value pair in a JSON structure.
     *
     * Use this to specify an attribute from the JSON payload that is made available
     * by the input. Inputs are derived from messages sent to AWS IoT Events (BatchPutMessage).
     * Each such message contains a JSON payload. The attribute (and its paired value)
     * specified here are available for use in the condition expressions used by detectors.
     *
     * @experimental
     */
    readonly attributeJsonPaths: string[];
}
/**
 * (experimental) Defines an AWS IoT Events input in this stack.
 *
 * @experimental
 */
export declare class Input extends Resource implements IInput {
    /**
     * (experimental) Import an existing input.
     *
     * @experimental
     */
    static fromInputName(scope: Construct, id: string, inputName: string): IInput;
    /**
     * (experimental) The name of the input.
     *
     * @experimental
     */
    readonly inputName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: InputProps);
}
