"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplateRepositoryAssociation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const directories_1 = require("./directories");
class ApprovalRuleTemplateRepositoryAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repository = props.repository;
        const resourceType = 'Custom::ApprovalRuleTemplateRepositoryAssociation';
        const serviceToken = aws_cdk_lib_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: directories_1.approvalRuleTemplateRepositoryAssociationDir,
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_18_X,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:AssociateApprovalRuleTemplateWithRepository',
                        'codecommit:DisassociateApprovalRuleTemplateFromRepository',
                    ],
                    Resource: '*',
                },
            ],
        });
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType,
            properties: {
                ApprovalRuleTemplateName: props.approvalRuleTemplateName,
                RepositoryName: this.repository.repositoryName,
            },
        });
    }
    onOverridden(id, options) {
        const rule = this.repository.onPullRequestStateChange(id, options);
        rule.addEventPattern({
            detail: {
                event: ['pullRequestApprovalRuleOverridden'],
            },
        });
        return rule;
    }
}
exports.ApprovalRuleTemplateRepositoryAssociation = ApprovalRuleTemplateRepositoryAssociation;
_a = JSII_RTTI_SYMBOL_1;
ApprovalRuleTemplateRepositoryAssociation[_a] = { fqn: "@cloudcomponents/cdk-pull-request-approval-rule.ApprovalRuleTemplateRepositoryAssociation", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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