"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const directories_1 = require("./directories");
class ApprovalRuleTemplate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { approvalRuleTemplateName, approvalRuleTemplateDescription, template } = props;
        const serviceToken = aws_cdk_lib_1.CustomResourceProvider.getOrCreate(this, 'Custom::ApprovalRuleTemplate', {
            codeDirectory: directories_1.approvalRuleTemplateDir,
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_18_X,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:CreateApprovalRuleTemplate',
                        'codecommit:DeleteApprovalRuleTemplate',
                        'codecommit:GetApprovalRuleTemplate',
                        'codecommit:UpdateApprovalRuleTemplateContent',
                        'codecommit:UpdateApprovalRuleTemplateDescription',
                        'codecommit:UpdateApprovalRuleTemplateName',
                    ],
                    Resource: '*',
                },
            ],
        });
        const resource = new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::ApprovalRuleTemplate',
            properties: {
                ApprovalRuleTemplateName: approvalRuleTemplateName,
                ApprovalRuleTemplateDescription: approvalRuleTemplateDescription,
                Template: {
                    DestinationReferences: template.branches?.map((branch) => `refs/heads/${branch}`),
                    Approvers: {
                        NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                        ApprovalPoolMembers: template.approvers.approvalPoolMembers,
                    },
                },
            },
        });
        this.approvalRuleTemplateName = resource.getAttString('ApprovalRuleTemplateName');
    }
}
exports.ApprovalRuleTemplate = ApprovalRuleTemplate;
_a = JSII_RTTI_SYMBOL_1;
ApprovalRuleTemplate[_a] = { fqn: "@cloudcomponents/cdk-pull-request-approval-rule.ApprovalRuleTemplate", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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