module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 1);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = require("@aws-sdk/client-codecommit");

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const client_codecommit_1 = __webpack_require__(0);
const codecommit = new client_codecommit_1.CodeCommitClient();
const getProperties = (props) => ({
    approvalRuleTemplateName: props.ApprovalRuleTemplateName,
    approvalRuleTemplateDescription: props.ApprovalRuleTemplateDescription,
    template: {
        destinationReferences: props.Template.DestinationReferences,
        approvers: {
            numberOfApprovalsNeeded: props.Template.Approvers.NumberOfApprovalsNeeded,
            approvalPoolMembers: props.Template.Approvers.ApprovalPoolMembers,
        },
    },
});
const buildTemplateContent = (template) => {
    const templateContent = {
        Version: '2018-11-08',
        DestinationReferences: template.destinationReferences || undefined,
        Statements: [
            {
                Type: 'Approvers',
                NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                ApprovalPoolMembers: template.approvers.approvalPoolMembers || undefined,
            },
        ],
    };
    return JSON.stringify(templateContent, null, 2);
};
const onCreate = async (event) => {
    const { approvalRuleTemplateName, approvalRuleTemplateDescription = '', template, } = getProperties(event.ResourceProperties);
    const { approvalRuleTemplate } = await codecommit.send(new client_codecommit_1.CreateApprovalRuleTemplateCommand({
        approvalRuleTemplateName,
        approvalRuleTemplateDescription,
        approvalRuleTemplateContent: buildTemplateContent(template),
    }));
    return {
        PhysicalResourceId: approvalRuleTemplate === null || approvalRuleTemplate === void 0 ? void 0 : approvalRuleTemplate.approvalRuleTemplateId,
        Data: {
            ApprovalRuleTemplateName: approvalRuleTemplate === null || approvalRuleTemplate === void 0 ? void 0 : approvalRuleTemplate.approvalRuleTemplateName,
        },
    };
};
const onUpdate = async (event) => {
    const newProps = getProperties(event.ResourceProperties);
    const oldProps = getProperties(event.OldResourceProperties);
    let approvalRuleTemplate;
    if (buildTemplateContent(newProps.template) !== buildTemplateContent(oldProps.template)) {
        const response = await codecommit.send(new client_codecommit_1.UpdateApprovalRuleTemplateContentCommand({
            approvalRuleTemplateName: oldProps.approvalRuleTemplateName,
            newRuleContent: buildTemplateContent(newProps.template),
        }));
        approvalRuleTemplate = response.approvalRuleTemplate;
    }
    if (newProps.approvalRuleTemplateDescription !== oldProps.approvalRuleTemplateDescription) {
        const response = await codecommit.send(new client_codecommit_1.UpdateApprovalRuleTemplateDescriptionCommand({
            approvalRuleTemplateName: oldProps.approvalRuleTemplateName,
            approvalRuleTemplateDescription: newProps.approvalRuleTemplateDescription || '',
        }));
        approvalRuleTemplate = response.approvalRuleTemplate;
    }
    if (newProps.approvalRuleTemplateName !== oldProps.approvalRuleTemplateName) {
        const response = await codecommit.send(new client_codecommit_1.UpdateApprovalRuleTemplateNameCommand({
            newApprovalRuleTemplateName: newProps.approvalRuleTemplateName,
            oldApprovalRuleTemplateName: oldProps.approvalRuleTemplateName,
        }));
        approvalRuleTemplate = response.approvalRuleTemplate;
    }
    if (!approvalRuleTemplate) {
        const response = await codecommit.send(new client_codecommit_1.GetApprovalRuleTemplateCommand({
            approvalRuleTemplateName: oldProps.approvalRuleTemplateName,
        }));
        approvalRuleTemplate = response.approvalRuleTemplate;
    }
    return {
        PhysicalResourceId: approvalRuleTemplate === null || approvalRuleTemplate === void 0 ? void 0 : approvalRuleTemplate.approvalRuleTemplateId,
        Data: {
            ApprovalRuleTemplateName: approvalRuleTemplate === null || approvalRuleTemplate === void 0 ? void 0 : approvalRuleTemplate.approvalRuleTemplateName,
        },
    };
};
const onDelete = async (event) => {
    const { approvalRuleTemplateName } = getProperties(event.ResourceProperties);
    await codecommit.send(new client_codecommit_1.DeleteApprovalRuleTemplateCommand({
        approvalRuleTemplateName,
    }));
};
const handler = async (event) => {
    const requestType = event.RequestType;
    switch (requestType) {
        case 'Create':
            return onCreate(event);
        case 'Update':
            return onUpdate(event);
        case 'Delete':
            return onDelete(event);
        default:
            throw new Error(`Invalid request type: ${requestType}`);
    }
};
exports.handler = handler;


/***/ })
/******/ ]);
//# sourceMappingURL=index.js.map