/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus;

import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.SemLeidmiseAbimeetodid;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.base.BaseLocal;

public class TimeMLDateTimePoint {
    public final boolean SET_TYPE_OPERATION = true;
    public final boolean ADD_TYPE_OPERATION = false;
    public static final VALUE_FIELD[] valueFieldsInOrder = new VALUE_FIELD[]{VALUE_FIELD.YEAR, VALUE_FIELD.MONTH_OR_WEEK, VALUE_FIELD.DAY, VALUE_FIELD.HOUR_OR_POD, VALUE_FIELD.MINUTE};
    private HashMap<VALUE_FIELD, String> maskedFields = new HashMap();
    private HashMap<VALUE_FIELD, String> openedFields = new HashMap();
    private HashMap<VALUE_FIELD, String> inputFields = new HashMap();
    private HashMap<Granulaarsus, String> modifiedGrans = new HashMap();
    private LocalTime underlyingTime = null;
    private LocalDate underlyingDate = null;
    private String partOfDay = null;
    private boolean dateModified = false;
    private boolean functionOtherThanSetUsed = false;

    public TimeMLDateTimePoint(LocalDateTime localDateTime) {
        this.underlyingTime = localDateTime.toLocalTime();
        this.underlyingDate = localDateTime.toLocalDate();
        this.inputFields.put(VALUE_FIELD.YEAR, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, this.underlyingDate.getYear()));
        this.inputFields.put(VALUE_FIELD.MONTH_OR_WEEK, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()));
        this.inputFields.put(VALUE_FIELD.DAY, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()));
        this.inputFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
        this.inputFields.put(VALUE_FIELD.MINUTE, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, this.underlyingTime.getMinuteOfHour()));
    }

    public TimeMLDateTimePoint(String[] stringArray) {
        this(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
    }

    public TimeMLDateTimePoint(String string, String string2, String string3, String string4, String string5) {
        this.underlyingDate = new LocalDate();
        this.underlyingTime = new LocalTime();
        Pattern pattern = Pattern.compile("X+");
        if (pattern.matcher(string).matches()) {
            this.maskedFields.put(VALUE_FIELD.YEAR, string);
            this.inputFields.put(VALUE_FIELD.YEAR, string);
        } else if (TimeMLDateTimePoint.parseInteger(string) > -1) {
            this.inputFields.put(VALUE_FIELD.YEAR, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, string));
            this.underlyingDate = this.underlyingDate.withYear(TimeMLDateTimePoint.parseInteger(string));
        }
        if (pattern.matcher(string2).matches()) {
            this.maskedFields.put(VALUE_FIELD.MONTH_OR_WEEK, string2);
            this.inputFields.put(VALUE_FIELD.MONTH_OR_WEEK, string2);
        } else if (TimeMLDateTimePoint.parseInteger(string2) > -1) {
            this.inputFields.put(VALUE_FIELD.MONTH_OR_WEEK, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, string2));
            this.underlyingDate = this.underlyingDate.withMonthOfYear(TimeMLDateTimePoint.parseInteger(string2));
        }
        if (pattern.matcher(string3).matches()) {
            this.maskedFields.put(VALUE_FIELD.DAY, string3);
            this.inputFields.put(VALUE_FIELD.DAY, string3);
        } else if (TimeMLDateTimePoint.parseInteger(string3) > -1) {
            this.inputFields.put(VALUE_FIELD.DAY, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, string3));
            this.underlyingDate = this.underlyingDate.withDayOfMonth(TimeMLDateTimePoint.parseInteger(string3));
        }
        if (pattern.matcher(string4).matches()) {
            this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, string4);
            this.inputFields.put(VALUE_FIELD.HOUR_OR_POD, string4);
        } else if (TimeMLDateTimePoint.parseInteger(string4) > -1) {
            this.inputFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, string4));
            this.underlyingTime = this.underlyingTime.withHourOfDay(TimeMLDateTimePoint.parseInteger(string4));
        }
        if (pattern.matcher(string5).matches()) {
            this.maskedFields.put(VALUE_FIELD.MINUTE, string5);
            this.inputFields.put(VALUE_FIELD.MINUTE, string5);
        } else if (TimeMLDateTimePoint.parseInteger(string5) > -1) {
            this.inputFields.put(VALUE_FIELD.MINUTE, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, string5));
            this.underlyingTime = this.underlyingTime.withMinuteOfHour(TimeMLDateTimePoint.parseInteger(string5));
        }
    }

    public TimeMLDateTimePoint(TimeMLDateTimePoint timeMLDateTimePoint) {
        if (timeMLDateTimePoint.underlyingTime != null) {
            this.underlyingTime = new LocalTime(timeMLDateTimePoint.underlyingTime);
        }
        if (timeMLDateTimePoint.underlyingDate != null) {
            this.underlyingDate = new LocalDate(timeMLDateTimePoint.underlyingDate);
        }
        this.inputFields = new HashMap<VALUE_FIELD, String>(timeMLDateTimePoint.inputFields);
        this.maskedFields = new HashMap<VALUE_FIELD, String>(timeMLDateTimePoint.maskedFields);
        this.openedFields = new HashMap<VALUE_FIELD, String>(timeMLDateTimePoint.openedFields);
        this.modifiedGrans = new HashMap<Granulaarsus, String>(timeMLDateTimePoint.modifiedGrans);
        this.dateModified = timeMLDateTimePoint.dateModified;
        this.functionOtherThanSetUsed = timeMLDateTimePoint.functionOtherThanSetUsed;
    }

    public void setField(Granulaarsus granulaarsus, int n) {
        if (granulaarsus == Granulaarsus.AM_PM) {
            try {
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.halfdayOfDay(), n);
                this.updateTimeRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY) {
            try {
                if (n == 12) {
                    n = 0;
                }
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.hourOfHalfday(), n);
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.minuteOfHour(), 0);
                this.updateTimeRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.MINUTE) {
            try {
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.minuteOfHour(), n);
                this.updateTimeRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.dayOfWeek(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.WEEK_OF_YEAR) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.weekOfWeekyear(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.DAY_OF_MONTH) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.dayOfMonth(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.MONTH) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.monthOfYear(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.YEAR) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.year(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.YEAR_OF_CENTURY) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.yearOfCentury(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.centuryOfEra(), n);
                this.dateModified = true;
                this.updateDateRepresentation(granulaarsus, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setField(Granulaarsus granulaarsus, String string) {
        if (granulaarsus == Granulaarsus.TIME) {
            this.updateTimeRepresentation(granulaarsus, string, false, true);
        }
        if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
            this.openedFields.put(VALUE_FIELD.DAY, string);
            this.updateDateRepresentation(granulaarsus, string, true, true);
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.MONTH) {
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, string);
            this.updateDateRepresentation(granulaarsus, string, true, true);
            this.dateModified = true;
        }
    }

    public void addToField(Granulaarsus granulaarsus, int n) {
        if (granulaarsus == Granulaarsus.MINUTE || granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY || granulaarsus == Granulaarsus.HOUR_OF_DAY) {
            LocalDateTime localDateTime = this.getAsLocalDateTime();
            if (granulaarsus == Granulaarsus.MINUTE) {
                localDateTime = localDateTime.plusMinutes(n);
                this.underlyingTime = localDateTime.toLocalTime();
                this.underlyingDate = localDateTime.toLocalDate();
                if (this.dateModified) {
                    this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
                }
                this.updateTimeRepresentation(granulaarsus, null, false, false);
                this.functionOtherThanSetUsed = true;
            }
            if (granulaarsus == Granulaarsus.HOUR_OF_DAY || granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY) {
                localDateTime = localDateTime.plusHours(n);
                this.underlyingTime = localDateTime.toLocalTime();
                this.underlyingDate = localDateTime.toLocalDate();
                if (this.dateModified) {
                    this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
                }
                this.updateTimeRepresentation(granulaarsus, null, false, false);
                this.functionOtherThanSetUsed = true;
            }
        }
        if (granulaarsus == Granulaarsus.DAY_OF_MONTH) {
            this.underlyingDate = this.underlyingDate.plusDays(n);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
            this.underlyingDate = this.underlyingDate.plusDays(n);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.WEEK_OF_YEAR) {
            this.underlyingDate = this.underlyingDate.plusWeeks(n);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.MONTH) {
            this.underlyingDate = this.underlyingDate.plusMonths(n);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.YEAR) {
            this.underlyingDate = this.underlyingDate.plusYears(n);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.YEAR_OF_CENTURY) {
            this.underlyingDate = this.underlyingDate.plusYears(n);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
            this.underlyingDate = this.underlyingDate.plusYears(n * 100);
            this.updateDateRepresentation(granulaarsus, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
    }

    public void addToField(Granulaarsus granulaarsus, Period period, int n) {
        if (granulaarsus.compareByCoarseRank(Granulaarsus.WEEK_OF_YEAR) == -1) {
            LocalDateTime localDateTime = this.getAsLocalDateTime();
            try {
                localDateTime = n > 0 ? localDateTime.plus(period) : localDateTime.minus(period);
                this.functionOtherThanSetUsed = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.underlyingTime = localDateTime.toLocalTime();
            this.underlyingDate = localDateTime.toLocalDate();
            if (granulaarsus.compareByCoarseRank(Granulaarsus.DAY_OF_MONTH) == 0) {
                this.dateModified = true;
                this.updateTimeRepresentation(Granulaarsus.HOUR_OF_DAY, null, false, false);
            } else {
                this.updateTimeRepresentation(Granulaarsus.MINUTE, null, false, false);
            }
            if (this.dateModified) {
                this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            }
        } else {
            try {
                this.underlyingDate = n > 0 ? this.underlyingDate.plus(period) : this.underlyingDate.minus(period);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (granulaarsus == Granulaarsus.MONTH || granulaarsus == Granulaarsus.WEEK_OF_YEAR) {
                this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            }
            if (granulaarsus == Granulaarsus.YEAR) {
                this.updateDateRepresentation(Granulaarsus.MONTH, null, false, false);
            }
            if (granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
                this.updateDateRepresentation(Granulaarsus.YEAR, null, false, false);
            }
        }
    }

    public void seekField(Granulaarsus granulaarsus, int n, int n2, boolean bl) {
        int n3;
        LocalDate localDate;
        int n4;
        LocalDate localDate2;
        int n5;
        if (granulaarsus == Granulaarsus.DAY_OF_MONTH && n != 0 && n2 == 0) {
            LocalDate localDate3;
            n5 = n > 0 ? 1 : -1;
            localDate2 = new LocalDate(this.underlyingDate);
            this.underlyingDate = localDate2 = (localDate3 = localDate2.plusDays(1 * n5));
            this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.DAY_OF_WEEK && n2 >= 1 && n2 <= 7 && n != 0) {
            int n6;
            n5 = n > 0 ? 1 : -1;
            localDate2 = new LocalDate(this.underlyingDate);
            int n7 = n6 = bl ? localDate2.getDayOfWeek() : -1;
            if (!bl) {
                localDate2 = localDate2.plusDays(n5 * -1);
            }
            n4 = 0;
            while (true) {
                localDate2 = localDate = localDate2.plusDays(1 * n5);
                n3 = localDate2.getDayOfWeek();
                if (n6 != -1) {
                    if (n6 == n3) continue;
                    n6 = -1;
                }
                if (n3 != n2) continue;
                n6 = n3;
                if (++n4 == Math.abs(n)) break;
            }
            this.underlyingDate = localDate2;
            this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.WEEK_OF_YEAR && n2 == 0 && n != 0) {
            int n8;
            n5 = n > 0 ? 1 : -1;
            localDate2 = new LocalDate(this.underlyingDate);
            int n9 = n8 = bl ? localDate2.getWeekOfWeekyear() : -1;
            if (!bl) {
                localDate2 = localDate2.plusDays(n5 * -1);
            }
            n4 = 0;
            while (true) {
                localDate2 = localDate = localDate2.plusDays(1 * n5);
                n3 = localDate.getWeekOfWeekyear();
                if (n8 != -1) {
                    if (n8 == n3) continue;
                    n8 = -1;
                }
                if (n2 != 0) continue;
                n8 = n3;
                if (++n4 == Math.abs(n)) break;
            }
            this.underlyingDate = localDate2;
            this.updateDateRepresentation(Granulaarsus.WEEK_OF_YEAR, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.MONTH && (n2 == 0 || 1 <= n2 && n2 <= 12) && n != 0) {
            int n10;
            n5 = n > 0 ? 1 : -1;
            localDate2 = new LocalDate(this.underlyingDate);
            int n11 = n10 = bl ? localDate2.getMonthOfYear() : -1;
            if (!bl) {
                localDate2 = localDate2.plusMonths(n5 * -1);
            }
            n4 = 0;
            while (true) {
                localDate2 = localDate = localDate2.plusMonths(1 * n5);
                n3 = localDate.getMonthOfYear();
                if (n10 != -1) {
                    if (n10 == n3) continue;
                    n10 = -1;
                }
                if (n2 != 0 && (n2 == 0 || n3 != n2)) continue;
                n10 = n3;
                if (++n4 == Math.abs(n)) break;
            }
            this.underlyingDate = localDate2;
            this.updateDateRepresentation(Granulaarsus.MONTH, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.YEAR && n2 == 0 && n != 0) {
            int n12;
            n5 = n > 0 ? 1 : -1;
            localDate2 = new LocalDate(this.underlyingDate);
            int n13 = n12 = bl ? localDate2.getYear() : -1;
            if (!bl) {
                localDate2 = localDate2.plusMonths(n5 * -1);
            }
            n4 = 0;
            while (true) {
                localDate2 = localDate = localDate2.plusMonths(1 * n5);
                n3 = localDate.getYear();
                if (n12 != -1) {
                    if (n12 == n3) continue;
                    n12 = -1;
                }
                if (n2 != 0) continue;
                n12 = n3;
                if (++n4 == Math.abs(n)) break;
            }
            this.underlyingDate = localDate2;
            this.updateDateRepresentation(Granulaarsus.YEAR, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.YEAR_OF_CENTURY && n != 0) {
            n5 = SemLeidmiseAbimeetodid.getLocalDateTimeFieldExtremum(this.underlyingDate, DateTimeFieldType.yearOfCentury(), false);
            int n14 = SemLeidmiseAbimeetodid.getLocalDateTimeFieldExtremum(this.underlyingDate, DateTimeFieldType.yearOfCentury(), true);
            if (n5 <= n2 && n2 <= n14) {
                int n15;
                int n16 = n > 0 ? 1 : -1;
                LocalDate localDate4 = new LocalDate(this.underlyingDate);
                int n17 = n15 = bl ? localDate4.getYearOfCentury() : -1;
                if (!bl) {
                    localDate4 = localDate4.plusYears(n16 * -1);
                }
                n3 = 0;
                int n18 = 0;
                while (true) {
                    LocalDate localDate5 = localDate4.plusYears(1 * n16);
                    ++n18;
                    localDate4 = localDate5;
                    int n19 = localDate5.getYearOfCentury();
                    if (n15 != -1) {
                        if (n15 == n19) continue;
                        n15 = -1;
                    }
                    if (n19 != n2) continue;
                    n15 = n19;
                    if (++n3 == Math.abs(n)) break;
                }
                this.underlyingDate = localDate4;
                this.updateDateRepresentation(Granulaarsus.YEAR, null, false, false);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            }
        }
        if (granulaarsus == Granulaarsus.CENTURY_OF_ERA && n2 == 0 && n != 0) {
            int n20;
            n5 = n > 0 ? 1 : -1;
            LocalDate localDate6 = new LocalDate(this.underlyingDate);
            int n21 = n20 = bl ? localDate6.getCenturyOfEra() : Integer.MIN_VALUE;
            if (!bl) {
                localDate6 = localDate6.plusYears(n5 * -10);
            }
            int n22 = 0;
            while (true) {
                LocalDate localDate7;
                localDate6 = localDate7 = localDate6.plusYears(10 * n5);
                n3 = localDate7.getCenturyOfEra();
                if (n20 != Integer.MIN_VALUE) {
                    if (n20 == n3) continue;
                    n20 = Integer.MIN_VALUE;
                }
                if (n2 != 0) continue;
                n20 = n3;
                if (++n22 == Math.abs(n)) break;
            }
            this.underlyingDate = localDate6;
            this.updateDateRepresentation(Granulaarsus.CENTURY_OF_ERA, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
    }

    public void seekField(Granulaarsus granulaarsus, int n, String string, boolean bl) {
        String string2;
        Object object;
        int n2;
        String string3;
        BaseLocal baseLocal;
        int n3;
        if (granulaarsus == Granulaarsus.TIME && string != null && string.matches("(NI|MO|AF|EV)") && n != 0) {
            n3 = n > 0 ? 1 : -1;
            baseLocal = this.getAsLocalDateTime();
            String string4 = string3 = bl ? SemLeidmiseAbimeetodid.getPartOfDay(((LocalDateTime)baseLocal).toLocalTime()) : null;
            if (!bl) {
                baseLocal = ((LocalDateTime)baseLocal).plusHours(n3 * -1);
            }
            n2 = 0;
            while (true) {
                object = ((LocalDateTime)baseLocal).plusHours(1 * n3);
                baseLocal = object;
                string2 = SemLeidmiseAbimeetodid.getPartOfDay(((LocalDateTime)object).toLocalTime());
                if (string3 != null) {
                    if (string3.equals(string2)) continue;
                    string3 = null;
                }
                if (string2 == null || !string2.equals(string)) continue;
                string3 = string2;
                if (++n2 == Math.abs(n)) break;
            }
            this.partOfDay = string;
            this.updateTimeRepresentation(Granulaarsus.TIME, string, true, false);
            this.underlyingTime = ((LocalDateTime)baseLocal).toLocalTime();
            this.underlyingDate = ((LocalDateTime)baseLocal).toLocalDate();
            this.functionOtherThanSetUsed = true;
        }
        if (granulaarsus == Granulaarsus.DAY_OF_WEEK && string != null && string.matches("(WD|WE)") && n != 0) {
            n3 = n > 0 ? 1 : -1;
            baseLocal = new LocalDate(this.underlyingDate);
            String string5 = string3 = bl ? SemLeidmiseAbimeetodid.getWordDayOrWeekend((LocalDate)baseLocal) : null;
            if (!bl) {
                baseLocal = ((LocalDate)baseLocal).plusDays(n3 * -1);
            }
            n2 = 0;
            while (true) {
                object = ((LocalDate)baseLocal).plusDays(1 * n3);
                baseLocal = object;
                string2 = SemLeidmiseAbimeetodid.getWordDayOrWeekend((LocalDate)baseLocal);
                if (string3 != null) {
                    if (string3.equals(string2)) continue;
                    string3 = null;
                }
                if (!string2.equals(string)) continue;
                string3 = string2;
                if (++n2 == Math.abs(n)) break;
            }
            this.underlyingDate = baseLocal;
            this.openedFields.put(VALUE_FIELD.DAY, string);
            this.updateDateRepresentation(Granulaarsus.DAY_OF_WEEK, string, true, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.MONTH && string != null && string.matches("(SP|SU|FA|WI)") && n != 0) {
            n3 = n > 0 ? 1 : -1;
            baseLocal = new LocalDate(this.underlyingDate);
            String string6 = string3 = bl ? SemLeidmiseAbimeetodid.getSeason((LocalDate)baseLocal) : null;
            if (!bl) {
                baseLocal = ((LocalDate)baseLocal).plusMonths(n3 * -1);
            }
            n2 = 0;
            while (true) {
                object = ((LocalDate)baseLocal).plusMonths(1 * n3);
                baseLocal = object;
                string2 = SemLeidmiseAbimeetodid.getSeason((LocalDate)baseLocal);
                if (string3 != null) {
                    if (string3.equals(string2)) continue;
                    string3 = null;
                }
                if (!string2.equals(string)) continue;
                string3 = string2;
                if (++n2 == Math.abs(n)) break;
            }
            this.underlyingDate = baseLocal;
            if (this.underlyingDate.getMonthOfYear() == 12) {
                this.underlyingDate = this.underlyingDate.plusMonths(1);
            }
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, string);
            this.updateDateRepresentation(Granulaarsus.MONTH, string, true, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (granulaarsus == Granulaarsus.MONTH && string != null && string.matches("Q(1|2|3|4)") && n != 0) {
            n3 = n > 0 ? 1 : -1;
            baseLocal = new LocalDate(this.underlyingDate);
            String string7 = string3 = bl ? SemLeidmiseAbimeetodid.getQuarterOfYear((LocalDate)baseLocal) : null;
            if (!bl) {
                baseLocal = ((LocalDate)baseLocal).plusMonths(n3 * -1);
            }
            n2 = 0;
            while (true) {
                object = ((LocalDate)baseLocal).plusMonths(1 * n3);
                baseLocal = object;
                string2 = SemLeidmiseAbimeetodid.getQuarterOfYear((LocalDate)baseLocal);
                if (string3 != null) {
                    if (string3.equals(string2)) continue;
                    string3 = null;
                }
                if (!string2.equals(string)) continue;
                string3 = string2;
                if (++n2 == Math.abs(n)) break;
            }
            this.underlyingDate = baseLocal;
            object = SemLeidmiseAbimeetodid.getQuarterOfYear(this.underlyingDate);
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, (String)object);
            this.updateDateRepresentation(Granulaarsus.MONTH, (String)object, true, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
    }

    public void applyBalwinWindow(Granulaarsus granulaarsus, String string) {
        block4: {
            if (string != null) {
                LocalDateTime localDateTime = this.getAsLocalDateTime();
                try {
                    int n = Integer.parseInt(string);
                    LocalDateTime localDateTime2 = SemLeidmiseAbimeetodid.applyBaldwinWindow(granulaarsus, localDateTime, n);
                    this.underlyingTime = localDateTime2.toLocalTime();
                    this.underlyingDate = localDateTime2.toLocalDate();
                    if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
                        granulaarsus = Granulaarsus.DAY_OF_MONTH;
                    }
                    this.updateDateRepresentation(granulaarsus, null, false, false);
                    this.functionOtherThanSetUsed = true;
                    this.dateModified = true;
                }
                catch (NumberFormatException numberFormatException) {
                    LocalDateTime localDateTime3 = SemLeidmiseAbimeetodid.applyBaldwinWindow(granulaarsus, localDateTime, string);
                    if (localDateTime3 == null || granulaarsus != Granulaarsus.MONTH) break block4;
                    this.underlyingTime = localDateTime3.toLocalTime();
                    this.underlyingDate = localDateTime3.toLocalDate();
                    this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, string);
                    this.updateDateRepresentation(Granulaarsus.MONTH, string, true, false);
                    this.functionOtherThanSetUsed = true;
                    this.dateModified = true;
                }
            }
        }
    }

    public void findNthSubpartOfGranularity(Granulaarsus granulaarsus, Granulaarsus granulaarsus2, int n, int n2) {
        LocalDateTime localDateTime = this.getAsLocalDateTime();
        LocalDateTime localDateTime2 = SemLeidmiseAbimeetodid.findNthSubpartOfGranularity(granulaarsus, granulaarsus2, n, n2, localDateTime);
        if (localDateTime2 != null && granulaarsus == Granulaarsus.MONTH) {
            this.underlyingTime = localDateTime2.toLocalTime();
            this.underlyingDate = localDateTime2.toLocalDate();
            if (granulaarsus2 == Granulaarsus.DAY_OF_WEEK) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    this.manageMaskedFields(Granulaarsus.MONTH, null, false, true);
                }
                this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            } else if (granulaarsus2 == Granulaarsus.WEEK_OF_YEAR) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    this.manageMaskedFields(Granulaarsus.MONTH, null, false, true);
                }
                this.updateDateRepresentation(Granulaarsus.WEEK_OF_YEAR, null, false, false);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            }
        }
    }

    private void updateDateRepresentation(Granulaarsus granulaarsus, String string, boolean bl, boolean bl2) {
        this.modifiedGrans.put(granulaarsus, "1");
        if (string == null && this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && (granulaarsus == Granulaarsus.WEEK_OF_YEAR || granulaarsus == Granulaarsus.DAY_OF_WEEK) && !this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()));
            this.openedFields.put(VALUE_FIELD.DAY, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()));
        }
        for (int i = 0; i < 3; ++i) {
            VALUE_FIELD vALUE_FIELD = valueFieldsInOrder[i];
            if (!vALUE_FIELD.matchesGranularity(granulaarsus)) continue;
            int n = i;
            while (n > -1) {
                VALUE_FIELD vALUE_FIELD2 = valueFieldsInOrder[n];
                if (n == i && bl) {
                    --n;
                    continue;
                }
                if (vALUE_FIELD2 == VALUE_FIELD.YEAR) {
                    String string2 = String.valueOf(this.underlyingDate.getYear());
                    if (string2.startsWith("-")) {
                        string2 = string2.substring(1);
                    }
                    string2 = TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, string2);
                    if (this.underlyingDate.era().get() == 0) {
                        string2 = "BC" + string2;
                    }
                    this.openedFields.put(vALUE_FIELD2, string2);
                }
                if (vALUE_FIELD2 == VALUE_FIELD.MONTH_OR_WEEK) {
                    if (this.isModified(Granulaarsus.WEEK_OF_YEAR) && !this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && granulaarsus == Granulaarsus.DAY_OF_WEEK && string != null) {
                        this.openedFields.put(vALUE_FIELD2, "W" + TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getWeekOfWeekyear()));
                        if (this.maskedFields.containsKey((Object)vALUE_FIELD2)) {
                            this.maskedFields.put(vALUE_FIELD2, "WXX");
                        }
                    } else {
                        this.openedFields.put(vALUE_FIELD2, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()));
                        if (this.maskedFields.containsKey((Object)vALUE_FIELD2)) {
                            this.maskedFields.put(vALUE_FIELD2, "XX");
                        }
                    }
                }
                if (vALUE_FIELD2 == VALUE_FIELD.DAY) {
                    if (this.isModified(Granulaarsus.WEEK_OF_YEAR) && !this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                        this.openedFields.put(vALUE_FIELD2, String.valueOf(this.underlyingDate.getDayOfWeek()));
                    } else {
                        this.openedFields.put(vALUE_FIELD2, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()));
                    }
                }
                --n;
            }
            break;
        }
        if (this.isModified(Granulaarsus.CENTURY_OF_ERA) && !this.isModified(Granulaarsus.YEAR) && !this.isModified(Granulaarsus.YEAR_OF_CENTURY) && this.openedFields.containsKey((Object)VALUE_FIELD.YEAR) && this.openedFields.get((Object)VALUE_FIELD.YEAR).matches("(BC)?\\d{2,4}")) {
            String string3 = String.valueOf(this.underlyingDate.getCenturyOfEra());
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            if (this.underlyingDate.era().get() == 0) {
                string3 = "BC" + string3;
            }
            this.openedFields.put(VALUE_FIELD.YEAR, string3);
        }
        this.manageMaskedFields(granulaarsus, string, bl, bl2);
    }

    private void updateTimeRepresentation(Granulaarsus granulaarsus, String string, boolean bl, boolean bl2) {
        if (granulaarsus == Granulaarsus.TIME && string != null) {
            this.partOfDay = string;
        }
        this.modifiedGrans.put(granulaarsus, "1");
        if (string == null) {
            if (!bl) {
                if (granulaarsus == Granulaarsus.AM_PM) {
                    this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
                }
                if (granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY) {
                    if (this.isModified(Granulaarsus.AM_PM)) {
                        this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
                        this.openedFields.remove((Object)VALUE_FIELD.MINUTE);
                    } else {
                        this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
                    }
                }
                if (granulaarsus == Granulaarsus.MINUTE) {
                    this.openedFields.put(VALUE_FIELD.MINUTE, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, this.underlyingTime.getMinuteOfHour()));
                }
            }
        } else if (granulaarsus == Granulaarsus.TIME) {
            if (!this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD)) {
                this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, string);
                this.openedFields.remove((Object)VALUE_FIELD.MINUTE);
            } else if (this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+")) {
                this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, string);
                this.openedFields.remove((Object)VALUE_FIELD.MINUTE);
            }
        }
        if (this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && this.partOfDay != null && !this.isModified(Granulaarsus.AM_PM)) {
            int n = this.underlyingTime.get(DateTimeFieldType.hourOfHalfday());
            if (this.partOfDay.equals("NI")) {
                if (n >= 8 && n < 12) {
                    this.setField(Granulaarsus.AM_PM, 1);
                } else {
                    this.setField(Granulaarsus.AM_PM, 0);
                }
                return;
            }
            if (this.partOfDay.equals("MO")) {
                if (n == 0) {
                    this.setField(Granulaarsus.AM_PM, 1);
                } else {
                    this.setField(Granulaarsus.AM_PM, 0);
                }
            }
            if (this.partOfDay.equals("AF")) {
                this.setField(Granulaarsus.AM_PM, 1);
            }
            if (this.partOfDay.equals("DT")) {
                if (n == 0) {
                    this.setField(Granulaarsus.AM_PM, 1);
                } else if (9 <= n && n < 12) {
                    this.setField(Granulaarsus.AM_PM, 0);
                } else if (n <= 7) {
                    this.setField(Granulaarsus.AM_PM, 1);
                }
            }
            if (this.partOfDay.equals("EV")) {
                if (n == 0) {
                    this.setField(Granulaarsus.AM_PM, 0);
                } else {
                    this.setField(Granulaarsus.AM_PM, 1);
                }
            }
        }
        this.manageMaskedFields(granulaarsus, string, bl, bl2);
    }

    public void closeGranularitiesBelow(Granulaarsus granulaarsus, int n) {
        if (granulaarsus.compareByCoarseRank(Granulaarsus.TIME) == 1) {
            this.partOfDay = null;
        }
        boolean bl = false;
        if (n > 0 && granulaarsus == Granulaarsus.YEAR && this.openedFields.containsKey((Object)VALUE_FIELD.YEAR) && this.openedFields.get((Object)VALUE_FIELD.YEAR).matches("(BC)?\\d{4}")) {
            if (n > 3) {
                this.maskedFields.put(VALUE_FIELD.YEAR, "XXXX");
                bl = true;
            } else {
                String string = this.openedFields.get((Object)VALUE_FIELD.YEAR);
                this.openedFields.put(VALUE_FIELD.YEAR, string.substring(0, string.length() - n));
            }
        }
        if (!bl) {
            for (Granulaarsus granulaarsus2 : Granulaarsus.fieldsInSafeOrder) {
                if (granulaarsus.compareByCoarseRank(granulaarsus2) != 1) continue;
                for (int i = 0; i < valueFieldsInOrder.length; ++i) {
                    VALUE_FIELD vALUE_FIELD = valueFieldsInOrder[i];
                    if (!vALUE_FIELD.matchesGranularity(granulaarsus2)) continue;
                    this.openedFields.remove((Object)vALUE_FIELD);
                }
            }
        }
    }

    private void manageMaskedFields(Granulaarsus granulaarsus, String string, boolean bl, boolean bl2) {
        VALUE_FIELD vALUE_FIELD;
        int n;
        boolean bl3;
        VALUE_FIELD vALUE_FIELD2 = null;
        VALUE_FIELD vALUE_FIELD3 = null;
        if (bl2) {
            if (granulaarsus == Granulaarsus.YEAR || granulaarsus == Granulaarsus.YEAR_OF_CENTURY || granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
                this.maskedFields.remove((Object)VALUE_FIELD.YEAR);
                vALUE_FIELD2 = VALUE_FIELD.YEAR;
            }
            if (granulaarsus == Granulaarsus.MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR) || string != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                } else if (!(this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_MONTH))) {
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    vALUE_FIELD3 = VALUE_FIELD.YEAR;
                }
            }
            if (granulaarsus == Granulaarsus.WEEK_OF_YEAR) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                } else if (!this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.DAY_OF_MONTH)) {
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.MONTH_OR_WEEK;
                }
            }
            if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY) || string != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.DAY);
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = string != null ? VALUE_FIELD.MONTH_OR_WEEK : VALUE_FIELD.DAY;
                }
            }
            if (granulaarsus == Granulaarsus.DAY_OF_MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.DAY);
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
            if (granulaarsus == Granulaarsus.AM_PM && string == null && !bl) {
                this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                vALUE_FIELD2 = VALUE_FIELD.MINUTE;
            }
            if (granulaarsus == Granulaarsus.TIME && string != null) {
                this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                vALUE_FIELD2 = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
            if ((granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY || granulaarsus == Granulaarsus.HOUR_OF_DAY) && string == null) {
                if (this.isModified(Granulaarsus.AM_PM)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                } else {
                    this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
                }
                vALUE_FIELD2 = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
            if (granulaarsus == Granulaarsus.MINUTE) {
                this.maskedFields.remove((Object)VALUE_FIELD.MINUTE);
                if (!this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) || this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+")) {
                    this.openedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                    this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
                }
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
        } else {
            if (granulaarsus == Granulaarsus.YEAR || granulaarsus == Granulaarsus.YEAR_OF_CENTURY || granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR)) {
                    vALUE_FIELD2 = VALUE_FIELD.YEAR;
                } else if (!this.isModified(Granulaarsus.MONTH) && !this.isModified(Granulaarsus.WEEK_OF_YEAR)) {
                    vALUE_FIELD2 = VALUE_FIELD.MONTH_OR_WEEK;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR)) {
                    if (granulaarsus == Granulaarsus.YEAR) {
                        this.maskedFields.put(VALUE_FIELD.YEAR, "XXXX");
                    }
                    if (granulaarsus == Granulaarsus.YEAR_OF_CENTURY) {
                        this.maskedFields.put(VALUE_FIELD.YEAR, "XXXX");
                    }
                    if (granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
                        this.maskedFields.put(VALUE_FIELD.YEAR, "XX");
                    }
                }
            }
            if (granulaarsus == Granulaarsus.MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || string != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                } else if (!(this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_MONTH))) {
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    vALUE_FIELD3 = VALUE_FIELD.YEAR;
                }
            }
            if (granulaarsus == Granulaarsus.WEEK_OF_YEAR) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY) || string != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                } else if (!this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.DAY_OF_MONTH)) {
                    vALUE_FIELD2 = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.MONTH_OR_WEEK;
                }
            }
            if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = string != null ? VALUE_FIELD.MONTH_OR_WEEK : VALUE_FIELD.DAY;
                }
            }
            if (granulaarsus == Granulaarsus.DAY_OF_MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    vALUE_FIELD2 = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
            if ((granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY || granulaarsus == Granulaarsus.HOUR_OF_DAY) && string == null) {
                if (this.isModified(Granulaarsus.AM_PM)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                } else {
                    this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
                }
                vALUE_FIELD2 = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
            if (granulaarsus == Granulaarsus.TIME && string != null) {
                this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                vALUE_FIELD2 = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    vALUE_FIELD3 = VALUE_FIELD.DAY;
                }
            }
            if (granulaarsus == Granulaarsus.MINUTE && (!this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) || this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+"))) {
                this.openedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
            }
        }
        if (vALUE_FIELD2 != null) {
            bl3 = false;
            for (n = 0; n < valueFieldsInOrder.length; ++n) {
                vALUE_FIELD = valueFieldsInOrder[n];
                if (vALUE_FIELD == vALUE_FIELD2) {
                    bl3 = true;
                }
                if (!bl3) continue;
                this.maskedFields.remove((Object)vALUE_FIELD);
            }
        }
        if (vALUE_FIELD3 != null) {
            bl3 = false;
            for (n = valueFieldsInOrder.length - 1; n > -1; --n) {
                vALUE_FIELD = valueFieldsInOrder[n];
                if (vALUE_FIELD == vALUE_FIELD3) {
                    bl3 = true;
                }
                if (!bl3) continue;
                if (vALUE_FIELD == VALUE_FIELD.YEAR) {
                    this.maskedFields.put(vALUE_FIELD, "XXXX");
                }
                if (vALUE_FIELD == VALUE_FIELD.MONTH_OR_WEEK) {
                    if (this.hasWeekBasedFormatInOutput()) {
                        this.maskedFields.put(vALUE_FIELD, "WXX");
                    } else {
                        this.maskedFields.put(vALUE_FIELD, "XX");
                    }
                }
                if (vALUE_FIELD == VALUE_FIELD.DAY) {
                    this.maskedFields.put(vALUE_FIELD, "XX");
                }
                if (vALUE_FIELD == VALUE_FIELD.HOUR_OR_POD) {
                    this.maskedFields.put(vALUE_FIELD, "XX");
                }
                if (vALUE_FIELD != VALUE_FIELD.MINUTE) continue;
                this.maskedFields.put(vALUE_FIELD, "XX");
            }
        }
    }

    public void setMaskedFields(String string, String string2, String string3, String string4, String string5) {
        Pattern pattern = Pattern.compile("X+");
        if (string != null && pattern.matcher(string).matches()) {
            this.maskedFields.put(VALUE_FIELD.YEAR, string);
        }
        if (string2 != null && pattern.matcher(string2).matches()) {
            this.maskedFields.put(VALUE_FIELD.MONTH_OR_WEEK, string2);
        }
        if (string3 != null && pattern.matcher(string3).matches()) {
            this.maskedFields.put(VALUE_FIELD.DAY, string3);
        }
        if (string4 != null && pattern.matcher(string4).matches()) {
            this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, string4);
        }
        if (string5 != null && pattern.matcher(string5).matches()) {
            this.maskedFields.put(VALUE_FIELD.MINUTE, string5);
        }
    }

    public TimeMLDateTimePoint clone() {
        TimeMLDateTimePoint timeMLDateTimePoint = new TimeMLDateTimePoint(this);
        return timeMLDateTimePoint;
    }

    public boolean isModified(Granulaarsus granulaarsus) {
        return this.modifiedGrans.containsKey((Object)granulaarsus);
    }

    public boolean hasFunctionOtherThanSetUsed() {
        return this.functionOtherThanSetUsed;
    }

    public boolean hasModifiedFields() {
        return !this.openedFields.isEmpty();
    }

    public boolean hadModifiedDateFields() {
        return this.dateModified;
    }

    public boolean hasModifiedTimeFields() {
        return this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) || this.maskedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD);
    }

    public boolean hasLabelsInOutput() {
        return this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+") || this.openedFields.containsKey((Object)VALUE_FIELD.DAY) && this.openedFields.get((Object)VALUE_FIELD.DAY).matches("[A-Z]+") || this.openedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) && this.openedFields.get((Object)VALUE_FIELD.MONTH_OR_WEEK).matches("[A-Z]+[0-9]*");
    }

    public boolean hasWeekBasedFormatInOutput() {
        return this.openedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) && this.openedFields.get((Object)VALUE_FIELD.MONTH_OR_WEEK).matches("W\\d+") || this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) && this.maskedFields.get((Object)VALUE_FIELD.MONTH_OR_WEEK).matches("WX+");
    }

    public String toValueString() throws Exception {
        VALUE_FIELD vALUE_FIELD;
        int n;
        HashMap<VALUE_FIELD, String> hashMap = this.openedFields;
        if (this.openedFields.size() == 0) {
            hashMap = this.inputFields;
        }
        if (hashMap.size() == 0 && this.maskedFields.size() == 0) {
            throw new Exception("No calendaric fields have been set for " + this.getClass().getCanonicalName() + " object.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < valueFieldsInOrder.length; ++n) {
            vALUE_FIELD = valueFieldsInOrder[n];
            if (this.maskedFields.containsKey((Object)vALUE_FIELD)) {
                if (n > 0 && n < 3) {
                    stringBuilder.append("-");
                }
                if (n == 3) {
                    stringBuilder.append("T");
                }
                if (n == 4) {
                    stringBuilder.append(":");
                }
                stringBuilder.append(this.maskedFields.get((Object)vALUE_FIELD));
                continue;
            }
            if (!hashMap.containsKey((Object)vALUE_FIELD)) break;
            if (n > 0 && n < 3) {
                stringBuilder.append("-");
            }
            if (n == 3) {
                stringBuilder.append("T");
            }
            if (n == 4) {
                stringBuilder.append(":");
            }
            stringBuilder.append(hashMap.get((Object)vALUE_FIELD));
        }
        if (stringBuilder.length() == 0) {
            for (n = 3; n < valueFieldsInOrder.length; ++n) {
                vALUE_FIELD = valueFieldsInOrder[n];
                if (this.maskedFields.containsKey((Object)vALUE_FIELD)) {
                    if (n == 3) {
                        stringBuilder.append("T");
                    }
                    if (n == 4) {
                        stringBuilder.append(":");
                    }
                    stringBuilder.append(this.maskedFields.get((Object)vALUE_FIELD));
                    continue;
                }
                if (!hashMap.containsKey((Object)vALUE_FIELD)) break;
                if (n == 3) {
                    stringBuilder.append("T");
                }
                if (n == 4) {
                    stringBuilder.append(":");
                }
                stringBuilder.append(hashMap.get((Object)vALUE_FIELD));
            }
        }
        return stringBuilder.toString();
    }

    public static String normalizeByAddingZeroes(VALUE_FIELD vALUE_FIELD, int n) {
        return TimeMLDateTimePoint.normalizeByAddingZeroes(vALUE_FIELD, String.valueOf(n));
    }

    public static String normalizeByAddingZeroes(VALUE_FIELD vALUE_FIELD, String string) {
        if (string.matches("\\d+")) {
            if (vALUE_FIELD == VALUE_FIELD.YEAR) {
                while (string.length() < 4) {
                    string = "0" + string;
                }
            }
            if (string.length() == 1) {
                if (vALUE_FIELD == VALUE_FIELD.MONTH_OR_WEEK) {
                    return "0" + string;
                }
                if (vALUE_FIELD == VALUE_FIELD.DAY) {
                    return "0" + string;
                }
                if (vALUE_FIELD == VALUE_FIELD.HOUR_OR_POD) {
                    return "0" + string;
                }
                if (vALUE_FIELD == VALUE_FIELD.MINUTE) {
                    return "0" + string;
                }
            }
        }
        return string;
    }

    public static String getFieldShapeInXXXes(VALUE_FIELD vALUE_FIELD) {
        if (vALUE_FIELD == VALUE_FIELD.YEAR) {
            return "XXXX";
        }
        return "XX";
    }

    public Granulaarsus getLowestChangedGranularity() {
        Granulaarsus granulaarsus = null;
        for (Granulaarsus granulaarsus2 : Granulaarsus.fieldsInSafeOrder) {
            if (!this.isModified(granulaarsus2)) continue;
            granulaarsus = granulaarsus2;
        }
        if (granulaarsus == Granulaarsus.CENTURY_OF_ERA) {
            granulaarsus = Granulaarsus.YEAR;
        }
        if (granulaarsus == Granulaarsus.DAY_OF_WEEK) {
            granulaarsus = Granulaarsus.DAY_OF_MONTH;
        }
        if (granulaarsus == Granulaarsus.WEEK_OF_YEAR) {
            granulaarsus = Granulaarsus.DAY_OF_MONTH;
        }
        if (granulaarsus == Granulaarsus.HOUR_OF_HALF_DAY) {
            granulaarsus = Granulaarsus.HOUR_OF_DAY;
        }
        if (granulaarsus == Granulaarsus.AM_PM) {
            granulaarsus = Granulaarsus.HOUR_OF_DAY;
        }
        if (granulaarsus == null && this.isModified(Granulaarsus.TIME)) {
            granulaarsus = Granulaarsus.HOUR_OF_DAY;
        }
        if (granulaarsus == null && this.isModified(Granulaarsus.YEAR_OF_CENTURY)) {
            granulaarsus = Granulaarsus.YEAR;
        }
        return granulaarsus;
    }

    public void copyInputFieldsToOpenedFields() {
        if (this.inputFields.size() == 5) {
            for (VALUE_FIELD vALUE_FIELD : this.inputFields.keySet()) {
                this.openedFields.put(vALUE_FIELD, this.inputFields.get((Object)vALUE_FIELD));
            }
        }
    }

    public LocalDateTime getAsLocalDateTime() {
        return new LocalDateTime(this.underlyingDate.getYear(), this.underlyingDate.getMonthOfYear(), this.underlyingDate.getDayOfMonth(), this.underlyingTime.getHourOfDay(), this.underlyingTime.getMinuteOfHour());
    }

    public String[] getUnderlyingDateTimeAsGranularitiesArray() {
        return new String[]{TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, this.underlyingDate.getYear()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, this.underlyingTime.getMinuteOfHour())};
    }

    private static int parseInteger(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static enum VALUE_FIELD {
        YEAR,
        MONTH_OR_WEEK,
        DAY,
        HOUR_OR_POD,
        MINUTE;


        public boolean matchesGranularity(Granulaarsus granulaarsus) {
            if (this.equals((Object)MINUTE)) {
                return granulaarsus.equals((Object)Granulaarsus.MINUTE);
            }
            if (this.equals((Object)HOUR_OR_POD)) {
                return granulaarsus.equals((Object)Granulaarsus.HOUR_OF_DAY) || granulaarsus.equals((Object)Granulaarsus.HOUR_OF_HALF_DAY);
            }
            if (this.equals((Object)DAY)) {
                return granulaarsus.equals((Object)Granulaarsus.DAY_OF_MONTH) || granulaarsus.equals((Object)Granulaarsus.DAY_OF_WEEK);
            }
            if (this.equals((Object)MONTH_OR_WEEK)) {
                return granulaarsus.equals((Object)Granulaarsus.MONTH) || granulaarsus.equals((Object)Granulaarsus.WEEK_OF_YEAR);
            }
            if (this.equals((Object)YEAR)) {
                return granulaarsus.equals((Object)Granulaarsus.YEAR) || granulaarsus.equals((Object)Granulaarsus.YEAR_OF_CENTURY) || granulaarsus.equals((Object)Granulaarsus.CENTURY_OF_ERA);
            }
            return false;
        }
    }
}

